package me.jingbin.progress;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
/* loaded from: classes.dex */
public class WebProgress extends FrameLayout {

    /* renamed from: IFxWkV_5  reason: collision with root package name */
    public static int f3718IFxWkV_5 = 450;

    /* renamed from: IMuAHx_6  reason: collision with root package name */
    public static int f3719IMuAHx_6 = 3;
    public static String KQgRr5e_0 = "#2483D9";

    /* renamed from: X6FRs_4  reason: collision with root package name */
    public static int f3720X6FRs_4 = 8000;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public float f3013KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public int f3014KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Animator f3015KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public AnimatorListenerAdapter f3016KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public ValueAnimator.AnimatorUpdateListener f3017KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Paint f3018KQgRr5e_0;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public int f3721Mqv2r_3;
    public int PGPF6hQ_2;
    public int QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f3019QxJ9d_1;

    /* loaded from: classes.dex */
    public class KQgRr5e_0 implements ValueAnimator.AnimatorUpdateListener {
        public KQgRr5e_0() {
        }

        @Override // android.animation.ValueAnimator.AnimatorUpdateListener
        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            WebProgress.this.f3013KQgRr5e_0 = ((Float) valueAnimator.getAnimatedValue()).floatValue();
            WebProgress.this.invalidate();
        }
    }

    /* loaded from: classes.dex */
    public class QxJ9d_1 extends AnimatorListenerAdapter {
        public QxJ9d_1() {
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            WebProgress.this.KQgRr5e_0();
        }
    }

    public WebProgress(Context context) {
        this(context, null);
    }

    public void Mqv2r_3() {
        this.f3019QxJ9d_1 = true;
        setVisibility(0);
        this.f3013KQgRr5e_0 = 0.0f;
        KQgRr5e_0(false);
    }

    public final void PGPF6hQ_2() {
        this.f3019QxJ9d_1 = false;
        this.f3721Mqv2r_3 = 2;
    }

    public void QxJ9d_1() {
        setWebProgress(100);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void dispatchDraw(Canvas canvas) {
        canvas.drawRect(0.0f, 0.0f, (this.f3013KQgRr5e_0 / 100.0f) * Float.valueOf(getWidth()).floatValue(), getHeight(), this.f3018KQgRr5e_0);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Animator animator = this.f3015KQgRr5e_0;
        if (animator == null || !animator.isStarted()) {
            return;
        }
        this.f3015KQgRr5e_0.cancel();
        this.f3015KQgRr5e_0 = null;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
    }

    @Override // android.widget.FrameLayout, android.view.View
    public void onMeasure(int i, int i2) {
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        int size2 = View.MeasureSpec.getSize(i2);
        if (mode == Integer.MIN_VALUE && size > getContext().getResources().getDisplayMetrics().widthPixels) {
            size = getContext().getResources().getDisplayMetrics().widthPixels;
        }
        if (mode2 == Integer.MIN_VALUE) {
            size2 = this.PGPF6hQ_2;
        }
        setMeasuredDimension(size, size2);
    }

    @Override // android.view.View
    public void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        this.QxJ9d_1 = getMeasuredWidth();
        int i5 = getContext().getResources().getDisplayMetrics().widthPixels;
        int i6 = this.QxJ9d_1;
        if (i6 >= i5) {
            f3718IFxWkV_5 = 450;
            f3720X6FRs_4 = 8000;
            return;
        }
        float floatValue = i6 / Float.valueOf(i5).floatValue();
        f3720X6FRs_4 = (int) (8000.0f * floatValue);
        f3718IFxWkV_5 = (int) (floatValue * 450.0f);
    }

    public void setColor(int i) {
        this.f3014KQgRr5e_0 = i;
        this.f3018KQgRr5e_0.setColor(i);
    }

    public void setProgress(int i) {
        setProgress(Float.valueOf(i).floatValue());
    }

    public void setWebProgress(int i) {
        if (i >= 0 && i < 95) {
            if (!this.f3019QxJ9d_1) {
                Mqv2r_3();
                return;
            } else {
                setProgress(i);
                return;
            }
        }
        setProgress(i);
        PGPF6hQ_2();
    }

    public WebProgress(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public void setProgress(float f) {
        if (this.f3721Mqv2r_3 == 0 && f == 100.0f) {
            setVisibility(8);
            return;
        }
        if (getVisibility() == 8) {
            setVisibility(0);
        }
        if (f >= 95.0f && this.f3721Mqv2r_3 != 2) {
            KQgRr5e_0(true);
        }
    }

    public WebProgress(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.QxJ9d_1 = 0;
        this.f3721Mqv2r_3 = 0;
        this.f3019QxJ9d_1 = false;
        this.f3013KQgRr5e_0 = 0.0f;
        this.f3017KQgRr5e_0 = new KQgRr5e_0();
        this.f3016KQgRr5e_0 = new QxJ9d_1();
        KQgRr5e_0(context, attributeSet, i);
    }

    public final void KQgRr5e_0(Context context, AttributeSet attributeSet, int i) {
        this.f3018KQgRr5e_0 = new Paint();
        this.f3014KQgRr5e_0 = Color.parseColor(KQgRr5e_0);
        this.f3018KQgRr5e_0.setAntiAlias(true);
        this.f3018KQgRr5e_0.setColor(this.f3014KQgRr5e_0);
        this.f3018KQgRr5e_0.setDither(true);
        this.f3018KQgRr5e_0.setStrokeCap(Paint.Cap.SQUARE);
        this.QxJ9d_1 = context.getResources().getDisplayMetrics().widthPixels;
        this.PGPF6hQ_2 = KQgRr5e_0(f3719IMuAHx_6);
    }

    public void setColor(String str) {
        setColor(Color.parseColor(str));
    }

    public final void KQgRr5e_0(boolean z) {
        float f = z ? 100.0f : 95.0f;
        Animator animator = this.f3015KQgRr5e_0;
        if (animator != null && animator.isStarted()) {
            this.f3015KQgRr5e_0.cancel();
        }
        float f2 = this.f3013KQgRr5e_0;
        if (f2 == 0.0f) {
            f2 = 1.0E-8f;
        }
        this.f3013KQgRr5e_0 = f2;
        if (!z) {
            ValueAnimator ofFloat = ValueAnimator.ofFloat(f2, f);
            ofFloat.setInterpolator(new LinearInterpolator());
            ofFloat.setDuration(((1.0f - (this.f3013KQgRr5e_0 / 100.0f)) - 0.05f) * f3720X6FRs_4);
            ofFloat.addUpdateListener(this.f3017KQgRr5e_0);
            ofFloat.start();
            this.f3015KQgRr5e_0 = ofFloat;
        } else {
            ValueAnimator valueAnimator = null;
            if (f2 < 95.0f) {
                valueAnimator = ValueAnimator.ofFloat(f2, 95.0f);
                valueAnimator.setInterpolator(new LinearInterpolator());
                valueAnimator.setDuration(((1.0f - (this.f3013KQgRr5e_0 / 100.0f)) - 0.05f) * f3718IFxWkV_5);
                valueAnimator.setInterpolator(new DecelerateInterpolator());
                valueAnimator.addUpdateListener(this.f3017KQgRr5e_0);
            }
            ObjectAnimator ofFloat2 = ObjectAnimator.ofFloat(this, "alpha", 1.0f, 0.0f);
            ofFloat2.setDuration(630L);
            ValueAnimator ofFloat3 = ValueAnimator.ofFloat(95.0f, 100.0f);
            ofFloat3.setDuration(500L);
            ofFloat3.addUpdateListener(this.f3017KQgRr5e_0);
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(ofFloat2, ofFloat3);
            if (valueAnimator != null) {
                AnimatorSet animatorSet2 = new AnimatorSet();
                animatorSet2.play(animatorSet).after(valueAnimator);
                animatorSet = animatorSet2;
            }
            animatorSet.addListener(this.f3016KQgRr5e_0);
            animatorSet.start();
            this.f3015KQgRr5e_0 = animatorSet;
        }
        this.f3721Mqv2r_3 = 1;
    }

    public final void KQgRr5e_0() {
        if (this.f3721Mqv2r_3 == 2 && this.f3013KQgRr5e_0 == 100.0f) {
            setVisibility(8);
            this.f3013KQgRr5e_0 = 0.0f;
            setAlpha(1.0f);
        }
        this.f3721Mqv2r_3 = 0;
    }

    public final int KQgRr5e_0(float f) {
        return (int) ((f * getContext().getResources().getDisplayMetrics().density) + 0.5f);
    }
}
