package com.webh5app.wrap.config;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.wang.avi.BuildConfig;
/* loaded from: classes.dex */
public class AppConfig {
    public static AppConfig Instance;
    public static ConfigData data;
    public static boolean isParsedConfig;
    public static SharedPreferences sharedPreferences;
    public ADModule advertising;
    public PrivacyModule agreement;
    public String appUrl;
    public BottomDialogModule bottomBar;
    public NavMenuModule drawer;
    public DownMenuModule dropdownBar;
    public BackBtnModule exit;
    public BottomNavModule footer;
    public RefreshModule fresh;
    public GuideModule guide;
    public AppBarModule header;
    public HideBottomModule hideBottom;
    public InjectJSModule injectJs;
    public InstallTipModule installTip;
    public KeepScreenOnModule keepScreen;
    public LaunchMiniProgramModule launchMiniProgram;
    public LoadingStyleModule loadStyle;
    public LongPressModule longPress;
    public NoNetModule noNet;
    public String orientation;
    public ScanModule scan;
    public SystemShareModule share;
    public SwipeBackModule skidBack;
    public StatusBarModule statusBar;
    public X5Module useX5;
    public UserAgentModule userAgent;
    public ZoomModule zoom;

    public static String getLocalConfig(String str) {
        SharedPreferences sharedPreferences2 = sharedPreferences;
        return sharedPreferences2 == null ? BuildConfig.FLAVOR : sharedPreferences2.getString(str, BuildConfig.FLAVOR);
    }

    public static void initLocalConfig(Context context) {
        sharedPreferences = context.getSharedPreferences("bufandata", 0);
    }

    public static void parseConfig(String str) {
        try {
            try {
                ConfigData configData = (ConfigData) new Gson().fromJson(str, (Class<Object>) ConfigData.class);
                data = configData;
                if (configData.code == 1) {
                    Instance = configData.data;
                }
            } catch (Exception e) {
                e.printStackTrace();
                Instance = null;
            }
        } finally {
            isParsedConfig = true;
        }
    }

    public static void parseConfigInternal(String str) {
        Gson gson = new Gson();
        try {
            try {
                ConfigData configData = new ConfigData();
                data = configData;
                configData.msg = BuildConfig.FLAVOR;
                configData.code = 1;
                configData.data = (AppConfig) gson.fromJson(str, (Class<Object>) AppConfig.class);
                if (data.code == 1) {
                    Instance = data.data;
                }
            } catch (Exception e) {
                e.printStackTrace();
                Instance = null;
            }
        } finally {
            isParsedConfig = true;
        }
    }

    public static void writeLocalConfig(String str, String str2) {
        SharedPreferences sharedPreferences2 = sharedPreferences;
        if (sharedPreferences2 == null) {
            return;
        }
        SharedPreferences.Editor edit = sharedPreferences2.edit();
        edit.putString(str, str2);
        edit.apply();
    }

    public native void initbufan(String str, String str2);
}
