package com.webh5app.utils;

import android.util.Base64;
import android.util.Log;
import androidx.recyclerview.widget.RecyclerView;
import androidx.transition.Transition;
import com.wang.avi.BuildConfig;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.JSONObject;
/* loaded from: classes.dex */
public class JwtUtils {
    public static final String TAG = "JwtUtils";
    public static final String key1 = "U2xkVQ";
    public static final String key2 = "VFVRMQ";
    public static final String key3 = "czIwMT";
    public static final String key4 = "kwNTIw";
    public static final String key5 = "MWtOTD";
    public static final String key6 = "V4UEdMRTlOU3paSA";
    public static final String key7 = "H3kTiX";
    public static final String key8 = "keyW3ABy46";

    public static final String KEY(String str) {
        return key3 + str;
    }

    public static final String KEY2(String str) {
        return key5 + str;
    }

    public static final String KEY3(String str) {
        return key7 + str;
    }

    public static byte[] initKey(String str) {
        byte[] bytes = str.getBytes();
        byte[] bArr = new byte[RecyclerView.WGk6X_27.FLAG_TMP_DETACHED];
        for (int i = 0; i < 256; i++) {
            bArr[i] = (byte) i;
        }
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        int i2 = 0;
        int i3 = 0;
        for (int i4 = 0; i4 < 256; i4++) {
            i3 = ((bytes[i2] & 255) + (bArr[i4] & 255) + i3) & 255;
            byte b = bArr[i4];
            bArr[i4] = bArr[i3];
            bArr[i3] = b;
            i2 = (i2 + 1) % bytes.length;
        }
        return bArr;
    }

    public static JSONObject jsonDecode(String str) {
        try {
            return new JSONObject(str);
        } catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String jsonEncode(JSONObject jSONObject) {
        return (jSONObject == null || jSONObject.length() == 0 || "null".equals(jSONObject)) ? BuildConfig.FLAVOR : jSONObject.toString();
    }

    public static JSONObject jwtDecode(String str) {
        String safeUrlBase64Decode = safeUrlBase64Decode(KEY2(key6));
        String[] split = str.split("\\.");
        String sign = sign(split[0] + '.' + split[1], safeUrlBase64Decode);
        if (!sign.equals(split[2])) {
            Log.d(TAG, "jwtDecode error: " + split[2] + "-signature: " + sign);
            return null;
        }
        return jsonDecode(safeUrlBase64Decode(split[1]));
    }

    public static String jwtEncode(JSONObject jSONObject) {
        String safeUrlBase64Decode = safeUrlBase64Decode(safeUrlBase64Decode(key1));
        String safeUrlBase64Decode2 = safeUrlBase64Decode(safeUrlBase64Decode(key2));
        String safeUrlBase64Decode3 = safeUrlBase64Decode(KEY(key4));
        String safeUrlBase64Decode4 = safeUrlBase64Decode(KEY2(key6));
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("typ", safeUrlBase64Decode);
            jSONObject2.put("alg", safeUrlBase64Decode2);
            jSONObject2.put("kid", safeUrlBase64Decode3);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        String safeUrlBase64Encode = safeUrlBase64Encode(jsonEncode(jSONObject2));
        String safeUrlBase64Encode2 = safeUrlBase64Encode(jsonEncode(jSONObject));
        String sign = sign(safeUrlBase64Encode + "." + safeUrlBase64Encode2, safeUrlBase64Decode4);
        return safeUrlBase64Encode + '.' + safeUrlBase64Encode2 + '.' + sign;
    }

    public static JSONObject mainDecode(String str) {
        return jwtDecode(rc4Decode(str));
    }

    public static String mainEncode(JSONObject jSONObject) {
        return rc4Encode(jwtEncode(jSONObject));
    }

    public static byte[] rc4(byte[] bArr, String str) {
        if (bArr == null || str == null) {
            return null;
        }
        byte[] initKey = initKey(str);
        byte[] bArr2 = new byte[bArr.length];
        int i = 0;
        int i2 = 0;
        for (int i3 = 0; i3 < bArr.length; i3++) {
            i = (i + 1) & 255;
            i2 = ((initKey[i] & 255) + i2) & 255;
            byte b = initKey[i];
            initKey[i] = initKey[i2];
            initKey[i2] = b;
            bArr2[i3] = (byte) (initKey[((initKey[i] & 255) + (initKey[i2] & 255)) & 255] ^ bArr[i3]);
        }
        return bArr2;
    }

    public static byte[] rc4Base64Decode(String str) {
        int length;
        String replace = str.replace('-', '+').replace('_', '/');
        if (replace.length() % 4 > 0) {
            replace = replace + Collections.nCopies(4 - length, '=');
        }
        return Base64.decode(replace, 0);
    }

    public static String rc4Base64Encode(byte[] bArr) {
        if (bArr == null) {
            return null;
        }
        return Base64.encodeToString(bArr, 2).replace('+', '-').replace('/', '_').replace("=", BuildConfig.FLAVOR);
    }

    public static String rc4Decode(String str) {
        return new String(rc4(rc4Base64Decode(str), KEY3(key8)));
    }

    public static String rc4Encode(String str) {
        return rc4Base64Encode(rc4(str.getBytes(), KEY3(key8)));
    }

    public static String safeUrlBase64Decode(String str) {
        int length;
        String replace = str.replace('-', '+').replace('_', '/');
        if (replace.length() % 4 > 0) {
            replace = replace + Collections.nCopies(4 - length, '=');
        }
        try {
            return new String(Base64.decode(replace, 0), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return BuildConfig.FLAVOR;
        }
    }

    public static String safeUrlBase64Encode(String str) {
        return Base64.encodeToString(str.getBytes(), 2).replace('+', '-').replace('/', '_').replace("=", BuildConfig.FLAVOR);
    }

    public static String sign(String str, String str2) {
        String str3;
        try {
            Log.d(TAG, str);
            SecretKeySpec secretKeySpec = new SecretKeySpec(str2.getBytes(), "HmacMD5");
            Mac mac = Mac.getInstance(secretKeySpec.getAlgorithm());
            mac.init(secretKeySpec);
            str3 = Base64.encodeToString(mac.doFinal(str.getBytes()), 2);
        } catch (Exception e) {
            PrintStream printStream = System.out;
            printStream.println("Error HmacMD5 ===========" + e.getMessage());
            str3 = BuildConfig.FLAVOR;
        }
        return str3.replace('+', '-').replace('/', '_').replace("=", BuildConfig.FLAVOR);
    }

    public static String test() {
        new JwtUtils();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(Transition.MATCH_ID_STR, 1);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        String mainEncode = mainEncode(jSONObject);
        JSONObject mainDecode = mainDecode(mainEncode);
        return mainEncode + '\n' + mainDecode.toString();
    }
}
