package com.webh5app.utils;

import com.wang.avi.BuildConfig;
import com.webh5app.app.MainActivity;
import org.json.JSONObject;
/* loaded from: classes.dex */
public class IconFontUtils {
    public static JSONObject fontConfig;
    public static MainActivity mContext;

    public static String getFontString(String str) {
        JSONObject jSONObject = fontConfig;
        if (jSONObject != null && jSONObject.has(str)) {
            int i = 0;
            try {
                i = fontConfig.getInt(str);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (i > 0) {
                String hexString = Integer.toHexString(i);
                return "&#x" + hexString + ";";
            }
            return BuildConfig.FLAVOR;
        }
        return BuildConfig.FLAVOR;
    }

    public static void init(MainActivity mainActivity) {
        mContext = mainActivity;
        try {
            fontConfig = new JSONObject(Utils.readAssetString(mainActivity, "iconfont.json"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
