package com.google.android.material.internal;

import X6FRs_4.JZJr_16.H5YG8fq_22;
import android.animation.Animator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.transition.Transition;
import java.util.Map;
/* loaded from: classes.dex */
public class TextScale extends Transition {
    public static final String PROPNAME_SCALE = "android:textscale:scale";

    private void captureValues(H5YG8fq_22 h5YG8fq_22) {
        View view = h5YG8fq_22.KQgRr5e_0;
        if (view instanceof TextView) {
            h5YG8fq_22.f566KQgRr5e_0.put(PROPNAME_SCALE, Float.valueOf(((TextView) view).getScaleX()));
        }
    }

    @Override // androidx.transition.Transition
    public void captureEndValues(H5YG8fq_22 h5YG8fq_22) {
        captureValues(h5YG8fq_22);
    }

    @Override // androidx.transition.Transition
    public void captureStartValues(H5YG8fq_22 h5YG8fq_22) {
        captureValues(h5YG8fq_22);
    }

    @Override // androidx.transition.Transition
    public Animator createAnimator(ViewGroup viewGroup, H5YG8fq_22 h5YG8fq_22, H5YG8fq_22 h5YG8fq_222) {
        if (h5YG8fq_22 == null || h5YG8fq_222 == null || !(h5YG8fq_22.KQgRr5e_0 instanceof TextView)) {
            return null;
        }
        View view = h5YG8fq_222.KQgRr5e_0;
        if (view instanceof TextView) {
            final TextView textView = (TextView) view;
            Map<String, Object> map = h5YG8fq_22.f566KQgRr5e_0;
            Map<String, Object> map2 = h5YG8fq_222.f566KQgRr5e_0;
            float floatValue = map.get(PROPNAME_SCALE) != null ? ((Float) map.get(PROPNAME_SCALE)).floatValue() : 1.0f;
            float floatValue2 = map2.get(PROPNAME_SCALE) != null ? ((Float) map2.get(PROPNAME_SCALE)).floatValue() : 1.0f;
            if (floatValue == floatValue2) {
                return null;
            }
            ValueAnimator ofFloat = ValueAnimator.ofFloat(floatValue, floatValue2);
            ofFloat.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() { // from class: com.google.android.material.internal.TextScale.1
                @Override // android.animation.ValueAnimator.AnimatorUpdateListener
                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float floatValue3 = ((Float) valueAnimator.getAnimatedValue()).floatValue();
                    textView.setScaleX(floatValue3);
                    textView.setScaleY(floatValue3);
                }
            });
            return ofFloat;
        }
        return null;
    }
}
