package com.google.android.material.internal;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.JZJr_16;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.XuVgy_28;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.material.R;
/* loaded from: classes.dex */
public class ScrimInsetsFrameLayout extends FrameLayout {
    public Drawable insetForeground;
    public Rect insets;
    public Rect tempRect;

    public ScrimInsetsFrameLayout(Context context) {
        this(context, null);
    }

    @Override // android.view.View
    public void draw(Canvas canvas) {
        super.draw(canvas);
        int width = getWidth();
        int height = getHeight();
        if (this.insets == null || this.insetForeground == null) {
            return;
        }
        int save = canvas.save();
        canvas.translate(getScrollX(), getScrollY());
        this.tempRect.set(0, 0, width, this.insets.top);
        this.insetForeground.setBounds(this.tempRect);
        this.insetForeground.draw(canvas);
        this.tempRect.set(0, height - this.insets.bottom, width, height);
        this.insetForeground.setBounds(this.tempRect);
        this.insetForeground.draw(canvas);
        Rect rect = this.tempRect;
        Rect rect2 = this.insets;
        rect.set(0, rect2.top, rect2.left, height - rect2.bottom);
        this.insetForeground.setBounds(this.tempRect);
        this.insetForeground.draw(canvas);
        Rect rect3 = this.tempRect;
        Rect rect4 = this.insets;
        rect3.set(width - rect4.right, rect4.top, width, height - rect4.bottom);
        this.insetForeground.setBounds(this.tempRect);
        this.insetForeground.draw(canvas);
        canvas.restoreToCount(save);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Drawable drawable = this.insetForeground;
        if (drawable != null) {
            drawable.setCallback(this);
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Drawable drawable = this.insetForeground;
        if (drawable != null) {
            drawable.setCallback(null);
        }
    }

    public void onInsetsChanged(XuVgy_28 xuVgy_28) {
    }

    public ScrimInsetsFrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ScrimInsetsFrameLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.tempRect = new Rect();
        TypedArray obtainStyledAttributes = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.ScrimInsetsFrameLayout, i, R.style.Widget_Design_ScrimInsetsFrameLayout, new int[0]);
        this.insetForeground = obtainStyledAttributes.getDrawable(R.styleable.ScrimInsetsFrameLayout_insetForeground);
        obtainStyledAttributes.recycle();
        setWillNotDraw(true);
        ZzDuCHW_20.KQgRr5e_0(this, new JZJr_16() { // from class: com.google.android.material.internal.ScrimInsetsFrameLayout.1
            @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.JZJr_16
            public XuVgy_28 onApplyWindowInsets(View view, XuVgy_28 xuVgy_28) {
                ScrimInsetsFrameLayout scrimInsetsFrameLayout = ScrimInsetsFrameLayout.this;
                if (scrimInsetsFrameLayout.insets == null) {
                    scrimInsetsFrameLayout.insets = new Rect();
                }
                ScrimInsetsFrameLayout.this.insets.set(xuVgy_28.QxJ9d_1(), xuVgy_28.Mqv2r_3(), xuVgy_28.PGPF6hQ_2(), xuVgy_28.KQgRr5e_0());
                ScrimInsetsFrameLayout.this.onInsetsChanged(xuVgy_28);
                ScrimInsetsFrameLayout.this.setWillNotDraw(!xuVgy_28.m246KQgRr5e_0() || ScrimInsetsFrameLayout.this.insetForeground == null);
                ZzDuCHW_20.m262KQgRr5e_0((View) ScrimInsetsFrameLayout.this);
                return xuVgy_28.m245KQgRr5e_0();
            }
        });
    }
}
