package com.google.android.material.internal;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.NzhupJ_29.Mqv2r_3;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import X6FRs_4.KQgRr5e_0.KQgRr5e_0;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Checkable;
import android.widget.ImageButton;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.recyclerview.widget.RecyclerView;
/* loaded from: classes.dex */
public class CheckableImageButton extends AppCompatImageButton implements Checkable {
    public static final int[] DRAWABLE_STATE_CHECKED = {16842912};
    public boolean checked;

    public CheckableImageButton(Context context) {
        this(context, null);
    }

    @Override // android.widget.Checkable
    public boolean isChecked() {
        return this.checked;
    }

    @Override // android.widget.ImageView, android.view.View
    public int[] onCreateDrawableState(int i) {
        if (this.checked) {
            return ImageButton.mergeDrawableStates(super.onCreateDrawableState(i + DRAWABLE_STATE_CHECKED.length), DRAWABLE_STATE_CHECKED);
        }
        return super.onCreateDrawableState(i);
    }

    @Override // android.widget.Checkable
    public void setChecked(boolean z) {
        if (this.checked != z) {
            this.checked = z;
            refreshDrawableState();
            sendAccessibilityEvent(RecyclerView.WGk6X_27.FLAG_MOVED);
        }
    }

    @Override // android.widget.Checkable
    public void toggle() {
        setChecked(!this.checked);
    }

    public CheckableImageButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, KQgRr5e_0.imageButtonStyle);
    }

    public CheckableImageButton(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        ZzDuCHW_20.KQgRr5e_0(this, new X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0() { // from class: com.google.android.material.internal.CheckableImageButton.1
            @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0
            public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
                super.onInitializeAccessibilityEvent(view, accessibilityEvent);
                accessibilityEvent.setChecked(CheckableImageButton.this.isChecked());
            }

            @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0
            public void onInitializeAccessibilityNodeInfo(View view, Mqv2r_3 mqv2r_3) {
                super.onInitializeAccessibilityNodeInfo(view, mqv2r_3);
                mqv2r_3.PGPF6hQ_2(true);
                mqv2r_3.Mqv2r_3(CheckableImageButton.this.isChecked());
            }
        });
    }
}
