package com.google.android.material.appbar;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import android.view.View;
/* loaded from: classes.dex */
public class ViewOffsetHelper {
    public int layoutLeft;
    public int layoutTop;
    public int offsetLeft;
    public int offsetTop;
    public final View view;

    public ViewOffsetHelper(View view) {
        this.view = view;
    }

    private void updateOffsets() {
        View view = this.view;
        ZzDuCHW_20.X6FRs_4(view, this.offsetTop - (view.getTop() - this.layoutTop));
        View view2 = this.view;
        ZzDuCHW_20.Mqv2r_3(view2, this.offsetLeft - (view2.getLeft() - this.layoutLeft));
    }

    public int getLayoutLeft() {
        return this.layoutLeft;
    }

    public int getLayoutTop() {
        return this.layoutTop;
    }

    public int getLeftAndRightOffset() {
        return this.offsetLeft;
    }

    public int getTopAndBottomOffset() {
        return this.offsetTop;
    }

    public void onViewLayout() {
        this.layoutTop = this.view.getTop();
        this.layoutLeft = this.view.getLeft();
        updateOffsets();
    }

    public boolean setLeftAndRightOffset(int i) {
        if (this.offsetLeft != i) {
            this.offsetLeft = i;
            updateOffsets();
            return true;
        }
        return false;
    }

    public boolean setTopAndBottomOffset(int i) {
        if (this.offsetTop != i) {
            this.offsetTop = i;
            updateOffsets();
            return true;
        }
        return false;
    }
}
