package butterknife;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
/* loaded from: classes.dex */
public final class ButterKnife {
    public static final Map<Class<?>, Constructor<? extends Unbinder>> KQgRr5e_0 = new LinkedHashMap();

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public static boolean f2673KQgRr5e_0;

    public ButterKnife() {
        throw new AssertionError("No instances.");
    }

    public static Unbinder KQgRr5e_0(Activity activity) {
        return KQgRr5e_0(activity, activity.getWindow().getDecorView());
    }

    public static Unbinder KQgRr5e_0(Object obj, View view) {
        Class<?> cls = obj.getClass();
        if (f2673KQgRr5e_0) {
            Log.d("ButterKnife", "Looking up binding for " + cls.getName());
        }
        Constructor<? extends Unbinder> KQgRr5e_02 = KQgRr5e_0(cls);
        if (KQgRr5e_02 == null) {
            return Unbinder.KQgRr5e_0;
        }
        try {
            return KQgRr5e_02.newInstance(obj, view);
        } catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to invoke " + KQgRr5e_02, e);
        } catch (InstantiationException e2) {
            throw new RuntimeException("Unable to invoke " + KQgRr5e_02, e2);
        } catch (InvocationTargetException e3) {
            Throwable cause = e3.getCause();
            if (!(cause instanceof RuntimeException)) {
                if (cause instanceof Error) {
                    throw ((Error) cause);
                }
                throw new RuntimeException("Unable to create binding instance.", cause);
            }
            throw ((RuntimeException) cause);
        }
    }

    public static Constructor<? extends Unbinder> KQgRr5e_0(Class<?> cls) {
        Constructor<? extends Unbinder> KQgRr5e_02;
        Constructor<? extends Unbinder> constructor = KQgRr5e_0.get(cls);
        if (constructor == null && !KQgRr5e_0.containsKey(cls)) {
            String name = cls.getName();
            if (!name.startsWith("android.") && !name.startsWith("java.") && !name.startsWith("androidx.")) {
                try {
                    ClassLoader classLoader = cls.getClassLoader();
                    KQgRr5e_02 = classLoader.loadClass(name + "_ViewBinding").getConstructor(cls, View.class);
                    if (f2673KQgRr5e_0) {
                        Log.d("ButterKnife", "HIT: Loaded binding class and constructor.");
                    }
                } catch (ClassNotFoundException unused) {
                    if (f2673KQgRr5e_0) {
                        Log.d("ButterKnife", "Not found. Trying superclass " + cls.getSuperclass().getName());
                    }
                    KQgRr5e_02 = KQgRr5e_0(cls.getSuperclass());
                } catch (NoSuchMethodException e) {
                    throw new RuntimeException("Unable to find binding constructor for " + name, e);
                }
                KQgRr5e_0.put(cls, KQgRr5e_02);
                return KQgRr5e_02;
            } else if (f2673KQgRr5e_0) {
                Log.d("ButterKnife", "MISS: Reached framework class. Abandoning search.");
                return null;
            } else {
                return null;
            }
        }
        if (f2673KQgRr5e_0) {
            Log.d("ButterKnife", "HIT: Cached in binding map.");
        }
        return constructor;
    }
}
