package androidx.viewpager.widget;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.JZJr_16;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.XuVgy_28;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.Scroller;
import androidx.customview.view.AbsSavedState;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
/* loaded from: classes.dex */
public class ViewPager extends ViewGroup {
    public int BVpCZyH_19;
    public int Eps4cJe_18;
    public int EuDEkJe_12;

    /* renamed from: FSaI4_7  reason: collision with root package name */
    public int f3606FSaI4_7;

    /* renamed from: FSaI4_7  reason: collision with other field name */
    public boolean f2629FSaI4_7;

    /* renamed from: IFxWkV_5  reason: collision with root package name */
    public float f3607IFxWkV_5;

    /* renamed from: IFxWkV_5  reason: collision with other field name */
    public int f2630IFxWkV_5;

    /* renamed from: IFxWkV_5  reason: collision with other field name */
    public boolean f2631IFxWkV_5;

    /* renamed from: IMuAHx_6  reason: collision with root package name */
    public int f3608IMuAHx_6;

    /* renamed from: IMuAHx_6  reason: collision with other field name */
    public boolean f2632IMuAHx_6;
    public int JZJr_16;

    /* renamed from: KNBe_11  reason: collision with root package name */
    public int f3609KNBe_11;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public float f2633KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public int f2634KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 f2635KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Rect f2636KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Drawable f2637KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Parcelable f2638KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public VelocityTracker f2639KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public EdgeEffect f2640KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Scroller f2641KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final IFxWkV_5 f2642KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Nm6q_10 f2643KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Xgtqvk_8 f2644KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public XnFJ5_9 f2645KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public ClassLoader f2646KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Runnable f2647KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final ArrayList<IFxWkV_5> f2648KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public List<Xgtqvk_8> f2649KQgRr5e_0;
    public int LGe8pk_15;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public float f3610Mqv2r_3;

    /* renamed from: Mqv2r_3  reason: collision with other field name */
    public int f2650Mqv2r_3;

    /* renamed from: Mqv2r_3  reason: collision with other field name */
    public boolean f2651Mqv2r_3;
    public int NQvZgp_17;

    /* renamed from: Nm6q_10  reason: collision with root package name */
    public int f3611Nm6q_10;
    public float PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public int f2652PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public boolean f2653PGPF6hQ_2;
    public float QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public int f2654QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public EdgeEffect f2655QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public Xgtqvk_8 f2656QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public ArrayList<View> f2657QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public List<FSaI4_7> f2658QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f2659QxJ9d_1;
    public int WwEq_13;

    /* renamed from: X6FRs_4  reason: collision with root package name */
    public float f3612X6FRs_4;

    /* renamed from: X6FRs_4  reason: collision with other field name */
    public int f2660X6FRs_4;

    /* renamed from: X6FRs_4  reason: collision with other field name */
    public boolean f2661X6FRs_4;

    /* renamed from: Xgtqvk_8  reason: collision with root package name */
    public int f3613Xgtqvk_8;

    /* renamed from: Xgtqvk_8  reason: collision with other field name */
    public boolean f2662Xgtqvk_8;

    /* renamed from: XnFJ5_9  reason: collision with root package name */
    public int f3614XnFJ5_9;

    /* renamed from: XnFJ5_9  reason: collision with other field name */
    public boolean f2663XnFJ5_9;
    public int YghfZG_14;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public static final int[] f2628KQgRr5e_0 = {16842931};

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public static final Comparator<IFxWkV_5> f2627KQgRr5e_0 = new KQgRr5e_0();
    public static final Interpolator KQgRr5e_0 = new QxJ9d_1();

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public static final KNBe_11 f2626KQgRr5e_0 = new KNBe_11();

    /* loaded from: classes.dex */
    public interface FSaI4_7 {
        void onAdapterChanged(ViewPager viewPager, X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0, X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_02);
    }

    /* loaded from: classes.dex */
    public static class IFxWkV_5 {
        public float KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public int f2664KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public Object f2665KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public boolean f2666KQgRr5e_0;
        public float QxJ9d_1;
    }

    /* loaded from: classes.dex */
    public class IMuAHx_6 extends X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0 {
        public IMuAHx_6() {
        }

        public final boolean KQgRr5e_0() {
            X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0 = ViewPager.this.f2635KQgRr5e_0;
            return kQgRr5e_0 != null && kQgRr5e_0.KQgRr5e_0() > 1;
        }

        @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0;
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName(ViewPager.class.getName());
            accessibilityEvent.setScrollable(KQgRr5e_0());
            if (accessibilityEvent.getEventType() != 4096 || (kQgRr5e_0 = ViewPager.this.f2635KQgRr5e_0) == null) {
                return;
            }
            accessibilityEvent.setItemCount(kQgRr5e_0.KQgRr5e_0());
            accessibilityEvent.setFromIndex(ViewPager.this.f2654QxJ9d_1);
            accessibilityEvent.setToIndex(ViewPager.this.f2654QxJ9d_1);
        }

        @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0
        public void onInitializeAccessibilityNodeInfo(View view, X6FRs_4.IMuAHx_6.EuDEkJe_12.NzhupJ_29.Mqv2r_3 mqv2r_3) {
            super.onInitializeAccessibilityNodeInfo(view, mqv2r_3);
            mqv2r_3.m231KQgRr5e_0((CharSequence) ViewPager.class.getName());
            mqv2r_3.WwEq_13(KQgRr5e_0());
            if (ViewPager.this.canScrollHorizontally(1)) {
                mqv2r_3.m229KQgRr5e_0(RecyclerView.WGk6X_27.FLAG_APPEARED_IN_PRE_LAYOUT);
            }
            if (ViewPager.this.canScrollHorizontally(-1)) {
                mqv2r_3.m229KQgRr5e_0(RecyclerView.WGk6X_27.FLAG_BOUNCED_FROM_HIDDEN_LIST);
            }
        }

        @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0
        public boolean performAccessibilityAction(View view, int i, Bundle bundle) {
            if (super.performAccessibilityAction(view, i, bundle)) {
                return true;
            }
            if (i != 4096) {
                if (i == 8192 && ViewPager.this.canScrollHorizontally(-1)) {
                    ViewPager viewPager = ViewPager.this;
                    viewPager.setCurrentItem(viewPager.f2654QxJ9d_1 - 1);
                    return true;
                }
                return false;
            } else if (ViewPager.this.canScrollHorizontally(1)) {
                ViewPager viewPager2 = ViewPager.this;
                viewPager2.setCurrentItem(viewPager2.f2654QxJ9d_1 + 1);
                return true;
            } else {
                return false;
            }
        }
    }

    /* loaded from: classes.dex */
    public static class KNBe_11 implements Comparator<View> {
        @Override // java.util.Comparator
        /* renamed from: KQgRr5e_0 */
        public int compare(View view, View view2) {
            LayoutParams layoutParams = (LayoutParams) view.getLayoutParams();
            LayoutParams layoutParams2 = (LayoutParams) view2.getLayoutParams();
            boolean z = layoutParams.f2668KQgRr5e_0;
            if (z != layoutParams2.f2668KQgRr5e_0) {
                return z ? 1 : -1;
            }
            return layoutParams.QxJ9d_1 - layoutParams2.QxJ9d_1;
        }
    }

    /* loaded from: classes.dex */
    public static class KQgRr5e_0 implements Comparator<IFxWkV_5> {
        @Override // java.util.Comparator
        /* renamed from: KQgRr5e_0 */
        public int compare(IFxWkV_5 iFxWkV_5, IFxWkV_5 iFxWkV_52) {
            return iFxWkV_5.f2664KQgRr5e_0 - iFxWkV_52.f2664KQgRr5e_0;
        }
    }

    /* loaded from: classes.dex */
    public class Mqv2r_3 implements JZJr_16 {
        public final Rect KQgRr5e_0 = new Rect();

        public Mqv2r_3() {
        }

        @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.JZJr_16
        public XuVgy_28 onApplyWindowInsets(View view, XuVgy_28 xuVgy_28) {
            XuVgy_28 QxJ9d_1 = ZzDuCHW_20.QxJ9d_1(view, xuVgy_28);
            if (QxJ9d_1.m247QxJ9d_1()) {
                return QxJ9d_1;
            }
            Rect rect = this.KQgRr5e_0;
            rect.left = QxJ9d_1.QxJ9d_1();
            rect.top = QxJ9d_1.Mqv2r_3();
            rect.right = QxJ9d_1.PGPF6hQ_2();
            rect.bottom = QxJ9d_1.KQgRr5e_0();
            int childCount = ViewPager.this.getChildCount();
            for (int i = 0; i < childCount; i++) {
                XuVgy_28 KQgRr5e_0 = ZzDuCHW_20.KQgRr5e_0(ViewPager.this.getChildAt(i), QxJ9d_1);
                rect.left = Math.min(KQgRr5e_0.QxJ9d_1(), rect.left);
                rect.top = Math.min(KQgRr5e_0.Mqv2r_3(), rect.top);
                rect.right = Math.min(KQgRr5e_0.PGPF6hQ_2(), rect.right);
                rect.bottom = Math.min(KQgRr5e_0.KQgRr5e_0(), rect.bottom);
            }
            return QxJ9d_1.KQgRr5e_0(rect.left, rect.top, rect.right, rect.bottom);
        }
    }

    /* loaded from: classes.dex */
    public class Nm6q_10 extends DataSetObserver {
        public Nm6q_10() {
        }

        @Override // android.database.DataSetObserver
        public void onChanged() {
            ViewPager.this.m992KQgRr5e_0();
        }

        @Override // android.database.DataSetObserver
        public void onInvalidated() {
            ViewPager.this.m992KQgRr5e_0();
        }
    }

    /* loaded from: classes.dex */
    public class PGPF6hQ_2 implements Runnable {
        public PGPF6hQ_2() {
        }

        @Override // java.lang.Runnable
        public void run() {
            ViewPager.this.setScrollState(0);
            ViewPager.this.Mqv2r_3();
        }
    }

    /* loaded from: classes.dex */
    public static class QxJ9d_1 implements Interpolator {
        @Override // android.animation.TimeInterpolator
        public float getInterpolation(float f) {
            float f2 = f - 1.0f;
            return (f2 * f2 * f2 * f2 * f2) + 1.0f;
        }
    }

    /* loaded from: classes.dex */
    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new KQgRr5e_0();
        public int KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public Parcelable f2671KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public ClassLoader f2672KQgRr5e_0;

        /* loaded from: classes.dex */
        public static class KQgRr5e_0 implements Parcelable.ClassLoaderCreator<SavedState> {
            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: KQgRr5e_0 */
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " position=" + this.KQgRr5e_0 + "}";
        }

        @Override // androidx.customview.view.AbsSavedState, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeInt(this.KQgRr5e_0);
            parcel.writeParcelable(this.f2671KQgRr5e_0, i);
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            classLoader = classLoader == null ? SavedState.class.getClassLoader() : classLoader;
            this.KQgRr5e_0 = parcel.readInt();
            this.f2671KQgRr5e_0 = parcel.readParcelable(classLoader);
            this.f2672KQgRr5e_0 = classLoader;
        }
    }

    @Target({ElementType.TYPE})
    @Inherited
    @Retention(RetentionPolicy.RUNTIME)
    /* loaded from: classes.dex */
    public @interface X6FRs_4 {
    }

    /* loaded from: classes.dex */
    public interface Xgtqvk_8 {
        void onPageScrollStateChanged(int i);

        void onPageScrolled(int i, float f, int i2);

        void onPageSelected(int i);
    }

    /* loaded from: classes.dex */
    public interface XnFJ5_9 {
        void KQgRr5e_0(View view, float f);
    }

    public ViewPager(Context context) {
        super(context);
        this.f2648KQgRr5e_0 = new ArrayList<>();
        this.f2642KQgRr5e_0 = new IFxWkV_5();
        this.f2636KQgRr5e_0 = new Rect();
        this.f2652PGPF6hQ_2 = -1;
        this.f2638KQgRr5e_0 = null;
        this.f2646KQgRr5e_0 = null;
        this.f2633KQgRr5e_0 = -3.4028235E38f;
        this.QxJ9d_1 = Float.MAX_VALUE;
        this.f3606FSaI4_7 = 1;
        this.f3609KNBe_11 = -1;
        this.f2662Xgtqvk_8 = true;
        this.f2647KQgRr5e_0 = new PGPF6hQ_2();
        this.BVpCZyH_19 = 0;
        PGPF6hQ_2();
    }

    private int getClientWidth() {
        return (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight();
    }

    private void setScrollingCacheEnabled(boolean z) {
        if (this.f2651Mqv2r_3 != z) {
            this.f2651Mqv2r_3 = z;
        }
    }

    public final void IFxWkV_5() {
        if (this.Eps4cJe_18 != 0) {
            ArrayList<View> arrayList = this.f2657QxJ9d_1;
            if (arrayList == null) {
                this.f2657QxJ9d_1 = new ArrayList<>();
            } else {
                arrayList.clear();
            }
            int childCount = getChildCount();
            for (int i = 0; i < childCount; i++) {
                this.f2657QxJ9d_1.add(getChildAt(i));
            }
            Collections.sort(this.f2657QxJ9d_1, f2626KQgRr5e_0);
        }
    }

    public void KQgRr5e_0(FSaI4_7 fSaI4_7) {
        if (this.f2658QxJ9d_1 == null) {
            this.f2658QxJ9d_1 = new ArrayList();
        }
        this.f2658QxJ9d_1.add(fSaI4_7);
    }

    public void Mqv2r_3() {
        PGPF6hQ_2(this.f2654QxJ9d_1);
    }

    public void PGPF6hQ_2() {
        setWillNotDraw(false);
        setDescendantFocusability(262144);
        setFocusable(true);
        Context context = getContext();
        this.f2641KQgRr5e_0 = new Scroller(context, KQgRr5e_0);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        float f = context.getResources().getDisplayMetrics().density;
        this.f3611Nm6q_10 = viewConfiguration.getScaledPagingTouchSlop();
        this.EuDEkJe_12 = (int) (400.0f * f);
        this.WwEq_13 = viewConfiguration.getScaledMaximumFlingVelocity();
        this.f2640KQgRr5e_0 = new EdgeEffect(context);
        this.f2655QxJ9d_1 = new EdgeEffect(context);
        this.YghfZG_14 = (int) (25.0f * f);
        this.LGe8pk_15 = (int) (2.0f * f);
        this.f3613Xgtqvk_8 = (int) (f * 16.0f);
        ZzDuCHW_20.KQgRr5e_0(this, new IMuAHx_6());
        if (ZzDuCHW_20.m269QxJ9d_1((View) this) == 0) {
            ZzDuCHW_20.IMuAHx_6(this, 1);
        }
        ZzDuCHW_20.KQgRr5e_0(this, new Mqv2r_3());
    }

    public void QxJ9d_1(FSaI4_7 fSaI4_7) {
        List<FSaI4_7> list = this.f2658QxJ9d_1;
        if (list != null) {
            list.remove(fSaI4_7);
        }
    }

    public final void X6FRs_4() {
        int i = 0;
        while (i < getChildCount()) {
            if (!((LayoutParams) getChildAt(i).getLayoutParams()).f2668KQgRr5e_0) {
                removeViewAt(i);
                i--;
            }
            i++;
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public void addFocusables(ArrayList<View> arrayList, int i, int i2) {
        IFxWkV_5 QxJ9d_12;
        int size = arrayList.size();
        int descendantFocusability = getDescendantFocusability();
        if (descendantFocusability != 393216) {
            for (int i3 = 0; i3 < getChildCount(); i3++) {
                View childAt = getChildAt(i3);
                if (childAt.getVisibility() == 0 && (QxJ9d_12 = QxJ9d_1(childAt)) != null && QxJ9d_12.f2664KQgRr5e_0 == this.f2654QxJ9d_1) {
                    childAt.addFocusables(arrayList, i, i2);
                }
            }
        }
        if ((descendantFocusability != 262144 || size == arrayList.size()) && isFocusable()) {
            if (((i2 & 1) == 1 && isInTouchMode() && !isFocusableInTouchMode()) || arrayList == null) {
                return;
            }
            arrayList.add(this);
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public void addTouchables(ArrayList<View> arrayList) {
        IFxWkV_5 QxJ9d_12;
        for (int i = 0; i < getChildCount(); i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() == 0 && (QxJ9d_12 = QxJ9d_1(childAt)) != null && QxJ9d_12.f2664KQgRr5e_0 == this.f2654QxJ9d_1) {
                childAt.addTouchables(arrayList);
            }
        }
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        if (!checkLayoutParams(layoutParams)) {
            layoutParams = generateLayoutParams(layoutParams);
        }
        LayoutParams layoutParams2 = (LayoutParams) layoutParams;
        boolean KQgRr5e_02 = layoutParams2.f2668KQgRr5e_0 | KQgRr5e_0(view);
        layoutParams2.f2668KQgRr5e_0 = KQgRr5e_02;
        if (!this.f2653PGPF6hQ_2) {
            super.addView(view, i, layoutParams);
        } else if (layoutParams2 != null && KQgRr5e_02) {
            throw new IllegalStateException("Cannot add pager decor view during layout");
        } else {
            layoutParams2.f2669QxJ9d_1 = true;
            addViewInLayout(view, i, layoutParams);
        }
    }

    @Override // android.view.View
    public boolean canScrollHorizontally(int i) {
        if (this.f2635KQgRr5e_0 == null) {
            return false;
        }
        int clientWidth = getClientWidth();
        int scrollX = getScrollX();
        return i < 0 ? scrollX > ((int) (((float) clientWidth) * this.f2633KQgRr5e_0)) : i > 0 && scrollX < ((int) (((float) clientWidth) * this.QxJ9d_1));
    }

    @Override // android.view.ViewGroup
    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof LayoutParams) && super.checkLayoutParams(layoutParams);
    }

    @Override // android.view.View
    public void computeScroll() {
        this.f2659QxJ9d_1 = true;
        if (!this.f2641KQgRr5e_0.isFinished() && this.f2641KQgRr5e_0.computeScrollOffset()) {
            int scrollX = getScrollX();
            int scrollY = getScrollY();
            int currX = this.f2641KQgRr5e_0.getCurrX();
            int currY = this.f2641KQgRr5e_0.getCurrY();
            if (scrollX != currX || scrollY != currY) {
                scrollTo(currX, currY);
                if (!m1000QxJ9d_1(currX)) {
                    this.f2641KQgRr5e_0.abortAnimation();
                    scrollTo(0, currY);
                }
            }
            ZzDuCHW_20.m262KQgRr5e_0((View) this);
            return;
        }
        KQgRr5e_0(true);
    }

    @Override // android.view.ViewGroup, android.view.View
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || KQgRr5e_0(keyEvent);
    }

    @Override // android.view.View
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        IFxWkV_5 QxJ9d_12;
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() == 0 && (QxJ9d_12 = QxJ9d_1(childAt)) != null && QxJ9d_12.f2664KQgRr5e_0 == this.f2654QxJ9d_1 && childAt.dispatchPopulateAccessibilityEvent(accessibilityEvent)) {
                return true;
            }
        }
        return false;
    }

    @Override // android.view.View
    public void draw(Canvas canvas) {
        X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0;
        super.draw(canvas);
        int overScrollMode = getOverScrollMode();
        boolean z = false;
        if (overScrollMode != 0 && (overScrollMode != 1 || (kQgRr5e_0 = this.f2635KQgRr5e_0) == null || kQgRr5e_0.KQgRr5e_0() <= 1)) {
            this.f2640KQgRr5e_0.finish();
            this.f2655QxJ9d_1.finish();
        } else {
            if (!this.f2640KQgRr5e_0.isFinished()) {
                int save = canvas.save();
                int height = (getHeight() - getPaddingTop()) - getPaddingBottom();
                int width = getWidth();
                canvas.rotate(270.0f);
                canvas.translate((-height) + getPaddingTop(), this.f2633KQgRr5e_0 * width);
                this.f2640KQgRr5e_0.setSize(height, width);
                z = false | this.f2640KQgRr5e_0.draw(canvas);
                canvas.restoreToCount(save);
            }
            if (!this.f2655QxJ9d_1.isFinished()) {
                int save2 = canvas.save();
                int width2 = getWidth();
                int height2 = (getHeight() - getPaddingTop()) - getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate(-getPaddingTop(), (-(this.QxJ9d_1 + 1.0f)) * width2);
                this.f2655QxJ9d_1.setSize(height2, width2);
                z |= this.f2655QxJ9d_1.draw(canvas);
                canvas.restoreToCount(save2);
            }
        }
        if (z) {
            ZzDuCHW_20.m262KQgRr5e_0((View) this);
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.f2637KQgRr5e_0;
        if (drawable == null || !drawable.isStateful()) {
            return;
        }
        drawable.setState(getDrawableState());
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return generateDefaultLayoutParams();
    }

    public X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 getAdapter() {
        return this.f2635KQgRr5e_0;
    }

    @Override // android.view.ViewGroup
    public int getChildDrawingOrder(int i, int i2) {
        if (this.Eps4cJe_18 == 2) {
            i2 = (i - 1) - i2;
        }
        return ((LayoutParams) this.f2657QxJ9d_1.get(i2).getLayoutParams()).PGPF6hQ_2;
    }

    public int getCurrentItem() {
        return this.f2654QxJ9d_1;
    }

    public int getOffscreenPageLimit() {
        return this.f3606FSaI4_7;
    }

    public int getPageMargin() {
        return this.f2650Mqv2r_3;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.f2662Xgtqvk_8 = true;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onDetachedFromWindow() {
        removeCallbacks(this.f2647KQgRr5e_0);
        Scroller scroller = this.f2641KQgRr5e_0;
        if (scroller != null && !scroller.isFinished()) {
            this.f2641KQgRr5e_0.abortAnimation();
        }
        super.onDetachedFromWindow();
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        int width;
        float f;
        float f2;
        super.onDraw(canvas);
        if (this.f2650Mqv2r_3 <= 0 || this.f2637KQgRr5e_0 == null || this.f2648KQgRr5e_0.size() <= 0 || this.f2635KQgRr5e_0 == null) {
            return;
        }
        int scrollX = getScrollX();
        float width2 = getWidth();
        float f3 = this.f2650Mqv2r_3 / width2;
        int i = 0;
        IFxWkV_5 iFxWkV_5 = this.f2648KQgRr5e_0.get(0);
        float f4 = iFxWkV_5.QxJ9d_1;
        int size = this.f2648KQgRr5e_0.size();
        int i2 = iFxWkV_5.f2664KQgRr5e_0;
        int i3 = this.f2648KQgRr5e_0.get(size - 1).f2664KQgRr5e_0;
        while (i2 < i3) {
            while (i2 > iFxWkV_5.f2664KQgRr5e_0 && i < size) {
                i++;
                iFxWkV_5 = this.f2648KQgRr5e_0.get(i);
            }
            if (i2 == iFxWkV_5.f2664KQgRr5e_0) {
                float f5 = iFxWkV_5.QxJ9d_1;
                float f6 = iFxWkV_5.KQgRr5e_0;
                f = (f5 + f6) * width2;
                f4 = f5 + f6 + f3;
            } else {
                float KQgRr5e_02 = this.f2635KQgRr5e_0.KQgRr5e_0(i2);
                f = (f4 + KQgRr5e_02) * width2;
                f4 += KQgRr5e_02 + f3;
            }
            if (this.f2650Mqv2r_3 + f > scrollX) {
                f2 = f3;
                this.f2637KQgRr5e_0.setBounds(Math.round(f), this.f2660X6FRs_4, Math.round(this.f2650Mqv2r_3 + f), this.f2630IFxWkV_5);
                this.f2637KQgRr5e_0.draw(canvas);
            } else {
                f2 = f3;
            }
            if (f > scrollX + width) {
                return;
            }
            i2++;
            f3 = f2;
        }
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction() & 255;
        if (action != 3 && action != 1) {
            if (action != 0) {
                if (this.f2631IFxWkV_5) {
                    return true;
                }
                if (this.f2632IMuAHx_6) {
                    return false;
                }
            }
            if (action == 0) {
                float x = motionEvent.getX();
                this.f3612X6FRs_4 = x;
                this.PGPF6hQ_2 = x;
                float y = motionEvent.getY();
                this.f3607IFxWkV_5 = y;
                this.f3610Mqv2r_3 = y;
                this.f3609KNBe_11 = motionEvent.getPointerId(0);
                this.f2632IMuAHx_6 = false;
                this.f2659QxJ9d_1 = true;
                this.f2641KQgRr5e_0.computeScrollOffset();
                if (this.BVpCZyH_19 == 2 && Math.abs(this.f2641KQgRr5e_0.getFinalX() - this.f2641KQgRr5e_0.getCurrX()) > this.LGe8pk_15) {
                    this.f2641KQgRr5e_0.abortAnimation();
                    this.f2661X6FRs_4 = false;
                    Mqv2r_3();
                    this.f2631IFxWkV_5 = true;
                    PGPF6hQ_2(true);
                    setScrollState(1);
                } else {
                    KQgRr5e_0(false);
                    this.f2631IFxWkV_5 = false;
                }
            } else if (action == 2) {
                int i = this.f3609KNBe_11;
                if (i != -1) {
                    int findPointerIndex = motionEvent.findPointerIndex(i);
                    float x2 = motionEvent.getX(findPointerIndex);
                    float f = x2 - this.PGPF6hQ_2;
                    float abs = Math.abs(f);
                    float y2 = motionEvent.getY(findPointerIndex);
                    float abs2 = Math.abs(y2 - this.f3607IFxWkV_5);
                    if (f != 0.0f && !KQgRr5e_0(this.PGPF6hQ_2, f) && KQgRr5e_0(this, false, (int) f, (int) x2, (int) y2)) {
                        this.PGPF6hQ_2 = x2;
                        this.f3610Mqv2r_3 = y2;
                        this.f2632IMuAHx_6 = true;
                        return false;
                    }
                    if (abs > this.f3611Nm6q_10 && abs * 0.5f > abs2) {
                        this.f2631IFxWkV_5 = true;
                        PGPF6hQ_2(true);
                        setScrollState(1);
                        this.PGPF6hQ_2 = f > 0.0f ? this.f3612X6FRs_4 + this.f3611Nm6q_10 : this.f3612X6FRs_4 - this.f3611Nm6q_10;
                        this.f3610Mqv2r_3 = y2;
                        setScrollingCacheEnabled(true);
                    } else if (abs2 > this.f3611Nm6q_10) {
                        this.f2632IMuAHx_6 = true;
                    }
                    if (this.f2631IFxWkV_5 && m996KQgRr5e_0(x2)) {
                        ZzDuCHW_20.m262KQgRr5e_0((View) this);
                    }
                }
            } else if (action == 6) {
                KQgRr5e_0(motionEvent);
            }
            if (this.f2639KQgRr5e_0 == null) {
                this.f2639KQgRr5e_0 = VelocityTracker.obtain();
            }
            this.f2639KQgRr5e_0.addMovement(motionEvent);
            return this.f2631IFxWkV_5;
        }
        m998PGPF6hQ_2();
        return false;
    }

    /* JADX WARN: Removed duplicated region for block: B:22:0x0071  */
    /* JADX WARN: Removed duplicated region for block: B:29:0x008e  */
    @Override // android.view.ViewGroup, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        boolean z2;
        IFxWkV_5 QxJ9d_12;
        int max;
        int i5;
        int max2;
        int i6;
        int childCount = getChildCount();
        int i7 = i3 - i;
        int i8 = i4 - i2;
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        int paddingRight = getPaddingRight();
        int paddingBottom = getPaddingBottom();
        int scrollX = getScrollX();
        int i9 = 0;
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            if (childAt.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams) childAt.getLayoutParams();
                if (layoutParams.f2668KQgRr5e_0) {
                    int i11 = layoutParams.f2667KQgRr5e_0;
                    int i12 = i11 & 7;
                    int i13 = i11 & 112;
                    if (i12 == 1) {
                        max = Math.max((i7 - childAt.getMeasuredWidth()) / 2, paddingLeft);
                    } else {
                        if (i12 == 3) {
                            i5 = childAt.getMeasuredWidth() + paddingLeft;
                        } else if (i12 != 5) {
                            i5 = paddingLeft;
                        } else {
                            max = (i7 - paddingRight) - childAt.getMeasuredWidth();
                            paddingRight += childAt.getMeasuredWidth();
                        }
                        if (i13 != 16) {
                            max2 = Math.max((i8 - childAt.getMeasuredHeight()) / 2, paddingTop);
                        } else {
                            if (i13 == 48) {
                                i6 = childAt.getMeasuredHeight() + paddingTop;
                            } else if (i13 != 80) {
                                i6 = paddingTop;
                            } else {
                                max2 = (i8 - paddingBottom) - childAt.getMeasuredHeight();
                                paddingBottom += childAt.getMeasuredHeight();
                            }
                            int i14 = paddingLeft + scrollX;
                            childAt.layout(i14, paddingTop, childAt.getMeasuredWidth() + i14, paddingTop + childAt.getMeasuredHeight());
                            i9++;
                            paddingTop = i6;
                            paddingLeft = i5;
                        }
                        int i15 = max2;
                        i6 = paddingTop;
                        paddingTop = i15;
                        int i142 = paddingLeft + scrollX;
                        childAt.layout(i142, paddingTop, childAt.getMeasuredWidth() + i142, paddingTop + childAt.getMeasuredHeight());
                        i9++;
                        paddingTop = i6;
                        paddingLeft = i5;
                    }
                    int i16 = max;
                    i5 = paddingLeft;
                    paddingLeft = i16;
                    if (i13 != 16) {
                    }
                    int i152 = max2;
                    i6 = paddingTop;
                    paddingTop = i152;
                    int i1422 = paddingLeft + scrollX;
                    childAt.layout(i1422, paddingTop, childAt.getMeasuredWidth() + i1422, paddingTop + childAt.getMeasuredHeight());
                    i9++;
                    paddingTop = i6;
                    paddingLeft = i5;
                }
            }
        }
        int i17 = (i7 - paddingLeft) - paddingRight;
        for (int i18 = 0; i18 < childCount; i18++) {
            View childAt2 = getChildAt(i18);
            if (childAt2.getVisibility() != 8) {
                LayoutParams layoutParams2 = (LayoutParams) childAt2.getLayoutParams();
                if (!layoutParams2.f2668KQgRr5e_0 && (QxJ9d_12 = QxJ9d_1(childAt2)) != null) {
                    float f = i17;
                    int i19 = ((int) (QxJ9d_12.QxJ9d_1 * f)) + paddingLeft;
                    if (layoutParams2.f2669QxJ9d_1) {
                        layoutParams2.f2669QxJ9d_1 = false;
                        childAt2.measure(View.MeasureSpec.makeMeasureSpec((int) (f * layoutParams2.KQgRr5e_0), 1073741824), View.MeasureSpec.makeMeasureSpec((i8 - paddingTop) - paddingBottom, 1073741824));
                    }
                    childAt2.layout(i19, paddingTop, childAt2.getMeasuredWidth() + i19, childAt2.getMeasuredHeight() + paddingTop);
                }
            }
        }
        this.f2660X6FRs_4 = paddingTop;
        this.f2630IFxWkV_5 = i8 - paddingBottom;
        this.JZJr_16 = i9;
        if (this.f2662Xgtqvk_8) {
            z2 = false;
            KQgRr5e_0(this.f2654QxJ9d_1, false, 0, false);
        } else {
            z2 = false;
        }
        this.f2662Xgtqvk_8 = z2;
    }

    /* JADX WARN: Removed duplicated region for block: B:32:0x0082  */
    /* JADX WARN: Removed duplicated region for block: B:36:0x0089  */
    /* JADX WARN: Removed duplicated region for block: B:39:0x008e  */
    /* JADX WARN: Removed duplicated region for block: B:42:0x0093  */
    /* JADX WARN: Removed duplicated region for block: B:45:0x00a2  */
    /* JADX WARN: Removed duplicated region for block: B:46:0x00a8  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void onMeasure(int i, int i2) {
        LayoutParams layoutParams;
        LayoutParams layoutParams2;
        int i3;
        int i4;
        int i5;
        setMeasuredDimension(ViewGroup.getDefaultSize(0, i), ViewGroup.getDefaultSize(0, i2));
        int measuredWidth = getMeasuredWidth();
        this.f3614XnFJ5_9 = Math.min(measuredWidth / 10, this.f3613Xgtqvk_8);
        int paddingLeft = (measuredWidth - getPaddingLeft()) - getPaddingRight();
        int measuredHeight = (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom();
        int childCount = getChildCount();
        int i6 = 0;
        while (true) {
            boolean z = true;
            int i7 = 1073741824;
            if (i6 >= childCount) {
                break;
            }
            View childAt = getChildAt(i6);
            if (childAt.getVisibility() != 8 && (layoutParams2 = (LayoutParams) childAt.getLayoutParams()) != null && layoutParams2.f2668KQgRr5e_0) {
                int i8 = layoutParams2.f2667KQgRr5e_0;
                int i9 = i8 & 7;
                int i10 = i8 & 112;
                boolean z2 = i10 == 48 || i10 == 80;
                if (i9 != 3 && i9 != 5) {
                    z = false;
                }
                int i11 = X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0.INVALID_ID;
                if (z2) {
                    i11 = 1073741824;
                } else if (z) {
                    i3 = 1073741824;
                    i4 = ((ViewGroup.LayoutParams) layoutParams2).width;
                    if (i4 == -2) {
                        if (i4 == -1) {
                            i4 = paddingLeft;
                        }
                        i11 = 1073741824;
                    } else {
                        i4 = paddingLeft;
                    }
                    i5 = ((ViewGroup.LayoutParams) layoutParams2).height;
                    if (i5 != -2) {
                        i5 = measuredHeight;
                        i7 = i3;
                    } else if (i5 == -1) {
                        i5 = measuredHeight;
                    }
                    childAt.measure(View.MeasureSpec.makeMeasureSpec(i4, i11), View.MeasureSpec.makeMeasureSpec(i5, i7));
                    if (!z2) {
                        measuredHeight -= childAt.getMeasuredHeight();
                    } else if (z) {
                        paddingLeft -= childAt.getMeasuredWidth();
                    }
                }
                i3 = X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0.INVALID_ID;
                i4 = ((ViewGroup.LayoutParams) layoutParams2).width;
                if (i4 == -2) {
                }
                i5 = ((ViewGroup.LayoutParams) layoutParams2).height;
                if (i5 != -2) {
                }
                childAt.measure(View.MeasureSpec.makeMeasureSpec(i4, i11), View.MeasureSpec.makeMeasureSpec(i5, i7));
                if (!z2) {
                }
            }
            i6++;
        }
        View.MeasureSpec.makeMeasureSpec(paddingLeft, 1073741824);
        this.f3608IMuAHx_6 = View.MeasureSpec.makeMeasureSpec(measuredHeight, 1073741824);
        this.f2653PGPF6hQ_2 = true;
        Mqv2r_3();
        this.f2653PGPF6hQ_2 = false;
        int childCount2 = getChildCount();
        for (int i12 = 0; i12 < childCount2; i12++) {
            View childAt2 = getChildAt(i12);
            if (childAt2.getVisibility() != 8 && ((layoutParams = (LayoutParams) childAt2.getLayoutParams()) == null || !layoutParams.f2668KQgRr5e_0)) {
                childAt2.measure(View.MeasureSpec.makeMeasureSpec((int) (paddingLeft * layoutParams.KQgRr5e_0), 1073741824), this.f3608IMuAHx_6);
            }
        }
    }

    @Override // android.view.ViewGroup
    public boolean onRequestFocusInDescendants(int i, Rect rect) {
        int i2;
        int i3;
        IFxWkV_5 QxJ9d_12;
        int childCount = getChildCount();
        int i4 = -1;
        if ((i & 2) != 0) {
            i4 = childCount;
            i2 = 0;
            i3 = 1;
        } else {
            i2 = childCount - 1;
            i3 = -1;
        }
        while (i2 != i4) {
            View childAt = getChildAt(i2);
            if (childAt.getVisibility() == 0 && (QxJ9d_12 = QxJ9d_1(childAt)) != null && QxJ9d_12.f2664KQgRr5e_0 == this.f2654QxJ9d_1 && childAt.requestFocus(i, rect)) {
                return true;
            }
            i2 += i3;
        }
        return false;
    }

    @Override // android.view.View
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0 = this.f2635KQgRr5e_0;
        if (kQgRr5e_0 != null) {
            kQgRr5e_0.KQgRr5e_0(savedState.f2671KQgRr5e_0, savedState.f2672KQgRr5e_0);
            KQgRr5e_0(savedState.KQgRr5e_0, false, true);
            return;
        }
        this.f2652PGPF6hQ_2 = savedState.KQgRr5e_0;
        this.f2638KQgRr5e_0 = savedState.f2671KQgRr5e_0;
        this.f2646KQgRr5e_0 = savedState.f2672KQgRr5e_0;
    }

    @Override // android.view.View
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.KQgRr5e_0 = this.f2654QxJ9d_1;
        X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0 = this.f2635KQgRr5e_0;
        if (kQgRr5e_0 != null) {
            savedState.f2671KQgRr5e_0 = kQgRr5e_0.m190KQgRr5e_0();
        }
        return savedState;
    }

    @Override // android.view.View
    public void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        if (i != i3) {
            int i5 = this.f2650Mqv2r_3;
            KQgRr5e_0(i, i3, i5, i5);
        }
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0;
        if (this.f2629FSaI4_7) {
            return true;
        }
        boolean z = false;
        if ((motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) || (kQgRr5e_0 = this.f2635KQgRr5e_0) == null || kQgRr5e_0.KQgRr5e_0() == 0) {
            return false;
        }
        if (this.f2639KQgRr5e_0 == null) {
            this.f2639KQgRr5e_0 = VelocityTracker.obtain();
        }
        this.f2639KQgRr5e_0.addMovement(motionEvent);
        int action = motionEvent.getAction() & 255;
        if (action == 0) {
            this.f2641KQgRr5e_0.abortAnimation();
            this.f2661X6FRs_4 = false;
            Mqv2r_3();
            float x = motionEvent.getX();
            this.f3612X6FRs_4 = x;
            this.PGPF6hQ_2 = x;
            float y = motionEvent.getY();
            this.f3607IFxWkV_5 = y;
            this.f3610Mqv2r_3 = y;
            this.f3609KNBe_11 = motionEvent.getPointerId(0);
        } else if (action != 1) {
            if (action == 2) {
                if (!this.f2631IFxWkV_5) {
                    int findPointerIndex = motionEvent.findPointerIndex(this.f3609KNBe_11);
                    if (findPointerIndex == -1) {
                        z = m998PGPF6hQ_2();
                    } else {
                        float x2 = motionEvent.getX(findPointerIndex);
                        float abs = Math.abs(x2 - this.PGPF6hQ_2);
                        float y2 = motionEvent.getY(findPointerIndex);
                        float abs2 = Math.abs(y2 - this.f3610Mqv2r_3);
                        if (abs > this.f3611Nm6q_10 && abs > abs2) {
                            this.f2631IFxWkV_5 = true;
                            PGPF6hQ_2(true);
                            float f = this.f3612X6FRs_4;
                            this.PGPF6hQ_2 = x2 - f > 0.0f ? f + this.f3611Nm6q_10 : f - this.f3611Nm6q_10;
                            this.f3610Mqv2r_3 = y2;
                            setScrollState(1);
                            setScrollingCacheEnabled(true);
                            ViewParent parent = getParent();
                            if (parent != null) {
                                parent.requestDisallowInterceptTouchEvent(true);
                            }
                        }
                    }
                }
                if (this.f2631IFxWkV_5) {
                    z = false | m996KQgRr5e_0(motionEvent.getX(motionEvent.findPointerIndex(this.f3609KNBe_11)));
                }
            } else if (action != 3) {
                if (action == 5) {
                    int actionIndex = motionEvent.getActionIndex();
                    this.PGPF6hQ_2 = motionEvent.getX(actionIndex);
                    this.f3609KNBe_11 = motionEvent.getPointerId(actionIndex);
                } else if (action == 6) {
                    KQgRr5e_0(motionEvent);
                    this.PGPF6hQ_2 = motionEvent.getX(motionEvent.findPointerIndex(this.f3609KNBe_11));
                }
            } else if (this.f2631IFxWkV_5) {
                KQgRr5e_0(this.f2654QxJ9d_1, true, 0, false);
                z = m998PGPF6hQ_2();
            }
        } else if (this.f2631IFxWkV_5) {
            VelocityTracker velocityTracker = this.f2639KQgRr5e_0;
            velocityTracker.computeCurrentVelocity(1000, this.WwEq_13);
            int xVelocity = (int) velocityTracker.getXVelocity(this.f3609KNBe_11);
            this.f2661X6FRs_4 = true;
            int clientWidth = getClientWidth();
            int scrollX = getScrollX();
            IFxWkV_5 KQgRr5e_02 = KQgRr5e_0();
            float f2 = clientWidth;
            KQgRr5e_0(KQgRr5e_0(KQgRr5e_02.f2664KQgRr5e_0, ((scrollX / f2) - KQgRr5e_02.QxJ9d_1) / (KQgRr5e_02.KQgRr5e_0 + (this.f2650Mqv2r_3 / f2)), xVelocity, (int) (motionEvent.getX(motionEvent.findPointerIndex(this.f3609KNBe_11)) - this.f3612X6FRs_4)), true, true, xVelocity);
            z = m998PGPF6hQ_2();
        }
        if (z) {
            ZzDuCHW_20.m262KQgRr5e_0((View) this);
        }
        return true;
    }

    @Override // android.view.ViewGroup, android.view.ViewManager
    public void removeView(View view) {
        if (this.f2653PGPF6hQ_2) {
            removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    public void setAdapter(X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0) {
        X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_02 = this.f2635KQgRr5e_0;
        if (kQgRr5e_02 != null) {
            kQgRr5e_02.QxJ9d_1((DataSetObserver) null);
            this.f2635KQgRr5e_0.QxJ9d_1((ViewGroup) this);
            for (int i = 0; i < this.f2648KQgRr5e_0.size(); i++) {
                IFxWkV_5 iFxWkV_5 = this.f2648KQgRr5e_0.get(i);
                this.f2635KQgRr5e_0.KQgRr5e_0((ViewGroup) this, iFxWkV_5.f2664KQgRr5e_0, iFxWkV_5.f2665KQgRr5e_0);
            }
            this.f2635KQgRr5e_0.KQgRr5e_0((ViewGroup) this);
            this.f2648KQgRr5e_0.clear();
            X6FRs_4();
            this.f2654QxJ9d_1 = 0;
            scrollTo(0, 0);
        }
        X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_03 = this.f2635KQgRr5e_0;
        this.f2635KQgRr5e_0 = kQgRr5e_0;
        this.f2634KQgRr5e_0 = 0;
        if (kQgRr5e_0 != null) {
            if (this.f2643KQgRr5e_0 == null) {
                this.f2643KQgRr5e_0 = new Nm6q_10();
            }
            this.f2635KQgRr5e_0.QxJ9d_1(this.f2643KQgRr5e_0);
            this.f2661X6FRs_4 = false;
            boolean z = this.f2662Xgtqvk_8;
            this.f2662Xgtqvk_8 = true;
            this.f2634KQgRr5e_0 = this.f2635KQgRr5e_0.KQgRr5e_0();
            if (this.f2652PGPF6hQ_2 >= 0) {
                this.f2635KQgRr5e_0.KQgRr5e_0(this.f2638KQgRr5e_0, this.f2646KQgRr5e_0);
                KQgRr5e_0(this.f2652PGPF6hQ_2, false, true);
                this.f2652PGPF6hQ_2 = -1;
                this.f2638KQgRr5e_0 = null;
                this.f2646KQgRr5e_0 = null;
            } else if (!z) {
                Mqv2r_3();
            } else {
                requestLayout();
            }
        }
        List<FSaI4_7> list = this.f2658QxJ9d_1;
        if (list == null || list.isEmpty()) {
            return;
        }
        int size = this.f2658QxJ9d_1.size();
        for (int i2 = 0; i2 < size; i2++) {
            this.f2658QxJ9d_1.get(i2).onAdapterChanged(this, kQgRr5e_03, kQgRr5e_0);
        }
    }

    public void setCurrentItem(int i) {
        this.f2661X6FRs_4 = false;
        KQgRr5e_0(i, !this.f2662Xgtqvk_8, false);
    }

    public void setOffscreenPageLimit(int i) {
        if (i < 1) {
            Log.w("ViewPager", "Requested offscreen page limit " + i + " too small; defaulting to 1");
            i = 1;
        }
        if (i != this.f3606FSaI4_7) {
            this.f3606FSaI4_7 = i;
            Mqv2r_3();
        }
    }

    @Deprecated
    public void setOnPageChangeListener(Xgtqvk_8 xgtqvk_8) {
        this.f2644KQgRr5e_0 = xgtqvk_8;
    }

    public void setPageMargin(int i) {
        int i2 = this.f2650Mqv2r_3;
        this.f2650Mqv2r_3 = i;
        int width = getWidth();
        KQgRr5e_0(width, width, i, i2);
        requestLayout();
    }

    public void setPageMarginDrawable(Drawable drawable) {
        this.f2637KQgRr5e_0 = drawable;
        if (drawable != null) {
            refreshDrawableState();
        }
        setWillNotDraw(drawable == null);
        invalidate();
    }

    public void setScrollState(int i) {
        if (this.BVpCZyH_19 == i) {
            return;
        }
        this.BVpCZyH_19 = i;
        if (this.f2645KQgRr5e_0 != null) {
            QxJ9d_1(i != 0);
        }
        QxJ9d_1(i);
    }

    @Override // android.view.View
    public boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.f2637KQgRr5e_0;
    }

    /* loaded from: classes.dex */
    public static class LayoutParams extends ViewGroup.LayoutParams {
        public float KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public int f2667KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public boolean f2668KQgRr5e_0;
        public int PGPF6hQ_2;
        public int QxJ9d_1;

        /* renamed from: QxJ9d_1  reason: collision with other field name */
        public boolean f2669QxJ9d_1;

        public LayoutParams() {
            super(-1, -1);
            this.KQgRr5e_0 = 0.0f;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.KQgRr5e_0 = 0.0f;
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, ViewPager.f2628KQgRr5e_0);
            this.f2667KQgRr5e_0 = obtainStyledAttributes.getInteger(0, 48);
            obtainStyledAttributes.recycle();
        }
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(getContext(), attributeSet);
    }

    public void QxJ9d_1(Xgtqvk_8 xgtqvk_8) {
        List<Xgtqvk_8> list = this.f2649KQgRr5e_0;
        if (list != null) {
            list.remove(xgtqvk_8);
        }
    }

    public void KQgRr5e_0(int i, boolean z) {
        this.f2661X6FRs_4 = false;
        KQgRr5e_0(i, z, false);
    }

    public IFxWkV_5 QxJ9d_1(View view) {
        for (int i = 0; i < this.f2648KQgRr5e_0.size(); i++) {
            IFxWkV_5 iFxWkV_5 = this.f2648KQgRr5e_0.get(i);
            if (this.f2635KQgRr5e_0.KQgRr5e_0(view, iFxWkV_5.f2665KQgRr5e_0)) {
                return iFxWkV_5;
            }
        }
        return null;
    }

    public void setPageMarginDrawable(int i) {
        setPageMarginDrawable(X6FRs_4.IMuAHx_6.X6FRs_4.KQgRr5e_0.m332KQgRr5e_0(getContext(), i));
    }

    public void KQgRr5e_0(int i, boolean z, boolean z2) {
        KQgRr5e_0(i, z, z2, 0);
    }

    public void KQgRr5e_0(int i, boolean z, boolean z2, int i2) {
        X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0 = this.f2635KQgRr5e_0;
        if (kQgRr5e_0 != null && kQgRr5e_0.KQgRr5e_0() > 0) {
            if (!z2 && this.f2654QxJ9d_1 == i && this.f2648KQgRr5e_0.size() != 0) {
                setScrollingCacheEnabled(false);
                return;
            }
            if (i < 0) {
                i = 0;
            } else if (i >= this.f2635KQgRr5e_0.KQgRr5e_0()) {
                i = this.f2635KQgRr5e_0.KQgRr5e_0() - 1;
            }
            int i3 = this.f3606FSaI4_7;
            int i4 = this.f2654QxJ9d_1;
            if (i > i4 + i3 || i < i4 - i3) {
                for (int i5 = 0; i5 < this.f2648KQgRr5e_0.size(); i5++) {
                    this.f2648KQgRr5e_0.get(i5).f2666KQgRr5e_0 = true;
                }
            }
            boolean z3 = this.f2654QxJ9d_1 != i;
            if (this.f2662Xgtqvk_8) {
                this.f2654QxJ9d_1 = i;
                if (z3) {
                    m993KQgRr5e_0(i);
                }
                requestLayout();
                return;
            }
            PGPF6hQ_2(i);
            KQgRr5e_0(i, z, i2, z3);
            return;
        }
        setScrollingCacheEnabled(false);
    }

    /* renamed from: QxJ9d_1  reason: collision with other method in class */
    public final boolean m1000QxJ9d_1(int i) {
        if (this.f2648KQgRr5e_0.size() == 0) {
            if (this.f2662Xgtqvk_8) {
                return false;
            }
            this.f2663XnFJ5_9 = false;
            QxJ9d_1(0, 0.0f, 0);
            if (this.f2663XnFJ5_9) {
                return false;
            }
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        IFxWkV_5 KQgRr5e_02 = KQgRr5e_0();
        int clientWidth = getClientWidth();
        int i2 = this.f2650Mqv2r_3;
        int i3 = clientWidth + i2;
        float f = clientWidth;
        int i4 = KQgRr5e_02.f2664KQgRr5e_0;
        float f2 = ((i / f) - KQgRr5e_02.QxJ9d_1) / (KQgRr5e_02.KQgRr5e_0 + (i2 / f));
        this.f2663XnFJ5_9 = false;
        QxJ9d_1(i4, f2, (int) (i3 * f2));
        if (this.f2663XnFJ5_9) {
            return true;
        }
        throw new IllegalStateException("onPageScrolled did not call superclass implementation");
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f2648KQgRr5e_0 = new ArrayList<>();
        this.f2642KQgRr5e_0 = new IFxWkV_5();
        this.f2636KQgRr5e_0 = new Rect();
        this.f2652PGPF6hQ_2 = -1;
        this.f2638KQgRr5e_0 = null;
        this.f2646KQgRr5e_0 = null;
        this.f2633KQgRr5e_0 = -3.4028235E38f;
        this.QxJ9d_1 = Float.MAX_VALUE;
        this.f3606FSaI4_7 = 1;
        this.f3609KNBe_11 = -1;
        this.f2662Xgtqvk_8 = true;
        this.f2647KQgRr5e_0 = new PGPF6hQ_2();
        this.BVpCZyH_19 = 0;
        PGPF6hQ_2();
    }

    /* JADX WARN: Code restructure failed: missing block: B:24:0x0060, code lost:
        if (r9 == r10) goto L27;
     */
    /* JADX WARN: Code restructure failed: missing block: B:27:0x0066, code lost:
        r8 = null;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void PGPF6hQ_2(int i) {
        IFxWkV_5 iFxWkV_5;
        String hexString;
        IFxWkV_5 iFxWkV_52;
        IFxWkV_5 QxJ9d_12;
        IFxWkV_5 iFxWkV_53;
        int i2 = this.f2654QxJ9d_1;
        if (i2 != i) {
            iFxWkV_5 = KQgRr5e_0(i2);
            this.f2654QxJ9d_1 = i;
        } else {
            iFxWkV_5 = null;
        }
        if (this.f2635KQgRr5e_0 == null) {
            IFxWkV_5();
        } else if (this.f2661X6FRs_4) {
            IFxWkV_5();
        } else if (getWindowToken() != null) {
            this.f2635KQgRr5e_0.QxJ9d_1((ViewGroup) this);
            int i3 = this.f3606FSaI4_7;
            int max = Math.max(0, this.f2654QxJ9d_1 - i3);
            int KQgRr5e_02 = this.f2635KQgRr5e_0.KQgRr5e_0();
            int min = Math.min(KQgRr5e_02 - 1, this.f2654QxJ9d_1 + i3);
            if (KQgRr5e_02 == this.f2634KQgRr5e_0) {
                int i4 = 0;
                while (true) {
                    if (i4 >= this.f2648KQgRr5e_0.size()) {
                        break;
                    }
                    iFxWkV_52 = this.f2648KQgRr5e_0.get(i4);
                    int i5 = iFxWkV_52.f2664KQgRr5e_0;
                    int i6 = this.f2654QxJ9d_1;
                    if (i5 < i6) {
                        i4++;
                    }
                }
                if (iFxWkV_52 == null && KQgRr5e_02 > 0) {
                    iFxWkV_52 = KQgRr5e_0(this.f2654QxJ9d_1, i4);
                }
                if (iFxWkV_52 != null) {
                    int i7 = i4 - 1;
                    IFxWkV_5 iFxWkV_54 = i7 >= 0 ? this.f2648KQgRr5e_0.get(i7) : null;
                    int clientWidth = getClientWidth();
                    float paddingLeft = clientWidth <= 0 ? 0.0f : (2.0f - iFxWkV_52.KQgRr5e_0) + (getPaddingLeft() / clientWidth);
                    float f = 0.0f;
                    for (int i8 = this.f2654QxJ9d_1 - 1; i8 >= 0; i8--) {
                        if (f < paddingLeft || i8 >= max) {
                            if (iFxWkV_54 != null && i8 == iFxWkV_54.f2664KQgRr5e_0) {
                                f += iFxWkV_54.KQgRr5e_0;
                                i7--;
                                if (i7 >= 0) {
                                    iFxWkV_53 = this.f2648KQgRr5e_0.get(i7);
                                    iFxWkV_54 = iFxWkV_53;
                                }
                                iFxWkV_53 = null;
                                iFxWkV_54 = iFxWkV_53;
                            } else {
                                f += KQgRr5e_0(i8, i7 + 1).KQgRr5e_0;
                                i4++;
                                if (i7 >= 0) {
                                    iFxWkV_53 = this.f2648KQgRr5e_0.get(i7);
                                    iFxWkV_54 = iFxWkV_53;
                                }
                                iFxWkV_53 = null;
                                iFxWkV_54 = iFxWkV_53;
                            }
                        } else if (iFxWkV_54 == null) {
                            break;
                        } else {
                            if (i8 == iFxWkV_54.f2664KQgRr5e_0 && !iFxWkV_54.f2666KQgRr5e_0) {
                                this.f2648KQgRr5e_0.remove(i7);
                                this.f2635KQgRr5e_0.KQgRr5e_0((ViewGroup) this, i8, iFxWkV_54.f2665KQgRr5e_0);
                                i7--;
                                i4--;
                                if (i7 >= 0) {
                                    iFxWkV_53 = this.f2648KQgRr5e_0.get(i7);
                                    iFxWkV_54 = iFxWkV_53;
                                }
                                iFxWkV_53 = null;
                                iFxWkV_54 = iFxWkV_53;
                            }
                        }
                    }
                    float f2 = iFxWkV_52.KQgRr5e_0;
                    int i9 = i4 + 1;
                    if (f2 < 2.0f) {
                        IFxWkV_5 iFxWkV_55 = i9 < this.f2648KQgRr5e_0.size() ? this.f2648KQgRr5e_0.get(i9) : null;
                        float paddingRight = clientWidth <= 0 ? 0.0f : (getPaddingRight() / clientWidth) + 2.0f;
                        int i10 = this.f2654QxJ9d_1;
                        while (true) {
                            i10++;
                            if (i10 >= KQgRr5e_02) {
                                break;
                            } else if (f2 < paddingRight || i10 <= min) {
                                if (iFxWkV_55 != null && i10 == iFxWkV_55.f2664KQgRr5e_0) {
                                    f2 += iFxWkV_55.KQgRr5e_0;
                                    i9++;
                                    if (i9 < this.f2648KQgRr5e_0.size()) {
                                        iFxWkV_55 = this.f2648KQgRr5e_0.get(i9);
                                    }
                                } else {
                                    IFxWkV_5 KQgRr5e_03 = KQgRr5e_0(i10, i9);
                                    i9++;
                                    f2 += KQgRr5e_03.KQgRr5e_0;
                                    iFxWkV_55 = i9 < this.f2648KQgRr5e_0.size() ? this.f2648KQgRr5e_0.get(i9) : null;
                                }
                            } else if (iFxWkV_55 == null) {
                                break;
                            } else if (i10 == iFxWkV_55.f2664KQgRr5e_0 && !iFxWkV_55.f2666KQgRr5e_0) {
                                this.f2648KQgRr5e_0.remove(i9);
                                this.f2635KQgRr5e_0.KQgRr5e_0((ViewGroup) this, i10, iFxWkV_55.f2665KQgRr5e_0);
                                if (i9 < this.f2648KQgRr5e_0.size()) {
                                    iFxWkV_55 = this.f2648KQgRr5e_0.get(i9);
                                }
                            }
                        }
                    }
                    KQgRr5e_0(iFxWkV_52, i4, iFxWkV_5);
                    this.f2635KQgRr5e_0.QxJ9d_1((ViewGroup) this, this.f2654QxJ9d_1, iFxWkV_52.f2665KQgRr5e_0);
                }
                this.f2635KQgRr5e_0.KQgRr5e_0((ViewGroup) this);
                int childCount = getChildCount();
                for (int i11 = 0; i11 < childCount; i11++) {
                    View childAt = getChildAt(i11);
                    LayoutParams layoutParams = (LayoutParams) childAt.getLayoutParams();
                    layoutParams.PGPF6hQ_2 = i11;
                    if (!layoutParams.f2668KQgRr5e_0 && layoutParams.KQgRr5e_0 == 0.0f && (QxJ9d_12 = QxJ9d_1(childAt)) != null) {
                        layoutParams.KQgRr5e_0 = QxJ9d_12.KQgRr5e_0;
                        layoutParams.QxJ9d_1 = QxJ9d_12.f2664KQgRr5e_0;
                    }
                }
                IFxWkV_5();
                if (hasFocus()) {
                    View findFocus = findFocus();
                    IFxWkV_5 m991KQgRr5e_0 = findFocus != null ? m991KQgRr5e_0(findFocus) : null;
                    if (m991KQgRr5e_0 == null || m991KQgRr5e_0.f2664KQgRr5e_0 != this.f2654QxJ9d_1) {
                        for (int i12 = 0; i12 < getChildCount(); i12++) {
                            View childAt2 = getChildAt(i12);
                            IFxWkV_5 QxJ9d_13 = QxJ9d_1(childAt2);
                            if (QxJ9d_13 != null && QxJ9d_13.f2664KQgRr5e_0 == this.f2654QxJ9d_1 && childAt2.requestFocus(2)) {
                                return;
                            }
                        }
                        return;
                    }
                    return;
                }
                return;
            }
            try {
                hexString = getResources().getResourceName(getId());
            } catch (Resources.NotFoundException unused) {
                hexString = Integer.toHexString(getId());
            }
            throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.f2634KQgRr5e_0 + ", found: " + KQgRr5e_02 + " Pager id: " + hexString + " Pager class: " + ViewPager.class + " Problematic adapter: " + this.f2635KQgRr5e_0.getClass());
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:22:0x0064  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void QxJ9d_1(int i, float f, int i2) {
        int max;
        int i3;
        int left;
        if (this.JZJr_16 > 0) {
            int scrollX = getScrollX();
            int paddingLeft = getPaddingLeft();
            int paddingRight = getPaddingRight();
            int width = getWidth();
            int childCount = getChildCount();
            for (int i4 = 0; i4 < childCount; i4++) {
                View childAt = getChildAt(i4);
                LayoutParams layoutParams = (LayoutParams) childAt.getLayoutParams();
                if (layoutParams.f2668KQgRr5e_0) {
                    int i5 = layoutParams.f2667KQgRr5e_0 & 7;
                    if (i5 == 1) {
                        max = Math.max((width - childAt.getMeasuredWidth()) / 2, paddingLeft);
                    } else {
                        if (i5 == 3) {
                            i3 = childAt.getWidth() + paddingLeft;
                        } else if (i5 != 5) {
                            i3 = paddingLeft;
                        } else {
                            max = (width - paddingRight) - childAt.getMeasuredWidth();
                            paddingRight += childAt.getMeasuredWidth();
                        }
                        left = (paddingLeft + scrollX) - childAt.getLeft();
                        if (left != 0) {
                            childAt.offsetLeftAndRight(left);
                        }
                        paddingLeft = i3;
                    }
                    int i6 = max;
                    i3 = paddingLeft;
                    paddingLeft = i6;
                    left = (paddingLeft + scrollX) - childAt.getLeft();
                    if (left != 0) {
                    }
                    paddingLeft = i3;
                }
            }
        }
        KQgRr5e_0(i, f, i2);
        if (this.f2645KQgRr5e_0 != null) {
            int scrollX2 = getScrollX();
            int childCount2 = getChildCount();
            for (int i7 = 0; i7 < childCount2; i7++) {
                View childAt2 = getChildAt(i7);
                if (!((LayoutParams) childAt2.getLayoutParams()).f2668KQgRr5e_0) {
                    this.f2645KQgRr5e_0.KQgRr5e_0(childAt2, (childAt2.getLeft() - scrollX2) / getClientWidth());
                }
            }
        }
        this.f2663XnFJ5_9 = true;
    }

    public final void KQgRr5e_0(int i, boolean z, int i2, boolean z2) {
        IFxWkV_5 KQgRr5e_02 = KQgRr5e_0(i);
        int clientWidth = KQgRr5e_02 != null ? (int) (getClientWidth() * Math.max(this.f2633KQgRr5e_0, Math.min(KQgRr5e_02.QxJ9d_1, this.QxJ9d_1))) : 0;
        if (z) {
            KQgRr5e_0(clientWidth, 0, i2);
            if (z2) {
                m993KQgRr5e_0(i);
                return;
            }
            return;
        }
        if (z2) {
            m993KQgRr5e_0(i);
        }
        KQgRr5e_0(false);
        scrollTo(clientWidth, 0);
        m1000QxJ9d_1(clientWidth);
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public void m994KQgRr5e_0(Xgtqvk_8 xgtqvk_8) {
        if (this.f2649KQgRr5e_0 == null) {
            this.f2649KQgRr5e_0 = new ArrayList();
        }
        this.f2649KQgRr5e_0.add(xgtqvk_8);
    }

    public Xgtqvk_8 KQgRr5e_0(Xgtqvk_8 xgtqvk_8) {
        Xgtqvk_8 xgtqvk_82 = this.f2656QxJ9d_1;
        this.f2656QxJ9d_1 = xgtqvk_8;
        return xgtqvk_82;
    }

    public float KQgRr5e_0(float f) {
        return (float) Math.sin((f - 0.5f) * 0.47123894f);
    }

    public void KQgRr5e_0(int i, int i2, int i3) {
        int scrollX;
        int abs;
        if (getChildCount() == 0) {
            setScrollingCacheEnabled(false);
            return;
        }
        Scroller scroller = this.f2641KQgRr5e_0;
        if ((scroller == null || scroller.isFinished()) ? false : true) {
            scrollX = this.f2659QxJ9d_1 ? this.f2641KQgRr5e_0.getCurrX() : this.f2641KQgRr5e_0.getStartX();
            this.f2641KQgRr5e_0.abortAnimation();
            setScrollingCacheEnabled(false);
        } else {
            scrollX = getScrollX();
        }
        int i4 = scrollX;
        int scrollY = getScrollY();
        int i5 = i - i4;
        int i6 = i2 - scrollY;
        if (i5 == 0 && i6 == 0) {
            KQgRr5e_0(false);
            Mqv2r_3();
            setScrollState(0);
            return;
        }
        setScrollingCacheEnabled(true);
        setScrollState(2);
        int clientWidth = getClientWidth();
        int i7 = clientWidth / 2;
        float f = clientWidth;
        float f2 = i7;
        float KQgRr5e_02 = f2 + (KQgRr5e_0(Math.min(1.0f, (Math.abs(i5) * 1.0f) / f)) * f2);
        int abs2 = Math.abs(i3);
        if (abs2 > 0) {
            abs = Math.round(Math.abs(KQgRr5e_02 / abs2) * 1000.0f) * 4;
        } else {
            abs = (int) (((Math.abs(i5) / ((f * this.f2635KQgRr5e_0.KQgRr5e_0(this.f2654QxJ9d_1)) + this.f2650Mqv2r_3)) + 1.0f) * 100.0f);
        }
        int min = Math.min(abs, 600);
        this.f2659QxJ9d_1 = false;
        this.f2641KQgRr5e_0.startScroll(i4, scrollY, i5, i6, min);
        ZzDuCHW_20.m262KQgRr5e_0((View) this);
    }

    public final void QxJ9d_1(int i) {
        Xgtqvk_8 xgtqvk_8 = this.f2644KQgRr5e_0;
        if (xgtqvk_8 != null) {
            xgtqvk_8.onPageScrollStateChanged(i);
        }
        List<Xgtqvk_8> list = this.f2649KQgRr5e_0;
        if (list != null) {
            int size = list.size();
            for (int i2 = 0; i2 < size; i2++) {
                Xgtqvk_8 xgtqvk_82 = this.f2649KQgRr5e_0.get(i2);
                if (xgtqvk_82 != null) {
                    xgtqvk_82.onPageScrollStateChanged(i);
                }
            }
        }
        Xgtqvk_8 xgtqvk_83 = this.f2656QxJ9d_1;
        if (xgtqvk_83 != null) {
            xgtqvk_83.onPageScrollStateChanged(i);
        }
    }

    public final void QxJ9d_1(boolean z) {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            getChildAt(i).setLayerType(z ? this.NQvZgp_17 : 0, null);
        }
    }

    public final void QxJ9d_1() {
        this.f2631IFxWkV_5 = false;
        this.f2632IMuAHx_6 = false;
        VelocityTracker velocityTracker = this.f2639KQgRr5e_0;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.f2639KQgRr5e_0 = null;
        }
    }

    /* renamed from: QxJ9d_1  reason: collision with other method in class */
    public boolean m999QxJ9d_1() {
        X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0 = this.f2635KQgRr5e_0;
        if (kQgRr5e_0 == null || this.f2654QxJ9d_1 >= kQgRr5e_0.KQgRr5e_0() - 1) {
            return false;
        }
        KQgRr5e_0(this.f2654QxJ9d_1 + 1, true);
        return true;
    }

    public IFxWkV_5 KQgRr5e_0(int i, int i2) {
        IFxWkV_5 iFxWkV_5 = new IFxWkV_5();
        iFxWkV_5.f2664KQgRr5e_0 = i;
        iFxWkV_5.f2665KQgRr5e_0 = this.f2635KQgRr5e_0.KQgRr5e_0((ViewGroup) this, i);
        iFxWkV_5.KQgRr5e_0 = this.f2635KQgRr5e_0.KQgRr5e_0(i);
        if (i2 >= 0 && i2 < this.f2648KQgRr5e_0.size()) {
            this.f2648KQgRr5e_0.add(i2, iFxWkV_5);
        } else {
            this.f2648KQgRr5e_0.add(iFxWkV_5);
        }
        return iFxWkV_5;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public void m992KQgRr5e_0() {
        int KQgRr5e_02 = this.f2635KQgRr5e_0.KQgRr5e_0();
        this.f2634KQgRr5e_0 = KQgRr5e_02;
        boolean z = this.f2648KQgRr5e_0.size() < (this.f3606FSaI4_7 * 2) + 1 && this.f2648KQgRr5e_0.size() < KQgRr5e_02;
        int i = this.f2654QxJ9d_1;
        int i2 = 0;
        boolean z2 = false;
        while (i2 < this.f2648KQgRr5e_0.size()) {
            IFxWkV_5 iFxWkV_5 = this.f2648KQgRr5e_0.get(i2);
            int KQgRr5e_03 = this.f2635KQgRr5e_0.KQgRr5e_0(iFxWkV_5.f2665KQgRr5e_0);
            if (KQgRr5e_03 != -1) {
                if (KQgRr5e_03 == -2) {
                    this.f2648KQgRr5e_0.remove(i2);
                    i2--;
                    if (!z2) {
                        this.f2635KQgRr5e_0.QxJ9d_1((ViewGroup) this);
                        z2 = true;
                    }
                    this.f2635KQgRr5e_0.KQgRr5e_0((ViewGroup) this, iFxWkV_5.f2664KQgRr5e_0, iFxWkV_5.f2665KQgRr5e_0);
                    int i3 = this.f2654QxJ9d_1;
                    if (i3 == iFxWkV_5.f2664KQgRr5e_0) {
                        i = Math.max(0, Math.min(i3, KQgRr5e_02 - 1));
                    }
                } else {
                    int i4 = iFxWkV_5.f2664KQgRr5e_0;
                    if (i4 != KQgRr5e_03) {
                        if (i4 == this.f2654QxJ9d_1) {
                            i = KQgRr5e_03;
                        }
                        iFxWkV_5.f2664KQgRr5e_0 = KQgRr5e_03;
                    }
                }
                z = true;
            }
            i2++;
        }
        if (z2) {
            this.f2635KQgRr5e_0.KQgRr5e_0((ViewGroup) this);
        }
        Collections.sort(this.f2648KQgRr5e_0, f2627KQgRr5e_0);
        if (z) {
            int childCount = getChildCount();
            for (int i5 = 0; i5 < childCount; i5++) {
                LayoutParams layoutParams = (LayoutParams) getChildAt(i5).getLayoutParams();
                if (!layoutParams.f2668KQgRr5e_0) {
                    layoutParams.KQgRr5e_0 = 0.0f;
                }
            }
            KQgRr5e_0(i, false, true);
            requestLayout();
        }
    }

    /* renamed from: PGPF6hQ_2  reason: collision with other method in class */
    public final boolean m998PGPF6hQ_2() {
        this.f3609KNBe_11 = -1;
        QxJ9d_1();
        this.f2640KQgRr5e_0.onRelease();
        this.f2655QxJ9d_1.onRelease();
        return this.f2640KQgRr5e_0.isFinished() || this.f2655QxJ9d_1.isFinished();
    }

    public final void KQgRr5e_0(IFxWkV_5 iFxWkV_5, int i, IFxWkV_5 iFxWkV_52) {
        int i2;
        int i3;
        IFxWkV_5 iFxWkV_53;
        IFxWkV_5 iFxWkV_54;
        int KQgRr5e_02 = this.f2635KQgRr5e_0.KQgRr5e_0();
        int clientWidth = getClientWidth();
        float f = clientWidth > 0 ? this.f2650Mqv2r_3 / clientWidth : 0.0f;
        if (iFxWkV_52 != null) {
            int i4 = iFxWkV_52.f2664KQgRr5e_0;
            int i5 = iFxWkV_5.f2664KQgRr5e_0;
            if (i4 < i5) {
                int i6 = 0;
                float f2 = iFxWkV_52.QxJ9d_1 + iFxWkV_52.KQgRr5e_0 + f;
                while (true) {
                    i4++;
                    if (i4 > iFxWkV_5.f2664KQgRr5e_0 || i6 >= this.f2648KQgRr5e_0.size()) {
                        break;
                    }
                    IFxWkV_5 iFxWkV_55 = this.f2648KQgRr5e_0.get(i6);
                    while (true) {
                        iFxWkV_54 = iFxWkV_55;
                        if (i4 <= iFxWkV_54.f2664KQgRr5e_0 || i6 >= this.f2648KQgRr5e_0.size() - 1) {
                            break;
                        }
                        i6++;
                        iFxWkV_55 = this.f2648KQgRr5e_0.get(i6);
                    }
                    while (i4 < iFxWkV_54.f2664KQgRr5e_0) {
                        f2 += this.f2635KQgRr5e_0.KQgRr5e_0(i4) + f;
                        i4++;
                    }
                    iFxWkV_54.QxJ9d_1 = f2;
                    f2 += iFxWkV_54.KQgRr5e_0 + f;
                }
            } else if (i4 > i5) {
                int size = this.f2648KQgRr5e_0.size() - 1;
                float f3 = iFxWkV_52.QxJ9d_1;
                while (true) {
                    i4--;
                    if (i4 < iFxWkV_5.f2664KQgRr5e_0 || size < 0) {
                        break;
                    }
                    IFxWkV_5 iFxWkV_56 = this.f2648KQgRr5e_0.get(size);
                    while (true) {
                        iFxWkV_53 = iFxWkV_56;
                        if (i4 >= iFxWkV_53.f2664KQgRr5e_0 || size <= 0) {
                            break;
                        }
                        size--;
                        iFxWkV_56 = this.f2648KQgRr5e_0.get(size);
                    }
                    while (i4 > iFxWkV_53.f2664KQgRr5e_0) {
                        f3 -= this.f2635KQgRr5e_0.KQgRr5e_0(i4) + f;
                        i4--;
                    }
                    f3 -= iFxWkV_53.KQgRr5e_0 + f;
                    iFxWkV_53.QxJ9d_1 = f3;
                }
            }
        }
        int size2 = this.f2648KQgRr5e_0.size();
        float f4 = iFxWkV_5.QxJ9d_1;
        int i7 = iFxWkV_5.f2664KQgRr5e_0;
        int i8 = i7 - 1;
        this.f2633KQgRr5e_0 = i7 == 0 ? f4 : -3.4028235E38f;
        int i9 = KQgRr5e_02 - 1;
        this.QxJ9d_1 = iFxWkV_5.f2664KQgRr5e_0 == i9 ? (iFxWkV_5.QxJ9d_1 + iFxWkV_5.KQgRr5e_0) - 1.0f : Float.MAX_VALUE;
        int i10 = i - 1;
        while (i10 >= 0) {
            IFxWkV_5 iFxWkV_57 = this.f2648KQgRr5e_0.get(i10);
            while (true) {
                i3 = iFxWkV_57.f2664KQgRr5e_0;
                if (i8 <= i3) {
                    break;
                }
                f4 -= this.f2635KQgRr5e_0.KQgRr5e_0(i8) + f;
                i8--;
            }
            f4 -= iFxWkV_57.KQgRr5e_0 + f;
            iFxWkV_57.QxJ9d_1 = f4;
            if (i3 == 0) {
                this.f2633KQgRr5e_0 = f4;
            }
            i10--;
            i8--;
        }
        float f5 = iFxWkV_5.QxJ9d_1 + iFxWkV_5.KQgRr5e_0 + f;
        int i11 = iFxWkV_5.f2664KQgRr5e_0 + 1;
        int i12 = i + 1;
        while (i12 < size2) {
            IFxWkV_5 iFxWkV_58 = this.f2648KQgRr5e_0.get(i12);
            while (true) {
                i2 = iFxWkV_58.f2664KQgRr5e_0;
                if (i11 >= i2) {
                    break;
                }
                f5 += this.f2635KQgRr5e_0.KQgRr5e_0(i11) + f;
                i11++;
            }
            if (i2 == i9) {
                this.QxJ9d_1 = (iFxWkV_58.KQgRr5e_0 + f5) - 1.0f;
            }
            iFxWkV_58.QxJ9d_1 = f5;
            f5 += iFxWkV_58.KQgRr5e_0 + f;
            i12++;
            i11++;
        }
    }

    public final void PGPF6hQ_2(boolean z) {
        ViewParent parent = getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(z);
        }
    }

    public static boolean KQgRr5e_0(View view) {
        return view.getClass().getAnnotation(X6FRs_4.class) != null;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public IFxWkV_5 m991KQgRr5e_0(View view) {
        while (true) {
            ViewParent parent = view.getParent();
            if (parent != this) {
                if (parent == null || !(parent instanceof View)) {
                    return null;
                }
                view = (View) parent;
            } else {
                return QxJ9d_1(view);
            }
        }
    }

    public IFxWkV_5 KQgRr5e_0(int i) {
        for (int i2 = 0; i2 < this.f2648KQgRr5e_0.size(); i2++) {
            IFxWkV_5 iFxWkV_5 = this.f2648KQgRr5e_0.get(i2);
            if (iFxWkV_5.f2664KQgRr5e_0 == i) {
                return iFxWkV_5;
            }
        }
        return null;
    }

    public final void KQgRr5e_0(int i, int i2, int i3, int i4) {
        if (i2 > 0 && !this.f2648KQgRr5e_0.isEmpty()) {
            if (!this.f2641KQgRr5e_0.isFinished()) {
                this.f2641KQgRr5e_0.setFinalX(getCurrentItem() * getClientWidth());
                return;
            } else {
                scrollTo((int) ((getScrollX() / (((i2 - getPaddingLeft()) - getPaddingRight()) + i4)) * (((i - getPaddingLeft()) - getPaddingRight()) + i3)), getScrollY());
                return;
            }
        }
        IFxWkV_5 KQgRr5e_02 = KQgRr5e_0(this.f2654QxJ9d_1);
        int min = (int) ((KQgRr5e_02 != null ? Math.min(KQgRr5e_02.QxJ9d_1, this.QxJ9d_1) : 0.0f) * ((i - getPaddingLeft()) - getPaddingRight()));
        if (min != getScrollX()) {
            KQgRr5e_0(false);
            scrollTo(min, getScrollY());
        }
    }

    public final void KQgRr5e_0(int i, float f, int i2) {
        Xgtqvk_8 xgtqvk_8 = this.f2644KQgRr5e_0;
        if (xgtqvk_8 != null) {
            xgtqvk_8.onPageScrolled(i, f, i2);
        }
        List<Xgtqvk_8> list = this.f2649KQgRr5e_0;
        if (list != null) {
            int size = list.size();
            for (int i3 = 0; i3 < size; i3++) {
                Xgtqvk_8 xgtqvk_82 = this.f2649KQgRr5e_0.get(i3);
                if (xgtqvk_82 != null) {
                    xgtqvk_82.onPageScrolled(i, f, i2);
                }
            }
        }
        Xgtqvk_8 xgtqvk_83 = this.f2656QxJ9d_1;
        if (xgtqvk_83 != null) {
            xgtqvk_83.onPageScrolled(i, f, i2);
        }
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public final void m993KQgRr5e_0(int i) {
        Xgtqvk_8 xgtqvk_8 = this.f2644KQgRr5e_0;
        if (xgtqvk_8 != null) {
            xgtqvk_8.onPageSelected(i);
        }
        List<Xgtqvk_8> list = this.f2649KQgRr5e_0;
        if (list != null) {
            int size = list.size();
            for (int i2 = 0; i2 < size; i2++) {
                Xgtqvk_8 xgtqvk_82 = this.f2649KQgRr5e_0.get(i2);
                if (xgtqvk_82 != null) {
                    xgtqvk_82.onPageSelected(i);
                }
            }
        }
        Xgtqvk_8 xgtqvk_83 = this.f2656QxJ9d_1;
        if (xgtqvk_83 != null) {
            xgtqvk_83.onPageSelected(i);
        }
    }

    public final void KQgRr5e_0(boolean z) {
        boolean z2 = this.BVpCZyH_19 == 2;
        if (z2) {
            setScrollingCacheEnabled(false);
            if (!this.f2641KQgRr5e_0.isFinished()) {
                this.f2641KQgRr5e_0.abortAnimation();
                int scrollX = getScrollX();
                int scrollY = getScrollY();
                int currX = this.f2641KQgRr5e_0.getCurrX();
                int currY = this.f2641KQgRr5e_0.getCurrY();
                if (scrollX != currX || scrollY != currY) {
                    scrollTo(currX, currY);
                    if (currX != scrollX) {
                        m1000QxJ9d_1(currX);
                    }
                }
            }
        }
        this.f2661X6FRs_4 = false;
        for (int i = 0; i < this.f2648KQgRr5e_0.size(); i++) {
            IFxWkV_5 iFxWkV_5 = this.f2648KQgRr5e_0.get(i);
            if (iFxWkV_5.f2666KQgRr5e_0) {
                iFxWkV_5.f2666KQgRr5e_0 = false;
                z2 = true;
            }
        }
        if (z2) {
            if (z) {
                ZzDuCHW_20.KQgRr5e_0(this, this.f2647KQgRr5e_0);
            } else {
                this.f2647KQgRr5e_0.run();
            }
        }
    }

    public final boolean KQgRr5e_0(float f, float f2) {
        return (f < ((float) this.f3614XnFJ5_9) && f2 > 0.0f) || (f > ((float) (getWidth() - this.f3614XnFJ5_9)) && f2 < 0.0f);
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public final boolean m996KQgRr5e_0(float f) {
        boolean z;
        boolean z2;
        float f2 = this.PGPF6hQ_2 - f;
        this.PGPF6hQ_2 = f;
        float scrollX = getScrollX() + f2;
        float clientWidth = getClientWidth();
        float f3 = this.f2633KQgRr5e_0 * clientWidth;
        float f4 = this.QxJ9d_1 * clientWidth;
        boolean z3 = false;
        IFxWkV_5 iFxWkV_5 = this.f2648KQgRr5e_0.get(0);
        ArrayList<IFxWkV_5> arrayList = this.f2648KQgRr5e_0;
        IFxWkV_5 iFxWkV_52 = arrayList.get(arrayList.size() - 1);
        if (iFxWkV_5.f2664KQgRr5e_0 != 0) {
            f3 = iFxWkV_5.QxJ9d_1 * clientWidth;
            z = false;
        } else {
            z = true;
        }
        if (iFxWkV_52.f2664KQgRr5e_0 != this.f2635KQgRr5e_0.KQgRr5e_0() - 1) {
            f4 = iFxWkV_52.QxJ9d_1 * clientWidth;
            z2 = false;
        } else {
            z2 = true;
        }
        if (scrollX < f3) {
            if (z) {
                this.f2640KQgRr5e_0.onPull(Math.abs(f3 - scrollX) / clientWidth);
                z3 = true;
            }
            scrollX = f3;
        } else if (scrollX > f4) {
            if (z2) {
                this.f2655QxJ9d_1.onPull(Math.abs(scrollX - f4) / clientWidth);
                z3 = true;
            }
            scrollX = f4;
        }
        int i = (int) scrollX;
        this.PGPF6hQ_2 += scrollX - i;
        scrollTo(i, getScrollY());
        m1000QxJ9d_1(i);
        return z3;
    }

    public final IFxWkV_5 KQgRr5e_0() {
        int i;
        int clientWidth = getClientWidth();
        float f = 0.0f;
        float scrollX = clientWidth > 0 ? getScrollX() / clientWidth : 0.0f;
        float f2 = clientWidth > 0 ? this.f2650Mqv2r_3 / clientWidth : 0.0f;
        IFxWkV_5 iFxWkV_5 = null;
        float f3 = 0.0f;
        int i2 = -1;
        int i3 = 0;
        boolean z = true;
        while (i3 < this.f2648KQgRr5e_0.size()) {
            IFxWkV_5 iFxWkV_52 = this.f2648KQgRr5e_0.get(i3);
            if (!z && iFxWkV_52.f2664KQgRr5e_0 != (i = i2 + 1)) {
                iFxWkV_52 = this.f2642KQgRr5e_0;
                iFxWkV_52.QxJ9d_1 = f + f3 + f2;
                iFxWkV_52.f2664KQgRr5e_0 = i;
                iFxWkV_52.KQgRr5e_0 = this.f2635KQgRr5e_0.KQgRr5e_0(i);
                i3--;
            }
            f = iFxWkV_52.QxJ9d_1;
            float f4 = iFxWkV_52.KQgRr5e_0 + f + f2;
            if (!z && scrollX < f) {
                return iFxWkV_5;
            }
            if (scrollX < f4 || i3 == this.f2648KQgRr5e_0.size() - 1) {
                return iFxWkV_52;
            }
            i2 = iFxWkV_52.f2664KQgRr5e_0;
            f3 = iFxWkV_52.KQgRr5e_0;
            i3++;
            iFxWkV_5 = iFxWkV_52;
            z = false;
        }
        return iFxWkV_5;
    }

    public final int KQgRr5e_0(int i, float f, int i2, int i3) {
        if (Math.abs(i3) <= this.YghfZG_14 || Math.abs(i2) <= this.EuDEkJe_12) {
            i += (int) (f + (i >= this.f2654QxJ9d_1 ? 0.4f : 0.6f));
        } else if (i2 <= 0) {
            i++;
        }
        if (this.f2648KQgRr5e_0.size() > 0) {
            ArrayList<IFxWkV_5> arrayList = this.f2648KQgRr5e_0;
            return Math.max(this.f2648KQgRr5e_0.get(0).f2664KQgRr5e_0, Math.min(i, arrayList.get(arrayList.size() - 1).f2664KQgRr5e_0));
        }
        return i;
    }

    public final void KQgRr5e_0(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.f3609KNBe_11) {
            int i = actionIndex == 0 ? 1 : 0;
            this.PGPF6hQ_2 = motionEvent.getX(i);
            this.f3609KNBe_11 = motionEvent.getPointerId(i);
            VelocityTracker velocityTracker = this.f2639KQgRr5e_0;
            if (velocityTracker != null) {
                velocityTracker.clear();
            }
        }
    }

    public boolean KQgRr5e_0(View view, boolean z, int i, int i2, int i3) {
        int i4;
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup) view;
            int scrollX = view.getScrollX();
            int scrollY = view.getScrollY();
            for (int childCount = viewGroup.getChildCount() - 1; childCount >= 0; childCount--) {
                View childAt = viewGroup.getChildAt(childCount);
                int i5 = i2 + scrollX;
                if (i5 >= childAt.getLeft() && i5 < childAt.getRight() && (i4 = i3 + scrollY) >= childAt.getTop() && i4 < childAt.getBottom() && KQgRr5e_0(childAt, true, i, i5 - childAt.getLeft(), i4 - childAt.getTop())) {
                    return true;
                }
            }
        }
        return z && view.canScrollHorizontally(-i);
    }

    public boolean KQgRr5e_0(KeyEvent keyEvent) {
        if (keyEvent.getAction() == 0) {
            int keyCode = keyEvent.getKeyCode();
            if (keyCode == 21) {
                if (keyEvent.hasModifiers(2)) {
                    return m995KQgRr5e_0();
                }
                return m997KQgRr5e_0(17);
            } else if (keyCode == 22) {
                if (keyEvent.hasModifiers(2)) {
                    return m999QxJ9d_1();
                }
                return m997KQgRr5e_0(66);
            } else if (keyCode == 61) {
                if (keyEvent.hasNoModifiers()) {
                    return m997KQgRr5e_0(2);
                }
                if (keyEvent.hasModifiers(1)) {
                    return m997KQgRr5e_0(1);
                }
            }
        }
        return false;
    }

    /* JADX WARN: Removed duplicated region for block: B:44:0x00cf  */
    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean m997KQgRr5e_0(int i) {
        boolean z;
        View findNextFocus;
        boolean requestFocus;
        View findFocus = findFocus();
        boolean z2 = false;
        if (findFocus != this) {
            if (findFocus != null) {
                ViewParent parent = findFocus.getParent();
                while (true) {
                    if (!(parent instanceof ViewGroup)) {
                        z = false;
                        break;
                    } else if (parent == this) {
                        z = true;
                        break;
                    } else {
                        parent = parent.getParent();
                    }
                }
                if (!z) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(findFocus.getClass().getSimpleName());
                    for (ViewParent parent2 = findFocus.getParent(); parent2 instanceof ViewGroup; parent2 = parent2.getParent()) {
                        sb.append(" => ");
                        sb.append(parent2.getClass().getSimpleName());
                    }
                    Log.e("ViewPager", "arrowScroll tried to find focus based on non-child current focused view " + sb.toString());
                }
            }
            findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, i);
            if (findNextFocus == null && findNextFocus != findFocus) {
                if (i == 17) {
                    int i2 = KQgRr5e_0(this.f2636KQgRr5e_0, findNextFocus).left;
                    int i3 = KQgRr5e_0(this.f2636KQgRr5e_0, findFocus).left;
                    if (findFocus != null && i2 >= i3) {
                        requestFocus = m995KQgRr5e_0();
                    } else {
                        requestFocus = findNextFocus.requestFocus();
                    }
                } else if (i == 66) {
                    int i4 = KQgRr5e_0(this.f2636KQgRr5e_0, findNextFocus).left;
                    int i5 = KQgRr5e_0(this.f2636KQgRr5e_0, findFocus).left;
                    if (findFocus != null && i4 <= i5) {
                        requestFocus = m999QxJ9d_1();
                    } else {
                        requestFocus = findNextFocus.requestFocus();
                    }
                }
                z2 = requestFocus;
            } else if (i != 17 || i == 1) {
                z2 = m995KQgRr5e_0();
            } else if (i == 66 || i == 2) {
                z2 = m999QxJ9d_1();
            }
            if (z2) {
                playSoundEffect(SoundEffectConstants.getContantForFocusDirection(i));
            }
            return z2;
        }
        findFocus = null;
        findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, i);
        if (findNextFocus == null) {
        }
        if (i != 17) {
        }
        z2 = m995KQgRr5e_0();
        if (z2) {
        }
        return z2;
    }

    public final Rect KQgRr5e_0(Rect rect, View view) {
        if (rect == null) {
            rect = new Rect();
        }
        if (view == null) {
            rect.set(0, 0, 0, 0);
            return rect;
        }
        rect.left = view.getLeft();
        rect.right = view.getRight();
        rect.top = view.getTop();
        rect.bottom = view.getBottom();
        ViewParent parent = view.getParent();
        while ((parent instanceof ViewGroup) && parent != this) {
            ViewGroup viewGroup = (ViewGroup) parent;
            rect.left += viewGroup.getLeft();
            rect.right += viewGroup.getRight();
            rect.top += viewGroup.getTop();
            rect.bottom += viewGroup.getBottom();
            parent = viewGroup.getParent();
        }
        return rect;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public boolean m995KQgRr5e_0() {
        int i = this.f2654QxJ9d_1;
        if (i > 0) {
            KQgRr5e_0(i - 1, true);
            return true;
        }
        return false;
    }
}
