package androidx.viewpager.widget;

import X6FRs_4.IMuAHx_6.WwEq_13.Xgtqvk_8;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.method.SingleLineTransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import androidx.viewpager.widget.ViewPager;
import java.lang.ref.WeakReference;
import java.util.Locale;
@ViewPager.X6FRs_4
/* loaded from: classes.dex */
public class PagerTitleStrip extends ViewGroup {
    public static final int[] KQgRr5e_0 = {16842804, 16842901, 16842904, 16842927};
    public static final int[] QxJ9d_1 = {16843660};

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public float f2614KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public int f2615KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public TextView f2616KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final KQgRr5e_0 f2617KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public ViewPager f2618KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public WeakReference<X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0> f2619KQgRr5e_0;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public int f3604Mqv2r_3;
    public int PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public TextView f2620PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public boolean f2621PGPF6hQ_2;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public int f2622QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public TextView f2623QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f2624QxJ9d_1;

    /* renamed from: X6FRs_4  reason: collision with root package name */
    public int f3605X6FRs_4;

    /* loaded from: classes.dex */
    public class KQgRr5e_0 extends DataSetObserver implements ViewPager.Xgtqvk_8, ViewPager.FSaI4_7 {
        public int KQgRr5e_0;

        public KQgRr5e_0() {
        }

        @Override // androidx.viewpager.widget.ViewPager.FSaI4_7
        public void onAdapterChanged(ViewPager viewPager, X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0, X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_02) {
            PagerTitleStrip.this.KQgRr5e_0(kQgRr5e_0, kQgRr5e_02);
        }

        @Override // android.database.DataSetObserver
        public void onChanged() {
            PagerTitleStrip pagerTitleStrip = PagerTitleStrip.this;
            pagerTitleStrip.KQgRr5e_0(pagerTitleStrip.f2618KQgRr5e_0.getCurrentItem(), PagerTitleStrip.this.f2618KQgRr5e_0.getAdapter());
            float f = PagerTitleStrip.this.f2614KQgRr5e_0;
            if (f < 0.0f) {
                f = 0.0f;
            }
            PagerTitleStrip pagerTitleStrip2 = PagerTitleStrip.this;
            pagerTitleStrip2.KQgRr5e_0(pagerTitleStrip2.f2618KQgRr5e_0.getCurrentItem(), f, true);
        }

        @Override // androidx.viewpager.widget.ViewPager.Xgtqvk_8
        public void onPageScrollStateChanged(int i) {
            this.KQgRr5e_0 = i;
        }

        @Override // androidx.viewpager.widget.ViewPager.Xgtqvk_8
        public void onPageScrolled(int i, float f, int i2) {
            if (f > 0.5f) {
                i++;
            }
            PagerTitleStrip.this.KQgRr5e_0(i, f, false);
        }

        @Override // androidx.viewpager.widget.ViewPager.Xgtqvk_8
        public void onPageSelected(int i) {
            if (this.KQgRr5e_0 == 0) {
                PagerTitleStrip pagerTitleStrip = PagerTitleStrip.this;
                pagerTitleStrip.KQgRr5e_0(pagerTitleStrip.f2618KQgRr5e_0.getCurrentItem(), PagerTitleStrip.this.f2618KQgRr5e_0.getAdapter());
                float f = PagerTitleStrip.this.f2614KQgRr5e_0;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                PagerTitleStrip pagerTitleStrip2 = PagerTitleStrip.this;
                pagerTitleStrip2.KQgRr5e_0(pagerTitleStrip2.f2618KQgRr5e_0.getCurrentItem(), f, true);
            }
        }
    }

    /* loaded from: classes.dex */
    public static class QxJ9d_1 extends SingleLineTransformationMethod {
        public Locale KQgRr5e_0;

        public QxJ9d_1(Context context) {
            this.KQgRr5e_0 = context.getResources().getConfiguration().locale;
        }

        @Override // android.text.method.ReplacementTransformationMethod, android.text.method.TransformationMethod
        public CharSequence getTransformation(CharSequence charSequence, View view) {
            CharSequence transformation = super.getTransformation(charSequence, view);
            if (transformation != null) {
                return transformation.toString().toUpperCase(this.KQgRr5e_0);
            }
            return null;
        }
    }

    public PagerTitleStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f2615KQgRr5e_0 = -1;
        this.f2614KQgRr5e_0 = -1.0f;
        this.f2617KQgRr5e_0 = new KQgRr5e_0();
        TextView textView = new TextView(context);
        this.f2616KQgRr5e_0 = textView;
        addView(textView);
        TextView textView2 = new TextView(context);
        this.f2623QxJ9d_1 = textView2;
        addView(textView2);
        TextView textView3 = new TextView(context);
        this.f2620PGPF6hQ_2 = textView3;
        addView(textView3);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, KQgRr5e_0);
        boolean z = false;
        int resourceId = obtainStyledAttributes.getResourceId(0, 0);
        if (resourceId != 0) {
            Xgtqvk_8.Mqv2r_3(this.f2616KQgRr5e_0, resourceId);
            Xgtqvk_8.Mqv2r_3(this.f2623QxJ9d_1, resourceId);
            Xgtqvk_8.Mqv2r_3(this.f2620PGPF6hQ_2, resourceId);
        }
        int dimensionPixelSize = obtainStyledAttributes.getDimensionPixelSize(1, 0);
        if (dimensionPixelSize != 0) {
            KQgRr5e_0(0, dimensionPixelSize);
        }
        if (obtainStyledAttributes.hasValue(2)) {
            int color = obtainStyledAttributes.getColor(2, 0);
            this.f2616KQgRr5e_0.setTextColor(color);
            this.f2623QxJ9d_1.setTextColor(color);
            this.f2620PGPF6hQ_2.setTextColor(color);
        }
        this.PGPF6hQ_2 = obtainStyledAttributes.getInteger(3, 80);
        obtainStyledAttributes.recycle();
        this.f3605X6FRs_4 = this.f2623QxJ9d_1.getTextColors().getDefaultColor();
        setNonPrimaryAlpha(0.6f);
        this.f2616KQgRr5e_0.setEllipsize(TextUtils.TruncateAt.END);
        this.f2623QxJ9d_1.setEllipsize(TextUtils.TruncateAt.END);
        this.f2620PGPF6hQ_2.setEllipsize(TextUtils.TruncateAt.END);
        if (resourceId != 0) {
            TypedArray obtainStyledAttributes2 = context.obtainStyledAttributes(resourceId, QxJ9d_1);
            z = obtainStyledAttributes2.getBoolean(0, false);
            obtainStyledAttributes2.recycle();
        }
        if (z) {
            setSingleLineAllCaps(this.f2616KQgRr5e_0);
            setSingleLineAllCaps(this.f2623QxJ9d_1);
            setSingleLineAllCaps(this.f2620PGPF6hQ_2);
        } else {
            this.f2616KQgRr5e_0.setSingleLine();
            this.f2623QxJ9d_1.setSingleLine();
            this.f2620PGPF6hQ_2.setSingleLine();
        }
        this.f2622QxJ9d_1 = (int) (context.getResources().getDisplayMetrics().density * 16.0f);
    }

    public static void setSingleLineAllCaps(TextView textView) {
        textView.setTransformationMethod(new QxJ9d_1(textView.getContext()));
    }

    public void KQgRr5e_0(int i, float f) {
        this.f2616KQgRr5e_0.setTextSize(i, f);
        this.f2623QxJ9d_1.setTextSize(i, f);
        this.f2620PGPF6hQ_2.setTextSize(i, f);
    }

    public int getMinHeight() {
        Drawable background = getBackground();
        if (background != null) {
            return background.getIntrinsicHeight();
        }
        return 0;
    }

    public int getTextSpacing() {
        return this.f2622QxJ9d_1;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = getParent();
        if (parent instanceof ViewPager) {
            ViewPager viewPager = (ViewPager) parent;
            X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 adapter = viewPager.getAdapter();
            viewPager.KQgRr5e_0((ViewPager.Xgtqvk_8) this.f2617KQgRr5e_0);
            viewPager.KQgRr5e_0((ViewPager.FSaI4_7) this.f2617KQgRr5e_0);
            this.f2618KQgRr5e_0 = viewPager;
            WeakReference<X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0> weakReference = this.f2619KQgRr5e_0;
            KQgRr5e_0(weakReference != null ? weakReference.get() : null, adapter);
            return;
        }
        throw new IllegalStateException("PagerTitleStrip must be a direct child of a ViewPager.");
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewPager viewPager = this.f2618KQgRr5e_0;
        if (viewPager != null) {
            KQgRr5e_0(viewPager.getAdapter(), (X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0) null);
            this.f2618KQgRr5e_0.KQgRr5e_0((ViewPager.Xgtqvk_8) null);
            this.f2618KQgRr5e_0.QxJ9d_1((ViewPager.FSaI4_7) this.f2617KQgRr5e_0);
            this.f2618KQgRr5e_0 = null;
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        if (this.f2618KQgRr5e_0 != null) {
            float f = this.f2614KQgRr5e_0;
            if (f < 0.0f) {
                f = 0.0f;
            }
            KQgRr5e_0(this.f2615KQgRr5e_0, f, true);
        }
    }

    @Override // android.view.View
    public void onMeasure(int i, int i2) {
        int max;
        if (View.MeasureSpec.getMode(i) == 1073741824) {
            int paddingTop = getPaddingTop() + getPaddingBottom();
            int childMeasureSpec = ViewGroup.getChildMeasureSpec(i2, paddingTop, -2);
            int size = View.MeasureSpec.getSize(i);
            int childMeasureSpec2 = ViewGroup.getChildMeasureSpec(i, (int) (size * 0.2f), -2);
            this.f2616KQgRr5e_0.measure(childMeasureSpec2, childMeasureSpec);
            this.f2623QxJ9d_1.measure(childMeasureSpec2, childMeasureSpec);
            this.f2620PGPF6hQ_2.measure(childMeasureSpec2, childMeasureSpec);
            if (View.MeasureSpec.getMode(i2) == 1073741824) {
                max = View.MeasureSpec.getSize(i2);
            } else {
                max = Math.max(getMinHeight(), this.f2623QxJ9d_1.getMeasuredHeight() + paddingTop);
            }
            setMeasuredDimension(size, View.resolveSizeAndState(max, i2, this.f2623QxJ9d_1.getMeasuredState() << 16));
            return;
        }
        throw new IllegalStateException("Must measure with an exact width");
    }

    @Override // android.view.View, android.view.ViewParent
    public void requestLayout() {
        if (this.f2624QxJ9d_1) {
            return;
        }
        super.requestLayout();
    }

    public void setGravity(int i) {
        this.PGPF6hQ_2 = i;
        requestLayout();
    }

    public void setNonPrimaryAlpha(float f) {
        int i = ((int) (f * 255.0f)) & 255;
        this.f3604Mqv2r_3 = i;
        int i2 = (i << 24) | (this.f3605X6FRs_4 & 16777215);
        this.f2616KQgRr5e_0.setTextColor(i2);
        this.f2620PGPF6hQ_2.setTextColor(i2);
    }

    public void setTextColor(int i) {
        this.f3605X6FRs_4 = i;
        this.f2623QxJ9d_1.setTextColor(i);
        int i2 = (this.f3604Mqv2r_3 << 24) | (this.f3605X6FRs_4 & 16777215);
        this.f2616KQgRr5e_0.setTextColor(i2);
        this.f2620PGPF6hQ_2.setTextColor(i2);
    }

    public void setTextSpacing(int i) {
        this.f2622QxJ9d_1 = i;
        requestLayout();
    }

    public void KQgRr5e_0(int i, X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0) {
        int KQgRr5e_02 = kQgRr5e_0 != null ? kQgRr5e_0.KQgRr5e_0() : 0;
        this.f2624QxJ9d_1 = true;
        CharSequence charSequence = null;
        this.f2616KQgRr5e_0.setText((i < 1 || kQgRr5e_0 == null) ? null : kQgRr5e_0.m191KQgRr5e_0(i - 1));
        this.f2623QxJ9d_1.setText((kQgRr5e_0 == null || i >= KQgRr5e_02) ? null : kQgRr5e_0.m191KQgRr5e_0(i));
        int i2 = i + 1;
        if (i2 < KQgRr5e_02 && kQgRr5e_0 != null) {
            charSequence = kQgRr5e_0.m191KQgRr5e_0(i2);
        }
        this.f2620PGPF6hQ_2.setText(charSequence);
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, (int) (((getWidth() - getPaddingLeft()) - getPaddingRight()) * 0.8f)), X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0.INVALID_ID);
        int makeMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(Math.max(0, (getHeight() - getPaddingTop()) - getPaddingBottom()), X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0.INVALID_ID);
        this.f2616KQgRr5e_0.measure(makeMeasureSpec, makeMeasureSpec2);
        this.f2623QxJ9d_1.measure(makeMeasureSpec, makeMeasureSpec2);
        this.f2620PGPF6hQ_2.measure(makeMeasureSpec, makeMeasureSpec2);
        this.f2615KQgRr5e_0 = i;
        if (!this.f2621PGPF6hQ_2) {
            KQgRr5e_0(i, this.f2614KQgRr5e_0, false);
        }
        this.f2624QxJ9d_1 = false;
    }

    public void KQgRr5e_0(X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0, X6FRs_4.BVpCZyH_19.KQgRr5e_0.KQgRr5e_0 kQgRr5e_02) {
        if (kQgRr5e_0 != null) {
            kQgRr5e_0.PGPF6hQ_2(this.f2617KQgRr5e_0);
            this.f2619KQgRr5e_0 = null;
        }
        if (kQgRr5e_02 != null) {
            kQgRr5e_02.KQgRr5e_0((DataSetObserver) this.f2617KQgRr5e_0);
            this.f2619KQgRr5e_0 = new WeakReference<>(kQgRr5e_02);
        }
        ViewPager viewPager = this.f2618KQgRr5e_0;
        if (viewPager != null) {
            this.f2615KQgRr5e_0 = -1;
            this.f2614KQgRr5e_0 = -1.0f;
            KQgRr5e_0(viewPager.getCurrentItem(), kQgRr5e_02);
            requestLayout();
        }
    }

    public void KQgRr5e_0(int i, float f, boolean z) {
        int i2;
        int i3;
        int i4;
        int i5;
        if (i != this.f2615KQgRr5e_0) {
            KQgRr5e_0(i, this.f2618KQgRr5e_0.getAdapter());
        } else if (!z && f == this.f2614KQgRr5e_0) {
            return;
        }
        this.f2621PGPF6hQ_2 = true;
        int measuredWidth = this.f2616KQgRr5e_0.getMeasuredWidth();
        int measuredWidth2 = this.f2623QxJ9d_1.getMeasuredWidth();
        int measuredWidth3 = this.f2620PGPF6hQ_2.getMeasuredWidth();
        int i6 = measuredWidth2 / 2;
        int width = getWidth();
        int height = getHeight();
        int paddingLeft = getPaddingLeft();
        int paddingRight = getPaddingRight();
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        int i7 = paddingRight + i6;
        int i8 = (width - (paddingLeft + i6)) - i7;
        float f2 = 0.5f + f;
        if (f2 > 1.0f) {
            f2 -= 1.0f;
        }
        int i9 = ((width - i7) - ((int) (i8 * f2))) - i6;
        int i10 = measuredWidth2 + i9;
        int baseline = this.f2616KQgRr5e_0.getBaseline();
        int baseline2 = this.f2623QxJ9d_1.getBaseline();
        int baseline3 = this.f2620PGPF6hQ_2.getBaseline();
        int max = Math.max(Math.max(baseline, baseline2), baseline3);
        int i11 = max - baseline;
        int i12 = max - baseline2;
        int i13 = max - baseline3;
        int max2 = Math.max(Math.max(this.f2616KQgRr5e_0.getMeasuredHeight() + i11, this.f2623QxJ9d_1.getMeasuredHeight() + i12), this.f2620PGPF6hQ_2.getMeasuredHeight() + i13);
        int i14 = this.PGPF6hQ_2 & 112;
        if (i14 == 16) {
            i2 = (((height - paddingTop) - paddingBottom) - max2) / 2;
        } else if (i14 != 80) {
            i3 = i11 + paddingTop;
            i4 = i12 + paddingTop;
            i5 = paddingTop + i13;
            TextView textView = this.f2623QxJ9d_1;
            textView.layout(i9, i4, i10, textView.getMeasuredHeight() + i4);
            int min = Math.min(paddingLeft, (i9 - this.f2622QxJ9d_1) - measuredWidth);
            TextView textView2 = this.f2616KQgRr5e_0;
            textView2.layout(min, i3, measuredWidth + min, textView2.getMeasuredHeight() + i3);
            int max3 = Math.max((width - paddingRight) - measuredWidth3, i10 + this.f2622QxJ9d_1);
            TextView textView3 = this.f2620PGPF6hQ_2;
            textView3.layout(max3, i5, max3 + measuredWidth3, textView3.getMeasuredHeight() + i5);
            this.f2614KQgRr5e_0 = f;
            this.f2621PGPF6hQ_2 = false;
        } else {
            i2 = (height - paddingBottom) - max2;
        }
        i3 = i11 + i2;
        i4 = i12 + i2;
        i5 = i2 + i13;
        TextView textView4 = this.f2623QxJ9d_1;
        textView4.layout(i9, i4, i10, textView4.getMeasuredHeight() + i4);
        int min2 = Math.min(paddingLeft, (i9 - this.f2622QxJ9d_1) - measuredWidth);
        TextView textView22 = this.f2616KQgRr5e_0;
        textView22.layout(min2, i3, measuredWidth + min2, textView22.getMeasuredHeight() + i3);
        int max32 = Math.max((width - paddingRight) - measuredWidth3, i10 + this.f2622QxJ9d_1);
        TextView textView32 = this.f2620PGPF6hQ_2;
        textView32.layout(max32, i5, max32 + measuredWidth3, textView32.getMeasuredHeight() + i5);
        this.f2614KQgRr5e_0 = f;
        this.f2621PGPF6hQ_2 = false;
    }
}
