package androidx.viewpager.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
/* loaded from: classes.dex */
public class PagerTabStrip extends PagerTitleStrip {
    public int EuDEkJe_12;

    /* renamed from: FSaI4_7  reason: collision with root package name */
    public int f3595FSaI4_7;

    /* renamed from: IFxWkV_5  reason: collision with root package name */
    public int f3596IFxWkV_5;

    /* renamed from: IFxWkV_5  reason: collision with other field name */
    public boolean f2612IFxWkV_5;

    /* renamed from: IMuAHx_6  reason: collision with root package name */
    public int f3597IMuAHx_6;

    /* renamed from: KNBe_11  reason: collision with root package name */
    public int f3598KNBe_11;
    public final Paint KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Rect f2613KQgRr5e_0;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public boolean f3599Mqv2r_3;

    /* renamed from: Nm6q_10  reason: collision with root package name */
    public int f3600Nm6q_10;
    public float PGPF6hQ_2;
    public float QxJ9d_1;
    public int WwEq_13;

    /* renamed from: X6FRs_4  reason: collision with root package name */
    public boolean f3601X6FRs_4;

    /* renamed from: Xgtqvk_8  reason: collision with root package name */
    public int f3602Xgtqvk_8;

    /* renamed from: XnFJ5_9  reason: collision with root package name */
    public int f3603XnFJ5_9;

    /* loaded from: classes.dex */
    public class KQgRr5e_0 implements View.OnClickListener {
        public KQgRr5e_0() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            ViewPager viewPager = ((PagerTitleStrip) PagerTabStrip.this).f2618KQgRr5e_0;
            viewPager.setCurrentItem(viewPager.getCurrentItem() - 1);
        }
    }

    /* loaded from: classes.dex */
    public class QxJ9d_1 implements View.OnClickListener {
        public QxJ9d_1() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            ViewPager viewPager = ((PagerTitleStrip) PagerTabStrip.this).f2618KQgRr5e_0;
            viewPager.setCurrentItem(viewPager.getCurrentItem() + 1);
        }
    }

    public PagerTabStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.KQgRr5e_0 = new Paint();
        this.f2613KQgRr5e_0 = new Rect();
        this.f3598KNBe_11 = 255;
        this.f3599Mqv2r_3 = false;
        this.f3601X6FRs_4 = false;
        int i = super.f3605X6FRs_4;
        this.f3596IFxWkV_5 = i;
        this.KQgRr5e_0.setColor(i);
        float f = context.getResources().getDisplayMetrics().density;
        this.f3597IMuAHx_6 = (int) ((3.0f * f) + 0.5f);
        this.f3595FSaI4_7 = (int) ((6.0f * f) + 0.5f);
        this.f3602Xgtqvk_8 = (int) (64.0f * f);
        this.f3600Nm6q_10 = (int) ((16.0f * f) + 0.5f);
        this.EuDEkJe_12 = (int) ((1.0f * f) + 0.5f);
        this.f3603XnFJ5_9 = (int) ((f * 32.0f) + 0.5f);
        this.WwEq_13 = ViewConfiguration.get(context).getScaledTouchSlop();
        setPadding(getPaddingLeft(), getPaddingTop(), getPaddingRight(), getPaddingBottom());
        setTextSpacing(getTextSpacing());
        setWillNotDraw(false);
        ((PagerTitleStrip) this).f2616KQgRr5e_0.setFocusable(true);
        ((PagerTitleStrip) this).f2616KQgRr5e_0.setOnClickListener(new KQgRr5e_0());
        ((PagerTitleStrip) this).f2620PGPF6hQ_2.setFocusable(true);
        ((PagerTitleStrip) this).f2620PGPF6hQ_2.setOnClickListener(new QxJ9d_1());
        if (getBackground() == null) {
            this.f3599Mqv2r_3 = true;
        }
    }

    @Override // androidx.viewpager.widget.PagerTitleStrip
    public void KQgRr5e_0(int i, float f, boolean z) {
        Rect rect = this.f2613KQgRr5e_0;
        int height = getHeight();
        int left = ((PagerTitleStrip) this).f2623QxJ9d_1.getLeft() - this.f3600Nm6q_10;
        int right = ((PagerTitleStrip) this).f2623QxJ9d_1.getRight() + this.f3600Nm6q_10;
        int i2 = height - this.f3597IMuAHx_6;
        rect.set(left, i2, right, height);
        super.KQgRr5e_0(i, f, z);
        this.f3598KNBe_11 = (int) (Math.abs(f - 0.5f) * 2.0f * 255.0f);
        rect.union(((PagerTitleStrip) this).f2623QxJ9d_1.getLeft() - this.f3600Nm6q_10, i2, ((PagerTitleStrip) this).f2623QxJ9d_1.getRight() + this.f3600Nm6q_10, height);
        invalidate(rect);
    }

    public boolean getDrawFullUnderline() {
        return this.f3599Mqv2r_3;
    }

    @Override // androidx.viewpager.widget.PagerTitleStrip
    public int getMinHeight() {
        return Math.max(super.getMinHeight(), this.f3603XnFJ5_9);
    }

    public int getTabIndicatorColor() {
        return this.f3596IFxWkV_5;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int height = getHeight();
        int left = ((PagerTitleStrip) this).f2623QxJ9d_1.getLeft() - this.f3600Nm6q_10;
        int right = ((PagerTitleStrip) this).f2623QxJ9d_1.getRight() + this.f3600Nm6q_10;
        this.KQgRr5e_0.setColor((this.f3598KNBe_11 << 24) | (this.f3596IFxWkV_5 & 16777215));
        float f = height;
        canvas.drawRect(left, height - this.f3597IMuAHx_6, right, f, this.KQgRr5e_0);
        if (this.f3599Mqv2r_3) {
            this.KQgRr5e_0.setColor((-16777216) | (this.f3596IFxWkV_5 & 16777215));
            canvas.drawRect(getPaddingLeft(), height - this.EuDEkJe_12, getWidth() - getPaddingRight(), f, this.KQgRr5e_0);
        }
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        if (action == 0 || !this.f2612IFxWkV_5) {
            float x = motionEvent.getX();
            float y = motionEvent.getY();
            if (action == 0) {
                this.QxJ9d_1 = x;
                this.PGPF6hQ_2 = y;
                this.f2612IFxWkV_5 = false;
            } else if (action != 1) {
                if (action == 2 && (Math.abs(x - this.QxJ9d_1) > this.WwEq_13 || Math.abs(y - this.PGPF6hQ_2) > this.WwEq_13)) {
                    this.f2612IFxWkV_5 = true;
                }
            } else if (x < ((PagerTitleStrip) this).f2623QxJ9d_1.getLeft() - this.f3600Nm6q_10) {
                ViewPager viewPager = ((PagerTitleStrip) this).f2618KQgRr5e_0;
                viewPager.setCurrentItem(viewPager.getCurrentItem() - 1);
            } else if (x > ((PagerTitleStrip) this).f2623QxJ9d_1.getRight() + this.f3600Nm6q_10) {
                ViewPager viewPager2 = ((PagerTitleStrip) this).f2618KQgRr5e_0;
                viewPager2.setCurrentItem(viewPager2.getCurrentItem() + 1);
            }
            return true;
        }
        return false;
    }

    @Override // android.view.View
    public void setBackgroundColor(int i) {
        super.setBackgroundColor(i);
        if (this.f3601X6FRs_4) {
            return;
        }
        this.f3599Mqv2r_3 = (i & (-16777216)) == 0;
    }

    @Override // android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        if (this.f3601X6FRs_4) {
            return;
        }
        this.f3599Mqv2r_3 = drawable == null;
    }

    @Override // android.view.View
    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        if (this.f3601X6FRs_4) {
            return;
        }
        this.f3599Mqv2r_3 = i == 0;
    }

    public void setDrawFullUnderline(boolean z) {
        this.f3599Mqv2r_3 = z;
        this.f3601X6FRs_4 = true;
        invalidate();
    }

    @Override // android.view.View
    public void setPadding(int i, int i2, int i3, int i4) {
        int i5 = this.f3595FSaI4_7;
        if (i4 < i5) {
            i4 = i5;
        }
        super.setPadding(i, i2, i3, i4);
    }

    public void setTabIndicatorColor(int i) {
        this.f3596IFxWkV_5 = i;
        this.KQgRr5e_0.setColor(i);
        invalidate();
    }

    public void setTabIndicatorColorResource(int i) {
        setTabIndicatorColor(X6FRs_4.IMuAHx_6.X6FRs_4.KQgRr5e_0.KQgRr5e_0(getContext(), i));
    }

    @Override // androidx.viewpager.widget.PagerTitleStrip
    public void setTextSpacing(int i) {
        int i2 = this.f3602Xgtqvk_8;
        if (i < i2) {
            i = i2;
        }
        super.setTextSpacing(i);
    }
}
