package androidx.transition;

import X6FRs_4.JZJr_16.H5YG8fq_22;
import X6FRs_4.JZJr_16.JXypC6_34;
import X6FRs_4.JZJr_16.NQvZgp_17;
import X6FRs_4.JZJr_16.SI64pbG_23;
import X6FRs_4.JZJr_16.XuYK_42;
import X6FRs_4.JZJr_16.ZzDuCHW_20;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ListView;
import androidx.recyclerview.widget.RecyclerView;
import com.wang.avi.BuildConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.xmlpull.v1.XmlPullParser;
/* loaded from: classes.dex */
public abstract class Transition implements Cloneable {
    public static final boolean DBG = false;
    public static final String LOG_TAG = "Transition";
    public static final int MATCH_FIRST = 1;
    public static final int MATCH_ID = 3;
    public static final String MATCH_ID_STR = "id";
    public static final int MATCH_INSTANCE = 1;
    public static final String MATCH_INSTANCE_STR = "instance";
    public static final int MATCH_ITEM_ID = 4;
    public static final String MATCH_ITEM_ID_STR = "itemId";
    public static final int MATCH_LAST = 4;
    public static final int MATCH_NAME = 2;
    public static final String MATCH_NAME_STR = "name";
    public ArrayList<H5YG8fq_22> mEndValuesList;
    public IFxWkV_5 mEpicenterCallback;
    public X6FRs_4.Mqv2r_3.KQgRr5e_0<String, String> mNameOverrides;
    public ZzDuCHW_20 mPropagation;
    public ArrayList<H5YG8fq_22> mStartValuesList;
    public static final int[] DEFAULT_MATCH_ORDER = {2, 1, 3, 4};
    public static final PathMotion STRAIGHT_PATH_MOTION = new KQgRr5e_0();
    public static ThreadLocal<X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3>> sRunningAnimators = new ThreadLocal<>();
    public String mName = getClass().getName();
    public long mStartDelay = -1;
    public long mDuration = -1;
    public TimeInterpolator mInterpolator = null;
    public ArrayList<Integer> mTargetIds = new ArrayList<>();
    public ArrayList<View> mTargets = new ArrayList<>();
    public ArrayList<String> mTargetNames = null;
    public ArrayList<Class> mTargetTypes = null;
    public ArrayList<Integer> mTargetIdExcludes = null;
    public ArrayList<View> mTargetExcludes = null;
    public ArrayList<Class> mTargetTypeExcludes = null;
    public ArrayList<String> mTargetNameExcludes = null;
    public ArrayList<Integer> mTargetIdChildExcludes = null;
    public ArrayList<View> mTargetChildExcludes = null;
    public ArrayList<Class> mTargetTypeChildExcludes = null;
    public SI64pbG_23 mStartValues = new SI64pbG_23();
    public SI64pbG_23 mEndValues = new SI64pbG_23();
    public TransitionSet mParent = null;
    public int[] mMatchOrder = DEFAULT_MATCH_ORDER;
    public ViewGroup mSceneRoot = null;
    public boolean mCanRemoveViews = false;
    public ArrayList<Animator> mCurrentAnimators = new ArrayList<>();
    public int mNumInstances = 0;
    public boolean mPaused = false;
    public boolean mEnded = false;
    public ArrayList<IMuAHx_6> mListeners = null;
    public ArrayList<Animator> mAnimators = new ArrayList<>();
    public PathMotion mPathMotion = STRAIGHT_PATH_MOTION;

    /* loaded from: classes.dex */
    public static abstract class IFxWkV_5 {
        public abstract Rect KQgRr5e_0(Transition transition);
    }

    /* loaded from: classes.dex */
    public interface IMuAHx_6 {
        void KQgRr5e_0(Transition transition);

        void Mqv2r_3(Transition transition);

        void PGPF6hQ_2(Transition transition);

        void QxJ9d_1(Transition transition);

        void X6FRs_4(Transition transition);
    }

    /* loaded from: classes.dex */
    public static class KQgRr5e_0 extends PathMotion {
        @Override // androidx.transition.PathMotion
        public Path KQgRr5e_0(float f, float f2, float f3, float f4) {
            Path path = new Path();
            path.moveTo(f, f2);
            path.lineTo(f3, f4);
            return path;
        }
    }

    /* loaded from: classes.dex */
    public static class Mqv2r_3 {
        public H5YG8fq_22 KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public XuYK_42 f2597KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public View f2598KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public Transition f2599KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public String f2600KQgRr5e_0;

        public Mqv2r_3(View view, String str, Transition transition, XuYK_42 xuYK_42, H5YG8fq_22 h5YG8fq_22) {
            this.f2598KQgRr5e_0 = view;
            this.f2600KQgRr5e_0 = str;
            this.KQgRr5e_0 = h5YG8fq_22;
            this.f2597KQgRr5e_0 = xuYK_42;
            this.f2599KQgRr5e_0 = transition;
        }
    }

    /* loaded from: classes.dex */
    public class PGPF6hQ_2 extends AnimatorListenerAdapter {
        public PGPF6hQ_2() {
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            Transition.this.end();
            animator.removeListener(this);
        }
    }

    /* loaded from: classes.dex */
    public class QxJ9d_1 extends AnimatorListenerAdapter {
        public final /* synthetic */ X6FRs_4.Mqv2r_3.KQgRr5e_0 KQgRr5e_0;

        public QxJ9d_1(X6FRs_4.Mqv2r_3.KQgRr5e_0 kQgRr5e_0) {
            this.KQgRr5e_0 = kQgRr5e_0;
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            this.KQgRr5e_0.remove(animator);
            Transition.this.mCurrentAnimators.remove(animator);
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationStart(Animator animator) {
            Transition.this.mCurrentAnimators.add(animator);
        }
    }

    /* loaded from: classes.dex */
    public static class X6FRs_4 {
        public static <T> ArrayList<T> KQgRr5e_0(ArrayList<T> arrayList, T t) {
            if (arrayList == null) {
                arrayList = new ArrayList<>();
            }
            if (!arrayList.contains(t)) {
                arrayList.add(t);
            }
            return arrayList;
        }

        public static <T> ArrayList<T> QxJ9d_1(ArrayList<T> arrayList, T t) {
            if (arrayList != null) {
                arrayList.remove(t);
                if (arrayList.isEmpty()) {
                    return null;
                }
                return arrayList;
            }
            return arrayList;
        }
    }

    public Transition() {
    }

    private void addUnmatched(X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_0, X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_02) {
        for (int i = 0; i < kQgRr5e_0.size(); i++) {
            H5YG8fq_22 PGPF6hQ_22 = kQgRr5e_0.PGPF6hQ_2(i);
            if (isValidTarget(PGPF6hQ_22.KQgRr5e_0)) {
                this.mStartValuesList.add(PGPF6hQ_22);
                this.mEndValuesList.add(null);
            }
        }
        for (int i2 = 0; i2 < kQgRr5e_02.size(); i2++) {
            H5YG8fq_22 PGPF6hQ_23 = kQgRr5e_02.PGPF6hQ_2(i2);
            if (isValidTarget(PGPF6hQ_23.KQgRr5e_0)) {
                this.mEndValuesList.add(PGPF6hQ_23);
                this.mStartValuesList.add(null);
            }
        }
    }

    public static void addViewValues(SI64pbG_23 sI64pbG_23, View view, H5YG8fq_22 h5YG8fq_22) {
        sI64pbG_23.KQgRr5e_0.put(view, h5YG8fq_22);
        int id = view.getId();
        if (id >= 0) {
            if (sI64pbG_23.f592KQgRr5e_0.indexOfKey(id) >= 0) {
                sI64pbG_23.f592KQgRr5e_0.put(id, null);
            } else {
                sI64pbG_23.f592KQgRr5e_0.put(id, view);
            }
        }
        String m261KQgRr5e_0 = X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20.m261KQgRr5e_0(view);
        if (m261KQgRr5e_0 != null) {
            if (sI64pbG_23.QxJ9d_1.containsKey(m261KQgRr5e_0)) {
                sI64pbG_23.QxJ9d_1.put(m261KQgRr5e_0, null);
            } else {
                sI64pbG_23.QxJ9d_1.put(m261KQgRr5e_0, view);
            }
        }
        if (view.getParent() instanceof ListView) {
            ListView listView = (ListView) view.getParent();
            if (listView.getAdapter().hasStableIds()) {
                long itemIdAtPosition = listView.getItemIdAtPosition(listView.getPositionForView(view));
                if (sI64pbG_23.f591KQgRr5e_0.KQgRr5e_0(itemIdAtPosition) >= 0) {
                    View m505KQgRr5e_0 = sI64pbG_23.f591KQgRr5e_0.m505KQgRr5e_0(itemIdAtPosition);
                    if (m505KQgRr5e_0 != null) {
                        X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20.QxJ9d_1(m505KQgRr5e_0, false);
                        sI64pbG_23.f591KQgRr5e_0.QxJ9d_1(itemIdAtPosition, null);
                        return;
                    }
                    return;
                }
                X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20.QxJ9d_1(view, true);
                sI64pbG_23.f591KQgRr5e_0.QxJ9d_1(itemIdAtPosition, view);
            }
        }
    }

    public static boolean alreadyContains(int[] iArr, int i) {
        int i2 = iArr[i];
        for (int i3 = 0; i3 < i; i3++) {
            if (iArr[i3] == i2) {
                return true;
            }
        }
        return false;
    }

    private void captureHierarchy(View view, boolean z) {
        if (view == null) {
            return;
        }
        int id = view.getId();
        ArrayList<Integer> arrayList = this.mTargetIdExcludes;
        if (arrayList == null || !arrayList.contains(Integer.valueOf(id))) {
            ArrayList<View> arrayList2 = this.mTargetExcludes;
            if (arrayList2 == null || !arrayList2.contains(view)) {
                ArrayList<Class> arrayList3 = this.mTargetTypeExcludes;
                if (arrayList3 != null) {
                    int size = arrayList3.size();
                    for (int i = 0; i < size; i++) {
                        if (this.mTargetTypeExcludes.get(i).isInstance(view)) {
                            return;
                        }
                    }
                }
                if (view.getParent() instanceof ViewGroup) {
                    H5YG8fq_22 h5YG8fq_22 = new H5YG8fq_22();
                    h5YG8fq_22.KQgRr5e_0 = view;
                    if (z) {
                        captureStartValues(h5YG8fq_22);
                    } else {
                        captureEndValues(h5YG8fq_22);
                    }
                    h5YG8fq_22.f565KQgRr5e_0.add(this);
                    capturePropagationValues(h5YG8fq_22);
                    if (z) {
                        addViewValues(this.mStartValues, view, h5YG8fq_22);
                    } else {
                        addViewValues(this.mEndValues, view, h5YG8fq_22);
                    }
                }
                if (view instanceof ViewGroup) {
                    ArrayList<Integer> arrayList4 = this.mTargetIdChildExcludes;
                    if (arrayList4 == null || !arrayList4.contains(Integer.valueOf(id))) {
                        ArrayList<View> arrayList5 = this.mTargetChildExcludes;
                        if (arrayList5 == null || !arrayList5.contains(view)) {
                            ArrayList<Class> arrayList6 = this.mTargetTypeChildExcludes;
                            if (arrayList6 != null) {
                                int size2 = arrayList6.size();
                                for (int i2 = 0; i2 < size2; i2++) {
                                    if (this.mTargetTypeChildExcludes.get(i2).isInstance(view)) {
                                        return;
                                    }
                                }
                            }
                            ViewGroup viewGroup = (ViewGroup) view;
                            for (int i3 = 0; i3 < viewGroup.getChildCount(); i3++) {
                                captureHierarchy(viewGroup.getChildAt(i3), z);
                            }
                        }
                    }
                }
            }
        }
    }

    private ArrayList<Integer> excludeId(ArrayList<Integer> arrayList, int i, boolean z) {
        if (i > 0) {
            if (z) {
                return X6FRs_4.KQgRr5e_0(arrayList, Integer.valueOf(i));
            }
            return X6FRs_4.QxJ9d_1(arrayList, Integer.valueOf(i));
        }
        return arrayList;
    }

    public static <T> ArrayList<T> excludeObject(ArrayList<T> arrayList, T t, boolean z) {
        if (t != null) {
            if (z) {
                return X6FRs_4.KQgRr5e_0(arrayList, t);
            }
            return X6FRs_4.QxJ9d_1(arrayList, t);
        }
        return arrayList;
    }

    private ArrayList<Class> excludeType(ArrayList<Class> arrayList, Class cls, boolean z) {
        if (cls != null) {
            if (z) {
                return X6FRs_4.KQgRr5e_0(arrayList, cls);
            }
            return X6FRs_4.QxJ9d_1(arrayList, cls);
        }
        return arrayList;
    }

    private ArrayList<View> excludeView(ArrayList<View> arrayList, View view, boolean z) {
        if (view != null) {
            if (z) {
                return X6FRs_4.KQgRr5e_0(arrayList, view);
            }
            return X6FRs_4.QxJ9d_1(arrayList, view);
        }
        return arrayList;
    }

    public static X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> getRunningAnimators() {
        X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> kQgRr5e_0 = sRunningAnimators.get();
        if (kQgRr5e_0 == null) {
            X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> kQgRr5e_02 = new X6FRs_4.Mqv2r_3.KQgRr5e_0<>();
            sRunningAnimators.set(kQgRr5e_02);
            return kQgRr5e_02;
        }
        return kQgRr5e_0;
    }

    public static boolean isValidMatch(int i) {
        return i >= 1 && i <= 4;
    }

    public static boolean isValueChanged(H5YG8fq_22 h5YG8fq_22, H5YG8fq_22 h5YG8fq_222, String str) {
        Object obj = h5YG8fq_22.f566KQgRr5e_0.get(str);
        Object obj2 = h5YG8fq_222.f566KQgRr5e_0.get(str);
        if (obj == null && obj2 == null) {
            return false;
        }
        if (obj == null || obj2 == null) {
            return true;
        }
        return true ^ obj.equals(obj2);
    }

    private void matchIds(X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_0, X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_02, SparseArray<View> sparseArray, SparseArray<View> sparseArray2) {
        View view;
        int size = sparseArray.size();
        for (int i = 0; i < size; i++) {
            View valueAt = sparseArray.valueAt(i);
            if (valueAt != null && isValidTarget(valueAt) && (view = sparseArray2.get(sparseArray.keyAt(i))) != null && isValidTarget(view)) {
                H5YG8fq_22 h5YG8fq_22 = kQgRr5e_0.get(valueAt);
                H5YG8fq_22 h5YG8fq_222 = kQgRr5e_02.get(view);
                if (h5YG8fq_22 != null && h5YG8fq_222 != null) {
                    this.mStartValuesList.add(h5YG8fq_22);
                    this.mEndValuesList.add(h5YG8fq_222);
                    kQgRr5e_0.remove(valueAt);
                    kQgRr5e_02.remove(view);
                }
            }
        }
    }

    private void matchInstances(X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_0, X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_02) {
        H5YG8fq_22 remove;
        View view;
        for (int size = kQgRr5e_0.size() - 1; size >= 0; size--) {
            View KQgRr5e_02 = kQgRr5e_0.KQgRr5e_0(size);
            if (KQgRr5e_02 != null && isValidTarget(KQgRr5e_02) && (remove = kQgRr5e_02.remove(KQgRr5e_02)) != null && (view = remove.KQgRr5e_0) != null && isValidTarget(view)) {
                this.mStartValuesList.add(kQgRr5e_0.QxJ9d_1(size));
                this.mEndValuesList.add(remove);
            }
        }
    }

    private void matchItemIds(X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_0, X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_02, X6FRs_4.Mqv2r_3.Mqv2r_3<View> mqv2r_3, X6FRs_4.Mqv2r_3.Mqv2r_3<View> mqv2r_32) {
        View m505KQgRr5e_0;
        int KQgRr5e_02 = mqv2r_3.KQgRr5e_0();
        for (int i = 0; i < KQgRr5e_02; i++) {
            View m504KQgRr5e_0 = mqv2r_3.m504KQgRr5e_0(i);
            if (m504KQgRr5e_0 != null && isValidTarget(m504KQgRr5e_0) && (m505KQgRr5e_0 = mqv2r_32.m505KQgRr5e_0(mqv2r_3.KQgRr5e_0(i))) != null && isValidTarget(m505KQgRr5e_0)) {
                H5YG8fq_22 h5YG8fq_22 = kQgRr5e_0.get(m504KQgRr5e_0);
                H5YG8fq_22 h5YG8fq_222 = kQgRr5e_02.get(m505KQgRr5e_0);
                if (h5YG8fq_22 != null && h5YG8fq_222 != null) {
                    this.mStartValuesList.add(h5YG8fq_22);
                    this.mEndValuesList.add(h5YG8fq_222);
                    kQgRr5e_0.remove(m504KQgRr5e_0);
                    kQgRr5e_02.remove(m505KQgRr5e_0);
                }
            }
        }
    }

    private void matchNames(X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_0, X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_02, X6FRs_4.Mqv2r_3.KQgRr5e_0<String, View> kQgRr5e_03, X6FRs_4.Mqv2r_3.KQgRr5e_0<String, View> kQgRr5e_04) {
        View view;
        int size = kQgRr5e_03.size();
        for (int i = 0; i < size; i++) {
            View PGPF6hQ_22 = kQgRr5e_03.PGPF6hQ_2(i);
            if (PGPF6hQ_22 != null && isValidTarget(PGPF6hQ_22) && (view = kQgRr5e_04.get(kQgRr5e_03.KQgRr5e_0(i))) != null && isValidTarget(view)) {
                H5YG8fq_22 h5YG8fq_22 = kQgRr5e_0.get(PGPF6hQ_22);
                H5YG8fq_22 h5YG8fq_222 = kQgRr5e_02.get(view);
                if (h5YG8fq_22 != null && h5YG8fq_222 != null) {
                    this.mStartValuesList.add(h5YG8fq_22);
                    this.mEndValuesList.add(h5YG8fq_222);
                    kQgRr5e_0.remove(PGPF6hQ_22);
                    kQgRr5e_02.remove(view);
                }
            }
        }
    }

    private void matchStartAndEnd(SI64pbG_23 sI64pbG_23, SI64pbG_23 sI64pbG_232) {
        X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_0 = new X6FRs_4.Mqv2r_3.KQgRr5e_0<>(sI64pbG_23.KQgRr5e_0);
        X6FRs_4.Mqv2r_3.KQgRr5e_0<View, H5YG8fq_22> kQgRr5e_02 = new X6FRs_4.Mqv2r_3.KQgRr5e_0<>(sI64pbG_232.KQgRr5e_0);
        int i = 0;
        while (true) {
            int[] iArr = this.mMatchOrder;
            if (i < iArr.length) {
                int i2 = iArr[i];
                if (i2 == 1) {
                    matchInstances(kQgRr5e_0, kQgRr5e_02);
                } else if (i2 == 2) {
                    matchNames(kQgRr5e_0, kQgRr5e_02, sI64pbG_23.QxJ9d_1, sI64pbG_232.QxJ9d_1);
                } else if (i2 == 3) {
                    matchIds(kQgRr5e_0, kQgRr5e_02, sI64pbG_23.f592KQgRr5e_0, sI64pbG_232.f592KQgRr5e_0);
                } else if (i2 == 4) {
                    matchItemIds(kQgRr5e_0, kQgRr5e_02, sI64pbG_23.f591KQgRr5e_0, sI64pbG_232.f591KQgRr5e_0);
                }
                i++;
            } else {
                addUnmatched(kQgRr5e_0, kQgRr5e_02);
                return;
            }
        }
    }

    public static int[] parseMatchOrder(String str) {
        StringTokenizer stringTokenizer = new StringTokenizer(str, ",");
        int[] iArr = new int[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String trim = stringTokenizer.nextToken().trim();
            if (MATCH_ID_STR.equalsIgnoreCase(trim)) {
                iArr[i] = 3;
            } else if (MATCH_INSTANCE_STR.equalsIgnoreCase(trim)) {
                iArr[i] = 1;
            } else if (MATCH_NAME_STR.equalsIgnoreCase(trim)) {
                iArr[i] = 2;
            } else if (MATCH_ITEM_ID_STR.equalsIgnoreCase(trim)) {
                iArr[i] = 4;
            } else if (trim.isEmpty()) {
                int[] iArr2 = new int[iArr.length - 1];
                System.arraycopy(iArr, 0, iArr2, 0, i);
                i--;
                iArr = iArr2;
            } else {
                throw new InflateException("Unknown match type in matchOrder: '" + trim + "'");
            }
            i++;
        }
        return iArr;
    }

    private void runAnimator(Animator animator, X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> kQgRr5e_0) {
        if (animator != null) {
            animator.addListener(new QxJ9d_1(kQgRr5e_0));
            animate(animator);
        }
    }

    public Transition addListener(IMuAHx_6 iMuAHx_6) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<>();
        }
        this.mListeners.add(iMuAHx_6);
        return this;
    }

    public Transition addTarget(View view) {
        this.mTargets.add(view);
        return this;
    }

    public void animate(Animator animator) {
        if (animator == null) {
            end();
            return;
        }
        if (getDuration() >= 0) {
            animator.setDuration(getDuration());
        }
        if (getStartDelay() >= 0) {
            animator.setStartDelay(getStartDelay());
        }
        if (getInterpolator() != null) {
            animator.setInterpolator(getInterpolator());
        }
        animator.addListener(new PGPF6hQ_2());
        animator.start();
    }

    public void cancel() {
        for (int size = this.mCurrentAnimators.size() - 1; size >= 0; size--) {
            this.mCurrentAnimators.get(size).cancel();
        }
        ArrayList<IMuAHx_6> arrayList = this.mListeners;
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
        int size2 = arrayList2.size();
        for (int i = 0; i < size2; i++) {
            ((IMuAHx_6) arrayList2.get(i)).Mqv2r_3(this);
        }
    }

    public abstract void captureEndValues(H5YG8fq_22 h5YG8fq_22);

    public void capturePropagationValues(H5YG8fq_22 h5YG8fq_22) {
        String[] KQgRr5e_02;
        if (this.mPropagation == null || h5YG8fq_22.f566KQgRr5e_0.isEmpty() || (KQgRr5e_02 = this.mPropagation.KQgRr5e_0()) == null) {
            return;
        }
        boolean z = false;
        int i = 0;
        while (true) {
            if (i >= KQgRr5e_02.length) {
                z = true;
                break;
            } else if (!h5YG8fq_22.f566KQgRr5e_0.containsKey(KQgRr5e_02[i])) {
                break;
            } else {
                i++;
            }
        }
        if (z) {
            return;
        }
        this.mPropagation.KQgRr5e_0(h5YG8fq_22);
    }

    public abstract void captureStartValues(H5YG8fq_22 h5YG8fq_22);

    public void captureValues(ViewGroup viewGroup, boolean z) {
        ArrayList<String> arrayList;
        ArrayList<Class> arrayList2;
        X6FRs_4.Mqv2r_3.KQgRr5e_0<String, String> kQgRr5e_0;
        clearValues(z);
        if ((this.mTargetIds.size() <= 0 && this.mTargets.size() <= 0) || (((arrayList = this.mTargetNames) != null && !arrayList.isEmpty()) || ((arrayList2 = this.mTargetTypes) != null && !arrayList2.isEmpty()))) {
            captureHierarchy(viewGroup, z);
        } else {
            for (int i = 0; i < this.mTargetIds.size(); i++) {
                View findViewById = viewGroup.findViewById(this.mTargetIds.get(i).intValue());
                if (findViewById != null) {
                    H5YG8fq_22 h5YG8fq_22 = new H5YG8fq_22();
                    h5YG8fq_22.KQgRr5e_0 = findViewById;
                    if (z) {
                        captureStartValues(h5YG8fq_22);
                    } else {
                        captureEndValues(h5YG8fq_22);
                    }
                    h5YG8fq_22.f565KQgRr5e_0.add(this);
                    capturePropagationValues(h5YG8fq_22);
                    if (z) {
                        addViewValues(this.mStartValues, findViewById, h5YG8fq_22);
                    } else {
                        addViewValues(this.mEndValues, findViewById, h5YG8fq_22);
                    }
                }
            }
            for (int i2 = 0; i2 < this.mTargets.size(); i2++) {
                View view = this.mTargets.get(i2);
                H5YG8fq_22 h5YG8fq_222 = new H5YG8fq_22();
                h5YG8fq_222.KQgRr5e_0 = view;
                if (z) {
                    captureStartValues(h5YG8fq_222);
                } else {
                    captureEndValues(h5YG8fq_222);
                }
                h5YG8fq_222.f565KQgRr5e_0.add(this);
                capturePropagationValues(h5YG8fq_222);
                if (z) {
                    addViewValues(this.mStartValues, view, h5YG8fq_222);
                } else {
                    addViewValues(this.mEndValues, view, h5YG8fq_222);
                }
            }
        }
        if (z || (kQgRr5e_0 = this.mNameOverrides) == null) {
            return;
        }
        int size = kQgRr5e_0.size();
        ArrayList arrayList3 = new ArrayList(size);
        for (int i3 = 0; i3 < size; i3++) {
            arrayList3.add(this.mStartValues.QxJ9d_1.remove(this.mNameOverrides.KQgRr5e_0(i3)));
        }
        for (int i4 = 0; i4 < size; i4++) {
            View view2 = (View) arrayList3.get(i4);
            if (view2 != null) {
                this.mStartValues.QxJ9d_1.put(this.mNameOverrides.PGPF6hQ_2(i4), view2);
            }
        }
    }

    public void clearValues(boolean z) {
        if (z) {
            this.mStartValues.KQgRr5e_0.clear();
            this.mStartValues.f592KQgRr5e_0.clear();
            this.mStartValues.f591KQgRr5e_0.m506KQgRr5e_0();
            return;
        }
        this.mEndValues.KQgRr5e_0.clear();
        this.mEndValues.f592KQgRr5e_0.clear();
        this.mEndValues.f591KQgRr5e_0.m506KQgRr5e_0();
    }

    public Animator createAnimator(ViewGroup viewGroup, H5YG8fq_22 h5YG8fq_22, H5YG8fq_22 h5YG8fq_222) {
        return null;
    }

    public void createAnimators(ViewGroup viewGroup, SI64pbG_23 sI64pbG_23, SI64pbG_23 sI64pbG_232, ArrayList<H5YG8fq_22> arrayList, ArrayList<H5YG8fq_22> arrayList2) {
        Animator createAnimator;
        int i;
        int i2;
        View view;
        Animator animator;
        H5YG8fq_22 h5YG8fq_22;
        Animator animator2;
        H5YG8fq_22 h5YG8fq_222;
        X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> runningAnimators = getRunningAnimators();
        SparseIntArray sparseIntArray = new SparseIntArray();
        int size = arrayList.size();
        long j = RecyclerView.FOREVER_NS;
        int i3 = 0;
        while (i3 < size) {
            H5YG8fq_22 h5YG8fq_223 = arrayList.get(i3);
            H5YG8fq_22 h5YG8fq_224 = arrayList2.get(i3);
            if (h5YG8fq_223 != null && !h5YG8fq_223.f565KQgRr5e_0.contains(this)) {
                h5YG8fq_223 = null;
            }
            if (h5YG8fq_224 != null && !h5YG8fq_224.f565KQgRr5e_0.contains(this)) {
                h5YG8fq_224 = null;
            }
            if (h5YG8fq_223 != null || h5YG8fq_224 != null) {
                if ((h5YG8fq_223 == null || h5YG8fq_224 == null || isTransitionRequired(h5YG8fq_223, h5YG8fq_224)) && (createAnimator = createAnimator(viewGroup, h5YG8fq_223, h5YG8fq_224)) != null) {
                    if (h5YG8fq_224 != null) {
                        view = h5YG8fq_224.KQgRr5e_0;
                        String[] transitionProperties = getTransitionProperties();
                        if (view == null || transitionProperties == null || transitionProperties.length <= 0) {
                            i = size;
                            i2 = i3;
                            animator2 = createAnimator;
                            h5YG8fq_222 = null;
                        } else {
                            h5YG8fq_222 = new H5YG8fq_22();
                            h5YG8fq_222.KQgRr5e_0 = view;
                            i = size;
                            H5YG8fq_22 h5YG8fq_225 = sI64pbG_232.KQgRr5e_0.get(view);
                            if (h5YG8fq_225 != null) {
                                int i4 = 0;
                                while (i4 < transitionProperties.length) {
                                    h5YG8fq_222.f566KQgRr5e_0.put(transitionProperties[i4], h5YG8fq_225.f566KQgRr5e_0.get(transitionProperties[i4]));
                                    i4++;
                                    i3 = i3;
                                    h5YG8fq_225 = h5YG8fq_225;
                                }
                            }
                            i2 = i3;
                            int size2 = runningAnimators.size();
                            int i5 = 0;
                            while (true) {
                                if (i5 >= size2) {
                                    animator2 = createAnimator;
                                    break;
                                }
                                Mqv2r_3 mqv2r_3 = runningAnimators.get(runningAnimators.KQgRr5e_0(i5));
                                if (mqv2r_3.KQgRr5e_0 != null && mqv2r_3.f2598KQgRr5e_0 == view && mqv2r_3.f2600KQgRr5e_0.equals(getName()) && mqv2r_3.KQgRr5e_0.equals(h5YG8fq_222)) {
                                    animator2 = null;
                                    break;
                                }
                                i5++;
                            }
                        }
                        animator = animator2;
                        h5YG8fq_22 = h5YG8fq_222;
                    } else {
                        i = size;
                        i2 = i3;
                        view = h5YG8fq_223.KQgRr5e_0;
                        animator = createAnimator;
                        h5YG8fq_22 = null;
                    }
                    if (animator != null) {
                        ZzDuCHW_20 zzDuCHW_20 = this.mPropagation;
                        if (zzDuCHW_20 != null) {
                            long KQgRr5e_02 = zzDuCHW_20.KQgRr5e_0(viewGroup, this, h5YG8fq_223, h5YG8fq_224);
                            sparseIntArray.put(this.mAnimators.size(), (int) KQgRr5e_02);
                            j = Math.min(KQgRr5e_02, j);
                        }
                        runningAnimators.put(animator, new Mqv2r_3(view, getName(), this, JXypC6_34.m351KQgRr5e_0((View) viewGroup), h5YG8fq_22));
                        this.mAnimators.add(animator);
                        j = j;
                    }
                    i3 = i2 + 1;
                    size = i;
                }
            }
            i = size;
            i2 = i3;
            i3 = i2 + 1;
            size = i;
        }
        if (j != 0) {
            for (int i6 = 0; i6 < sparseIntArray.size(); i6++) {
                Animator animator3 = this.mAnimators.get(sparseIntArray.keyAt(i6));
                animator3.setStartDelay((sparseIntArray.valueAt(i6) - j) + animator3.getStartDelay());
            }
        }
    }

    public void end() {
        int i = this.mNumInstances - 1;
        this.mNumInstances = i;
        if (i == 0) {
            ArrayList<IMuAHx_6> arrayList = this.mListeners;
            if (arrayList != null && arrayList.size() > 0) {
                ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
                int size = arrayList2.size();
                for (int i2 = 0; i2 < size; i2++) {
                    ((IMuAHx_6) arrayList2.get(i2)).X6FRs_4(this);
                }
            }
            for (int i3 = 0; i3 < this.mStartValues.f591KQgRr5e_0.KQgRr5e_0(); i3++) {
                View m504KQgRr5e_0 = this.mStartValues.f591KQgRr5e_0.m504KQgRr5e_0(i3);
                if (m504KQgRr5e_0 != null) {
                    X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20.QxJ9d_1(m504KQgRr5e_0, false);
                }
            }
            for (int i4 = 0; i4 < this.mEndValues.f591KQgRr5e_0.KQgRr5e_0(); i4++) {
                View m504KQgRr5e_02 = this.mEndValues.f591KQgRr5e_0.m504KQgRr5e_0(i4);
                if (m504KQgRr5e_02 != null) {
                    X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20.QxJ9d_1(m504KQgRr5e_02, false);
                }
            }
            this.mEnded = true;
        }
    }

    public Transition excludeChildren(View view, boolean z) {
        this.mTargetChildExcludes = excludeView(this.mTargetChildExcludes, view, z);
        return this;
    }

    public Transition excludeTarget(View view, boolean z) {
        this.mTargetExcludes = excludeView(this.mTargetExcludes, view, z);
        return this;
    }

    public void forceToEnd(ViewGroup viewGroup) {
        X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> runningAnimators = getRunningAnimators();
        int size = runningAnimators.size();
        if (viewGroup != null) {
            XuYK_42 m351KQgRr5e_0 = JXypC6_34.m351KQgRr5e_0((View) viewGroup);
            for (int i = size - 1; i >= 0; i--) {
                Mqv2r_3 PGPF6hQ_22 = runningAnimators.PGPF6hQ_2(i);
                if (PGPF6hQ_22.f2598KQgRr5e_0 != null && m351KQgRr5e_0 != null && m351KQgRr5e_0.equals(PGPF6hQ_22.f2597KQgRr5e_0)) {
                    runningAnimators.KQgRr5e_0(i).end();
                }
            }
        }
    }

    public long getDuration() {
        return this.mDuration;
    }

    public Rect getEpicenter() {
        IFxWkV_5 iFxWkV_5 = this.mEpicenterCallback;
        if (iFxWkV_5 == null) {
            return null;
        }
        return iFxWkV_5.KQgRr5e_0(this);
    }

    public IFxWkV_5 getEpicenterCallback() {
        return this.mEpicenterCallback;
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public H5YG8fq_22 getMatchedTransitionValues(View view, boolean z) {
        TransitionSet transitionSet = this.mParent;
        if (transitionSet != null) {
            return transitionSet.getMatchedTransitionValues(view, z);
        }
        ArrayList<H5YG8fq_22> arrayList = z ? this.mStartValuesList : this.mEndValuesList;
        if (arrayList == null) {
            return null;
        }
        int size = arrayList.size();
        int i = -1;
        int i2 = 0;
        while (true) {
            if (i2 >= size) {
                break;
            }
            H5YG8fq_22 h5YG8fq_22 = arrayList.get(i2);
            if (h5YG8fq_22 == null) {
                return null;
            }
            if (h5YG8fq_22.KQgRr5e_0 == view) {
                i = i2;
                break;
            }
            i2++;
        }
        if (i >= 0) {
            return (z ? this.mEndValuesList : this.mStartValuesList).get(i);
        }
        return null;
    }

    public String getName() {
        return this.mName;
    }

    public PathMotion getPathMotion() {
        return this.mPathMotion;
    }

    public ZzDuCHW_20 getPropagation() {
        return this.mPropagation;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    public List<Integer> getTargetIds() {
        return this.mTargetIds;
    }

    public List<String> getTargetNames() {
        return this.mTargetNames;
    }

    public List<Class> getTargetTypes() {
        return this.mTargetTypes;
    }

    public List<View> getTargets() {
        return this.mTargets;
    }

    public String[] getTransitionProperties() {
        return null;
    }

    public H5YG8fq_22 getTransitionValues(View view, boolean z) {
        TransitionSet transitionSet = this.mParent;
        if (transitionSet != null) {
            return transitionSet.getTransitionValues(view, z);
        }
        return (z ? this.mStartValues : this.mEndValues).KQgRr5e_0.get(view);
    }

    public boolean isTransitionRequired(H5YG8fq_22 h5YG8fq_22, H5YG8fq_22 h5YG8fq_222) {
        if (h5YG8fq_22 == null || h5YG8fq_222 == null) {
            return false;
        }
        String[] transitionProperties = getTransitionProperties();
        if (transitionProperties != null) {
            for (String str : transitionProperties) {
                if (!isValueChanged(h5YG8fq_22, h5YG8fq_222, str)) {
                }
            }
            return false;
        }
        for (String str2 : h5YG8fq_22.f566KQgRr5e_0.keySet()) {
            if (isValueChanged(h5YG8fq_22, h5YG8fq_222, str2)) {
            }
        }
        return false;
        return true;
    }

    public boolean isValidTarget(View view) {
        ArrayList<Class> arrayList;
        ArrayList<String> arrayList2;
        int id = view.getId();
        ArrayList<Integer> arrayList3 = this.mTargetIdExcludes;
        if (arrayList3 == null || !arrayList3.contains(Integer.valueOf(id))) {
            ArrayList<View> arrayList4 = this.mTargetExcludes;
            if (arrayList4 == null || !arrayList4.contains(view)) {
                ArrayList<Class> arrayList5 = this.mTargetTypeExcludes;
                if (arrayList5 != null) {
                    int size = arrayList5.size();
                    for (int i = 0; i < size; i++) {
                        if (this.mTargetTypeExcludes.get(i).isInstance(view)) {
                            return false;
                        }
                    }
                }
                if (this.mTargetNameExcludes == null || X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20.m261KQgRr5e_0(view) == null || !this.mTargetNameExcludes.contains(X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20.m261KQgRr5e_0(view))) {
                    if ((this.mTargetIds.size() == 0 && this.mTargets.size() == 0 && (((arrayList = this.mTargetTypes) == null || arrayList.isEmpty()) && ((arrayList2 = this.mTargetNames) == null || arrayList2.isEmpty()))) || this.mTargetIds.contains(Integer.valueOf(id)) || this.mTargets.contains(view)) {
                        return true;
                    }
                    ArrayList<String> arrayList6 = this.mTargetNames;
                    if (arrayList6 == null || !arrayList6.contains(X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20.m261KQgRr5e_0(view))) {
                        if (this.mTargetTypes != null) {
                            for (int i2 = 0; i2 < this.mTargetTypes.size(); i2++) {
                                if (this.mTargetTypes.get(i2).isInstance(view)) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void pause(View view) {
        if (this.mEnded) {
            return;
        }
        X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> runningAnimators = getRunningAnimators();
        int size = runningAnimators.size();
        XuYK_42 m351KQgRr5e_0 = JXypC6_34.m351KQgRr5e_0(view);
        for (int i = size - 1; i >= 0; i--) {
            Mqv2r_3 PGPF6hQ_22 = runningAnimators.PGPF6hQ_2(i);
            if (PGPF6hQ_22.f2598KQgRr5e_0 != null && m351KQgRr5e_0.equals(PGPF6hQ_22.f2597KQgRr5e_0)) {
                X6FRs_4.JZJr_16.KQgRr5e_0.KQgRr5e_0(runningAnimators.KQgRr5e_0(i));
            }
        }
        ArrayList<IMuAHx_6> arrayList = this.mListeners;
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
            int size2 = arrayList2.size();
            for (int i2 = 0; i2 < size2; i2++) {
                ((IMuAHx_6) arrayList2.get(i2)).KQgRr5e_0(this);
            }
        }
        this.mPaused = true;
    }

    public void playTransition(ViewGroup viewGroup) {
        Mqv2r_3 mqv2r_3;
        this.mStartValuesList = new ArrayList<>();
        this.mEndValuesList = new ArrayList<>();
        matchStartAndEnd(this.mStartValues, this.mEndValues);
        X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> runningAnimators = getRunningAnimators();
        int size = runningAnimators.size();
        XuYK_42 m351KQgRr5e_0 = JXypC6_34.m351KQgRr5e_0((View) viewGroup);
        for (int i = size - 1; i >= 0; i--) {
            Animator KQgRr5e_02 = runningAnimators.KQgRr5e_0(i);
            if (KQgRr5e_02 != null && (mqv2r_3 = runningAnimators.get(KQgRr5e_02)) != null && mqv2r_3.f2598KQgRr5e_0 != null && m351KQgRr5e_0.equals(mqv2r_3.f2597KQgRr5e_0)) {
                H5YG8fq_22 h5YG8fq_22 = mqv2r_3.KQgRr5e_0;
                View view = mqv2r_3.f2598KQgRr5e_0;
                H5YG8fq_22 transitionValues = getTransitionValues(view, true);
                H5YG8fq_22 matchedTransitionValues = getMatchedTransitionValues(view, true);
                if (!(transitionValues == null && matchedTransitionValues == null) && mqv2r_3.f2599KQgRr5e_0.isTransitionRequired(h5YG8fq_22, matchedTransitionValues)) {
                    if (!KQgRr5e_02.isRunning() && !KQgRr5e_02.isStarted()) {
                        runningAnimators.remove(KQgRr5e_02);
                    } else {
                        KQgRr5e_02.cancel();
                    }
                }
            }
        }
        createAnimators(viewGroup, this.mStartValues, this.mEndValues, this.mStartValuesList, this.mEndValuesList);
        runAnimators();
    }

    public Transition removeListener(IMuAHx_6 iMuAHx_6) {
        ArrayList<IMuAHx_6> arrayList = this.mListeners;
        if (arrayList == null) {
            return this;
        }
        arrayList.remove(iMuAHx_6);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
        return this;
    }

    public Transition removeTarget(View view) {
        this.mTargets.remove(view);
        return this;
    }

    public void resume(View view) {
        if (this.mPaused) {
            if (!this.mEnded) {
                X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> runningAnimators = getRunningAnimators();
                int size = runningAnimators.size();
                XuYK_42 m351KQgRr5e_0 = JXypC6_34.m351KQgRr5e_0(view);
                for (int i = size - 1; i >= 0; i--) {
                    Mqv2r_3 PGPF6hQ_22 = runningAnimators.PGPF6hQ_2(i);
                    if (PGPF6hQ_22.f2598KQgRr5e_0 != null && m351KQgRr5e_0.equals(PGPF6hQ_22.f2597KQgRr5e_0)) {
                        X6FRs_4.JZJr_16.KQgRr5e_0.QxJ9d_1(runningAnimators.KQgRr5e_0(i));
                    }
                }
                ArrayList<IMuAHx_6> arrayList = this.mListeners;
                if (arrayList != null && arrayList.size() > 0) {
                    ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
                    int size2 = arrayList2.size();
                    for (int i2 = 0; i2 < size2; i2++) {
                        ((IMuAHx_6) arrayList2.get(i2)).QxJ9d_1(this);
                    }
                }
            }
            this.mPaused = false;
        }
    }

    public void runAnimators() {
        start();
        X6FRs_4.Mqv2r_3.KQgRr5e_0<Animator, Mqv2r_3> runningAnimators = getRunningAnimators();
        Iterator<Animator> it = this.mAnimators.iterator();
        while (it.hasNext()) {
            Animator next = it.next();
            if (runningAnimators.containsKey(next)) {
                start();
                runAnimator(next, runningAnimators);
            }
        }
        this.mAnimators.clear();
        end();
    }

    public void setCanRemoveViews(boolean z) {
        this.mCanRemoveViews = z;
    }

    public Transition setDuration(long j) {
        this.mDuration = j;
        return this;
    }

    public void setEpicenterCallback(IFxWkV_5 iFxWkV_5) {
        this.mEpicenterCallback = iFxWkV_5;
    }

    public Transition setInterpolator(TimeInterpolator timeInterpolator) {
        this.mInterpolator = timeInterpolator;
        return this;
    }

    public void setMatchOrder(int... iArr) {
        if (iArr != null && iArr.length != 0) {
            for (int i = 0; i < iArr.length; i++) {
                if (isValidMatch(iArr[i])) {
                    if (alreadyContains(iArr, i)) {
                        throw new IllegalArgumentException("matches contains a duplicate value");
                    }
                } else {
                    throw new IllegalArgumentException("matches contains invalid value");
                }
            }
            this.mMatchOrder = (int[]) iArr.clone();
            return;
        }
        this.mMatchOrder = DEFAULT_MATCH_ORDER;
    }

    public void setPathMotion(PathMotion pathMotion) {
        if (pathMotion == null) {
            this.mPathMotion = STRAIGHT_PATH_MOTION;
        } else {
            this.mPathMotion = pathMotion;
        }
    }

    public void setPropagation(ZzDuCHW_20 zzDuCHW_20) {
        this.mPropagation = zzDuCHW_20;
    }

    public Transition setSceneRoot(ViewGroup viewGroup) {
        this.mSceneRoot = viewGroup;
        return this;
    }

    public Transition setStartDelay(long j) {
        this.mStartDelay = j;
        return this;
    }

    public void start() {
        if (this.mNumInstances == 0) {
            ArrayList<IMuAHx_6> arrayList = this.mListeners;
            if (arrayList != null && arrayList.size() > 0) {
                ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
                int size = arrayList2.size();
                for (int i = 0; i < size; i++) {
                    ((IMuAHx_6) arrayList2.get(i)).PGPF6hQ_2(this);
                }
            }
            this.mEnded = false;
        }
        this.mNumInstances++;
    }

    public String toString() {
        return toString(BuildConfig.FLAVOR);
    }

    public Transition addTarget(int i) {
        if (i != 0) {
            this.mTargetIds.add(Integer.valueOf(i));
        }
        return this;
    }

    /* renamed from: clone */
    public Transition m988clone() {
        try {
            Transition transition = (Transition) super.clone();
            transition.mAnimators = new ArrayList<>();
            transition.mStartValues = new SI64pbG_23();
            transition.mEndValues = new SI64pbG_23();
            transition.mStartValuesList = null;
            transition.mEndValuesList = null;
            return transition;
        } catch (CloneNotSupportedException unused) {
            return null;
        }
    }

    public Transition excludeChildren(int i, boolean z) {
        this.mTargetIdChildExcludes = excludeId(this.mTargetIdChildExcludes, i, z);
        return this;
    }

    public Transition excludeTarget(int i, boolean z) {
        this.mTargetIdExcludes = excludeId(this.mTargetIdExcludes, i, z);
        return this;
    }

    public Transition removeTarget(int i) {
        if (i != 0) {
            this.mTargetIds.remove(Integer.valueOf(i));
        }
        return this;
    }

    public String toString(String str) {
        String str2 = str + getClass().getSimpleName() + "@" + Integer.toHexString(hashCode()) + ": ";
        if (this.mDuration != -1) {
            str2 = str2 + "dur(" + this.mDuration + ") ";
        }
        if (this.mStartDelay != -1) {
            str2 = str2 + "dly(" + this.mStartDelay + ") ";
        }
        if (this.mInterpolator != null) {
            str2 = str2 + "interp(" + this.mInterpolator + ") ";
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            String str3 = str2 + "tgts(";
            if (this.mTargetIds.size() > 0) {
                for (int i = 0; i < this.mTargetIds.size(); i++) {
                    if (i > 0) {
                        str3 = str3 + ", ";
                    }
                    str3 = str3 + this.mTargetIds.get(i);
                }
            }
            if (this.mTargets.size() > 0) {
                for (int i2 = 0; i2 < this.mTargets.size(); i2++) {
                    if (i2 > 0) {
                        str3 = str3 + ", ";
                    }
                    str3 = str3 + this.mTargets.get(i2);
                }
            }
            return str3 + ")";
        }
        return str2;
    }

    public Transition addTarget(String str) {
        if (this.mTargetNames == null) {
            this.mTargetNames = new ArrayList<>();
        }
        this.mTargetNames.add(str);
        return this;
    }

    public Transition excludeChildren(Class cls, boolean z) {
        this.mTargetTypeChildExcludes = excludeType(this.mTargetTypeChildExcludes, cls, z);
        return this;
    }

    public Transition excludeTarget(String str, boolean z) {
        this.mTargetNameExcludes = excludeObject(this.mTargetNameExcludes, str, z);
        return this;
    }

    public Transition removeTarget(String str) {
        ArrayList<String> arrayList = this.mTargetNames;
        if (arrayList != null) {
            arrayList.remove(str);
        }
        return this;
    }

    public Transition excludeTarget(Class cls, boolean z) {
        this.mTargetTypeExcludes = excludeType(this.mTargetTypeExcludes, cls, z);
        return this;
    }

    public Transition removeTarget(Class cls) {
        ArrayList<Class> arrayList = this.mTargetTypes;
        if (arrayList != null) {
            arrayList.remove(cls);
        }
        return this;
    }

    public Transition addTarget(Class cls) {
        if (this.mTargetTypes == null) {
            this.mTargetTypes = new ArrayList<>();
        }
        this.mTargetTypes.add(cls);
        return this;
    }

    public Transition(Context context, AttributeSet attributeSet) {
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, NQvZgp_17.KQgRr5e_0);
        XmlResourceParser xmlResourceParser = (XmlResourceParser) attributeSet;
        long QxJ9d_12 = X6FRs_4.IMuAHx_6.X6FRs_4.PGPF6hQ_2.IMuAHx_6.QxJ9d_1(obtainStyledAttributes, xmlResourceParser, "duration", 1, -1);
        if (QxJ9d_12 >= 0) {
            setDuration(QxJ9d_12);
        }
        long QxJ9d_13 = X6FRs_4.IMuAHx_6.X6FRs_4.PGPF6hQ_2.IMuAHx_6.QxJ9d_1(obtainStyledAttributes, xmlResourceParser, "startDelay", 2, -1);
        if (QxJ9d_13 > 0) {
            setStartDelay(QxJ9d_13);
        }
        int PGPF6hQ_22 = X6FRs_4.IMuAHx_6.X6FRs_4.PGPF6hQ_2.IMuAHx_6.PGPF6hQ_2(obtainStyledAttributes, xmlResourceParser, "interpolator", 0, 0);
        if (PGPF6hQ_22 > 0) {
            setInterpolator(AnimationUtils.loadInterpolator(context, PGPF6hQ_22));
        }
        String m334KQgRr5e_0 = X6FRs_4.IMuAHx_6.X6FRs_4.PGPF6hQ_2.IMuAHx_6.m334KQgRr5e_0(obtainStyledAttributes, (XmlPullParser) xmlResourceParser, "matchOrder", 3);
        if (m334KQgRr5e_0 != null) {
            setMatchOrder(parseMatchOrder(m334KQgRr5e_0));
        }
        obtainStyledAttributes.recycle();
    }
}
