package androidx.transition;

import X6FRs_4.IMuAHx_6.IFxWkV_5.QxJ9d_1;
import X6FRs_4.IMuAHx_6.X6FRs_4.PGPF6hQ_2.IMuAHx_6;
import X6FRs_4.JZJr_16.NQvZgp_17;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.util.AttributeSet;
import org.xmlpull.v1.XmlPullParser;
/* loaded from: classes.dex */
public class PatternPathMotion extends PathMotion {

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Path f2594KQgRr5e_0 = new Path();
    public final Matrix KQgRr5e_0 = new Matrix();

    public PatternPathMotion() {
        this.f2594KQgRr5e_0.lineTo(1.0f, 0.0f);
    }

    public void KQgRr5e_0(Path path) {
        PathMeasure pathMeasure = new PathMeasure(path, false);
        float[] fArr = new float[2];
        pathMeasure.getPosTan(pathMeasure.getLength(), fArr, null);
        float f = fArr[0];
        float f2 = fArr[1];
        pathMeasure.getPosTan(0.0f, fArr, null);
        float f3 = fArr[0];
        float f4 = fArr[1];
        if (f3 == f && f4 == f2) {
            throw new IllegalArgumentException("pattern must not end at the starting point");
        }
        this.KQgRr5e_0.setTranslate(-f3, -f4);
        float f5 = f - f3;
        float f6 = f2 - f4;
        float KQgRr5e_0 = 1.0f / KQgRr5e_0(f5, f6);
        this.KQgRr5e_0.postScale(KQgRr5e_0, KQgRr5e_0);
        this.KQgRr5e_0.postRotate((float) Math.toDegrees(-Math.atan2(f6, f5)));
        path.transform(this.KQgRr5e_0, this.f2594KQgRr5e_0);
    }

    public PatternPathMotion(Context context, AttributeSet attributeSet) {
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, NQvZgp_17.f3135Xgtqvk_8);
        try {
            String m334KQgRr5e_0 = IMuAHx_6.m334KQgRr5e_0(obtainStyledAttributes, (XmlPullParser) attributeSet, "patternPathData", 0);
            if (m334KQgRr5e_0 != null) {
                KQgRr5e_0(QxJ9d_1.KQgRr5e_0(m334KQgRr5e_0));
                return;
            }
            throw new RuntimeException("pathData must be supplied for patternPathMotion");
        } finally {
            obtainStyledAttributes.recycle();
        }
    }

    @Override // androidx.transition.PathMotion
    public Path KQgRr5e_0(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        float KQgRr5e_0 = KQgRr5e_0(f5, f6);
        double atan2 = Math.atan2(f6, f5);
        this.KQgRr5e_0.setScale(KQgRr5e_0, KQgRr5e_0);
        this.KQgRr5e_0.postRotate((float) Math.toDegrees(atan2));
        this.KQgRr5e_0.postTranslate(f, f2);
        Path path = new Path();
        this.f2594KQgRr5e_0.transform(this.KQgRr5e_0, path);
        return path;
    }

    public static float KQgRr5e_0(float f, float f2) {
        return (float) Math.sqrt((f * f) + (f2 * f2));
    }
}
