package androidx.transition;

import X6FRs_4.JZJr_16.H5YG8fq_22;
import X6FRs_4.JZJr_16.RfjZ_21;
import X6FRs_4.JZJr_16.Xgtqvk_8;
import X6FRs_4.JZJr_16.XnFJ5_9;
import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.util.Map;
/* loaded from: classes.dex */
public class ChangeImageTransform extends Transition {

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public static final String[] f2580KQgRr5e_0 = {"android:changeImageTransform:matrix", "android:changeImageTransform:bounds"};
    public static final TypeEvaluator<Matrix> KQgRr5e_0 = new KQgRr5e_0();

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public static final Property<ImageView, Matrix> f2579KQgRr5e_0 = new QxJ9d_1(Matrix.class, "animatedTransform");

    /* loaded from: classes.dex */
    public static class KQgRr5e_0 implements TypeEvaluator<Matrix> {
        @Override // android.animation.TypeEvaluator
        /* renamed from: KQgRr5e_0 */
        public Matrix evaluate(float f, Matrix matrix, Matrix matrix2) {
            return null;
        }
    }

    /* loaded from: classes.dex */
    public static /* synthetic */ class PGPF6hQ_2 {
        public static final /* synthetic */ int[] KQgRr5e_0;

        static {
            int[] iArr = new int[ImageView.ScaleType.values().length];
            KQgRr5e_0 = iArr;
            try {
                iArr[ImageView.ScaleType.FIT_XY.ordinal()] = 1;
            } catch (NoSuchFieldError unused) {
            }
            try {
                KQgRr5e_0[ImageView.ScaleType.CENTER_CROP.ordinal()] = 2;
            } catch (NoSuchFieldError unused2) {
            }
        }
    }

    /* loaded from: classes.dex */
    public static class QxJ9d_1 extends Property<ImageView, Matrix> {
        public QxJ9d_1(Class cls, String str) {
            super(cls, str);
        }

        @Override // android.util.Property
        /* renamed from: KQgRr5e_0 */
        public Matrix get(ImageView imageView) {
            return null;
        }

        @Override // android.util.Property
        /* renamed from: KQgRr5e_0 */
        public void set(ImageView imageView, Matrix matrix) {
            Xgtqvk_8.KQgRr5e_0(imageView, matrix);
        }
    }

    public ChangeImageTransform() {
    }

    public static Matrix PGPF6hQ_2(ImageView imageView) {
        Drawable drawable = imageView.getDrawable();
        Matrix matrix = new Matrix();
        matrix.postScale(imageView.getWidth() / drawable.getIntrinsicWidth(), imageView.getHeight() / drawable.getIntrinsicHeight());
        return matrix;
    }

    public static Matrix QxJ9d_1(ImageView imageView) {
        int i = PGPF6hQ_2.KQgRr5e_0[imageView.getScaleType().ordinal()];
        if (i != 1) {
            if (i != 2) {
                return new Matrix(imageView.getImageMatrix());
            }
            return KQgRr5e_0(imageView);
        }
        return PGPF6hQ_2(imageView);
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public final ObjectAnimator m986KQgRr5e_0(ImageView imageView) {
        return ObjectAnimator.ofObject(imageView, (Property<ImageView, V>) f2579KQgRr5e_0, (TypeEvaluator) KQgRr5e_0, (Object[]) new Matrix[]{null, null});
    }

    @Override // androidx.transition.Transition
    public void captureEndValues(H5YG8fq_22 h5YG8fq_22) {
        captureValues(h5YG8fq_22);
    }

    @Override // androidx.transition.Transition
    public void captureStartValues(H5YG8fq_22 h5YG8fq_22) {
        captureValues(h5YG8fq_22);
    }

    public final void captureValues(H5YG8fq_22 h5YG8fq_22) {
        View view = h5YG8fq_22.KQgRr5e_0;
        if ((view instanceof ImageView) && view.getVisibility() == 0) {
            ImageView imageView = (ImageView) view;
            if (imageView.getDrawable() == null) {
                return;
            }
            Map<String, Object> map = h5YG8fq_22.f566KQgRr5e_0;
            map.put("android:changeImageTransform:bounds", new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            map.put("android:changeImageTransform:matrix", QxJ9d_1(imageView));
        }
    }

    @Override // androidx.transition.Transition
    public Animator createAnimator(ViewGroup viewGroup, H5YG8fq_22 h5YG8fq_22, H5YG8fq_22 h5YG8fq_222) {
        ObjectAnimator m986KQgRr5e_0;
        if (h5YG8fq_22 != null && h5YG8fq_222 != null) {
            Rect rect = (Rect) h5YG8fq_22.f566KQgRr5e_0.get("android:changeImageTransform:bounds");
            Rect rect2 = (Rect) h5YG8fq_222.f566KQgRr5e_0.get("android:changeImageTransform:bounds");
            if (rect != null && rect2 != null) {
                Matrix matrix = (Matrix) h5YG8fq_22.f566KQgRr5e_0.get("android:changeImageTransform:matrix");
                Matrix matrix2 = (Matrix) h5YG8fq_222.f566KQgRr5e_0.get("android:changeImageTransform:matrix");
                boolean z = (matrix == null && matrix2 == null) || (matrix != null && matrix.equals(matrix2));
                if (rect.equals(rect2) && z) {
                    return null;
                }
                ImageView imageView = (ImageView) h5YG8fq_222.KQgRr5e_0;
                Drawable drawable = imageView.getDrawable();
                int intrinsicWidth = drawable.getIntrinsicWidth();
                int intrinsicHeight = drawable.getIntrinsicHeight();
                Xgtqvk_8.KQgRr5e_0(imageView);
                if (intrinsicWidth != 0 && intrinsicHeight != 0) {
                    if (matrix == null) {
                        matrix = XnFJ5_9.KQgRr5e_0;
                    }
                    if (matrix2 == null) {
                        matrix2 = XnFJ5_9.KQgRr5e_0;
                    }
                    f2579KQgRr5e_0.set(imageView, matrix);
                    m986KQgRr5e_0 = KQgRr5e_0(imageView, matrix, matrix2);
                } else {
                    m986KQgRr5e_0 = m986KQgRr5e_0(imageView);
                }
                Xgtqvk_8.KQgRr5e_0(imageView, m986KQgRr5e_0);
                return m986KQgRr5e_0;
            }
        }
        return null;
    }

    @Override // androidx.transition.Transition
    public String[] getTransitionProperties() {
        return f2580KQgRr5e_0;
    }

    public ChangeImageTransform(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public final ObjectAnimator KQgRr5e_0(ImageView imageView, Matrix matrix, Matrix matrix2) {
        return ObjectAnimator.ofObject(imageView, (Property<ImageView, V>) f2579KQgRr5e_0, (TypeEvaluator) new RfjZ_21.KQgRr5e_0(), (Object[]) new Matrix[]{matrix, matrix2});
    }

    public static Matrix KQgRr5e_0(ImageView imageView) {
        Drawable drawable = imageView.getDrawable();
        int intrinsicWidth = drawable.getIntrinsicWidth();
        float width = imageView.getWidth();
        float f = intrinsicWidth;
        int intrinsicHeight = drawable.getIntrinsicHeight();
        float height = imageView.getHeight();
        float f2 = intrinsicHeight;
        float max = Math.max(width / f, height / f2);
        int round = Math.round((width - (f * max)) / 2.0f);
        int round2 = Math.round((height - (f2 * max)) / 2.0f);
        Matrix matrix = new Matrix();
        matrix.postScale(max, max);
        matrix.postTranslate(round, round2);
        return matrix;
    }
}
