package androidx.media.session;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.RemoteException;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.util.Log;
import android.view.KeyEvent;
import java.util.List;
/* loaded from: classes.dex */
public class MediaButtonReceiver extends BroadcastReceiver {

    /* loaded from: classes.dex */
    public static class KQgRr5e_0 extends MediaBrowserCompat.QxJ9d_1 {
        public final BroadcastReceiver.PendingResult KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Context f2412KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Intent f2413KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public MediaBrowserCompat f2414KQgRr5e_0;

        public KQgRr5e_0(Context context, Intent intent, BroadcastReceiver.PendingResult pendingResult) {
            this.f2412KQgRr5e_0 = context;
            this.f2413KQgRr5e_0 = intent;
            this.KQgRr5e_0 = pendingResult;
        }

        public void KQgRr5e_0(MediaBrowserCompat mediaBrowserCompat) {
            this.f2414KQgRr5e_0 = mediaBrowserCompat;
        }

        public final void Mqv2r_3() {
            this.f2414KQgRr5e_0.QxJ9d_1();
            this.KQgRr5e_0.finish();
        }

        @Override // android.support.v4.media.MediaBrowserCompat.QxJ9d_1
        public void PGPF6hQ_2() {
            Mqv2r_3();
        }

        @Override // android.support.v4.media.MediaBrowserCompat.QxJ9d_1
        public void QxJ9d_1() {
            Mqv2r_3();
        }

        @Override // android.support.v4.media.MediaBrowserCompat.QxJ9d_1
        public void KQgRr5e_0() {
            try {
                new MediaControllerCompat(this.f2412KQgRr5e_0, this.f2414KQgRr5e_0.KQgRr5e_0()).KQgRr5e_0((KeyEvent) this.f2413KQgRr5e_0.getParcelableExtra("android.intent.extra.KEY_EVENT"));
            } catch (RemoteException e) {
                Log.e("MediaButtonReceiver", "Failed to create a media controller", e);
            }
            Mqv2r_3();
        }
    }

    public static void KQgRr5e_0(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT >= 26) {
            context.startForegroundService(intent);
        } else {
            context.startService(intent);
        }
    }

    @Override // android.content.BroadcastReceiver
    public void onReceive(Context context, Intent intent) {
        if (intent != null && "android.intent.action.MEDIA_BUTTON".equals(intent.getAction()) && intent.hasExtra("android.intent.extra.KEY_EVENT")) {
            ComponentName KQgRr5e_02 = KQgRr5e_0(context, "android.intent.action.MEDIA_BUTTON");
            if (KQgRr5e_02 != null) {
                intent.setComponent(KQgRr5e_02);
                KQgRr5e_0(context, intent);
                return;
            }
            ComponentName KQgRr5e_03 = KQgRr5e_0(context, "android.media.browse.MediaBrowserService");
            if (KQgRr5e_03 != null) {
                BroadcastReceiver.PendingResult goAsync = goAsync();
                Context applicationContext = context.getApplicationContext();
                KQgRr5e_0 kQgRr5e_0 = new KQgRr5e_0(applicationContext, intent, goAsync);
                MediaBrowserCompat mediaBrowserCompat = new MediaBrowserCompat(applicationContext, KQgRr5e_03, kQgRr5e_0, null);
                kQgRr5e_0.KQgRr5e_0(mediaBrowserCompat);
                mediaBrowserCompat.m817KQgRr5e_0();
                return;
            }
            throw new IllegalStateException("Could not find any Service that handles android.intent.action.MEDIA_BUTTON or implements a media browser service.");
        }
        Log.d("MediaButtonReceiver", "Ignore unsupported intent: " + intent);
    }

    public static ComponentName KQgRr5e_0(Context context, String str) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent(str);
        intent.setPackage(context.getPackageName());
        List<ResolveInfo> queryIntentServices = packageManager.queryIntentServices(intent, 0);
        if (queryIntentServices.size() == 1) {
            ServiceInfo serviceInfo = queryIntentServices.get(0).serviceInfo;
            return new ComponentName(serviceInfo.packageName, serviceInfo.name);
        } else if (queryIntentServices.isEmpty()) {
            return null;
        } else {
            throw new IllegalStateException("Expected 1 service that handles " + str + ", found " + queryIntentServices.size());
        }
    }
}
