package androidx.core.widget;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.Eps4cJe_18;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.KNBe_11;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.LGe8pk_15;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.NzhupJ_29.IFxWkV_5;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.NzhupJ_29.Mqv2r_3;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.WwEq_13;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.XnFJ5_9;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import android.widget.ScrollView;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
/* loaded from: classes.dex */
public class NestedScrollView extends FrameLayout implements WwEq_13, XnFJ5_9, Eps4cJe_18 {
    public static final KQgRr5e_0 KQgRr5e_0 = new KQgRr5e_0();
    public static final int[] PGPF6hQ_2 = {16843130};

    /* renamed from: IFxWkV_5  reason: collision with root package name */
    public int f3510IFxWkV_5;

    /* renamed from: IFxWkV_5  reason: collision with other field name */
    public boolean f2252IFxWkV_5;

    /* renamed from: IMuAHx_6  reason: collision with root package name */
    public int f3511IMuAHx_6;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public float f2253KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public int f2254KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public long f2255KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final KNBe_11 f2256KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final LGe8pk_15 f2257KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Rect f2258KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public VelocityTracker f2259KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public View f2260KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public EdgeEffect f2261KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public OverScroller f2262KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public QxJ9d_1 f2263KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public SavedState f2264KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final int[] f2265KQgRr5e_0;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public int f3512Mqv2r_3;

    /* renamed from: Mqv2r_3  reason: collision with other field name */
    public boolean f2266Mqv2r_3;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public int f2267PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public boolean f2268PGPF6hQ_2;
    public int QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public EdgeEffect f2269QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f2270QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public final int[] f2271QxJ9d_1;

    /* renamed from: X6FRs_4  reason: collision with root package name */
    public int f3513X6FRs_4;

    /* renamed from: X6FRs_4  reason: collision with other field name */
    public boolean f2272X6FRs_4;

    /* loaded from: classes.dex */
    public static class KQgRr5e_0 extends X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0 {
        @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            accessibilityEvent.setClassName(ScrollView.class.getName());
            accessibilityEvent.setScrollable(nestedScrollView.getScrollRange() > 0);
            accessibilityEvent.setScrollX(nestedScrollView.getScrollX());
            accessibilityEvent.setScrollY(nestedScrollView.getScrollY());
            IFxWkV_5.KQgRr5e_0(accessibilityEvent, nestedScrollView.getScrollX());
            IFxWkV_5.QxJ9d_1(accessibilityEvent, nestedScrollView.getScrollRange());
        }

        @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0
        public void onInitializeAccessibilityNodeInfo(View view, Mqv2r_3 mqv2r_3) {
            int scrollRange;
            super.onInitializeAccessibilityNodeInfo(view, mqv2r_3);
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            mqv2r_3.m231KQgRr5e_0((CharSequence) ScrollView.class.getName());
            if (!nestedScrollView.isEnabled() || (scrollRange = nestedScrollView.getScrollRange()) <= 0) {
                return;
            }
            mqv2r_3.WwEq_13(true);
            if (nestedScrollView.getScrollY() > 0) {
                mqv2r_3.m229KQgRr5e_0(RecyclerView.WGk6X_27.FLAG_BOUNCED_FROM_HIDDEN_LIST);
            }
            if (nestedScrollView.getScrollY() < scrollRange) {
                mqv2r_3.m229KQgRr5e_0(RecyclerView.WGk6X_27.FLAG_APPEARED_IN_PRE_LAYOUT);
            }
        }

        @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.KQgRr5e_0
        public boolean performAccessibilityAction(View view, int i, Bundle bundle) {
            if (super.performAccessibilityAction(view, i, bundle)) {
                return true;
            }
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            if (nestedScrollView.isEnabled()) {
                if (i == 4096) {
                    int min = Math.min(nestedScrollView.getScrollY() + ((nestedScrollView.getHeight() - nestedScrollView.getPaddingBottom()) - nestedScrollView.getPaddingTop()), nestedScrollView.getScrollRange());
                    if (min != nestedScrollView.getScrollY()) {
                        nestedScrollView.QxJ9d_1(0, min);
                        return true;
                    }
                    return false;
                } else if (i != 8192) {
                    return false;
                } else {
                    int max = Math.max(nestedScrollView.getScrollY() - ((nestedScrollView.getHeight() - nestedScrollView.getPaddingBottom()) - nestedScrollView.getPaddingTop()), 0);
                    if (max != nestedScrollView.getScrollY()) {
                        nestedScrollView.QxJ9d_1(0, max);
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }

    /* loaded from: classes.dex */
    public interface QxJ9d_1 {
        void KQgRr5e_0(NestedScrollView nestedScrollView, int i, int i2, int i3, int i4);
    }

    /* loaded from: classes.dex */
    public static class SavedState extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new KQgRr5e_0();
        public int KQgRr5e_0;

        /* loaded from: classes.dex */
        public static class KQgRr5e_0 implements Parcelable.Creator<SavedState> {
            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "HorizontalScrollView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " scrollPosition=" + this.KQgRr5e_0 + "}";
        }

        @Override // android.view.View.BaseSavedState, android.view.AbsSavedState, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeInt(this.KQgRr5e_0);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.KQgRr5e_0 = parcel.readInt();
        }
    }

    public NestedScrollView(Context context) {
        this(context, null);
    }

    public static int KQgRr5e_0(int i, int i2, int i3) {
        if (i2 >= i3 || i < 0) {
            return 0;
        }
        return i2 + i > i3 ? i3 - i2 : i;
    }

    private float getVerticalScrollFactorCompat() {
        if (this.f2253KQgRr5e_0 == 0.0f) {
            TypedValue typedValue = new TypedValue();
            Context context = getContext();
            if (context.getTheme().resolveAttribute(16842829, typedValue, true)) {
                this.f2253KQgRr5e_0 = typedValue.getDimension(context.getResources().getDisplayMetrics());
            } else {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
        }
        return this.f2253KQgRr5e_0;
    }

    public final void IFxWkV_5() {
        if (this.f2259KQgRr5e_0 == null) {
            this.f2259KQgRr5e_0 = VelocityTracker.obtain();
        }
    }

    public final void IMuAHx_6() {
        VelocityTracker velocityTracker = this.f2259KQgRr5e_0;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.f2259KQgRr5e_0 = null;
        }
    }

    public void KQgRr5e_0(int i, int i2, int i3, int i4, int[] iArr, int i5, int[] iArr2) {
        this.f2256KQgRr5e_0.KQgRr5e_0(i, i2, i3, i4, iArr, i5, iArr2);
    }

    public final void Mqv2r_3() {
        VelocityTracker velocityTracker = this.f2259KQgRr5e_0;
        if (velocityTracker == null) {
            this.f2259KQgRr5e_0 = VelocityTracker.obtain();
        } else {
            velocityTracker.clear();
        }
    }

    public boolean PGPF6hQ_2(int i) {
        return this.f2256KQgRr5e_0.m219KQgRr5e_0(i);
    }

    /* renamed from: QxJ9d_1  reason: collision with other method in class */
    public boolean m878QxJ9d_1(int i, int i2) {
        return this.f2256KQgRr5e_0.KQgRr5e_0(i, i2);
    }

    public final void X6FRs_4() {
        this.f2262KQgRr5e_0 = new OverScroller(getContext());
        setFocusable(true);
        setDescendantFocusability(262144);
        setWillNotDraw(false);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(getContext());
        this.QxJ9d_1 = viewConfiguration.getScaledTouchSlop();
        this.f2267PGPF6hQ_2 = viewConfiguration.getScaledMinimumFlingVelocity();
        this.f3512Mqv2r_3 = viewConfiguration.getScaledMaximumFlingVelocity();
    }

    @Override // android.view.ViewGroup
    public void addView(View view) {
        if (getChildCount() <= 0) {
            super.addView(view);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    @Override // android.view.View
    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    @Override // android.view.View
    public int computeHorizontalScrollOffset() {
        return super.computeHorizontalScrollOffset();
    }

    @Override // android.view.View
    public int computeHorizontalScrollRange() {
        return super.computeHorizontalScrollRange();
    }

    @Override // android.view.View
    public void computeScroll() {
        if (this.f2262KQgRr5e_0.isFinished()) {
            return;
        }
        this.f2262KQgRr5e_0.computeScrollOffset();
        int currY = this.f2262KQgRr5e_0.getCurrY();
        int i = currY - this.f3511IMuAHx_6;
        this.f3511IMuAHx_6 = currY;
        int[] iArr = this.f2271QxJ9d_1;
        boolean z = false;
        iArr[1] = 0;
        KQgRr5e_0(0, i, iArr, null, 1);
        int i2 = i - this.f2271QxJ9d_1[1];
        int scrollRange = getScrollRange();
        if (i2 != 0) {
            int scrollY = getScrollY();
            KQgRr5e_0(0, i2, getScrollX(), scrollY, 0, scrollRange, 0, 0, false);
            int scrollY2 = getScrollY() - scrollY;
            int i3 = i2 - scrollY2;
            int[] iArr2 = this.f2271QxJ9d_1;
            iArr2[1] = 0;
            KQgRr5e_0(0, scrollY2, 0, i3, this.f2265KQgRr5e_0, 1, iArr2);
            i2 = i3 - this.f2271QxJ9d_1[1];
        }
        if (i2 != 0) {
            int overScrollMode = getOverScrollMode();
            if (overScrollMode == 0 || (overScrollMode == 1 && scrollRange > 0)) {
                z = true;
            }
            if (z) {
                PGPF6hQ_2();
                if (i2 < 0) {
                    if (this.f2261KQgRr5e_0.isFinished()) {
                        this.f2261KQgRr5e_0.onAbsorb((int) this.f2262KQgRr5e_0.getCurrVelocity());
                    }
                } else if (this.f2269QxJ9d_1.isFinished()) {
                    this.f2269QxJ9d_1.onAbsorb((int) this.f2262KQgRr5e_0.getCurrVelocity());
                }
            }
            KQgRr5e_0();
        }
        if (this.f2262KQgRr5e_0.isFinished()) {
            return;
        }
        ZzDuCHW_20.m262KQgRr5e_0((View) this);
    }

    @Override // android.view.View
    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    @Override // android.view.View
    public int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    @Override // android.view.View
    public int computeVerticalScrollRange() {
        int childCount = getChildCount();
        int height = (getHeight() - getPaddingBottom()) - getPaddingTop();
        if (childCount == 0) {
            return height;
        }
        View childAt = getChildAt(0);
        int bottom = childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin;
        int scrollY = getScrollY();
        int max = Math.max(0, bottom - height);
        return scrollY < 0 ? bottom - scrollY : scrollY > max ? bottom + (scrollY - max) : bottom;
    }

    @Override // android.view.ViewGroup, android.view.View
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || KQgRr5e_0(keyEvent);
    }

    @Override // android.view.View
    public boolean dispatchNestedFling(float f, float f2, boolean z) {
        return this.f2256KQgRr5e_0.KQgRr5e_0(f, f2, z);
    }

    @Override // android.view.View
    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.f2256KQgRr5e_0.KQgRr5e_0(f, f2);
    }

    @Override // android.view.View
    public boolean dispatchNestedPreScroll(int i, int i2, int[] iArr, int[] iArr2) {
        return KQgRr5e_0(i, i2, iArr, iArr2, 0);
    }

    @Override // android.view.View
    public boolean dispatchNestedScroll(int i, int i2, int i3, int i4, int[] iArr) {
        return this.f2256KQgRr5e_0.KQgRr5e_0(i, i2, i3, i4, iArr);
    }

    @Override // android.view.View
    public void draw(Canvas canvas) {
        int paddingLeft;
        super.draw(canvas);
        if (this.f2261KQgRr5e_0 != null) {
            int scrollY = getScrollY();
            int i = 0;
            if (!this.f2261KQgRr5e_0.isFinished()) {
                int save = canvas.save();
                int width = getWidth();
                int height = getHeight();
                int min = Math.min(0, scrollY);
                if (Build.VERSION.SDK_INT < 21 || getClipToPadding()) {
                    width -= getPaddingLeft() + getPaddingRight();
                    paddingLeft = getPaddingLeft() + 0;
                } else {
                    paddingLeft = 0;
                }
                if (Build.VERSION.SDK_INT >= 21 && getClipToPadding()) {
                    height -= getPaddingTop() + getPaddingBottom();
                    min += getPaddingTop();
                }
                canvas.translate(paddingLeft, min);
                this.f2261KQgRr5e_0.setSize(width, height);
                if (this.f2261KQgRr5e_0.draw(canvas)) {
                    ZzDuCHW_20.m262KQgRr5e_0((View) this);
                }
                canvas.restoreToCount(save);
            }
            if (this.f2269QxJ9d_1.isFinished()) {
                return;
            }
            int save2 = canvas.save();
            int width2 = getWidth();
            int height2 = getHeight();
            int max = Math.max(getScrollRange(), scrollY) + height2;
            if (Build.VERSION.SDK_INT < 21 || getClipToPadding()) {
                width2 -= getPaddingLeft() + getPaddingRight();
                i = 0 + getPaddingLeft();
            }
            if (Build.VERSION.SDK_INT >= 21 && getClipToPadding()) {
                height2 -= getPaddingTop() + getPaddingBottom();
                max -= getPaddingBottom();
            }
            canvas.translate(i - width2, max);
            canvas.rotate(180.0f, width2, 0.0f);
            this.f2269QxJ9d_1.setSize(width2, height2);
            if (this.f2269QxJ9d_1.draw(canvas)) {
                ZzDuCHW_20.m262KQgRr5e_0((View) this);
            }
            canvas.restoreToCount(save2);
        }
    }

    @Override // android.view.View
    public float getBottomFadingEdgeStrength() {
        if (getChildCount() == 0) {
            return 0.0f;
        }
        View childAt = getChildAt(0);
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        int bottom = ((childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin) - getScrollY()) - (getHeight() - getPaddingBottom());
        if (bottom < verticalFadingEdgeLength) {
            return bottom / verticalFadingEdgeLength;
        }
        return 1.0f;
    }

    public int getMaxScrollAmount() {
        return (int) (getHeight() * 0.5f);
    }

    @Override // android.view.ViewGroup
    public int getNestedScrollAxes() {
        return this.f2257KQgRr5e_0.KQgRr5e_0();
    }

    public int getScrollRange() {
        if (getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            return Math.max(0, ((childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin) - ((getHeight() - getPaddingTop()) - getPaddingBottom()));
        }
        return 0;
    }

    @Override // android.view.View
    public float getTopFadingEdgeStrength() {
        if (getChildCount() == 0) {
            return 0.0f;
        }
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        int scrollY = getScrollY();
        if (scrollY < verticalFadingEdgeLength) {
            return scrollY / verticalFadingEdgeLength;
        }
        return 1.0f;
    }

    @Override // android.view.View
    public boolean hasNestedScrollingParent() {
        return PGPF6hQ_2(0);
    }

    @Override // android.view.View, X6FRs_4.IMuAHx_6.EuDEkJe_12.Nm6q_10
    public boolean isNestedScrollingEnabled() {
        return this.f2256KQgRr5e_0.QxJ9d_1();
    }

    @Override // android.view.ViewGroup
    public void measureChild(View view, int i, int i2) {
        view.measure(FrameLayout.getChildMeasureSpec(i, getPaddingLeft() + getPaddingRight(), view.getLayoutParams().width), View.MeasureSpec.makeMeasureSpec(0, 0));
    }

    @Override // android.view.ViewGroup
    public void measureChildWithMargins(View view, int i, int i2, int i3, int i4) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        view.measure(FrameLayout.getChildMeasureSpec(i, getPaddingLeft() + getPaddingRight() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + i2, marginLayoutParams.width), View.MeasureSpec.makeMeasureSpec(marginLayoutParams.topMargin + marginLayoutParams.bottomMargin, 0));
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.f2268PGPF6hQ_2 = false;
    }

    @Override // android.view.View
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((motionEvent.getSource() & 2) != 0 && motionEvent.getAction() == 8 && !this.f2266Mqv2r_3) {
            float axisValue = motionEvent.getAxisValue(9);
            if (axisValue != 0.0f) {
                int scrollRange = getScrollRange();
                int scrollY = getScrollY();
                int verticalScrollFactorCompat = scrollY - ((int) (axisValue * getVerticalScrollFactorCompat()));
                if (verticalScrollFactorCompat < 0) {
                    scrollRange = 0;
                } else if (verticalScrollFactorCompat <= scrollRange) {
                    scrollRange = verticalScrollFactorCompat;
                }
                if (scrollRange != scrollY) {
                    super.scrollTo(getScrollX(), scrollRange);
                    return true;
                }
            }
        }
        return false;
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        if (action == 2 && this.f2266Mqv2r_3) {
            return true;
        }
        int i = action & 255;
        if (i != 0) {
            if (i != 1) {
                if (i == 2) {
                    int i2 = this.f3513X6FRs_4;
                    if (i2 != -1) {
                        int findPointerIndex = motionEvent.findPointerIndex(i2);
                        if (findPointerIndex == -1) {
                            Log.e("NestedScrollView", "Invalid pointerId=" + i2 + " in onInterceptTouchEvent");
                        } else {
                            int y = (int) motionEvent.getY(findPointerIndex);
                            if (Math.abs(y - this.f2254KQgRr5e_0) > this.QxJ9d_1 && (2 & getNestedScrollAxes()) == 0) {
                                this.f2266Mqv2r_3 = true;
                                this.f2254KQgRr5e_0 = y;
                                IFxWkV_5();
                                this.f2259KQgRr5e_0.addMovement(motionEvent);
                                this.f3510IFxWkV_5 = 0;
                                ViewParent parent = getParent();
                                if (parent != null) {
                                    parent.requestDisallowInterceptTouchEvent(true);
                                }
                            }
                        }
                    }
                } else if (i != 3) {
                    if (i == 6) {
                        KQgRr5e_0(motionEvent);
                    }
                }
            }
            this.f2266Mqv2r_3 = false;
            this.f3513X6FRs_4 = -1;
            IMuAHx_6();
            if (this.f2262KQgRr5e_0.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange())) {
                ZzDuCHW_20.m262KQgRr5e_0((View) this);
            }
            stopNestedScroll(0);
        } else {
            int y2 = (int) motionEvent.getY();
            if (!m874KQgRr5e_0((int) motionEvent.getX(), y2)) {
                this.f2266Mqv2r_3 = false;
                IMuAHx_6();
            } else {
                this.f2254KQgRr5e_0 = y2;
                this.f3513X6FRs_4 = motionEvent.getPointerId(0);
                Mqv2r_3();
                this.f2259KQgRr5e_0.addMovement(motionEvent);
                this.f2262KQgRr5e_0.computeScrollOffset();
                this.f2266Mqv2r_3 = !this.f2262KQgRr5e_0.isFinished();
                m878QxJ9d_1(2, 0);
            }
        }
        return this.f2266Mqv2r_3;
    }

    @Override // android.widget.FrameLayout, android.view.ViewGroup, android.view.View
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        int i5 = 0;
        this.f2270QxJ9d_1 = false;
        View view = this.f2260KQgRr5e_0;
        if (view != null && KQgRr5e_0(view, this)) {
            KQgRr5e_0(this.f2260KQgRr5e_0);
        }
        this.f2260KQgRr5e_0 = null;
        if (!this.f2268PGPF6hQ_2) {
            if (this.f2264KQgRr5e_0 != null) {
                scrollTo(getScrollX(), this.f2264KQgRr5e_0.KQgRr5e_0);
                this.f2264KQgRr5e_0 = null;
            }
            if (getChildCount() > 0) {
                View childAt = getChildAt(0);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
                i5 = childAt.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
            int paddingTop = ((i4 - i2) - getPaddingTop()) - getPaddingBottom();
            int scrollY = getScrollY();
            int KQgRr5e_02 = KQgRr5e_0(scrollY, paddingTop, i5);
            if (KQgRr5e_02 != scrollY) {
                scrollTo(getScrollX(), KQgRr5e_02);
            }
        }
        scrollTo(getScrollX(), getScrollY());
        this.f2268PGPF6hQ_2 = true;
    }

    @Override // android.widget.FrameLayout, android.view.View
    public void onMeasure(int i, int i2) {
        super.onMeasure(i, i2);
        if (this.f2272X6FRs_4 && View.MeasureSpec.getMode(i2) != 0 && getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            int measuredHeight = childAt.getMeasuredHeight();
            int measuredHeight2 = (((getMeasuredHeight() - getPaddingTop()) - getPaddingBottom()) - layoutParams.topMargin) - layoutParams.bottomMargin;
            if (measuredHeight < measuredHeight2) {
                childAt.measure(FrameLayout.getChildMeasureSpec(i, getPaddingLeft() + getPaddingRight() + layoutParams.leftMargin + layoutParams.rightMargin, layoutParams.width), View.MeasureSpec.makeMeasureSpec(measuredHeight2, 1073741824));
            }
        }
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public boolean onNestedFling(View view, float f, float f2, boolean z) {
        if (z) {
            return false;
        }
        dispatchNestedFling(0.0f, f2, true);
        QxJ9d_1((int) f2);
        return true;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public boolean onNestedPreFling(View view, float f, float f2) {
        return dispatchNestedPreFling(f, f2);
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public void onNestedPreScroll(View view, int i, int i2, int[] iArr, int i3) {
        KQgRr5e_0(i, i2, iArr, null, i3);
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public void onNestedScroll(View view, int i, int i2, int i3, int i4, int i5) {
        KQgRr5e_0(i4, i5, (int[]) null);
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public void onNestedScrollAccepted(View view, View view2, int i, int i2) {
        this.f2257KQgRr5e_0.KQgRr5e_0(view, view2, i, i2);
        m878QxJ9d_1(2, i2);
    }

    @Override // android.view.View
    public void onOverScrolled(int i, int i2, boolean z, boolean z2) {
        super.scrollTo(i, i2);
    }

    @Override // android.view.ViewGroup
    public boolean onRequestFocusInDescendants(int i, Rect rect) {
        View findNextFocusFromRect;
        if (i == 2) {
            i = 130;
        } else if (i == 1) {
            i = 33;
        }
        if (rect == null) {
            findNextFocusFromRect = FocusFinder.getInstance().findNextFocus(this, null, i);
        } else {
            findNextFocusFromRect = FocusFinder.getInstance().findNextFocusFromRect(this, rect, i);
        }
        if (findNextFocusFromRect == null || m876KQgRr5e_0(findNextFocusFromRect)) {
            return false;
        }
        return findNextFocusFromRect.requestFocus(i, rect);
    }

    @Override // android.view.View
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.f2264KQgRr5e_0 = savedState;
        requestLayout();
    }

    @Override // android.view.View
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.KQgRr5e_0 = getScrollY();
        return savedState;
    }

    @Override // android.view.View
    public void onScrollChanged(int i, int i2, int i3, int i4) {
        super.onScrollChanged(i, i2, i3, i4);
        QxJ9d_1 qxJ9d_1 = this.f2263KQgRr5e_0;
        if (qxJ9d_1 != null) {
            qxJ9d_1.KQgRr5e_0(this, i, i2, i3, i4);
        }
    }

    @Override // android.view.View
    public void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        View findFocus = findFocus();
        if (findFocus == null || this == findFocus || !KQgRr5e_0(findFocus, 0, i4)) {
            return;
        }
        findFocus.getDrawingRect(this.f2258KQgRr5e_0);
        offsetDescendantRectToMyCoords(findFocus, this.f2258KQgRr5e_0);
        KQgRr5e_0(KQgRr5e_0(this.f2258KQgRr5e_0));
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public boolean onStartNestedScroll(View view, View view2, int i) {
        return onStartNestedScroll(view, view2, i, 0);
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public boolean onStartNestedScroll(View view, View view2, int i, int i2) {
        return (i & 2) != 0;
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public void onStopNestedScroll(View view, int i) {
        this.f2257KQgRr5e_0.KQgRr5e_0(view, i);
        stopNestedScroll(i);
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        ViewParent parent;
        IFxWkV_5();
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.f3510IFxWkV_5 = 0;
        }
        MotionEvent obtain = MotionEvent.obtain(motionEvent);
        obtain.offsetLocation(0.0f, this.f3510IFxWkV_5);
        if (actionMasked != 0) {
            if (actionMasked == 1) {
                VelocityTracker velocityTracker = this.f2259KQgRr5e_0;
                velocityTracker.computeCurrentVelocity(1000, this.f3512Mqv2r_3);
                int yVelocity = (int) velocityTracker.getYVelocity(this.f3513X6FRs_4);
                if (Math.abs(yVelocity) > this.f2267PGPF6hQ_2) {
                    int i = -yVelocity;
                    float f = i;
                    if (!dispatchNestedPreFling(0.0f, f)) {
                        dispatchNestedFling(0.0f, f, true);
                        QxJ9d_1(i);
                    }
                } else if (this.f2262KQgRr5e_0.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange())) {
                    ZzDuCHW_20.m262KQgRr5e_0((View) this);
                }
                this.f3513X6FRs_4 = -1;
                QxJ9d_1();
            } else if (actionMasked == 2) {
                int findPointerIndex = motionEvent.findPointerIndex(this.f3513X6FRs_4);
                if (findPointerIndex == -1) {
                    Log.e("NestedScrollView", "Invalid pointerId=" + this.f3513X6FRs_4 + " in onTouchEvent");
                } else {
                    int y = (int) motionEvent.getY(findPointerIndex);
                    int i2 = this.f2254KQgRr5e_0 - y;
                    if (KQgRr5e_0(0, i2, this.f2271QxJ9d_1, this.f2265KQgRr5e_0, 0)) {
                        i2 -= this.f2271QxJ9d_1[1];
                        this.f3510IFxWkV_5 += this.f2265KQgRr5e_0[1];
                    }
                    if (!this.f2266Mqv2r_3 && Math.abs(i2) > this.QxJ9d_1) {
                        ViewParent parent2 = getParent();
                        if (parent2 != null) {
                            parent2.requestDisallowInterceptTouchEvent(true);
                        }
                        this.f2266Mqv2r_3 = true;
                        if (i2 > 0) {
                            i2 -= this.QxJ9d_1;
                        } else {
                            i2 += this.QxJ9d_1;
                        }
                    }
                    int i3 = i2;
                    if (this.f2266Mqv2r_3) {
                        this.f2254KQgRr5e_0 = y - this.f2265KQgRr5e_0[1];
                        int scrollY = getScrollY();
                        int scrollRange = getScrollRange();
                        int overScrollMode = getOverScrollMode();
                        boolean z = overScrollMode == 0 || (overScrollMode == 1 && scrollRange > 0);
                        if (KQgRr5e_0(0, i3, 0, getScrollY(), 0, scrollRange, 0, 0, true) && !PGPF6hQ_2(0)) {
                            this.f2259KQgRr5e_0.clear();
                        }
                        int scrollY2 = getScrollY() - scrollY;
                        int[] iArr = this.f2271QxJ9d_1;
                        iArr[1] = 0;
                        KQgRr5e_0(0, scrollY2, 0, i3 - scrollY2, this.f2265KQgRr5e_0, 0, iArr);
                        int i4 = this.f2254KQgRr5e_0;
                        int[] iArr2 = this.f2265KQgRr5e_0;
                        this.f2254KQgRr5e_0 = i4 - iArr2[1];
                        this.f3510IFxWkV_5 += iArr2[1];
                        if (z) {
                            int i5 = i3 - this.f2271QxJ9d_1[1];
                            PGPF6hQ_2();
                            int i6 = scrollY + i5;
                            if (i6 < 0) {
                                X6FRs_4.IMuAHx_6.WwEq_13.Mqv2r_3.KQgRr5e_0(this.f2261KQgRr5e_0, i5 / getHeight(), motionEvent.getX(findPointerIndex) / getWidth());
                                if (!this.f2269QxJ9d_1.isFinished()) {
                                    this.f2269QxJ9d_1.onRelease();
                                }
                            } else if (i6 > scrollRange) {
                                X6FRs_4.IMuAHx_6.WwEq_13.Mqv2r_3.KQgRr5e_0(this.f2269QxJ9d_1, i5 / getHeight(), 1.0f - (motionEvent.getX(findPointerIndex) / getWidth()));
                                if (!this.f2261KQgRr5e_0.isFinished()) {
                                    this.f2261KQgRr5e_0.onRelease();
                                }
                            }
                            EdgeEffect edgeEffect = this.f2261KQgRr5e_0;
                            if (edgeEffect != null && (!edgeEffect.isFinished() || !this.f2269QxJ9d_1.isFinished())) {
                                ZzDuCHW_20.m262KQgRr5e_0((View) this);
                            }
                        }
                    }
                }
            } else if (actionMasked == 3) {
                if (this.f2266Mqv2r_3 && getChildCount() > 0 && this.f2262KQgRr5e_0.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange())) {
                    ZzDuCHW_20.m262KQgRr5e_0((View) this);
                }
                this.f3513X6FRs_4 = -1;
                QxJ9d_1();
            } else if (actionMasked == 5) {
                int actionIndex = motionEvent.getActionIndex();
                this.f2254KQgRr5e_0 = (int) motionEvent.getY(actionIndex);
                this.f3513X6FRs_4 = motionEvent.getPointerId(actionIndex);
            } else if (actionMasked == 6) {
                KQgRr5e_0(motionEvent);
                this.f2254KQgRr5e_0 = (int) motionEvent.getY(motionEvent.findPointerIndex(this.f3513X6FRs_4));
            }
        } else if (getChildCount() == 0) {
            return false;
        } else {
            boolean z2 = !this.f2262KQgRr5e_0.isFinished();
            this.f2266Mqv2r_3 = z2;
            if (z2 && (parent = getParent()) != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            if (!this.f2262KQgRr5e_0.isFinished()) {
                KQgRr5e_0();
            }
            this.f2254KQgRr5e_0 = (int) motionEvent.getY();
            this.f3513X6FRs_4 = motionEvent.getPointerId(0);
            m878QxJ9d_1(2, 0);
        }
        VelocityTracker velocityTracker2 = this.f2259KQgRr5e_0;
        if (velocityTracker2 != null) {
            velocityTracker2.addMovement(obtain);
        }
        obtain.recycle();
        return true;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void requestChildFocus(View view, View view2) {
        if (!this.f2270QxJ9d_1) {
            KQgRr5e_0(view2);
        } else {
            this.f2260KQgRr5e_0 = view2;
        }
        super.requestChildFocus(view, view2);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z) {
        rect.offset(view.getLeft() - view.getScrollX(), view.getTop() - view.getScrollY());
        return KQgRr5e_0(rect, z);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void requestDisallowInterceptTouchEvent(boolean z) {
        if (z) {
            IMuAHx_6();
        }
        super.requestDisallowInterceptTouchEvent(z);
    }

    @Override // android.view.View, android.view.ViewParent
    public void requestLayout() {
        this.f2270QxJ9d_1 = true;
        super.requestLayout();
    }

    @Override // android.view.View
    public void scrollTo(int i, int i2) {
        if (getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            int KQgRr5e_02 = KQgRr5e_0(i, (getWidth() - getPaddingLeft()) - getPaddingRight(), childAt.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin);
            int KQgRr5e_03 = KQgRr5e_0(i2, (getHeight() - getPaddingTop()) - getPaddingBottom(), childAt.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin);
            if (KQgRr5e_02 == getScrollX() && KQgRr5e_03 == getScrollY()) {
                return;
            }
            super.scrollTo(KQgRr5e_02, KQgRr5e_03);
        }
    }

    public void setFillViewport(boolean z) {
        if (z != this.f2272X6FRs_4) {
            this.f2272X6FRs_4 = z;
            requestLayout();
        }
    }

    @Override // android.view.View
    public void setNestedScrollingEnabled(boolean z) {
        this.f2256KQgRr5e_0.KQgRr5e_0(z);
    }

    public void setOnScrollChangeListener(QxJ9d_1 qxJ9d_1) {
        this.f2263KQgRr5e_0 = qxJ9d_1;
    }

    public void setSmoothScrollingEnabled(boolean z) {
        this.f2252IFxWkV_5 = z;
    }

    @Override // android.widget.FrameLayout, android.view.ViewGroup
    public boolean shouldDelayChildPressedState() {
        return true;
    }

    @Override // android.view.View
    public boolean startNestedScroll(int i) {
        return m878QxJ9d_1(i, 0);
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.Xgtqvk_8
    public void stopNestedScroll(int i) {
        this.f2256KQgRr5e_0.m217KQgRr5e_0(i);
    }

    public NestedScrollView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public boolean KQgRr5e_0(int i, int i2, int[] iArr, int[] iArr2, int i3) {
        return this.f2256KQgRr5e_0.KQgRr5e_0(i, i2, iArr, iArr2, i3);
    }

    public final void PGPF6hQ_2() {
        if (getOverScrollMode() != 2) {
            if (this.f2261KQgRr5e_0 == null) {
                Context context = getContext();
                this.f2261KQgRr5e_0 = new EdgeEffect(context);
                this.f2269QxJ9d_1 = new EdgeEffect(context);
                return;
            }
            return;
        }
        this.f2261KQgRr5e_0 = null;
        this.f2269QxJ9d_1 = null;
    }

    /* renamed from: QxJ9d_1  reason: collision with other method in class */
    public boolean m877QxJ9d_1(int i) {
        int childCount;
        boolean z = i == 130;
        int height = getHeight();
        Rect rect = this.f2258KQgRr5e_0;
        rect.top = 0;
        rect.bottom = height;
        if (z && (childCount = getChildCount()) > 0) {
            View childAt = getChildAt(childCount - 1);
            this.f2258KQgRr5e_0.bottom = childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin + getPaddingBottom();
            Rect rect2 = this.f2258KQgRr5e_0;
            rect2.top = rect2.bottom - height;
        }
        Rect rect3 = this.f2258KQgRr5e_0;
        return m875KQgRr5e_0(i, rect3.top, rect3.bottom);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
        onNestedPreScroll(view, i, i2, iArr, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        KQgRr5e_0(i4, 0, (int[]) null);
    }

    @Override // android.view.View, X6FRs_4.IMuAHx_6.EuDEkJe_12.Nm6q_10
    public void stopNestedScroll() {
        stopNestedScroll(0);
    }

    public NestedScrollView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f2258KQgRr5e_0 = new Rect();
        this.f2270QxJ9d_1 = true;
        this.f2268PGPF6hQ_2 = false;
        this.f2260KQgRr5e_0 = null;
        this.f2266Mqv2r_3 = false;
        this.f2252IFxWkV_5 = true;
        this.f3513X6FRs_4 = -1;
        this.f2265KQgRr5e_0 = new int[2];
        this.f2271QxJ9d_1 = new int[2];
        X6FRs_4();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, PGPF6hQ_2, i, 0);
        setFillViewport(obtainStyledAttributes.getBoolean(0, false));
        obtainStyledAttributes.recycle();
        this.f2257KQgRr5e_0 = new LGe8pk_15(this);
        this.f2256KQgRr5e_0 = new KNBe_11(this);
        setNestedScrollingEnabled(true);
        ZzDuCHW_20.KQgRr5e_0(this, KQgRr5e_0);
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.WwEq_13
    public void KQgRr5e_0(View view, int i, int i2, int i3, int i4, int i5, int[] iArr) {
        KQgRr5e_0(i4, i5, iArr);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public void onNestedScrollAccepted(View view, View view2, int i) {
        onNestedScrollAccepted(view, view2, i, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public void onStopNestedScroll(View view) {
        onStopNestedScroll(view, 0);
    }

    public final void KQgRr5e_0(int i, int i2, int[] iArr) {
        int scrollY = getScrollY();
        scrollBy(0, i);
        int scrollY2 = getScrollY() - scrollY;
        if (iArr != null) {
            iArr[1] = iArr[1] + scrollY2;
        }
        this.f2256KQgRr5e_0.KQgRr5e_0(0, scrollY2, 0, i - scrollY2, (int[]) null, i2, iArr);
    }

    public boolean Mqv2r_3(int i) {
        boolean z = i == 130;
        int height = getHeight();
        if (z) {
            this.f2258KQgRr5e_0.top = getScrollY() + height;
            int childCount = getChildCount();
            if (childCount > 0) {
                View childAt = getChildAt(childCount - 1);
                int bottom = childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin + getPaddingBottom();
                Rect rect = this.f2258KQgRr5e_0;
                if (rect.top + height > bottom) {
                    rect.top = bottom - height;
                }
            }
        } else {
            this.f2258KQgRr5e_0.top = getScrollY() - height;
            Rect rect2 = this.f2258KQgRr5e_0;
            if (rect2.top < 0) {
                rect2.top = 0;
            }
        }
        Rect rect3 = this.f2258KQgRr5e_0;
        int i2 = rect3.top;
        int i3 = height + i2;
        rect3.bottom = i3;
        return m875KQgRr5e_0(i, i2, i3);
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i) {
        if (getChildCount() <= 0) {
            super.addView(view, i);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    @Override // android.view.ViewGroup, android.view.ViewManager
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        if (getChildCount() <= 0) {
            super.addView(view, layoutParams);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public final boolean m872KQgRr5e_0() {
        if (getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            return (childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin > (getHeight() - getPaddingTop()) - getPaddingBottom();
        }
        return false;
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        if (getChildCount() <= 0) {
            super.addView(view, i, layoutParams);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    public final void QxJ9d_1(int i, int i2) {
        KQgRr5e_0(i - getScrollX(), i2 - getScrollY());
    }

    public void QxJ9d_1(int i) {
        if (getChildCount() > 0) {
            this.f2262KQgRr5e_0.fling(getScrollX(), getScrollY(), 0, i, 0, 0, X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0.INVALID_ID, Integer.MAX_VALUE, 0, 0);
            KQgRr5e_0(true);
        }
    }

    public boolean KQgRr5e_0(KeyEvent keyEvent) {
        this.f2258KQgRr5e_0.setEmpty();
        if (!m872KQgRr5e_0()) {
            if (!isFocused() || keyEvent.getKeyCode() == 4) {
                return false;
            }
            View findFocus = findFocus();
            if (findFocus == this) {
                findFocus = null;
            }
            View findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, 130);
            return (findNextFocus == null || findNextFocus == this || !findNextFocus.requestFocus(130)) ? false : true;
        } else if (keyEvent.getAction() == 0) {
            int keyCode = keyEvent.getKeyCode();
            if (keyCode == 19) {
                if (!keyEvent.isAltPressed()) {
                    return m873KQgRr5e_0(33);
                }
                return m877QxJ9d_1(33);
            } else if (keyCode == 20) {
                if (!keyEvent.isAltPressed()) {
                    return m873KQgRr5e_0(130);
                }
                return m877QxJ9d_1(130);
            } else if (keyCode != 62) {
                return false;
            } else {
                Mqv2r_3(keyEvent.isShiftPressed() ? 33 : 130);
                return false;
            }
        } else {
            return false;
        }
    }

    public final void QxJ9d_1() {
        this.f2266Mqv2r_3 = false;
        IMuAHx_6();
        stopNestedScroll(0);
        EdgeEffect edgeEffect = this.f2261KQgRr5e_0;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
            this.f2269QxJ9d_1.onRelease();
        }
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public final boolean m874KQgRr5e_0(int i, int i2) {
        if (getChildCount() > 0) {
            int scrollY = getScrollY();
            View childAt = getChildAt(0);
            return i2 >= childAt.getTop() - scrollY && i2 < childAt.getBottom() - scrollY && i >= childAt.getLeft() && i < childAt.getRight();
        }
        return false;
    }

    public final void KQgRr5e_0(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.f3513X6FRs_4) {
            int i = actionIndex == 0 ? 1 : 0;
            this.f2254KQgRr5e_0 = (int) motionEvent.getY(i);
            this.f3513X6FRs_4 = motionEvent.getPointerId(i);
            VelocityTracker velocityTracker = this.f2259KQgRr5e_0;
            if (velocityTracker != null) {
                velocityTracker.clear();
            }
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:38:0x0057  */
    /* JADX WARN: Removed duplicated region for block: B:40:0x005a  */
    /* JADX WARN: Removed duplicated region for block: B:44:0x0061  */
    /* JADX WARN: Removed duplicated region for block: B:49:0x0083 A[ADDED_TO_REGION] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean KQgRr5e_0(int i, int i2, int i3, int i4, int i5, int i6, int i7, int i8, boolean z) {
        boolean z2;
        boolean z3;
        int overScrollMode = getOverScrollMode();
        boolean z4 = computeHorizontalScrollRange() > computeHorizontalScrollExtent();
        boolean z5 = computeVerticalScrollRange() > computeVerticalScrollExtent();
        boolean z6 = overScrollMode == 0 || (overScrollMode == 1 && z4);
        boolean z7 = overScrollMode == 0 || (overScrollMode == 1 && z5);
        int i9 = i3 + i;
        int i10 = !z6 ? 0 : i7;
        int i11 = i4 + i2;
        int i12 = !z7 ? 0 : i8;
        int i13 = -i10;
        int i14 = i10 + i5;
        int i15 = -i12;
        int i16 = i12 + i6;
        if (i9 > i14) {
            i9 = i14;
        } else if (i9 >= i13) {
            z2 = false;
            if (i11 <= i16) {
                i11 = i16;
            } else if (i11 >= i15) {
                z3 = false;
                if (z3 && !PGPF6hQ_2(1)) {
                    this.f2262KQgRr5e_0.springBack(i9, i11, 0, 0, 0, getScrollRange());
                }
                onOverScrolled(i9, i11, z2, z3);
                return !z2 || z3;
            } else {
                i11 = i15;
            }
            z3 = true;
            if (z3) {
                this.f2262KQgRr5e_0.springBack(i9, i11, 0, 0, 0, getScrollRange());
            }
            onOverScrolled(i9, i11, z2, z3);
            if (z2) {
            }
        } else {
            i9 = i13;
        }
        z2 = true;
        if (i11 <= i16) {
        }
        z3 = true;
        if (z3) {
        }
        onOverScrolled(i9, i11, z2, z3);
        if (z2) {
        }
    }

    public final View KQgRr5e_0(boolean z, int i, int i2) {
        ArrayList focusables = getFocusables(2);
        int size = focusables.size();
        View view = null;
        boolean z2 = false;
        for (int i3 = 0; i3 < size; i3++) {
            View view2 = (View) focusables.get(i3);
            int top = view2.getTop();
            int bottom = view2.getBottom();
            if (i < bottom && top < i2) {
                boolean z3 = i < top && bottom < i2;
                if (view == null) {
                    view = view2;
                    z2 = z3;
                } else {
                    boolean z4 = (z && top < view.getTop()) || (!z && bottom > view.getBottom());
                    if (z2) {
                        if (z3) {
                            if (!z4) {
                            }
                            view = view2;
                        }
                    } else if (z3) {
                        view = view2;
                        z2 = true;
                    } else {
                        if (!z4) {
                        }
                        view = view2;
                    }
                }
            }
        }
        return view;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public final boolean m875KQgRr5e_0(int i, int i2, int i3) {
        int height = getHeight();
        int scrollY = getScrollY();
        int i4 = height + scrollY;
        boolean z = false;
        boolean z2 = i == 33;
        View KQgRr5e_02 = KQgRr5e_0(z2, i2, i3);
        if (KQgRr5e_02 == null) {
            KQgRr5e_02 = this;
        }
        if (i2 < scrollY || i3 > i4) {
            KQgRr5e_0(z2 ? i2 - scrollY : i3 - i4);
            z = true;
        }
        if (KQgRr5e_02 != findFocus()) {
            KQgRr5e_02.requestFocus(i);
        }
        return z;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public boolean m873KQgRr5e_0(int i) {
        View findFocus = findFocus();
        if (findFocus == this) {
            findFocus = null;
        }
        View findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, i);
        int maxScrollAmount = getMaxScrollAmount();
        if (findNextFocus != null && KQgRr5e_0(findNextFocus, maxScrollAmount, getHeight())) {
            findNextFocus.getDrawingRect(this.f2258KQgRr5e_0);
            offsetDescendantRectToMyCoords(findNextFocus, this.f2258KQgRr5e_0);
            KQgRr5e_0(KQgRr5e_0(this.f2258KQgRr5e_0));
            findNextFocus.requestFocus(i);
        } else {
            if (i == 33 && getScrollY() < maxScrollAmount) {
                maxScrollAmount = getScrollY();
            } else if (i == 130 && getChildCount() > 0) {
                View childAt = getChildAt(0);
                maxScrollAmount = Math.min((childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin) - ((getScrollY() + getHeight()) - getPaddingBottom()), maxScrollAmount);
            }
            if (maxScrollAmount == 0) {
                return false;
            }
            if (i != 130) {
                maxScrollAmount = -maxScrollAmount;
            }
            KQgRr5e_0(maxScrollAmount);
        }
        if (findFocus != null && findFocus.isFocused() && m876KQgRr5e_0(findFocus)) {
            int descendantFocusability = getDescendantFocusability();
            setDescendantFocusability(131072);
            requestFocus();
            setDescendantFocusability(descendantFocusability);
            return true;
        }
        return true;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public final boolean m876KQgRr5e_0(View view) {
        return !KQgRr5e_0(view, 0, getHeight());
    }

    public final boolean KQgRr5e_0(View view, int i, int i2) {
        view.getDrawingRect(this.f2258KQgRr5e_0);
        offsetDescendantRectToMyCoords(view, this.f2258KQgRr5e_0);
        return this.f2258KQgRr5e_0.bottom + i >= getScrollY() && this.f2258KQgRr5e_0.top - i <= getScrollY() + i2;
    }

    public final void KQgRr5e_0(int i) {
        if (i != 0) {
            if (this.f2252IFxWkV_5) {
                KQgRr5e_0(0, i);
            } else {
                scrollBy(0, i);
            }
        }
    }

    public final void KQgRr5e_0(int i, int i2) {
        if (getChildCount() == 0) {
            return;
        }
        if (AnimationUtils.currentAnimationTimeMillis() - this.f2255KQgRr5e_0 > 250) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            int height = childAt.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            int height2 = (getHeight() - getPaddingTop()) - getPaddingBottom();
            int scrollY = getScrollY();
            OverScroller overScroller = this.f2262KQgRr5e_0;
            int scrollX = getScrollX();
            overScroller.startScroll(scrollX, scrollY, 0, Math.max(0, Math.min(i2 + scrollY, Math.max(0, height - height2))) - scrollY);
            KQgRr5e_0(false);
        } else {
            if (!this.f2262KQgRr5e_0.isFinished()) {
                KQgRr5e_0();
            }
            scrollBy(i, i2);
        }
        this.f2255KQgRr5e_0 = AnimationUtils.currentAnimationTimeMillis();
    }

    public final void KQgRr5e_0(boolean z) {
        if (z) {
            m878QxJ9d_1(2, 1);
        } else {
            stopNestedScroll(1);
        }
        this.f3511IMuAHx_6 = getScrollY();
        ZzDuCHW_20.m262KQgRr5e_0((View) this);
    }

    public final void KQgRr5e_0() {
        this.f2262KQgRr5e_0.abortAnimation();
        stopNestedScroll(1);
    }

    public final void KQgRr5e_0(View view) {
        view.getDrawingRect(this.f2258KQgRr5e_0);
        offsetDescendantRectToMyCoords(view, this.f2258KQgRr5e_0);
        int KQgRr5e_02 = KQgRr5e_0(this.f2258KQgRr5e_0);
        if (KQgRr5e_02 != 0) {
            scrollBy(0, KQgRr5e_02);
        }
    }

    public final boolean KQgRr5e_0(Rect rect, boolean z) {
        int KQgRr5e_02 = KQgRr5e_0(rect);
        boolean z2 = KQgRr5e_02 != 0;
        if (z2) {
            if (z) {
                scrollBy(0, KQgRr5e_02);
            } else {
                KQgRr5e_0(0, KQgRr5e_02);
            }
        }
        return z2;
    }

    public int KQgRr5e_0(Rect rect) {
        int i;
        int i2;
        if (getChildCount() == 0) {
            return 0;
        }
        int height = getHeight();
        int scrollY = getScrollY();
        int i3 = scrollY + height;
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        if (rect.top > 0) {
            scrollY += verticalFadingEdgeLength;
        }
        View childAt = getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
        int i4 = rect.bottom < (childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin ? i3 - verticalFadingEdgeLength : i3;
        if (rect.bottom > i4 && rect.top > scrollY) {
            if (rect.height() > height) {
                i2 = rect.top - scrollY;
            } else {
                i2 = rect.bottom - i4;
            }
            return Math.min(i2 + 0, (childAt.getBottom() + layoutParams.bottomMargin) - i3);
        } else if (rect.top >= scrollY || rect.bottom >= i4) {
            return 0;
        } else {
            if (rect.height() > height) {
                i = 0 - (i4 - rect.bottom);
            } else {
                i = 0 - (scrollY - rect.top);
            }
            return Math.max(i, -getScrollY());
        }
    }

    public static boolean KQgRr5e_0(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent parent = view.getParent();
        return (parent instanceof ViewGroup) && KQgRr5e_0((View) parent, view2);
    }
}
