package androidx.core.graphics.drawable;

import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import androidx.versionedparcelable.CustomVersionedParcelable;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
/* loaded from: classes.dex */
public class IconCompat extends CustomVersionedParcelable {
    public static final PorterDuff.Mode QxJ9d_1 = PorterDuff.Mode.SRC_IN;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Object f2246KQgRr5e_0;
    public int KQgRr5e_0 = -1;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public byte[] f2248KQgRr5e_0 = null;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Parcelable f2245KQgRr5e_0 = null;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public int f2249QxJ9d_1 = 0;
    public int PGPF6hQ_2 = 0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public ColorStateList f2243KQgRr5e_0 = null;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public PorterDuff.Mode f2244KQgRr5e_0 = QxJ9d_1;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public String f2247KQgRr5e_0 = null;

    public static String KQgRr5e_0(int i) {
        return i != 1 ? i != 2 ? i != 3 ? i != 4 ? i != 5 ? "UNKNOWN" : "BITMAP_MASKABLE" : "URI" : "DATA" : "RESOURCE" : "BITMAP";
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public String m870KQgRr5e_0() {
        if (this.KQgRr5e_0 == -1 && Build.VERSION.SDK_INT >= 23) {
            return m869KQgRr5e_0((Icon) this.f2246KQgRr5e_0);
        }
        if (this.KQgRr5e_0 == 2) {
            return ((String) this.f2246KQgRr5e_0).split(":", -1)[0];
        }
        throw new IllegalStateException("called getResPackage() on " + this);
    }

    /* JADX WARN: Code restructure failed: missing block: B:15:0x002b, code lost:
        if (r1 != 5) goto L16;
     */
    /* JADX WARN: Removed duplicated region for block: B:25:0x009e  */
    /* JADX WARN: Removed duplicated region for block: B:28:0x00ae  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public String toString() {
        if (this.KQgRr5e_0 == -1) {
            return String.valueOf(this.f2246KQgRr5e_0);
        }
        StringBuilder sb = new StringBuilder("Icon(typ=");
        sb.append(KQgRr5e_0(this.KQgRr5e_0));
        int i = this.KQgRr5e_0;
        if (i != 1) {
            if (i == 2) {
                sb.append(" pkg=");
                sb.append(m870KQgRr5e_0());
                sb.append(" id=");
                sb.append(String.format("0x%08x", Integer.valueOf(KQgRr5e_0())));
            } else if (i == 3) {
                sb.append(" len=");
                sb.append(this.f2249QxJ9d_1);
                if (this.PGPF6hQ_2 != 0) {
                    sb.append(" off=");
                    sb.append(this.PGPF6hQ_2);
                }
            } else if (i == 4) {
                sb.append(" uri=");
                sb.append(this.f2246KQgRr5e_0);
            }
            if (this.f2243KQgRr5e_0 != null) {
                sb.append(" tint=");
                sb.append(this.f2243KQgRr5e_0);
            }
            if (this.f2244KQgRr5e_0 != QxJ9d_1) {
                sb.append(" mode=");
                sb.append(this.f2244KQgRr5e_0);
            }
            sb.append(")");
            return sb.toString();
        }
        sb.append(" size=");
        sb.append(((Bitmap) this.f2246KQgRr5e_0).getWidth());
        sb.append("x");
        sb.append(((Bitmap) this.f2246KQgRr5e_0).getHeight());
        if (this.f2243KQgRr5e_0 != null) {
        }
        if (this.f2244KQgRr5e_0 != QxJ9d_1) {
        }
        sb.append(")");
        return sb.toString();
    }

    public int KQgRr5e_0() {
        if (this.KQgRr5e_0 == -1 && Build.VERSION.SDK_INT >= 23) {
            return KQgRr5e_0((Icon) this.f2246KQgRr5e_0);
        }
        if (this.KQgRr5e_0 == 2) {
            return this.f2249QxJ9d_1;
        }
        throw new IllegalStateException("called getResId() on " + this);
    }

    public void KQgRr5e_0(boolean z) {
        this.f2247KQgRr5e_0 = this.f2244KQgRr5e_0.name();
        int i = this.KQgRr5e_0;
        if (i == -1) {
            if (!z) {
                this.f2245KQgRr5e_0 = (Parcelable) this.f2246KQgRr5e_0;
                return;
            }
            throw new IllegalArgumentException("Can't serialize Icon created with IconCompat#createFromIcon");
        }
        if (i != 1) {
            if (i == 2) {
                this.f2248KQgRr5e_0 = ((String) this.f2246KQgRr5e_0).getBytes(Charset.forName("UTF-16"));
                return;
            } else if (i == 3) {
                this.f2248KQgRr5e_0 = (byte[]) this.f2246KQgRr5e_0;
                return;
            } else if (i == 4) {
                this.f2248KQgRr5e_0 = this.f2246KQgRr5e_0.toString().getBytes(Charset.forName("UTF-16"));
                return;
            } else if (i != 5) {
                return;
            }
        }
        if (z) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((Bitmap) this.f2246KQgRr5e_0).compress(Bitmap.CompressFormat.PNG, 90, byteArrayOutputStream);
            this.f2248KQgRr5e_0 = byteArrayOutputStream.toByteArray();
            return;
        }
        this.f2245KQgRr5e_0 = (Parcelable) this.f2246KQgRr5e_0;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public void m871KQgRr5e_0() {
        this.f2244KQgRr5e_0 = PorterDuff.Mode.valueOf(this.f2247KQgRr5e_0);
        int i = this.KQgRr5e_0;
        if (i != -1) {
            if (i != 1) {
                if (i != 2) {
                    if (i == 3) {
                        this.f2246KQgRr5e_0 = this.f2248KQgRr5e_0;
                        return;
                    } else if (i != 4) {
                        if (i != 5) {
                            return;
                        }
                    }
                }
                this.f2246KQgRr5e_0 = new String(this.f2248KQgRr5e_0, Charset.forName("UTF-16"));
                return;
            }
            Parcelable parcelable = this.f2245KQgRr5e_0;
            if (parcelable != null) {
                this.f2246KQgRr5e_0 = parcelable;
                return;
            }
            byte[] bArr = this.f2248KQgRr5e_0;
            this.f2246KQgRr5e_0 = bArr;
            this.KQgRr5e_0 = 3;
            this.f2249QxJ9d_1 = 0;
            this.PGPF6hQ_2 = bArr.length;
            return;
        }
        Parcelable parcelable2 = this.f2245KQgRr5e_0;
        if (parcelable2 != null) {
            this.f2246KQgRr5e_0 = parcelable2;
            return;
        }
        throw new IllegalArgumentException("Invalid icon");
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public static String m869KQgRr5e_0(Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getResPackage();
        }
        try {
            return (String) icon.getClass().getMethod("getResPackage", new Class[0]).invoke(icon, new Object[0]);
        } catch (IllegalAccessException e) {
            Log.e("IconCompat", "Unable to get icon package", e);
            return null;
        } catch (NoSuchMethodException e2) {
            Log.e("IconCompat", "Unable to get icon package", e2);
            return null;
        } catch (InvocationTargetException e3) {
            Log.e("IconCompat", "Unable to get icon package", e3);
            return null;
        }
    }

    public static int KQgRr5e_0(Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getResId();
        }
        try {
            return ((Integer) icon.getClass().getMethod("getResId", new Class[0]).invoke(icon, new Object[0])).intValue();
        } catch (IllegalAccessException e) {
            Log.e("IconCompat", "Unable to get icon resource", e);
            return 0;
        } catch (NoSuchMethodException e2) {
            Log.e("IconCompat", "Unable to get icon resource", e2);
            return 0;
        } catch (InvocationTargetException e3) {
            Log.e("IconCompat", "Unable to get icon resource", e3);
            return 0;
        }
    }
}
