package androidx.core.content;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.recyclerview.widget.RecyclerView;
import androidx.transition.Transition;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;
/* loaded from: classes.dex */
public class FileProvider extends ContentProvider {

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public KQgRr5e_0 f2241KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public static final String[] f2240KQgRr5e_0 = {"_display_name", "_size"};
    public static final File KQgRr5e_0 = new File("/");

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public static HashMap<String, KQgRr5e_0> f2239KQgRr5e_0 = new HashMap<>();

    /* loaded from: classes.dex */
    public interface KQgRr5e_0 {
        Uri KQgRr5e_0(File file);

        File KQgRr5e_0(Uri uri);
    }

    public static Uri KQgRr5e_0(Context context, String str, File file) {
        return KQgRr5e_0(context, str).KQgRr5e_0(file);
    }

    public static KQgRr5e_0 QxJ9d_1(Context context, String str) throws IOException, XmlPullParserException {
        QxJ9d_1 qxJ9d_1 = new QxJ9d_1(str);
        ProviderInfo resolveContentProvider = context.getPackageManager().resolveContentProvider(str, RecyclerView.WGk6X_27.FLAG_IGNORE);
        if (resolveContentProvider != null) {
            XmlResourceParser loadXmlMetaData = resolveContentProvider.loadXmlMetaData(context.getPackageManager(), "android.support.FILE_PROVIDER_PATHS");
            if (loadXmlMetaData == null) {
                throw new IllegalArgumentException("Missing android.support.FILE_PROVIDER_PATHS meta-data");
            }
            while (true) {
                int next = loadXmlMetaData.next();
                if (next == 1) {
                    return qxJ9d_1;
                }
                if (next == 2) {
                    String name = loadXmlMetaData.getName();
                    File file = null;
                    String attributeValue = loadXmlMetaData.getAttributeValue(null, Transition.MATCH_NAME_STR);
                    String attributeValue2 = loadXmlMetaData.getAttributeValue(null, "path");
                    if ("root-path".equals(name)) {
                        file = KQgRr5e_0;
                    } else if ("files-path".equals(name)) {
                        file = context.getFilesDir();
                    } else if ("cache-path".equals(name)) {
                        file = context.getCacheDir();
                    } else if ("external-path".equals(name)) {
                        file = Environment.getExternalStorageDirectory();
                    } else if ("external-files-path".equals(name)) {
                        File[] m333KQgRr5e_0 = X6FRs_4.IMuAHx_6.X6FRs_4.KQgRr5e_0.m333KQgRr5e_0(context, (String) null);
                        if (m333KQgRr5e_0.length > 0) {
                            file = m333KQgRr5e_0[0];
                        }
                    } else if ("external-cache-path".equals(name)) {
                        File[] KQgRr5e_02 = X6FRs_4.IMuAHx_6.X6FRs_4.KQgRr5e_0.KQgRr5e_0(context);
                        if (KQgRr5e_02.length > 0) {
                            file = KQgRr5e_02[0];
                        }
                    } else if (Build.VERSION.SDK_INT >= 21 && "external-media-path".equals(name)) {
                        File[] externalMediaDirs = context.getExternalMediaDirs();
                        if (externalMediaDirs.length > 0) {
                            file = externalMediaDirs[0];
                        }
                    }
                    if (file != null) {
                        qxJ9d_1.KQgRr5e_0(attributeValue, KQgRr5e_0(file, attributeValue2));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Couldn't find meta-data for provider with authority " + str);
        }
    }

    @Override // android.content.ContentProvider
    public void attachInfo(Context context, ProviderInfo providerInfo) {
        super.attachInfo(context, providerInfo);
        if (!providerInfo.exported) {
            if (providerInfo.grantUriPermissions) {
                this.f2241KQgRr5e_0 = KQgRr5e_0(context, providerInfo.authority);
                return;
            }
            throw new SecurityException("Provider must grant uri permissions");
        }
        throw new SecurityException("Provider must not be exported");
    }

    @Override // android.content.ContentProvider
    public int delete(Uri uri, String str, String[] strArr) {
        return this.f2241KQgRr5e_0.KQgRr5e_0(uri).delete() ? 1 : 0;
    }

    @Override // android.content.ContentProvider
    public String getType(Uri uri) {
        File KQgRr5e_02 = this.f2241KQgRr5e_0.KQgRr5e_0(uri);
        int lastIndexOf = KQgRr5e_02.getName().lastIndexOf(46);
        if (lastIndexOf >= 0) {
            String mimeTypeFromExtension = MimeTypeMap.getSingleton().getMimeTypeFromExtension(KQgRr5e_02.getName().substring(lastIndexOf + 1));
            return mimeTypeFromExtension != null ? mimeTypeFromExtension : "application/octet-stream";
        }
        return "application/octet-stream";
    }

    @Override // android.content.ContentProvider
    public Uri insert(Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException("No external inserts");
    }

    @Override // android.content.ContentProvider
    public boolean onCreate() {
        return true;
    }

    @Override // android.content.ContentProvider
    public ParcelFileDescriptor openFile(Uri uri, String str) throws FileNotFoundException {
        return ParcelFileDescriptor.open(this.f2241KQgRr5e_0.KQgRr5e_0(uri), KQgRr5e_0(str));
    }

    @Override // android.content.ContentProvider
    public Cursor query(Uri uri, String[] strArr, String str, String[] strArr2, String str2) {
        int i;
        File KQgRr5e_02 = this.f2241KQgRr5e_0.KQgRr5e_0(uri);
        if (strArr == null) {
            strArr = f2240KQgRr5e_0;
        }
        String[] strArr3 = new String[strArr.length];
        Object[] objArr = new Object[strArr.length];
        int i2 = 0;
        for (String str3 : strArr) {
            if ("_display_name".equals(str3)) {
                strArr3[i2] = "_display_name";
                i = i2 + 1;
                objArr[i2] = KQgRr5e_02.getName();
            } else if ("_size".equals(str3)) {
                strArr3[i2] = "_size";
                i = i2 + 1;
                objArr[i2] = Long.valueOf(KQgRr5e_02.length());
            }
            i2 = i;
        }
        String[] KQgRr5e_03 = KQgRr5e_0(strArr3, i2);
        Object[] KQgRr5e_04 = KQgRr5e_0(objArr, i2);
        MatrixCursor matrixCursor = new MatrixCursor(KQgRr5e_03, 1);
        matrixCursor.addRow(KQgRr5e_04);
        return matrixCursor;
    }

    @Override // android.content.ContentProvider
    public int update(Uri uri, ContentValues contentValues, String str, String[] strArr) {
        throw new UnsupportedOperationException("No external updates");
    }

    public static KQgRr5e_0 KQgRr5e_0(Context context, String str) {
        KQgRr5e_0 kQgRr5e_0;
        synchronized (f2239KQgRr5e_0) {
            kQgRr5e_0 = f2239KQgRr5e_0.get(str);
            if (kQgRr5e_0 == null) {
                try {
                    kQgRr5e_0 = QxJ9d_1(context, str);
                    f2239KQgRr5e_0.put(str, kQgRr5e_0);
                } catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", e);
                } catch (XmlPullParserException e2) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", e2);
                }
            }
        }
        return kQgRr5e_0;
    }

    /* loaded from: classes.dex */
    public static class QxJ9d_1 implements KQgRr5e_0 {
        public final String KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final HashMap<String, File> f2242KQgRr5e_0 = new HashMap<>();

        public QxJ9d_1(String str) {
            this.KQgRr5e_0 = str;
        }

        public void KQgRr5e_0(String str, File file) {
            if (!TextUtils.isEmpty(str)) {
                try {
                    this.f2242KQgRr5e_0.put(str, file.getCanonicalFile());
                    return;
                } catch (IOException e) {
                    throw new IllegalArgumentException("Failed to resolve canonical path for " + file, e);
                }
            }
            throw new IllegalArgumentException("Name must not be empty");
        }

        @Override // androidx.core.content.FileProvider.KQgRr5e_0
        public Uri KQgRr5e_0(File file) {
            String substring;
            try {
                String canonicalPath = file.getCanonicalPath();
                Map.Entry<String, File> entry = null;
                for (Map.Entry<String, File> entry2 : this.f2242KQgRr5e_0.entrySet()) {
                    String path = entry2.getValue().getPath();
                    if (canonicalPath.startsWith(path) && (entry == null || path.length() > entry.getValue().getPath().length())) {
                        entry = entry2;
                    }
                }
                if (entry != null) {
                    String path2 = entry.getValue().getPath();
                    if (path2.endsWith("/")) {
                        substring = canonicalPath.substring(path2.length());
                    } else {
                        substring = canonicalPath.substring(path2.length() + 1);
                    }
                    return new Uri.Builder().scheme("content").authority(this.KQgRr5e_0).encodedPath(Uri.encode(entry.getKey()) + '/' + Uri.encode(substring, "/")).build();
                }
                throw new IllegalArgumentException("Failed to find configured root that contains " + canonicalPath);
            } catch (IOException unused) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file);
            }
        }

        @Override // androidx.core.content.FileProvider.KQgRr5e_0
        public File KQgRr5e_0(Uri uri) {
            String encodedPath = uri.getEncodedPath();
            int indexOf = encodedPath.indexOf(47, 1);
            String decode = Uri.decode(encodedPath.substring(1, indexOf));
            String decode2 = Uri.decode(encodedPath.substring(indexOf + 1));
            File file = this.f2242KQgRr5e_0.get(decode);
            if (file != null) {
                File file2 = new File(file, decode2);
                try {
                    File canonicalFile = file2.getCanonicalFile();
                    if (canonicalFile.getPath().startsWith(file.getPath())) {
                        return canonicalFile;
                    }
                    throw new SecurityException("Resolved path jumped beyond configured root");
                } catch (IOException unused) {
                    throw new IllegalArgumentException("Failed to resolve canonical path for " + file2);
                }
            }
            throw new IllegalArgumentException("Unable to find configured root for " + uri);
        }
    }

    public static int KQgRr5e_0(String str) {
        if ("r".equals(str)) {
            return 268435456;
        }
        if ("w".equals(str) || "wt".equals(str)) {
            return 738197504;
        }
        if ("wa".equals(str)) {
            return 704643072;
        }
        if ("rw".equals(str)) {
            return 939524096;
        }
        if ("rwt".equals(str)) {
            return 1006632960;
        }
        throw new IllegalArgumentException("Invalid mode: " + str);
    }

    public static File KQgRr5e_0(File file, String... strArr) {
        for (String str : strArr) {
            if (str != null) {
                file = new File(file, str);
            }
        }
        return file;
    }

    public static String[] KQgRr5e_0(String[] strArr, int i) {
        String[] strArr2 = new String[i];
        System.arraycopy(strArr, 0, strArr2, 0, i);
        return strArr2;
    }

    public static Object[] KQgRr5e_0(Object[] objArr, int i) {
        Object[] objArr2 = new Object[i];
        System.arraycopy(objArr, 0, objArr2, 0, i);
        return objArr2;
    }
}
