package androidx.core.app;

import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobServiceEngine;
import android.app.job.JobWorkItem;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import java.util.ArrayList;
import java.util.HashMap;
/* loaded from: classes.dex */
public abstract class JobIntentService extends Service {
    public static final HashMap<ComponentName, FSaI4_7> KQgRr5e_0 = new HashMap<>();

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public FSaI4_7 f2223KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public KQgRr5e_0 f2224KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public QxJ9d_1 f2225KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final ArrayList<Mqv2r_3> f2226KQgRr5e_0;
    public boolean QxJ9d_1 = false;
    public boolean PGPF6hQ_2 = false;

    /* loaded from: classes.dex */
    public static abstract class FSaI4_7 {
        public int KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final ComponentName f2227KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public boolean f2228KQgRr5e_0;

        public FSaI4_7(ComponentName componentName) {
            this.f2227KQgRr5e_0 = componentName;
        }

        public void KQgRr5e_0() {
        }

        public void KQgRr5e_0(int i) {
            if (!this.f2228KQgRr5e_0) {
                this.f2228KQgRr5e_0 = true;
                this.KQgRr5e_0 = i;
            } else if (this.KQgRr5e_0 == i) {
            } else {
                throw new IllegalArgumentException("Given job ID " + i + " is different than previous " + this.KQgRr5e_0);
            }
        }

        public void PGPF6hQ_2() {
        }

        public void QxJ9d_1() {
        }
    }

    /* loaded from: classes.dex */
    public static final class IFxWkV_5 extends JobServiceEngine implements QxJ9d_1 {
        public JobParameters KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final JobIntentService f2229KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Object f2230KQgRr5e_0;

        /* loaded from: classes.dex */
        public final class KQgRr5e_0 implements X6FRs_4 {
            public final JobWorkItem KQgRr5e_0;

            public KQgRr5e_0(JobWorkItem jobWorkItem) {
                this.KQgRr5e_0 = jobWorkItem;
            }

            @Override // androidx.core.app.JobIntentService.X6FRs_4
            public void KQgRr5e_0() {
                synchronized (IFxWkV_5.this.f2230KQgRr5e_0) {
                    if (IFxWkV_5.this.KQgRr5e_0 != null) {
                        IFxWkV_5.this.KQgRr5e_0.completeWork(this.KQgRr5e_0);
                    }
                }
            }

            @Override // androidx.core.app.JobIntentService.X6FRs_4
            public Intent getIntent() {
                return this.KQgRr5e_0.getIntent();
            }
        }

        public IFxWkV_5(JobIntentService jobIntentService) {
            super(jobIntentService);
            this.f2230KQgRr5e_0 = new Object();
            this.f2229KQgRr5e_0 = jobIntentService;
        }

        @Override // androidx.core.app.JobIntentService.QxJ9d_1
        public IBinder KQgRr5e_0() {
            return getBinder();
        }

        @Override // android.app.job.JobServiceEngine
        public boolean onStartJob(JobParameters jobParameters) {
            this.KQgRr5e_0 = jobParameters;
            this.f2229KQgRr5e_0.KQgRr5e_0(false);
            return true;
        }

        @Override // android.app.job.JobServiceEngine
        public boolean onStopJob(JobParameters jobParameters) {
            boolean m867KQgRr5e_0 = this.f2229KQgRr5e_0.m867KQgRr5e_0();
            synchronized (this.f2230KQgRr5e_0) {
                this.KQgRr5e_0 = null;
            }
            return m867KQgRr5e_0;
        }

        @Override // androidx.core.app.JobIntentService.QxJ9d_1
        public X6FRs_4 KQgRr5e_0() {
            synchronized (this.f2230KQgRr5e_0) {
                if (this.KQgRr5e_0 == null) {
                    return null;
                }
                JobWorkItem dequeueWork = this.KQgRr5e_0.dequeueWork();
                if (dequeueWork != null) {
                    dequeueWork.getIntent().setExtrasClassLoader(this.f2229KQgRr5e_0.getClassLoader());
                    return new KQgRr5e_0(dequeueWork);
                }
                return null;
            }
        }
    }

    /* loaded from: classes.dex */
    public static final class IMuAHx_6 extends FSaI4_7 {
        public IMuAHx_6(Context context, ComponentName componentName, int i) {
            super(componentName);
            KQgRr5e_0(i);
            new JobInfo.Builder(i, ((FSaI4_7) this).f2227KQgRr5e_0).setOverrideDeadline(0L).build();
            JobScheduler jobScheduler = (JobScheduler) context.getApplicationContext().getSystemService("jobscheduler");
        }
    }

    /* loaded from: classes.dex */
    public final class Mqv2r_3 implements X6FRs_4 {
        public final int KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Intent f2232KQgRr5e_0;

        public Mqv2r_3(Intent intent, int i) {
            this.f2232KQgRr5e_0 = intent;
            this.KQgRr5e_0 = i;
        }

        @Override // androidx.core.app.JobIntentService.X6FRs_4
        public void KQgRr5e_0() {
            JobIntentService.this.stopSelf(this.KQgRr5e_0);
        }

        @Override // androidx.core.app.JobIntentService.X6FRs_4
        public Intent getIntent() {
            return this.f2232KQgRr5e_0;
        }
    }

    /* loaded from: classes.dex */
    public static final class PGPF6hQ_2 extends FSaI4_7 {
        public final PowerManager.WakeLock KQgRr5e_0;
        public boolean PGPF6hQ_2;
        public final PowerManager.WakeLock QxJ9d_1;

        /* renamed from: QxJ9d_1  reason: collision with other field name */
        public boolean f2234QxJ9d_1;

        public PGPF6hQ_2(Context context, ComponentName componentName) {
            super(componentName);
            context.getApplicationContext();
            PowerManager powerManager = (PowerManager) context.getSystemService("power");
            PowerManager.WakeLock newWakeLock = powerManager.newWakeLock(1, componentName.getClassName() + ":launch");
            this.KQgRr5e_0 = newWakeLock;
            newWakeLock.setReferenceCounted(false);
            PowerManager.WakeLock newWakeLock2 = powerManager.newWakeLock(1, componentName.getClassName() + ":run");
            this.QxJ9d_1 = newWakeLock2;
            newWakeLock2.setReferenceCounted(false);
        }

        @Override // androidx.core.app.JobIntentService.FSaI4_7
        public void KQgRr5e_0() {
            synchronized (this) {
                if (this.PGPF6hQ_2) {
                    if (this.f2234QxJ9d_1) {
                        this.KQgRr5e_0.acquire(60000L);
                    }
                    this.PGPF6hQ_2 = false;
                    this.QxJ9d_1.release();
                }
            }
        }

        @Override // androidx.core.app.JobIntentService.FSaI4_7
        public void PGPF6hQ_2() {
            synchronized (this) {
                this.f2234QxJ9d_1 = false;
            }
        }

        @Override // androidx.core.app.JobIntentService.FSaI4_7
        public void QxJ9d_1() {
            synchronized (this) {
                if (!this.PGPF6hQ_2) {
                    this.PGPF6hQ_2 = true;
                    this.QxJ9d_1.acquire(600000L);
                    this.KQgRr5e_0.release();
                }
            }
        }
    }

    /* loaded from: classes.dex */
    public interface QxJ9d_1 {
        IBinder KQgRr5e_0();

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        X6FRs_4 m868KQgRr5e_0();
    }

    /* loaded from: classes.dex */
    public interface X6FRs_4 {
        void KQgRr5e_0();

        Intent getIntent();
    }

    public JobIntentService() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.f2226KQgRr5e_0 = null;
        } else {
            this.f2226KQgRr5e_0 = new ArrayList<>();
        }
    }

    public static FSaI4_7 KQgRr5e_0(Context context, ComponentName componentName, boolean z, int i) {
        FSaI4_7 pGPF6hQ_2;
        FSaI4_7 fSaI4_7 = KQgRr5e_0.get(componentName);
        if (fSaI4_7 == null) {
            if (Build.VERSION.SDK_INT < 26) {
                pGPF6hQ_2 = new PGPF6hQ_2(context, componentName);
            } else if (z) {
                pGPF6hQ_2 = new IMuAHx_6(context, componentName, i);
            } else {
                throw new IllegalArgumentException("Can't be here without a job id");
            }
            FSaI4_7 fSaI4_72 = pGPF6hQ_2;
            KQgRr5e_0.put(componentName, fSaI4_72);
            return fSaI4_72;
        }
        return fSaI4_7;
    }

    public abstract void KQgRr5e_0(Intent intent);

    public boolean QxJ9d_1() {
        return true;
    }

    @Override // android.app.Service
    public IBinder onBind(Intent intent) {
        QxJ9d_1 qxJ9d_1 = this.f2225KQgRr5e_0;
        if (qxJ9d_1 != null) {
            return qxJ9d_1.KQgRr5e_0();
        }
        return null;
    }

    @Override // android.app.Service
    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 26) {
            this.f2225KQgRr5e_0 = new IFxWkV_5(this);
            this.f2223KQgRr5e_0 = null;
            return;
        }
        this.f2225KQgRr5e_0 = null;
        this.f2223KQgRr5e_0 = KQgRr5e_0(this, new ComponentName(this, JobIntentService.class), false, 0);
    }

    @Override // android.app.Service
    public void onDestroy() {
        super.onDestroy();
        ArrayList<Mqv2r_3> arrayList = this.f2226KQgRr5e_0;
        if (arrayList != null) {
            synchronized (arrayList) {
                this.PGPF6hQ_2 = true;
                this.f2223KQgRr5e_0.KQgRr5e_0();
            }
        }
    }

    @Override // android.app.Service
    public int onStartCommand(Intent intent, int i, int i2) {
        if (this.f2226KQgRr5e_0 != null) {
            this.f2223KQgRr5e_0.PGPF6hQ_2();
            synchronized (this.f2226KQgRr5e_0) {
                ArrayList<Mqv2r_3> arrayList = this.f2226KQgRr5e_0;
                if (intent == null) {
                    intent = new Intent();
                }
                arrayList.add(new Mqv2r_3(intent, i2));
                KQgRr5e_0(true);
            }
            return 3;
        }
        return 2;
    }

    /* loaded from: classes.dex */
    public final class KQgRr5e_0 extends AsyncTask<Void, Void, Void> {
        public KQgRr5e_0() {
        }

        @Override // android.os.AsyncTask
        /* renamed from: KQgRr5e_0 */
        public Void doInBackground(Void... voidArr) {
            while (true) {
                X6FRs_4 KQgRr5e_0 = JobIntentService.this.KQgRr5e_0();
                if (KQgRr5e_0 == null) {
                    return null;
                }
                JobIntentService.this.KQgRr5e_0(KQgRr5e_0.getIntent());
                KQgRr5e_0.KQgRr5e_0();
            }
        }

        @Override // android.os.AsyncTask
        /* renamed from: QxJ9d_1 */
        public void onPostExecute(Void r1) {
            JobIntentService.this.m866KQgRr5e_0();
        }

        @Override // android.os.AsyncTask
        /* renamed from: KQgRr5e_0 */
        public void onCancelled(Void r1) {
            JobIntentService.this.m866KQgRr5e_0();
        }
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public boolean m867KQgRr5e_0() {
        KQgRr5e_0 kQgRr5e_0 = this.f2224KQgRr5e_0;
        if (kQgRr5e_0 != null) {
            kQgRr5e_0.cancel(this.QxJ9d_1);
        }
        return QxJ9d_1();
    }

    public void KQgRr5e_0(boolean z) {
        if (this.f2224KQgRr5e_0 == null) {
            this.f2224KQgRr5e_0 = new KQgRr5e_0();
            FSaI4_7 fSaI4_7 = this.f2223KQgRr5e_0;
            if (fSaI4_7 != null && z) {
                fSaI4_7.QxJ9d_1();
            }
            this.f2224KQgRr5e_0.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public void m866KQgRr5e_0() {
        ArrayList<Mqv2r_3> arrayList = this.f2226KQgRr5e_0;
        if (arrayList != null) {
            synchronized (arrayList) {
                this.f2224KQgRr5e_0 = null;
                if (this.f2226KQgRr5e_0 != null && this.f2226KQgRr5e_0.size() > 0) {
                    KQgRr5e_0(false);
                } else if (!this.PGPF6hQ_2) {
                    this.f2223KQgRr5e_0.KQgRr5e_0();
                }
            }
        }
    }

    public X6FRs_4 KQgRr5e_0() {
        QxJ9d_1 qxJ9d_1 = this.f2225KQgRr5e_0;
        if (qxJ9d_1 != null) {
            return qxJ9d_1.m868KQgRr5e_0();
        }
        synchronized (this.f2226KQgRr5e_0) {
            if (this.f2226KQgRr5e_0.size() > 0) {
                return this.f2226KQgRr5e_0.remove(0);
            }
            return null;
        }
    }
}
