package androidx.coordinatorlayout.widget;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.JZJr_16;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.LGe8pk_15;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.XuVgy_28;
import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.customview.view.AbsSavedState;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/* loaded from: classes.dex */
public class CoordinatorLayout extends ViewGroup implements EuDEkJe_12 {
    public static final Class<?>[] CONSTRUCTOR_PARAMS;
    public static final int EVENT_NESTED_SCROLL = 1;
    public static final int EVENT_PRE_DRAW = 0;
    public static final int EVENT_VIEW_REMOVED = 2;
    public static final String TAG = "CoordinatorLayout";
    public static final Comparator<View> TOP_SORTED_CHILDREN_COMPARATOR;
    public static final int TYPE_ON_INTERCEPT = 0;
    public static final int TYPE_ON_TOUCH = 1;
    public static final String WIDGET_PACKAGE_NAME;
    public static final ThreadLocal<Map<String, Constructor<Behavior>>> sConstructors;
    public static final X6FRs_4.IMuAHx_6.KNBe_11.X6FRs_4<Rect> sRectPool;
    public JZJr_16 mApplyWindowInsetsListener;
    public View mBehaviorTouchView;
    public final X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<View> mChildDag;
    public final List<View> mDependencySortedChildren;
    public boolean mDisallowInterceptReset;
    public boolean mDrawStatusBarBackground;
    public boolean mIsAttachedToWindow;
    public int[] mKeylines;
    public XuVgy_28 mLastInsets;
    public boolean mNeedsPreDrawListener;
    public final LGe8pk_15 mNestedScrollingParentHelper;
    public View mNestedScrollingTarget;
    public ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;
    public IFxWkV_5 mOnPreDrawListener;
    public Paint mScrimPaint;
    public Drawable mStatusBarBackground;
    public final List<View> mTempDependenciesList;
    public final int[] mTempIntPair;
    public final List<View> mTempList1;

    /* loaded from: classes.dex */
    public static abstract class Behavior<V extends View> {
        public Behavior() {
        }

        public static Object getTag(View view) {
            return ((X6FRs_4) view.getLayoutParams()).f2215KQgRr5e_0;
        }

        public static void setTag(View view, Object obj) {
            ((X6FRs_4) view.getLayoutParams()).f2215KQgRr5e_0 = obj;
        }

        public boolean blocksInteractionBelow(CoordinatorLayout coordinatorLayout, V v) {
            return getScrimOpacity(coordinatorLayout, v) > 0.0f;
        }

        public boolean getInsetDodgeRect(CoordinatorLayout coordinatorLayout, V v, Rect rect) {
            return false;
        }

        public int getScrimColor(CoordinatorLayout coordinatorLayout, V v) {
            return -16777216;
        }

        public float getScrimOpacity(CoordinatorLayout coordinatorLayout, V v) {
            return 0.0f;
        }

        public boolean layoutDependsOn(CoordinatorLayout coordinatorLayout, V v, View view) {
            return false;
        }

        public XuVgy_28 onApplyWindowInsets(CoordinatorLayout coordinatorLayout, V v, XuVgy_28 xuVgy_28) {
            return xuVgy_28;
        }

        public void onAttachedToLayoutParams(X6FRs_4 x6FRs_4) {
        }

        public boolean onDependentViewChanged(CoordinatorLayout coordinatorLayout, V v, View view) {
            return false;
        }

        public void onDependentViewRemoved(CoordinatorLayout coordinatorLayout, V v, View view) {
        }

        public void onDetachedFromLayoutParams() {
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
            return false;
        }

        public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v, int i) {
            return false;
        }

        public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, V v, int i, int i2, int i3, int i4) {
            return false;
        }

        public boolean onNestedFling(CoordinatorLayout coordinatorLayout, V v, View view, float f, float f2, boolean z) {
            return false;
        }

        public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V v, View view, float f, float f2) {
            return false;
        }

        @Deprecated
        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int[] iArr) {
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int[] iArr, int i3) {
            if (i3 == 0) {
                onNestedPreScroll(coordinatorLayout, v, view, i, i2, iArr);
            }
        }

        @Deprecated
        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int i3, int i4) {
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int i3, int i4, int i5) {
            if (i5 == 0) {
                onNestedScroll(coordinatorLayout, v, view, i, i2, i3, i4);
            }
        }

        @Deprecated
        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int i) {
        }

        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int i, int i2) {
            if (i2 == 0) {
                onNestedScrollAccepted(coordinatorLayout, v, view, view2, i);
            }
        }

        public boolean onRequestChildRectangleOnScreen(CoordinatorLayout coordinatorLayout, V v, Rect rect, boolean z) {
            return false;
        }

        public void onRestoreInstanceState(CoordinatorLayout coordinatorLayout, V v, Parcelable parcelable) {
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout coordinatorLayout, V v) {
            return View.BaseSavedState.EMPTY_STATE;
        }

        @Deprecated
        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int i) {
            return false;
        }

        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int i, int i2) {
            if (i2 == 0) {
                return onStartNestedScroll(coordinatorLayout, v, view, view2, i);
            }
            return false;
        }

        @Deprecated
        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view) {
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i) {
            if (i == 0) {
                onStopNestedScroll(coordinatorLayout, v, view);
            }
        }

        public boolean onTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
            return false;
        }

        public Behavior(Context context, AttributeSet attributeSet) {
        }
    }

    /* loaded from: classes.dex */
    public class IFxWkV_5 implements ViewTreeObserver.OnPreDrawListener {
        public IFxWkV_5() {
        }

        @Override // android.view.ViewTreeObserver.OnPreDrawListener
        public boolean onPreDraw() {
            CoordinatorLayout.this.onChildViewsChanged(0);
            return true;
        }
    }

    /* loaded from: classes.dex */
    public static class IMuAHx_6 implements Comparator<View> {
        @Override // java.util.Comparator
        /* renamed from: KQgRr5e_0 */
        public int compare(View view, View view2) {
            float PGPF6hQ_2 = ZzDuCHW_20.PGPF6hQ_2(view);
            float PGPF6hQ_22 = ZzDuCHW_20.PGPF6hQ_2(view2);
            if (PGPF6hQ_2 > PGPF6hQ_22) {
                return -1;
            }
            return PGPF6hQ_2 < PGPF6hQ_22 ? 1 : 0;
        }
    }

    /* loaded from: classes.dex */
    public class KQgRr5e_0 implements JZJr_16 {
        public KQgRr5e_0() {
        }

        @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.JZJr_16
        public XuVgy_28 onApplyWindowInsets(View view, XuVgy_28 xuVgy_28) {
            return CoordinatorLayout.this.setWindowInsets(xuVgy_28);
        }
    }

    /* loaded from: classes.dex */
    public class Mqv2r_3 implements ViewGroup.OnHierarchyChangeListener {
        public Mqv2r_3() {
        }

        @Override // android.view.ViewGroup.OnHierarchyChangeListener
        public void onChildViewAdded(View view, View view2) {
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = CoordinatorLayout.this.mOnHierarchyChangeListener;
            if (onHierarchyChangeListener != null) {
                onHierarchyChangeListener.onChildViewAdded(view, view2);
            }
        }

        @Override // android.view.ViewGroup.OnHierarchyChangeListener
        public void onChildViewRemoved(View view, View view2) {
            CoordinatorLayout.this.onChildViewsChanged(2);
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = CoordinatorLayout.this.mOnHierarchyChangeListener;
            if (onHierarchyChangeListener != null) {
                onHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Deprecated
    /* loaded from: classes.dex */
    public @interface PGPF6hQ_2 {
        Class<? extends Behavior> value();
    }

    /* loaded from: classes.dex */
    public interface QxJ9d_1 {
        Behavior getBehavior();
    }

    /* loaded from: classes.dex */
    public static class X6FRs_4 extends ViewGroup.MarginLayoutParams {

        /* renamed from: FSaI4_7  reason: collision with root package name */
        public int f3504FSaI4_7;

        /* renamed from: IFxWkV_5  reason: collision with root package name */
        public int f3505IFxWkV_5;

        /* renamed from: IMuAHx_6  reason: collision with root package name */
        public int f3506IMuAHx_6;
        public int KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Rect f2212KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public View f2213KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public Behavior f2214KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public Object f2215KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public boolean f2216KQgRr5e_0;

        /* renamed from: Mqv2r_3  reason: collision with root package name */
        public int f3507Mqv2r_3;

        /* renamed from: Mqv2r_3  reason: collision with other field name */
        public boolean f2217Mqv2r_3;
        public int PGPF6hQ_2;

        /* renamed from: PGPF6hQ_2  reason: collision with other field name */
        public boolean f2218PGPF6hQ_2;
        public int QxJ9d_1;

        /* renamed from: QxJ9d_1  reason: collision with other field name */
        public View f2219QxJ9d_1;

        /* renamed from: QxJ9d_1  reason: collision with other field name */
        public boolean f2220QxJ9d_1;

        /* renamed from: X6FRs_4  reason: collision with root package name */
        public int f3508X6FRs_4;

        /* renamed from: X6FRs_4  reason: collision with other field name */
        public boolean f2221X6FRs_4;

        public X6FRs_4(int i, int i2) {
            super(i, i2);
            this.f2216KQgRr5e_0 = false;
            this.KQgRr5e_0 = 0;
            this.QxJ9d_1 = 0;
            this.PGPF6hQ_2 = -1;
            this.f3507Mqv2r_3 = -1;
            this.f3508X6FRs_4 = 0;
            this.f3505IFxWkV_5 = 0;
            this.f2212KQgRr5e_0 = new Rect();
        }

        public int KQgRr5e_0() {
            return this.f3507Mqv2r_3;
        }

        public boolean PGPF6hQ_2() {
            return this.f2221X6FRs_4;
        }

        /* renamed from: QxJ9d_1  reason: collision with other method in class */
        public boolean m865QxJ9d_1() {
            if (this.f2214KQgRr5e_0 == null) {
                this.f2220QxJ9d_1 = false;
            }
            return this.f2220QxJ9d_1;
        }

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        public Behavior m859KQgRr5e_0() {
            return this.f2214KQgRr5e_0;
        }

        public void KQgRr5e_0(Behavior behavior) {
            Behavior behavior2 = this.f2214KQgRr5e_0;
            if (behavior2 != behavior) {
                if (behavior2 != null) {
                    behavior2.onDetachedFromLayoutParams();
                }
                this.f2214KQgRr5e_0 = behavior;
                this.f2215KQgRr5e_0 = null;
                this.f2216KQgRr5e_0 = true;
                if (behavior != null) {
                    behavior.onAttachedToLayoutParams(this);
                }
            }
        }

        public void QxJ9d_1() {
            this.f2220QxJ9d_1 = false;
        }

        public void KQgRr5e_0(Rect rect) {
            this.f2212KQgRr5e_0.set(rect);
        }

        public X6FRs_4(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.f2216KQgRr5e_0 = false;
            this.KQgRr5e_0 = 0;
            this.QxJ9d_1 = 0;
            this.PGPF6hQ_2 = -1;
            this.f3507Mqv2r_3 = -1;
            this.f3508X6FRs_4 = 0;
            this.f3505IFxWkV_5 = 0;
            this.f2212KQgRr5e_0 = new Rect();
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout);
            this.KQgRr5e_0 = obtainStyledAttributes.getInteger(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout_android_layout_gravity, 0);
            this.f3507Mqv2r_3 = obtainStyledAttributes.getResourceId(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout_layout_anchor, -1);
            this.QxJ9d_1 = obtainStyledAttributes.getInteger(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout_layout_anchorGravity, 0);
            this.PGPF6hQ_2 = obtainStyledAttributes.getInteger(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout_layout_keyline, -1);
            this.f3508X6FRs_4 = obtainStyledAttributes.getInt(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout_layout_insetEdge, 0);
            this.f3505IFxWkV_5 = obtainStyledAttributes.getInt(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout_layout_dodgeInsetEdges, 0);
            boolean hasValue = obtainStyledAttributes.hasValue(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout_layout_behavior);
            this.f2216KQgRr5e_0 = hasValue;
            if (hasValue) {
                this.f2214KQgRr5e_0 = CoordinatorLayout.parseBehavior(context, attributeSet, obtainStyledAttributes.getString(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_Layout_layout_behavior));
            }
            obtainStyledAttributes.recycle();
            Behavior behavior = this.f2214KQgRr5e_0;
            if (behavior != null) {
                behavior.onAttachedToLayoutParams(this);
            }
        }

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        public Rect m858KQgRr5e_0() {
            return this.f2212KQgRr5e_0;
        }

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        public boolean m861KQgRr5e_0() {
            return this.f2213KQgRr5e_0 == null && this.f3507Mqv2r_3 != -1;
        }

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        public boolean m864KQgRr5e_0(CoordinatorLayout coordinatorLayout, View view) {
            boolean z = this.f2220QxJ9d_1;
            if (z) {
                return true;
            }
            Behavior behavior = this.f2214KQgRr5e_0;
            boolean blocksInteractionBelow = (behavior != null ? behavior.blocksInteractionBelow(coordinatorLayout, view) : false) | z;
            this.f2220QxJ9d_1 = blocksInteractionBelow;
            return blocksInteractionBelow;
        }

        public void KQgRr5e_0(int i) {
            KQgRr5e_0(i, false);
        }

        public void KQgRr5e_0(int i, boolean z) {
            if (i == 0) {
                this.f2218PGPF6hQ_2 = z;
            } else if (i != 1) {
            } else {
                this.f2217Mqv2r_3 = z;
            }
        }

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        public boolean m862KQgRr5e_0(int i) {
            if (i != 0) {
                if (i != 1) {
                    return false;
                }
                return this.f2217Mqv2r_3;
            }
            return this.f2218PGPF6hQ_2;
        }

        public void KQgRr5e_0(boolean z) {
            this.f2221X6FRs_4 = z;
        }

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        public void m860KQgRr5e_0() {
            this.f2221X6FRs_4 = false;
        }

        public boolean KQgRr5e_0(CoordinatorLayout coordinatorLayout, View view, View view2) {
            Behavior behavior;
            return view2 == this.f2219QxJ9d_1 || KQgRr5e_0(view2, ZzDuCHW_20.Mqv2r_3((View) coordinatorLayout)) || ((behavior = this.f2214KQgRr5e_0) != null && behavior.layoutDependsOn(coordinatorLayout, view, view2));
        }

        public View KQgRr5e_0(CoordinatorLayout coordinatorLayout, View view) {
            if (this.f3507Mqv2r_3 == -1) {
                this.f2219QxJ9d_1 = null;
                this.f2213KQgRr5e_0 = null;
                return null;
            }
            if (this.f2213KQgRr5e_0 == null || !m863KQgRr5e_0(view, coordinatorLayout)) {
                KQgRr5e_0(view, coordinatorLayout);
            }
            return this.f2213KQgRr5e_0;
        }

        public final void KQgRr5e_0(View view, CoordinatorLayout coordinatorLayout) {
            View findViewById = coordinatorLayout.findViewById(this.f3507Mqv2r_3);
            this.f2213KQgRr5e_0 = findViewById;
            if (findViewById == null) {
                if (coordinatorLayout.isInEditMode()) {
                    this.f2219QxJ9d_1 = null;
                    this.f2213KQgRr5e_0 = null;
                    return;
                }
                throw new IllegalStateException("Could not find CoordinatorLayout descendant view with id " + coordinatorLayout.getResources().getResourceName(this.f3507Mqv2r_3) + " to anchor view " + view);
            } else if (findViewById == coordinatorLayout) {
                if (coordinatorLayout.isInEditMode()) {
                    this.f2219QxJ9d_1 = null;
                    this.f2213KQgRr5e_0 = null;
                    return;
                }
                throw new IllegalStateException("View can not be anchored to the the parent CoordinatorLayout");
            } else {
                for (ViewParent parent = findViewById.getParent(); parent != coordinatorLayout && parent != null; parent = parent.getParent()) {
                    if (parent == view) {
                        if (coordinatorLayout.isInEditMode()) {
                            this.f2219QxJ9d_1 = null;
                            this.f2213KQgRr5e_0 = null;
                            return;
                        }
                        throw new IllegalStateException("Anchor must not be a descendant of the anchored view");
                    }
                    if (parent instanceof View) {
                        findViewById = (View) parent;
                    }
                }
                this.f2219QxJ9d_1 = findViewById;
            }
        }

        public X6FRs_4(X6FRs_4 x6FRs_4) {
            super((ViewGroup.MarginLayoutParams) x6FRs_4);
            this.f2216KQgRr5e_0 = false;
            this.KQgRr5e_0 = 0;
            this.QxJ9d_1 = 0;
            this.PGPF6hQ_2 = -1;
            this.f3507Mqv2r_3 = -1;
            this.f3508X6FRs_4 = 0;
            this.f3505IFxWkV_5 = 0;
            this.f2212KQgRr5e_0 = new Rect();
        }

        public X6FRs_4(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.f2216KQgRr5e_0 = false;
            this.KQgRr5e_0 = 0;
            this.QxJ9d_1 = 0;
            this.PGPF6hQ_2 = -1;
            this.f3507Mqv2r_3 = -1;
            this.f3508X6FRs_4 = 0;
            this.f3505IFxWkV_5 = 0;
            this.f2212KQgRr5e_0 = new Rect();
        }

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        public final boolean m863KQgRr5e_0(View view, CoordinatorLayout coordinatorLayout) {
            if (this.f2213KQgRr5e_0.getId() != this.f3507Mqv2r_3) {
                return false;
            }
            View view2 = this.f2213KQgRr5e_0;
            for (ViewParent parent = view2.getParent(); parent != coordinatorLayout; parent = parent.getParent()) {
                if (parent != null && parent != view) {
                    if (parent instanceof View) {
                        view2 = (View) parent;
                    }
                } else {
                    this.f2219QxJ9d_1 = null;
                    this.f2213KQgRr5e_0 = null;
                    return false;
                }
            }
            this.f2219QxJ9d_1 = view2;
            return true;
        }

        public X6FRs_4(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.f2216KQgRr5e_0 = false;
            this.KQgRr5e_0 = 0;
            this.QxJ9d_1 = 0;
            this.PGPF6hQ_2 = -1;
            this.f3507Mqv2r_3 = -1;
            this.f3508X6FRs_4 = 0;
            this.f3505IFxWkV_5 = 0;
            this.f2212KQgRr5e_0 = new Rect();
        }

        public final boolean KQgRr5e_0(View view, int i) {
            int KQgRr5e_0 = X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(((X6FRs_4) view.getLayoutParams()).f3508X6FRs_4, i);
            return KQgRr5e_0 != 0 && (X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(this.f3505IFxWkV_5, i) & KQgRr5e_0) == KQgRr5e_0;
        }
    }

    static {
        Package r0 = CoordinatorLayout.class.getPackage();
        WIDGET_PACKAGE_NAME = r0 != null ? r0.getName() : null;
        if (Build.VERSION.SDK_INT >= 21) {
            TOP_SORTED_CHILDREN_COMPARATOR = new IMuAHx_6();
        } else {
            TOP_SORTED_CHILDREN_COMPARATOR = null;
        }
        CONSTRUCTOR_PARAMS = new Class[]{Context.class, AttributeSet.class};
        sConstructors = new ThreadLocal<>();
        sRectPool = new X6FRs_4.IMuAHx_6.KNBe_11.IMuAHx_6(12);
    }

    public CoordinatorLayout(Context context) {
        this(context, null);
    }

    public static Rect acquireTempRect() {
        Rect KQgRr5e_02 = sRectPool.KQgRr5e_0();
        return KQgRr5e_02 == null ? new Rect() : KQgRr5e_02;
    }

    public static int clamp(int i, int i2, int i3) {
        return i < i2 ? i2 : i > i3 ? i3 : i;
    }

    private void constrainChildRect(X6FRs_4 x6FRs_4, Rect rect, int i, int i2) {
        int width = getWidth();
        int height = getHeight();
        int max = Math.max(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) x6FRs_4).leftMargin, Math.min(rect.left, ((width - getPaddingRight()) - i) - ((ViewGroup.MarginLayoutParams) x6FRs_4).rightMargin));
        int max2 = Math.max(getPaddingTop() + ((ViewGroup.MarginLayoutParams) x6FRs_4).topMargin, Math.min(rect.top, ((height - getPaddingBottom()) - i2) - ((ViewGroup.MarginLayoutParams) x6FRs_4).bottomMargin));
        rect.set(max, max2, i + max, i2 + max2);
    }

    private XuVgy_28 dispatchApplyWindowInsetsToBehaviors(XuVgy_28 xuVgy_28) {
        Behavior m859KQgRr5e_0;
        if (xuVgy_28.m247QxJ9d_1()) {
            return xuVgy_28;
        }
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (ZzDuCHW_20.m263KQgRr5e_0(childAt) && (m859KQgRr5e_0 = ((X6FRs_4) childAt.getLayoutParams()).m859KQgRr5e_0()) != null) {
                xuVgy_28 = m859KQgRr5e_0.onApplyWindowInsets(this, childAt, xuVgy_28);
                if (xuVgy_28.m247QxJ9d_1()) {
                    break;
                }
            }
        }
        return xuVgy_28;
    }

    private void getDesiredAnchoredChildRectWithoutConstraints(View view, int i, Rect rect, Rect rect2, X6FRs_4 x6FRs_4, int i2, int i3) {
        int width;
        int height;
        int KQgRr5e_02 = X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(resolveAnchoredChildGravity(x6FRs_4.KQgRr5e_0), i);
        int KQgRr5e_03 = X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(resolveGravity(x6FRs_4.QxJ9d_1), i);
        int i4 = KQgRr5e_02 & 7;
        int i5 = KQgRr5e_02 & 112;
        int i6 = KQgRr5e_03 & 7;
        int i7 = KQgRr5e_03 & 112;
        if (i6 == 1) {
            width = rect.left + (rect.width() / 2);
        } else if (i6 != 5) {
            width = rect.left;
        } else {
            width = rect.right;
        }
        if (i7 == 16) {
            height = rect.top + (rect.height() / 2);
        } else if (i7 != 80) {
            height = rect.top;
        } else {
            height = rect.bottom;
        }
        if (i4 == 1) {
            width -= i2 / 2;
        } else if (i4 != 5) {
            width -= i2;
        }
        if (i5 == 16) {
            height -= i3 / 2;
        } else if (i5 != 80) {
            height -= i3;
        }
        rect2.set(width, height, i2 + width, i3 + height);
    }

    private int getKeyline(int i) {
        int[] iArr = this.mKeylines;
        if (iArr == null) {
            Log.e(TAG, "No keylines defined for " + this + " - attempted index lookup " + i);
            return 0;
        } else if (i >= 0 && i < iArr.length) {
            return iArr[i];
        } else {
            Log.e(TAG, "Keyline index " + i + " out of range for " + this);
            return 0;
        }
    }

    private void getTopSortedChildren(List<View> list) {
        list.clear();
        boolean isChildrenDrawingOrderEnabled = isChildrenDrawingOrderEnabled();
        int childCount = getChildCount();
        for (int i = childCount - 1; i >= 0; i--) {
            list.add(getChildAt(isChildrenDrawingOrderEnabled ? getChildDrawingOrder(childCount, i) : i));
        }
        Comparator<View> comparator = TOP_SORTED_CHILDREN_COMPARATOR;
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    private boolean hasDependencies(View view) {
        return this.mChildDag.m215QxJ9d_1((X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<View>) view);
    }

    private void layoutChild(View view, int i) {
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        Rect acquireTempRect = acquireTempRect();
        acquireTempRect.set(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) x6FRs_4).leftMargin, getPaddingTop() + ((ViewGroup.MarginLayoutParams) x6FRs_4).topMargin, (getWidth() - getPaddingRight()) - ((ViewGroup.MarginLayoutParams) x6FRs_4).rightMargin, (getHeight() - getPaddingBottom()) - ((ViewGroup.MarginLayoutParams) x6FRs_4).bottomMargin);
        if (this.mLastInsets != null && ZzDuCHW_20.m263KQgRr5e_0((View) this) && !ZzDuCHW_20.m263KQgRr5e_0(view)) {
            acquireTempRect.left += this.mLastInsets.QxJ9d_1();
            acquireTempRect.top += this.mLastInsets.Mqv2r_3();
            acquireTempRect.right -= this.mLastInsets.PGPF6hQ_2();
            acquireTempRect.bottom -= this.mLastInsets.KQgRr5e_0();
        }
        Rect acquireTempRect2 = acquireTempRect();
        X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(resolveGravity(x6FRs_4.KQgRr5e_0), view.getMeasuredWidth(), view.getMeasuredHeight(), acquireTempRect, acquireTempRect2, i);
        view.layout(acquireTempRect2.left, acquireTempRect2.top, acquireTempRect2.right, acquireTempRect2.bottom);
        releaseTempRect(acquireTempRect);
        releaseTempRect(acquireTempRect2);
    }

    private void layoutChildWithAnchor(View view, View view2, int i) {
        Rect acquireTempRect = acquireTempRect();
        Rect acquireTempRect2 = acquireTempRect();
        try {
            getDescendantRect(view2, acquireTempRect);
            getDesiredAnchoredChildRect(view, i, acquireTempRect, acquireTempRect2);
            view.layout(acquireTempRect2.left, acquireTempRect2.top, acquireTempRect2.right, acquireTempRect2.bottom);
        } finally {
            releaseTempRect(acquireTempRect);
            releaseTempRect(acquireTempRect2);
        }
    }

    private void layoutChildWithKeyline(View view, int i, int i2) {
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        int KQgRr5e_02 = X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(resolveKeylineGravity(x6FRs_4.KQgRr5e_0), i2);
        int i3 = KQgRr5e_02 & 7;
        int i4 = KQgRr5e_02 & 112;
        int width = getWidth();
        int height = getHeight();
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        if (i2 == 1) {
            i = width - i;
        }
        int keyline = getKeyline(i) - measuredWidth;
        int i5 = 0;
        if (i3 == 1) {
            keyline += measuredWidth / 2;
        } else if (i3 == 5) {
            keyline += measuredWidth;
        }
        if (i4 == 16) {
            i5 = 0 + (measuredHeight / 2);
        } else if (i4 == 80) {
            i5 = measuredHeight + 0;
        }
        int max = Math.max(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) x6FRs_4).leftMargin, Math.min(keyline, ((width - getPaddingRight()) - measuredWidth) - ((ViewGroup.MarginLayoutParams) x6FRs_4).rightMargin));
        int max2 = Math.max(getPaddingTop() + ((ViewGroup.MarginLayoutParams) x6FRs_4).topMargin, Math.min(i5, ((height - getPaddingBottom()) - measuredHeight) - ((ViewGroup.MarginLayoutParams) x6FRs_4).bottomMargin));
        view.layout(max, max2, measuredWidth + max, measuredHeight + max2);
    }

    private void offsetChildByInset(View view, Rect rect, int i) {
        boolean z;
        boolean z2;
        int width;
        int i2;
        int i3;
        int i4;
        int height;
        int i5;
        int i6;
        int i7;
        if (ZzDuCHW_20.m248FSaI4_7(view) && view.getWidth() > 0 && view.getHeight() > 0) {
            X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
            Behavior m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0();
            Rect acquireTempRect = acquireTempRect();
            Rect acquireTempRect2 = acquireTempRect();
            acquireTempRect2.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            if (m859KQgRr5e_0 != null && m859KQgRr5e_0.getInsetDodgeRect(this, view, acquireTempRect)) {
                if (!acquireTempRect2.contains(acquireTempRect)) {
                    throw new IllegalArgumentException("Rect should be within the child's bounds. Rect:" + acquireTempRect.toShortString() + " | Bounds:" + acquireTempRect2.toShortString());
                }
            } else {
                acquireTempRect.set(acquireTempRect2);
            }
            releaseTempRect(acquireTempRect2);
            if (acquireTempRect.isEmpty()) {
                releaseTempRect(acquireTempRect);
                return;
            }
            int KQgRr5e_02 = X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(x6FRs_4.f3505IFxWkV_5, i);
            boolean z3 = true;
            if ((KQgRr5e_02 & 48) != 48 || (i6 = (acquireTempRect.top - ((ViewGroup.MarginLayoutParams) x6FRs_4).topMargin) - x6FRs_4.f3504FSaI4_7) >= (i7 = rect.top)) {
                z = false;
            } else {
                setInsetOffsetY(view, i7 - i6);
                z = true;
            }
            if ((KQgRr5e_02 & 80) == 80 && (height = ((getHeight() - acquireTempRect.bottom) - ((ViewGroup.MarginLayoutParams) x6FRs_4).bottomMargin) + x6FRs_4.f3504FSaI4_7) < (i5 = rect.bottom)) {
                setInsetOffsetY(view, height - i5);
                z = true;
            }
            if (!z) {
                setInsetOffsetY(view, 0);
            }
            if ((KQgRr5e_02 & 3) != 3 || (i3 = (acquireTempRect.left - ((ViewGroup.MarginLayoutParams) x6FRs_4).leftMargin) - x6FRs_4.f3506IMuAHx_6) >= (i4 = rect.left)) {
                z2 = false;
            } else {
                setInsetOffsetX(view, i4 - i3);
                z2 = true;
            }
            if ((KQgRr5e_02 & 5) != 5 || (width = ((getWidth() - acquireTempRect.right) - ((ViewGroup.MarginLayoutParams) x6FRs_4).rightMargin) + x6FRs_4.f3506IMuAHx_6) >= (i2 = rect.right)) {
                z3 = z2;
            } else {
                setInsetOffsetX(view, width - i2);
            }
            if (!z3) {
                setInsetOffsetX(view, 0);
            }
            releaseTempRect(acquireTempRect);
        }
    }

    public static Behavior parseBehavior(Context context, AttributeSet attributeSet, String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        if (str.startsWith(".")) {
            str = context.getPackageName() + str;
        } else if (str.indexOf(46) < 0 && !TextUtils.isEmpty(WIDGET_PACKAGE_NAME)) {
            str = WIDGET_PACKAGE_NAME + '.' + str;
        }
        try {
            Map<String, Constructor<Behavior>> map = sConstructors.get();
            if (map == null) {
                map = new HashMap<>();
                sConstructors.set(map);
            }
            Constructor<Behavior> constructor = map.get(str);
            if (constructor == null) {
                constructor = context.getClassLoader().loadClass(str).getConstructor(CONSTRUCTOR_PARAMS);
                constructor.setAccessible(true);
                map.put(str, constructor);
            }
            return (Behavior) constructor.newInstance(context, attributeSet);
        } catch (Exception e) {
            throw new RuntimeException("Could not inflate Behavior subclass " + str, e);
        }
    }

    private boolean performIntercept(MotionEvent motionEvent, int i) {
        int actionMasked = motionEvent.getActionMasked();
        List<View> list = this.mTempList1;
        getTopSortedChildren(list);
        int size = list.size();
        MotionEvent motionEvent2 = null;
        boolean z = false;
        boolean z2 = false;
        for (int i2 = 0; i2 < size; i2++) {
            View view = list.get(i2);
            X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
            Behavior m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0();
            if (!(z || z2) || actionMasked == 0) {
                if (!z && m859KQgRr5e_0 != null) {
                    if (i == 0) {
                        z = m859KQgRr5e_0.onInterceptTouchEvent(this, view, motionEvent);
                    } else if (i == 1) {
                        z = m859KQgRr5e_0.onTouchEvent(this, view, motionEvent);
                    }
                    if (z) {
                        this.mBehaviorTouchView = view;
                    }
                }
                boolean m865QxJ9d_1 = x6FRs_4.m865QxJ9d_1();
                boolean m864KQgRr5e_0 = x6FRs_4.m864KQgRr5e_0(this, view);
                z2 = m864KQgRr5e_0 && !m865QxJ9d_1;
                if (m864KQgRr5e_0 && !z2) {
                    break;
                }
            } else if (m859KQgRr5e_0 != null) {
                if (motionEvent2 == null) {
                    long uptimeMillis = SystemClock.uptimeMillis();
                    motionEvent2 = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                }
                if (i == 0) {
                    m859KQgRr5e_0.onInterceptTouchEvent(this, view, motionEvent2);
                } else if (i == 1) {
                    m859KQgRr5e_0.onTouchEvent(this, view, motionEvent2);
                }
            }
        }
        list.clear();
        return z;
    }

    private void prepareChildren() {
        this.mDependencySortedChildren.clear();
        this.mChildDag.m212KQgRr5e_0();
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            X6FRs_4 resolvedLayoutParams = getResolvedLayoutParams(childAt);
            resolvedLayoutParams.KQgRr5e_0(this, childAt);
            this.mChildDag.m213KQgRr5e_0((X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<View>) childAt);
            for (int i2 = 0; i2 < childCount; i2++) {
                if (i2 != i) {
                    View childAt2 = getChildAt(i2);
                    if (resolvedLayoutParams.KQgRr5e_0(this, childAt, childAt2)) {
                        if (!this.mChildDag.m214KQgRr5e_0((X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<View>) childAt2)) {
                            this.mChildDag.m213KQgRr5e_0((X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<View>) childAt2);
                        }
                        this.mChildDag.KQgRr5e_0(childAt2, childAt);
                    }
                }
            }
        }
        this.mDependencySortedChildren.addAll(this.mChildDag.QxJ9d_1());
        Collections.reverse(this.mDependencySortedChildren);
    }

    public static void releaseTempRect(Rect rect) {
        rect.setEmpty();
        sRectPool.KQgRr5e_0(rect);
    }

    private void resetTouchBehaviors(boolean z) {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            Behavior m859KQgRr5e_0 = ((X6FRs_4) childAt.getLayoutParams()).m859KQgRr5e_0();
            if (m859KQgRr5e_0 != null) {
                long uptimeMillis = SystemClock.uptimeMillis();
                MotionEvent obtain = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                if (z) {
                    m859KQgRr5e_0.onInterceptTouchEvent(this, childAt, obtain);
                } else {
                    m859KQgRr5e_0.onTouchEvent(this, childAt, obtain);
                }
                obtain.recycle();
            }
        }
        for (int i2 = 0; i2 < childCount; i2++) {
            ((X6FRs_4) getChildAt(i2).getLayoutParams()).QxJ9d_1();
        }
        this.mBehaviorTouchView = null;
        this.mDisallowInterceptReset = false;
    }

    public static int resolveAnchoredChildGravity(int i) {
        if (i == 0) {
            return 17;
        }
        return i;
    }

    public static int resolveGravity(int i) {
        if ((i & 7) == 0) {
            i |= 8388611;
        }
        return (i & 112) == 0 ? i | 48 : i;
    }

    public static int resolveKeylineGravity(int i) {
        if (i == 0) {
            return 8388661;
        }
        return i;
    }

    private void setInsetOffsetX(View view, int i) {
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        int i2 = x6FRs_4.f3506IMuAHx_6;
        if (i2 != i) {
            ZzDuCHW_20.Mqv2r_3(view, i - i2);
            x6FRs_4.f3506IMuAHx_6 = i;
        }
    }

    private void setInsetOffsetY(View view, int i) {
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        int i2 = x6FRs_4.f3504FSaI4_7;
        if (i2 != i) {
            ZzDuCHW_20.X6FRs_4(view, i - i2);
            x6FRs_4.f3504FSaI4_7 = i;
        }
    }

    private void setupForInsets() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (ZzDuCHW_20.m263KQgRr5e_0((View) this)) {
            if (this.mApplyWindowInsetsListener == null) {
                this.mApplyWindowInsetsListener = new KQgRr5e_0();
            }
            ZzDuCHW_20.KQgRr5e_0(this, this.mApplyWindowInsetsListener);
            setSystemUiVisibility(1280);
            return;
        }
        ZzDuCHW_20.KQgRr5e_0(this, (JZJr_16) null);
    }

    public void addPreDrawListener() {
        if (this.mIsAttachedToWindow) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new IFxWkV_5();
            }
            getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = true;
    }

    @Override // android.view.ViewGroup
    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof X6FRs_4) && super.checkLayoutParams(layoutParams);
    }

    public void dispatchDependentViewsChanged(View view) {
        List KQgRr5e_02 = this.mChildDag.KQgRr5e_0((X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<View>) view);
        if (KQgRr5e_02 == null || KQgRr5e_02.isEmpty()) {
            return;
        }
        for (int i = 0; i < KQgRr5e_02.size(); i++) {
            View view2 = (View) KQgRr5e_02.get(i);
            Behavior m859KQgRr5e_0 = ((X6FRs_4) view2.getLayoutParams()).m859KQgRr5e_0();
            if (m859KQgRr5e_0 != null) {
                m859KQgRr5e_0.onDependentViewChanged(this, view2, view);
            }
        }
    }

    public boolean doViewsOverlap(View view, View view2) {
        boolean z = false;
        if (view.getVisibility() == 0 && view2.getVisibility() == 0) {
            Rect acquireTempRect = acquireTempRect();
            getChildRect(view, view.getParent() != this, acquireTempRect);
            Rect acquireTempRect2 = acquireTempRect();
            getChildRect(view2, view2.getParent() != this, acquireTempRect2);
            try {
                if (acquireTempRect.left <= acquireTempRect2.right && acquireTempRect.top <= acquireTempRect2.bottom && acquireTempRect.right >= acquireTempRect2.left) {
                    if (acquireTempRect.bottom >= acquireTempRect2.top) {
                        z = true;
                    }
                }
                return z;
            } finally {
                releaseTempRect(acquireTempRect);
                releaseTempRect(acquireTempRect2);
            }
        }
        return false;
    }

    @Override // android.view.ViewGroup
    public boolean drawChild(Canvas canvas, View view, long j) {
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        Behavior behavior = x6FRs_4.f2214KQgRr5e_0;
        if (behavior != null) {
            float scrimOpacity = behavior.getScrimOpacity(this, view);
            if (scrimOpacity > 0.0f) {
                if (this.mScrimPaint == null) {
                    this.mScrimPaint = new Paint();
                }
                this.mScrimPaint.setColor(x6FRs_4.f2214KQgRr5e_0.getScrimColor(this, view));
                this.mScrimPaint.setAlpha(clamp(Math.round(scrimOpacity * 255.0f), 0, 255));
                int save = canvas.save();
                if (view.isOpaque()) {
                    canvas.clipRect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), Region.Op.DIFFERENCE);
                }
                canvas.drawRect(getPaddingLeft(), getPaddingTop(), getWidth() - getPaddingRight(), getHeight() - getPaddingBottom(), this.mScrimPaint);
                canvas.restoreToCount(save);
            }
        }
        return super.drawChild(canvas, view, j);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void drawableStateChanged() {
        super.drawableStateChanged();
        int[] drawableState = getDrawableState();
        Drawable drawable = this.mStatusBarBackground;
        boolean z = false;
        if (drawable != null && drawable.isStateful()) {
            z = false | drawable.setState(drawableState);
        }
        if (z) {
            invalidate();
        }
    }

    public void ensurePreDrawListener() {
        int childCount = getChildCount();
        boolean z = false;
        int i = 0;
        while (true) {
            if (i >= childCount) {
                break;
            } else if (hasDependencies(getChildAt(i))) {
                z = true;
                break;
            } else {
                i++;
            }
        }
        if (z != this.mNeedsPreDrawListener) {
            if (z) {
                addPreDrawListener();
            } else {
                removePreDrawListener();
            }
        }
    }

    public void getChildRect(View view, boolean z, Rect rect) {
        if (view.isLayoutRequested() || view.getVisibility() == 8) {
            rect.setEmpty();
        } else if (z) {
            getDescendantRect(view, rect);
        } else {
            rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public List<View> getDependencies(View view) {
        List<View> QxJ9d_12 = this.mChildDag.QxJ9d_1((X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<View>) view);
        this.mTempDependenciesList.clear();
        if (QxJ9d_12 != null) {
            this.mTempDependenciesList.addAll(QxJ9d_12);
        }
        return this.mTempDependenciesList;
    }

    public final List<View> getDependencySortedChildren() {
        prepareChildren();
        return Collections.unmodifiableList(this.mDependencySortedChildren);
    }

    public List<View> getDependents(View view) {
        List KQgRr5e_02 = this.mChildDag.KQgRr5e_0((X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<View>) view);
        this.mTempDependenciesList.clear();
        if (KQgRr5e_02 != null) {
            this.mTempDependenciesList.addAll(KQgRr5e_02);
        }
        return this.mTempDependenciesList;
    }

    public void getDescendantRect(View view, Rect rect) {
        X6FRs_4.IFxWkV_5.Mqv2r_3.QxJ9d_1.KQgRr5e_0(this, view, rect);
    }

    public void getDesiredAnchoredChildRect(View view, int i, Rect rect, Rect rect2) {
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        getDesiredAnchoredChildRectWithoutConstraints(view, i, rect, rect2, x6FRs_4, measuredWidth, measuredHeight);
        constrainChildRect(x6FRs_4, rect2, measuredWidth, measuredHeight);
    }

    public void getLastChildRect(View view, Rect rect) {
        rect.set(((X6FRs_4) view.getLayoutParams()).m858KQgRr5e_0());
    }

    public final XuVgy_28 getLastWindowInsets() {
        return this.mLastInsets;
    }

    @Override // android.view.ViewGroup
    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.KQgRr5e_0();
    }

    public X6FRs_4 getResolvedLayoutParams(View view) {
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        if (!x6FRs_4.f2216KQgRr5e_0) {
            if (view instanceof QxJ9d_1) {
                Behavior behavior = ((QxJ9d_1) view).getBehavior();
                if (behavior == null) {
                    Log.e(TAG, "Attached behavior class is null");
                }
                x6FRs_4.KQgRr5e_0(behavior);
                x6FRs_4.f2216KQgRr5e_0 = true;
            } else {
                PGPF6hQ_2 pGPF6hQ_2 = null;
                for (Class<?> cls = view.getClass(); cls != null; cls = cls.getSuperclass()) {
                    pGPF6hQ_2 = (PGPF6hQ_2) cls.getAnnotation(PGPF6hQ_2.class);
                    if (pGPF6hQ_2 != null) {
                        break;
                    }
                }
                if (pGPF6hQ_2 != null) {
                    try {
                        x6FRs_4.KQgRr5e_0(pGPF6hQ_2.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    } catch (Exception e) {
                        Log.e(TAG, "Default behavior class " + pGPF6hQ_2.value().getName() + " could not be instantiated. Did you forget a default constructor?", e);
                    }
                }
                x6FRs_4.f2216KQgRr5e_0 = true;
            }
        }
        return x6FRs_4;
    }

    public Drawable getStatusBarBackground() {
        return this.mStatusBarBackground;
    }

    @Override // android.view.View
    public int getSuggestedMinimumHeight() {
        return Math.max(super.getSuggestedMinimumHeight(), getPaddingTop() + getPaddingBottom());
    }

    @Override // android.view.View
    public int getSuggestedMinimumWidth() {
        return Math.max(super.getSuggestedMinimumWidth(), getPaddingLeft() + getPaddingRight());
    }

    public boolean isPointInChildBounds(View view, int i, int i2) {
        Rect acquireTempRect = acquireTempRect();
        getDescendantRect(view, acquireTempRect);
        try {
            return acquireTempRect.contains(i, i2);
        } finally {
            releaseTempRect(acquireTempRect);
        }
    }

    public void offsetChildToAnchor(View view, int i) {
        Behavior m859KQgRr5e_0;
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        if (x6FRs_4.f2213KQgRr5e_0 != null) {
            Rect acquireTempRect = acquireTempRect();
            Rect acquireTempRect2 = acquireTempRect();
            Rect acquireTempRect3 = acquireTempRect();
            getDescendantRect(x6FRs_4.f2213KQgRr5e_0, acquireTempRect);
            boolean z = false;
            getChildRect(view, false, acquireTempRect2);
            int measuredWidth = view.getMeasuredWidth();
            int measuredHeight = view.getMeasuredHeight();
            getDesiredAnchoredChildRectWithoutConstraints(view, i, acquireTempRect, acquireTempRect3, x6FRs_4, measuredWidth, measuredHeight);
            z = (acquireTempRect3.left == acquireTempRect2.left && acquireTempRect3.top == acquireTempRect2.top) ? true : true;
            constrainChildRect(x6FRs_4, acquireTempRect3, measuredWidth, measuredHeight);
            int i2 = acquireTempRect3.left - acquireTempRect2.left;
            int i3 = acquireTempRect3.top - acquireTempRect2.top;
            if (i2 != 0) {
                ZzDuCHW_20.Mqv2r_3(view, i2);
            }
            if (i3 != 0) {
                ZzDuCHW_20.X6FRs_4(view, i3);
            }
            if (z && (m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0()) != null) {
                m859KQgRr5e_0.onDependentViewChanged(this, view, x6FRs_4.f2213KQgRr5e_0);
            }
            releaseTempRect(acquireTempRect);
            releaseTempRect(acquireTempRect2);
            releaseTempRect(acquireTempRect3);
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        resetTouchBehaviors(false);
        if (this.mNeedsPreDrawListener) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new IFxWkV_5();
            }
            getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
        }
        if (this.mLastInsets == null && ZzDuCHW_20.m263KQgRr5e_0((View) this)) {
            ZzDuCHW_20.m270QxJ9d_1((View) this);
        }
        this.mIsAttachedToWindow = true;
    }

    public final void onChildViewsChanged(int i) {
        boolean z;
        int Mqv2r_32 = ZzDuCHW_20.Mqv2r_3((View) this);
        int size = this.mDependencySortedChildren.size();
        Rect acquireTempRect = acquireTempRect();
        Rect acquireTempRect2 = acquireTempRect();
        Rect acquireTempRect3 = acquireTempRect();
        for (int i2 = 0; i2 < size; i2++) {
            View view = this.mDependencySortedChildren.get(i2);
            X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
            if (i != 0 || view.getVisibility() != 8) {
                for (int i3 = 0; i3 < i2; i3++) {
                    if (x6FRs_4.f2219QxJ9d_1 == this.mDependencySortedChildren.get(i3)) {
                        offsetChildToAnchor(view, Mqv2r_32);
                    }
                }
                getChildRect(view, true, acquireTempRect2);
                if (x6FRs_4.f3508X6FRs_4 != 0 && !acquireTempRect2.isEmpty()) {
                    int KQgRr5e_02 = X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(x6FRs_4.f3508X6FRs_4, Mqv2r_32);
                    int i4 = KQgRr5e_02 & 112;
                    if (i4 == 48) {
                        acquireTempRect.top = Math.max(acquireTempRect.top, acquireTempRect2.bottom);
                    } else if (i4 == 80) {
                        acquireTempRect.bottom = Math.max(acquireTempRect.bottom, getHeight() - acquireTempRect2.top);
                    }
                    int i5 = KQgRr5e_02 & 7;
                    if (i5 == 3) {
                        acquireTempRect.left = Math.max(acquireTempRect.left, acquireTempRect2.right);
                    } else if (i5 == 5) {
                        acquireTempRect.right = Math.max(acquireTempRect.right, getWidth() - acquireTempRect2.left);
                    }
                }
                if (x6FRs_4.f3505IFxWkV_5 != 0 && view.getVisibility() == 0) {
                    offsetChildByInset(view, acquireTempRect, Mqv2r_32);
                }
                if (i != 2) {
                    getLastChildRect(view, acquireTempRect3);
                    if (!acquireTempRect3.equals(acquireTempRect2)) {
                        recordLastChildRect(view, acquireTempRect2);
                    }
                }
                for (int i6 = i2 + 1; i6 < size; i6++) {
                    View view2 = this.mDependencySortedChildren.get(i6);
                    X6FRs_4 x6FRs_42 = (X6FRs_4) view2.getLayoutParams();
                    Behavior m859KQgRr5e_0 = x6FRs_42.m859KQgRr5e_0();
                    if (m859KQgRr5e_0 != null && m859KQgRr5e_0.layoutDependsOn(this, view2, view)) {
                        if (i == 0 && x6FRs_42.PGPF6hQ_2()) {
                            x6FRs_42.m860KQgRr5e_0();
                        } else {
                            if (i != 2) {
                                z = m859KQgRr5e_0.onDependentViewChanged(this, view2, view);
                            } else {
                                m859KQgRr5e_0.onDependentViewRemoved(this, view2, view);
                                z = true;
                            }
                            if (i == 1) {
                                x6FRs_42.KQgRr5e_0(z);
                            }
                        }
                    }
                }
            }
        }
        releaseTempRect(acquireTempRect);
        releaseTempRect(acquireTempRect2);
        releaseTempRect(acquireTempRect3);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        resetTouchBehaviors(false);
        if (this.mNeedsPreDrawListener && this.mOnPreDrawListener != null) {
            getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
        }
        View view = this.mNestedScrollingTarget;
        if (view != null) {
            onStopNestedScroll(view);
        }
        this.mIsAttachedToWindow = false;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mDrawStatusBarBackground || this.mStatusBarBackground == null) {
            return;
        }
        XuVgy_28 xuVgy_28 = this.mLastInsets;
        int Mqv2r_32 = xuVgy_28 != null ? xuVgy_28.Mqv2r_3() : 0;
        if (Mqv2r_32 > 0) {
            this.mStatusBarBackground.setBounds(0, 0, getWidth(), Mqv2r_32);
            this.mStatusBarBackground.draw(canvas);
        }
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            resetTouchBehaviors(true);
        }
        boolean performIntercept = performIntercept(motionEvent, 0);
        if (actionMasked == 1 || actionMasked == 3) {
            resetTouchBehaviors(true);
        }
        return performIntercept;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        Behavior m859KQgRr5e_0;
        int Mqv2r_32 = ZzDuCHW_20.Mqv2r_3((View) this);
        int size = this.mDependencySortedChildren.size();
        for (int i5 = 0; i5 < size; i5++) {
            View view = this.mDependencySortedChildren.get(i5);
            if (view.getVisibility() != 8 && ((m859KQgRr5e_0 = ((X6FRs_4) view.getLayoutParams()).m859KQgRr5e_0()) == null || !m859KQgRr5e_0.onLayoutChild(this, view, Mqv2r_32))) {
                onLayoutChild(view, Mqv2r_32);
            }
        }
    }

    public void onLayoutChild(View view, int i) {
        X6FRs_4 x6FRs_4 = (X6FRs_4) view.getLayoutParams();
        if (!x6FRs_4.m861KQgRr5e_0()) {
            View view2 = x6FRs_4.f2213KQgRr5e_0;
            if (view2 != null) {
                layoutChildWithAnchor(view, view2, i);
                return;
            }
            int i2 = x6FRs_4.PGPF6hQ_2;
            if (i2 >= 0) {
                layoutChildWithKeyline(view, i2, i);
                return;
            } else {
                layoutChild(view, i);
                return;
            }
        }
        throw new IllegalStateException("An anchor may not be changed after CoordinatorLayout measurement begins before layout is complete.");
    }

    /* JADX WARN: Code restructure failed: missing block: B:43:0x011a, code lost:
        if (r0.onMeasureChild(r30, r20, r11, r21, r23, 0) == false) goto L33;
     */
    /* JADX WARN: Removed duplicated region for block: B:42:0x00fb  */
    /* JADX WARN: Removed duplicated region for block: B:45:0x011d  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void onMeasure(int i, int i2) {
        int i3;
        int i4;
        int i5;
        int i6;
        Behavior m859KQgRr5e_0;
        X6FRs_4 x6FRs_4;
        int i7;
        int i8;
        int i9;
        int i10;
        int i11;
        int i12;
        prepareChildren();
        ensurePreDrawListener();
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        int paddingRight = getPaddingRight();
        int paddingBottom = getPaddingBottom();
        int Mqv2r_32 = ZzDuCHW_20.Mqv2r_3((View) this);
        boolean z = Mqv2r_32 == 1;
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        int size2 = View.MeasureSpec.getSize(i2);
        int i13 = paddingLeft + paddingRight;
        int i14 = paddingTop + paddingBottom;
        int suggestedMinimumWidth = getSuggestedMinimumWidth();
        int suggestedMinimumHeight = getSuggestedMinimumHeight();
        boolean z2 = this.mLastInsets != null && ZzDuCHW_20.m263KQgRr5e_0((View) this);
        int size3 = this.mDependencySortedChildren.size();
        int i15 = suggestedMinimumWidth;
        int i16 = suggestedMinimumHeight;
        int i17 = 0;
        int i18 = 0;
        while (i18 < size3) {
            View view = this.mDependencySortedChildren.get(i18);
            if (view.getVisibility() == 8) {
                i11 = i18;
                i8 = size3;
                i9 = paddingLeft;
            } else {
                X6FRs_4 x6FRs_42 = (X6FRs_4) view.getLayoutParams();
                int i19 = x6FRs_42.PGPF6hQ_2;
                if (i19 < 0 || mode == 0) {
                    i3 = i17;
                } else {
                    int keyline = getKeyline(i19);
                    int KQgRr5e_02 = X6FRs_4.IMuAHx_6.EuDEkJe_12.PGPF6hQ_2.KQgRr5e_0(resolveKeylineGravity(x6FRs_42.KQgRr5e_0), Mqv2r_32) & 7;
                    i3 = i17;
                    if ((KQgRr5e_02 == 3 && !z) || (KQgRr5e_02 == 5 && z)) {
                        i4 = Math.max(0, (size - paddingRight) - keyline);
                    } else if ((KQgRr5e_02 == 5 && !z) || (KQgRr5e_02 == 3 && z)) {
                        i4 = Math.max(0, keyline - paddingLeft);
                    }
                    if (z2 || ZzDuCHW_20.m263KQgRr5e_0(view)) {
                        i5 = i;
                        i6 = i2;
                    } else {
                        i5 = View.MeasureSpec.makeMeasureSpec(size - (this.mLastInsets.QxJ9d_1() + this.mLastInsets.PGPF6hQ_2()), mode);
                        i6 = View.MeasureSpec.makeMeasureSpec(size2 - (this.mLastInsets.Mqv2r_3() + this.mLastInsets.KQgRr5e_0()), mode2);
                    }
                    m859KQgRr5e_0 = x6FRs_42.m859KQgRr5e_0();
                    if (m859KQgRr5e_0 == null) {
                        x6FRs_4 = x6FRs_42;
                        i10 = i3;
                        i11 = i18;
                        i7 = i16;
                        i9 = paddingLeft;
                        i12 = i15;
                        i8 = size3;
                    } else {
                        x6FRs_4 = x6FRs_42;
                        i7 = i16;
                        i8 = size3;
                        i9 = paddingLeft;
                        i10 = i3;
                        i11 = i18;
                        i12 = i15;
                    }
                    onMeasureChild(view, i5, i4, i6, 0);
                    X6FRs_4 x6FRs_43 = x6FRs_4;
                    int max = Math.max(i12, i13 + view.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) x6FRs_43).leftMargin + ((ViewGroup.MarginLayoutParams) x6FRs_43).rightMargin);
                    int max2 = Math.max(i7, i14 + view.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) x6FRs_43).topMargin + ((ViewGroup.MarginLayoutParams) x6FRs_43).bottomMargin);
                    i17 = View.combineMeasuredStates(i10, view.getMeasuredState());
                    i15 = max;
                    i16 = max2;
                }
                i4 = 0;
                if (z2) {
                }
                i5 = i;
                i6 = i2;
                m859KQgRr5e_0 = x6FRs_42.m859KQgRr5e_0();
                if (m859KQgRr5e_0 == null) {
                }
                onMeasureChild(view, i5, i4, i6, 0);
                X6FRs_4 x6FRs_432 = x6FRs_4;
                int max3 = Math.max(i12, i13 + view.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) x6FRs_432).leftMargin + ((ViewGroup.MarginLayoutParams) x6FRs_432).rightMargin);
                int max22 = Math.max(i7, i14 + view.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) x6FRs_432).topMargin + ((ViewGroup.MarginLayoutParams) x6FRs_432).bottomMargin);
                i17 = View.combineMeasuredStates(i10, view.getMeasuredState());
                i15 = max3;
                i16 = max22;
            }
            i18 = i11 + 1;
            paddingLeft = i9;
            size3 = i8;
        }
        int i20 = i17;
        setMeasuredDimension(View.resolveSizeAndState(i15, i, (-16777216) & i20), View.resolveSizeAndState(i16, i2, i20 << 16));
    }

    public void onMeasureChild(View view, int i, int i2, int i3, int i4) {
        measureChildWithMargins(view, i, i2, i3, i4);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public boolean onNestedFling(View view, float f, float f2, boolean z) {
        Behavior m859KQgRr5e_0;
        int childCount = getChildCount();
        boolean z2 = false;
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() != 8) {
                X6FRs_4 x6FRs_4 = (X6FRs_4) childAt.getLayoutParams();
                if (x6FRs_4.m862KQgRr5e_0(0) && (m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0()) != null) {
                    z2 |= m859KQgRr5e_0.onNestedFling(this, childAt, view, f, f2, z);
                }
            }
        }
        if (z2) {
            onChildViewsChanged(1);
        }
        return z2;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public boolean onNestedPreFling(View view, float f, float f2) {
        Behavior m859KQgRr5e_0;
        int childCount = getChildCount();
        boolean z = false;
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() != 8) {
                X6FRs_4 x6FRs_4 = (X6FRs_4) childAt.getLayoutParams();
                if (x6FRs_4.m862KQgRr5e_0(0) && (m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0()) != null) {
                    z |= m859KQgRr5e_0.onNestedPreFling(this, childAt, view, f, f2);
                }
            }
        }
        return z;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
        onNestedPreScroll(view, i, i2, iArr, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        onNestedScroll(view, i, i2, i3, i4, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public void onNestedScrollAccepted(View view, View view2, int i) {
        onNestedScrollAccepted(view, view2, i, 0);
    }

    @Override // android.view.View
    public void onRestoreInstanceState(Parcelable parcelable) {
        Parcelable parcelable2;
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        SparseArray<Parcelable> sparseArray = savedState.KQgRr5e_0;
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            int id = childAt.getId();
            Behavior m859KQgRr5e_0 = getResolvedLayoutParams(childAt).m859KQgRr5e_0();
            if (id != -1 && m859KQgRr5e_0 != null && (parcelable2 = sparseArray.get(id)) != null) {
                m859KQgRr5e_0.onRestoreInstanceState(this, childAt, parcelable2);
            }
        }
    }

    @Override // android.view.View
    public Parcelable onSaveInstanceState() {
        Parcelable onSaveInstanceState;
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        SparseArray<Parcelable> sparseArray = new SparseArray<>();
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            int id = childAt.getId();
            Behavior m859KQgRr5e_0 = ((X6FRs_4) childAt.getLayoutParams()).m859KQgRr5e_0();
            if (id != -1 && m859KQgRr5e_0 != null && (onSaveInstanceState = m859KQgRr5e_0.onSaveInstanceState(this, childAt)) != null) {
                sparseArray.append(id, onSaveInstanceState);
            }
        }
        savedState.KQgRr5e_0 = sparseArray;
        return savedState;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public boolean onStartNestedScroll(View view, View view2, int i) {
        return onStartNestedScroll(view, view2, i, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent, X6FRs_4.IMuAHx_6.EuDEkJe_12.YghfZG_14
    public void onStopNestedScroll(View view) {
        onStopNestedScroll(view, 0);
    }

    /* JADX WARN: Code restructure failed: missing block: B:5:0x0012, code lost:
        if (r3 != false) goto L19;
     */
    /* JADX WARN: Removed duplicated region for block: B:14:0x0031  */
    /* JADX WARN: Removed duplicated region for block: B:15:0x0037  */
    /* JADX WARN: Removed duplicated region for block: B:18:0x004c  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean z;
        boolean onTouchEvent;
        MotionEvent motionEvent2;
        int actionMasked = motionEvent.getActionMasked();
        if (this.mBehaviorTouchView == null) {
            z = performIntercept(motionEvent, 1);
        } else {
            z = false;
        }
        Behavior m859KQgRr5e_0 = ((X6FRs_4) this.mBehaviorTouchView.getLayoutParams()).m859KQgRr5e_0();
        if (m859KQgRr5e_0 != null) {
            onTouchEvent = m859KQgRr5e_0.onTouchEvent(this, this.mBehaviorTouchView, motionEvent);
            motionEvent2 = null;
            if (this.mBehaviorTouchView != null) {
                onTouchEvent |= super.onTouchEvent(motionEvent);
            } else if (z) {
                long uptimeMillis = SystemClock.uptimeMillis();
                motionEvent2 = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                super.onTouchEvent(motionEvent2);
            }
            if (motionEvent2 != null) {
                motionEvent2.recycle();
            }
            if (actionMasked != 1 || actionMasked == 3) {
                resetTouchBehaviors(false);
            }
            return onTouchEvent;
        }
        onTouchEvent = false;
        motionEvent2 = null;
        if (this.mBehaviorTouchView != null) {
        }
        if (motionEvent2 != null) {
        }
        if (actionMasked != 1) {
        }
        resetTouchBehaviors(false);
        return onTouchEvent;
    }

    public void recordLastChildRect(View view, Rect rect) {
        ((X6FRs_4) view.getLayoutParams()).KQgRr5e_0(rect);
    }

    public void removePreDrawListener() {
        if (this.mIsAttachedToWindow && this.mOnPreDrawListener != null) {
            getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = false;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z) {
        Behavior m859KQgRr5e_0 = ((X6FRs_4) view.getLayoutParams()).m859KQgRr5e_0();
        if (m859KQgRr5e_0 == null || !m859KQgRr5e_0.onRequestChildRectangleOnScreen(this, view, rect, z)) {
            return super.requestChildRectangleOnScreen(view, rect, z);
        }
        return true;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void requestDisallowInterceptTouchEvent(boolean z) {
        super.requestDisallowInterceptTouchEvent(z);
        if (!z || this.mDisallowInterceptReset) {
            return;
        }
        resetTouchBehaviors(false);
        this.mDisallowInterceptReset = true;
    }

    @Override // android.view.View
    public void setFitsSystemWindows(boolean z) {
        super.setFitsSystemWindows(z);
        setupForInsets();
    }

    @Override // android.view.ViewGroup
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mOnHierarchyChangeListener = onHierarchyChangeListener;
    }

    public void setStatusBarBackground(Drawable drawable) {
        Drawable drawable2 = this.mStatusBarBackground;
        if (drawable2 != drawable) {
            if (drawable2 != null) {
                drawable2.setCallback(null);
            }
            Drawable mutate = drawable != null ? drawable.mutate() : null;
            this.mStatusBarBackground = mutate;
            if (mutate != null) {
                if (mutate.isStateful()) {
                    this.mStatusBarBackground.setState(getDrawableState());
                }
                X6FRs_4.IMuAHx_6.IFxWkV_5.XnFJ5_9.KQgRr5e_0.m294KQgRr5e_0(this.mStatusBarBackground, ZzDuCHW_20.Mqv2r_3((View) this));
                this.mStatusBarBackground.setVisible(getVisibility() == 0, false);
                this.mStatusBarBackground.setCallback(this);
            }
            ZzDuCHW_20.m262KQgRr5e_0((View) this);
        }
    }

    public void setStatusBarBackgroundColor(int i) {
        setStatusBarBackground(new ColorDrawable(i));
    }

    public void setStatusBarBackgroundResource(int i) {
        setStatusBarBackground(i != 0 ? X6FRs_4.IMuAHx_6.X6FRs_4.KQgRr5e_0.m332KQgRr5e_0(getContext(), i) : null);
    }

    @Override // android.view.View
    public void setVisibility(int i) {
        super.setVisibility(i);
        boolean z = i == 0;
        Drawable drawable = this.mStatusBarBackground;
        if (drawable == null || drawable.isVisible() == z) {
            return;
        }
        this.mStatusBarBackground.setVisible(z, false);
    }

    public final XuVgy_28 setWindowInsets(XuVgy_28 xuVgy_28) {
        if (X6FRs_4.IMuAHx_6.KNBe_11.PGPF6hQ_2.KQgRr5e_0(this.mLastInsets, xuVgy_28)) {
            return xuVgy_28;
        }
        this.mLastInsets = xuVgy_28;
        boolean z = true;
        boolean z2 = xuVgy_28 != null && xuVgy_28.Mqv2r_3() > 0;
        this.mDrawStatusBarBackground = z2;
        setWillNotDraw((z2 || getBackground() != null) ? false : false);
        XuVgy_28 dispatchApplyWindowInsetsToBehaviors = dispatchApplyWindowInsetsToBehaviors(xuVgy_28);
        requestLayout();
        return dispatchApplyWindowInsetsToBehaviors;
    }

    @Override // android.view.View
    public boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.mStatusBarBackground;
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, X6FRs_4.IFxWkV_5.KQgRr5e_0.coordinatorLayoutStyle);
    }

    @Override // android.view.ViewGroup
    public X6FRs_4 generateDefaultLayoutParams() {
        return new X6FRs_4(-2, -2);
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public void onNestedPreScroll(View view, int i, int i2, int[] iArr, int i3) {
        Behavior m859KQgRr5e_0;
        int childCount = getChildCount();
        boolean z = false;
        int i4 = 0;
        int i5 = 0;
        for (int i6 = 0; i6 < childCount; i6++) {
            View childAt = getChildAt(i6);
            if (childAt.getVisibility() != 8) {
                X6FRs_4 x6FRs_4 = (X6FRs_4) childAt.getLayoutParams();
                if (x6FRs_4.m862KQgRr5e_0(i3) && (m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0()) != null) {
                    int[] iArr2 = this.mTempIntPair;
                    iArr2[1] = 0;
                    iArr2[0] = 0;
                    m859KQgRr5e_0.onNestedPreScroll(this, childAt, view, i, i2, iArr2, i3);
                    int[] iArr3 = this.mTempIntPair;
                    i4 = i > 0 ? Math.max(i4, iArr3[0]) : Math.min(i4, iArr3[0]);
                    int[] iArr4 = this.mTempIntPair;
                    i5 = i2 > 0 ? Math.max(i5, iArr4[1]) : Math.min(i5, iArr4[1]);
                    z = true;
                }
            }
        }
        iArr[0] = i4;
        iArr[1] = i5;
        if (z) {
            onChildViewsChanged(1);
        }
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public void onNestedScroll(View view, int i, int i2, int i3, int i4, int i5) {
        Behavior m859KQgRr5e_0;
        int childCount = getChildCount();
        boolean z = false;
        for (int i6 = 0; i6 < childCount; i6++) {
            View childAt = getChildAt(i6);
            if (childAt.getVisibility() != 8) {
                X6FRs_4 x6FRs_4 = (X6FRs_4) childAt.getLayoutParams();
                if (x6FRs_4.m862KQgRr5e_0(i5) && (m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0()) != null) {
                    m859KQgRr5e_0.onNestedScroll(this, childAt, view, i, i2, i3, i4, i5);
                    z = true;
                }
            }
        }
        if (z) {
            onChildViewsChanged(1);
        }
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public void onNestedScrollAccepted(View view, View view2, int i, int i2) {
        Behavior m859KQgRr5e_0;
        this.mNestedScrollingParentHelper.KQgRr5e_0(view, view2, i, i2);
        this.mNestedScrollingTarget = view2;
        int childCount = getChildCount();
        for (int i3 = 0; i3 < childCount; i3++) {
            View childAt = getChildAt(i3);
            X6FRs_4 x6FRs_4 = (X6FRs_4) childAt.getLayoutParams();
            if (x6FRs_4.m862KQgRr5e_0(i2) && (m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0()) != null) {
                m859KQgRr5e_0.onNestedScrollAccepted(this, childAt, view, view2, i, i2);
            }
        }
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public boolean onStartNestedScroll(View view, View view2, int i, int i2) {
        int childCount = getChildCount();
        boolean z = false;
        for (int i3 = 0; i3 < childCount; i3++) {
            View childAt = getChildAt(i3);
            if (childAt.getVisibility() != 8) {
                X6FRs_4 x6FRs_4 = (X6FRs_4) childAt.getLayoutParams();
                Behavior m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0();
                if (m859KQgRr5e_0 != null) {
                    boolean onStartNestedScroll = m859KQgRr5e_0.onStartNestedScroll(this, childAt, view, view2, i, i2);
                    z |= onStartNestedScroll;
                    x6FRs_4.KQgRr5e_0(i2, onStartNestedScroll);
                } else {
                    x6FRs_4.KQgRr5e_0(i2, false);
                }
            }
        }
        return z;
    }

    @Override // X6FRs_4.IMuAHx_6.EuDEkJe_12.EuDEkJe_12
    public void onStopNestedScroll(View view, int i) {
        this.mNestedScrollingParentHelper.KQgRr5e_0(view, i);
        int childCount = getChildCount();
        for (int i2 = 0; i2 < childCount; i2++) {
            View childAt = getChildAt(i2);
            X6FRs_4 x6FRs_4 = (X6FRs_4) childAt.getLayoutParams();
            if (x6FRs_4.m862KQgRr5e_0(i)) {
                Behavior m859KQgRr5e_0 = x6FRs_4.m859KQgRr5e_0();
                if (m859KQgRr5e_0 != null) {
                    m859KQgRr5e_0.onStopNestedScroll(this, childAt, view, i);
                }
                x6FRs_4.KQgRr5e_0(i);
                x6FRs_4.m860KQgRr5e_0();
            }
        }
        this.mNestedScrollingTarget = null;
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        TypedArray obtainStyledAttributes;
        this.mDependencySortedChildren = new ArrayList();
        this.mChildDag = new X6FRs_4.IFxWkV_5.Mqv2r_3.KQgRr5e_0<>();
        this.mTempList1 = new ArrayList();
        this.mTempDependenciesList = new ArrayList();
        this.mTempIntPair = new int[2];
        this.mNestedScrollingParentHelper = new LGe8pk_15(this);
        if (i == 0) {
            obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout, 0, X6FRs_4.IFxWkV_5.QxJ9d_1.Widget_Support_CoordinatorLayout);
        } else {
            obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout, i, 0);
        }
        int resourceId = obtainStyledAttributes.getResourceId(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_keylines, 0);
        if (resourceId != 0) {
            Resources resources = context.getResources();
            this.mKeylines = resources.getIntArray(resourceId);
            float f = resources.getDisplayMetrics().density;
            int length = this.mKeylines.length;
            for (int i2 = 0; i2 < length; i2++) {
                int[] iArr = this.mKeylines;
                iArr[i2] = (int) (iArr[i2] * f);
            }
        }
        this.mStatusBarBackground = obtainStyledAttributes.getDrawable(X6FRs_4.IFxWkV_5.PGPF6hQ_2.CoordinatorLayout_statusBarBackground);
        obtainStyledAttributes.recycle();
        setupForInsets();
        super.setOnHierarchyChangeListener(new Mqv2r_3());
    }

    @Override // android.view.ViewGroup
    public X6FRs_4 generateLayoutParams(AttributeSet attributeSet) {
        return new X6FRs_4(getContext(), attributeSet);
    }

    @Override // android.view.ViewGroup
    public X6FRs_4 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof X6FRs_4) {
            return new X6FRs_4((X6FRs_4) layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new X6FRs_4((ViewGroup.MarginLayoutParams) layoutParams);
        }
        return new X6FRs_4(layoutParams);
    }

    /* loaded from: classes.dex */
    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new KQgRr5e_0();
        public SparseArray<Parcelable> KQgRr5e_0;

        /* loaded from: classes.dex */
        public static class KQgRr5e_0 implements Parcelable.ClassLoaderCreator<SavedState> {
            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: KQgRr5e_0 */
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            int readInt = parcel.readInt();
            int[] iArr = new int[readInt];
            parcel.readIntArray(iArr);
            Parcelable[] readParcelableArray = parcel.readParcelableArray(classLoader);
            this.KQgRr5e_0 = new SparseArray<>(readInt);
            for (int i = 0; i < readInt; i++) {
                this.KQgRr5e_0.append(iArr[i], readParcelableArray[i]);
            }
        }

        @Override // androidx.customview.view.AbsSavedState, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            SparseArray<Parcelable> sparseArray = this.KQgRr5e_0;
            int size = sparseArray != null ? sparseArray.size() : 0;
            parcel.writeInt(size);
            int[] iArr = new int[size];
            Parcelable[] parcelableArr = new Parcelable[size];
            for (int i2 = 0; i2 < size; i2++) {
                iArr[i2] = this.KQgRr5e_0.keyAt(i2);
                parcelableArr[i2] = this.KQgRr5e_0.valueAt(i2);
            }
            parcel.writeIntArray(iArr);
            parcel.writeParcelableArray(parcelableArr, i);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }
    }
}
