package androidx.cardview.widget;

import X6FRs_4.PGPF6hQ_2.IFxWkV_5.Mqv2r_3;
import X6FRs_4.PGPF6hQ_2.IFxWkV_5.PGPF6hQ_2;
import X6FRs_4.PGPF6hQ_2.IFxWkV_5.QxJ9d_1;
import X6FRs_4.PGPF6hQ_2.IFxWkV_5.X6FRs_4;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
/* loaded from: classes.dex */
public class CardView extends FrameLayout {
    public static final int[] COLOR_BACKGROUND_ATTR = {16842801};
    public static final X6FRs_4 IMPL;
    public final Mqv2r_3 mCardViewDelegate;
    public boolean mCompatPadding;
    public final Rect mContentPadding;
    public boolean mPreventCornerOverlap;
    public final Rect mShadowBounds;
    public int mUserSetMinHeight;
    public int mUserSetMinWidth;

    static {
        int i = Build.VERSION.SDK_INT;
        if (i >= 21) {
            IMPL = new QxJ9d_1();
        } else if (i >= 17) {
            IMPL = new X6FRs_4.PGPF6hQ_2.IFxWkV_5.KQgRr5e_0();
        } else {
            IMPL = new PGPF6hQ_2();
        }
        IMPL.KQgRr5e_0();
    }

    public CardView(Context context) {
        this(context, null);
    }

    public ColorStateList getCardBackgroundColor() {
        return IMPL.m523KQgRr5e_0(this.mCardViewDelegate);
    }

    public float getCardElevation() {
        return IMPL.PGPF6hQ_2(this.mCardViewDelegate);
    }

    public int getContentPaddingBottom() {
        return this.mContentPadding.bottom;
    }

    public int getContentPaddingLeft() {
        return this.mContentPadding.left;
    }

    public int getContentPaddingRight() {
        return this.mContentPadding.right;
    }

    public int getContentPaddingTop() {
        return this.mContentPadding.top;
    }

    public float getMaxCardElevation() {
        return IMPL.X6FRs_4(this.mCardViewDelegate);
    }

    public boolean getPreventCornerOverlap() {
        return this.mPreventCornerOverlap;
    }

    public float getRadius() {
        return IMPL.KQgRr5e_0(this.mCardViewDelegate);
    }

    public boolean getUseCompatPadding() {
        return this.mCompatPadding;
    }

    @Override // android.widget.FrameLayout, android.view.View
    public void onMeasure(int i, int i2) {
        if (!(IMPL instanceof QxJ9d_1)) {
            int mode = View.MeasureSpec.getMode(i);
            if (mode == Integer.MIN_VALUE || mode == 1073741824) {
                i = View.MeasureSpec.makeMeasureSpec(Math.max((int) Math.ceil(IMPL.QxJ9d_1(this.mCardViewDelegate)), View.MeasureSpec.getSize(i)), mode);
            }
            int mode2 = View.MeasureSpec.getMode(i2);
            if (mode2 == Integer.MIN_VALUE || mode2 == 1073741824) {
                i2 = View.MeasureSpec.makeMeasureSpec(Math.max((int) Math.ceil(IMPL.Mqv2r_3(this.mCardViewDelegate)), View.MeasureSpec.getSize(i2)), mode2);
            }
            super.onMeasure(i, i2);
            return;
        }
        super.onMeasure(i, i2);
    }

    public void setCardBackgroundColor(int i) {
        IMPL.KQgRr5e_0(this.mCardViewDelegate, ColorStateList.valueOf(i));
    }

    public void setCardElevation(float f) {
        IMPL.PGPF6hQ_2(this.mCardViewDelegate, f);
    }

    public void setContentPadding(int i, int i2, int i3, int i4) {
        this.mContentPadding.set(i, i2, i3, i4);
        IMPL.m525PGPF6hQ_2(this.mCardViewDelegate);
    }

    public void setMaxCardElevation(float f) {
        IMPL.QxJ9d_1(this.mCardViewDelegate, f);
    }

    @Override // android.view.View
    public void setMinimumHeight(int i) {
        this.mUserSetMinHeight = i;
        super.setMinimumHeight(i);
    }

    @Override // android.view.View
    public void setMinimumWidth(int i) {
        this.mUserSetMinWidth = i;
        super.setMinimumWidth(i);
    }

    @Override // android.view.View
    public void setPadding(int i, int i2, int i3, int i4) {
    }

    @Override // android.view.View
    public void setPaddingRelative(int i, int i2, int i3, int i4) {
    }

    public void setPreventCornerOverlap(boolean z) {
        if (z != this.mPreventCornerOverlap) {
            this.mPreventCornerOverlap = z;
            IMPL.m526QxJ9d_1(this.mCardViewDelegate);
        }
    }

    public void setRadius(float f) {
        IMPL.KQgRr5e_0(this.mCardViewDelegate, f);
    }

    public void setUseCompatPadding(boolean z) {
        if (this.mCompatPadding != z) {
            this.mCompatPadding = z;
            IMPL.m524KQgRr5e_0(this.mCardViewDelegate);
        }
    }

    /* loaded from: classes.dex */
    public class KQgRr5e_0 implements Mqv2r_3 {
        public Drawable KQgRr5e_0;

        public KQgRr5e_0() {
        }

        @Override // X6FRs_4.PGPF6hQ_2.IFxWkV_5.Mqv2r_3
        public void KQgRr5e_0(Drawable drawable) {
            this.KQgRr5e_0 = drawable;
            CardView.this.setBackgroundDrawable(drawable);
        }

        @Override // X6FRs_4.PGPF6hQ_2.IFxWkV_5.Mqv2r_3
        public boolean QxJ9d_1() {
            return CardView.this.getUseCompatPadding();
        }

        @Override // X6FRs_4.PGPF6hQ_2.IFxWkV_5.Mqv2r_3
        public void setShadowPadding(int i, int i2, int i3, int i4) {
            CardView.this.mShadowBounds.set(i, i2, i3, i4);
            CardView cardView = CardView.this;
            Rect rect = cardView.mContentPadding;
            CardView.super.setPadding(i + rect.left, i2 + rect.top, i3 + rect.right, i4 + rect.bottom);
        }

        @Override // X6FRs_4.PGPF6hQ_2.IFxWkV_5.Mqv2r_3
        public boolean KQgRr5e_0() {
            return CardView.this.getPreventCornerOverlap();
        }

        @Override // X6FRs_4.PGPF6hQ_2.IFxWkV_5.Mqv2r_3
        public void KQgRr5e_0(int i, int i2) {
            CardView cardView = CardView.this;
            if (i > cardView.mUserSetMinWidth) {
                CardView.super.setMinimumWidth(i);
            }
            CardView cardView2 = CardView.this;
            if (i2 > cardView2.mUserSetMinHeight) {
                CardView.super.setMinimumHeight(i2);
            }
        }

        @Override // X6FRs_4.PGPF6hQ_2.IFxWkV_5.Mqv2r_3
        public Drawable KQgRr5e_0() {
            return this.KQgRr5e_0;
        }

        @Override // X6FRs_4.PGPF6hQ_2.IFxWkV_5.Mqv2r_3
        public View KQgRr5e_0() {
            return CardView.this;
        }
    }

    public CardView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, X6FRs_4.PGPF6hQ_2.KQgRr5e_0.cardViewStyle);
    }

    public void setCardBackgroundColor(ColorStateList colorStateList) {
        IMPL.KQgRr5e_0(this.mCardViewDelegate, colorStateList);
    }

    public CardView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        int color;
        ColorStateList valueOf;
        this.mContentPadding = new Rect();
        this.mShadowBounds = new Rect();
        this.mCardViewDelegate = new KQgRr5e_0();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView, i, X6FRs_4.PGPF6hQ_2.Mqv2r_3.CardView);
        if (obtainStyledAttributes.hasValue(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_cardBackgroundColor)) {
            valueOf = obtainStyledAttributes.getColorStateList(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_cardBackgroundColor);
        } else {
            TypedArray obtainStyledAttributes2 = getContext().obtainStyledAttributes(COLOR_BACKGROUND_ATTR);
            int color2 = obtainStyledAttributes2.getColor(0, 0);
            obtainStyledAttributes2.recycle();
            float[] fArr = new float[3];
            Color.colorToHSV(color2, fArr);
            if (fArr[2] > 0.5f) {
                color = getResources().getColor(X6FRs_4.PGPF6hQ_2.QxJ9d_1.cardview_light_background);
            } else {
                color = getResources().getColor(X6FRs_4.PGPF6hQ_2.QxJ9d_1.cardview_dark_background);
            }
            valueOf = ColorStateList.valueOf(color);
        }
        ColorStateList colorStateList = valueOf;
        float dimension = obtainStyledAttributes.getDimension(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_cardCornerRadius, 0.0f);
        float dimension2 = obtainStyledAttributes.getDimension(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_cardElevation, 0.0f);
        float dimension3 = obtainStyledAttributes.getDimension(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_cardMaxElevation, 0.0f);
        this.mCompatPadding = obtainStyledAttributes.getBoolean(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_cardUseCompatPadding, false);
        this.mPreventCornerOverlap = obtainStyledAttributes.getBoolean(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_cardPreventCornerOverlap, true);
        int dimensionPixelSize = obtainStyledAttributes.getDimensionPixelSize(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_contentPadding, 0);
        this.mContentPadding.left = obtainStyledAttributes.getDimensionPixelSize(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_contentPaddingLeft, dimensionPixelSize);
        this.mContentPadding.top = obtainStyledAttributes.getDimensionPixelSize(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_contentPaddingTop, dimensionPixelSize);
        this.mContentPadding.right = obtainStyledAttributes.getDimensionPixelSize(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_contentPaddingRight, dimensionPixelSize);
        this.mContentPadding.bottom = obtainStyledAttributes.getDimensionPixelSize(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_contentPaddingBottom, dimensionPixelSize);
        float f = dimension2 > dimension3 ? dimension2 : dimension3;
        this.mUserSetMinWidth = obtainStyledAttributes.getDimensionPixelSize(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_android_minWidth, 0);
        this.mUserSetMinHeight = obtainStyledAttributes.getDimensionPixelSize(X6FRs_4.PGPF6hQ_2.X6FRs_4.CardView_android_minHeight, 0);
        obtainStyledAttributes.recycle();
        IMPL.KQgRr5e_0(this.mCardViewDelegate, context, colorStateList, dimension, dimension2, f);
    }
}
