package androidx.appcompat.widget;

import X6FRs_4.KQgRr5e_0.XnFJ5_9;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.lang.ref.WeakReference;
/* loaded from: classes.dex */
public final class ViewStubCompat extends View {
    public int KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public LayoutInflater f2174KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public KQgRr5e_0 f2175KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public WeakReference<View> f2176KQgRr5e_0;
    public int QxJ9d_1;

    /* loaded from: classes.dex */
    public interface KQgRr5e_0 {
        void KQgRr5e_0(ViewStubCompat viewStubCompat, View view);
    }

    public ViewStubCompat(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public View KQgRr5e_0() {
        ViewParent parent = getParent();
        if (parent != null && (parent instanceof ViewGroup)) {
            if (this.KQgRr5e_0 != 0) {
                ViewGroup viewGroup = (ViewGroup) parent;
                LayoutInflater layoutInflater = this.f2174KQgRr5e_0;
                if (layoutInflater == null) {
                    layoutInflater = LayoutInflater.from(getContext());
                }
                View inflate = layoutInflater.inflate(this.KQgRr5e_0, viewGroup, false);
                int i = this.QxJ9d_1;
                if (i != -1) {
                    inflate.setId(i);
                }
                int indexOfChild = viewGroup.indexOfChild(this);
                viewGroup.removeViewInLayout(this);
                ViewGroup.LayoutParams layoutParams = getLayoutParams();
                if (layoutParams != null) {
                    viewGroup.addView(inflate, indexOfChild, layoutParams);
                } else {
                    viewGroup.addView(inflate, indexOfChild);
                }
                this.f2176KQgRr5e_0 = new WeakReference<>(inflate);
                KQgRr5e_0 kQgRr5e_0 = this.f2175KQgRr5e_0;
                if (kQgRr5e_0 != null) {
                    kQgRr5e_0.KQgRr5e_0(this, inflate);
                }
                return inflate;
            }
            throw new IllegalArgumentException("ViewStub must have a valid layoutResource");
        }
        throw new IllegalStateException("ViewStub must have a non-null ViewGroup viewParent");
    }

    @Override // android.view.View
    public void dispatchDraw(Canvas canvas) {
    }

    @Override // android.view.View
    @SuppressLint({"MissingSuperCall"})
    public void draw(Canvas canvas) {
    }

    public int getInflatedId() {
        return this.QxJ9d_1;
    }

    public LayoutInflater getLayoutInflater() {
        return this.f2174KQgRr5e_0;
    }

    public int getLayoutResource() {
        return this.KQgRr5e_0;
    }

    @Override // android.view.View
    public void onMeasure(int i, int i2) {
        setMeasuredDimension(0, 0);
    }

    public void setInflatedId(int i) {
        this.QxJ9d_1 = i;
    }

    public void setLayoutInflater(LayoutInflater layoutInflater) {
        this.f2174KQgRr5e_0 = layoutInflater;
    }

    public void setLayoutResource(int i) {
        this.KQgRr5e_0 = i;
    }

    public void setOnInflateListener(KQgRr5e_0 kQgRr5e_0) {
        this.f2175KQgRr5e_0 = kQgRr5e_0;
    }

    @Override // android.view.View
    public void setVisibility(int i) {
        WeakReference<View> weakReference = this.f2176KQgRr5e_0;
        if (weakReference != null) {
            View view = weakReference.get();
            if (view != null) {
                view.setVisibility(i);
                return;
            }
            throw new IllegalStateException("setVisibility called on un-referenced view");
        }
        super.setVisibility(i);
        if (i == 0 || i == 4) {
            KQgRr5e_0();
        }
    }

    public ViewStubCompat(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.KQgRr5e_0 = 0;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, XnFJ5_9.ViewStubCompat, i, 0);
        this.QxJ9d_1 = obtainStyledAttributes.getResourceId(XnFJ5_9.ViewStubCompat_android_inflatedId, -1);
        this.KQgRr5e_0 = obtainStyledAttributes.getResourceId(XnFJ5_9.ViewStubCompat_android_layout, 0);
        setId(obtainStyledAttributes.getResourceId(XnFJ5_9.ViewStubCompat_android_id, -1));
        obtainStyledAttributes.recycle();
        setVisibility(8);
        setWillNotDraw(true);
    }
}
