package androidx.appcompat.widget;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import X6FRs_4.KQgRr5e_0.LGe8pk_15.DtqPmDY_31;
import X6FRs_4.KQgRr5e_0.LGe8pk_15.NzhupJ_29;
import X6FRs_4.KQgRr5e_0.LGe8pk_15.R6WQ_35;
import X6FRs_4.KQgRr5e_0.LGe8pk_15.SI64pbG_23;
import android.app.PendingIntent;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.customview.view.AbsSavedState;
import androidx.recyclerview.widget.RecyclerView;
import com.wang.avi.BuildConfig;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
/* loaded from: classes.dex */
public class SearchView extends LinearLayoutCompat implements X6FRs_4.KQgRr5e_0.YghfZG_14.PGPF6hQ_2 {
    public static final Nm6q_10 KQgRr5e_0 = new Nm6q_10();

    /* renamed from: FSaI4_7  reason: collision with root package name */
    public boolean f3473FSaI4_7;

    /* renamed from: IFxWkV_5  reason: collision with root package name */
    public boolean f3474IFxWkV_5;

    /* renamed from: IMuAHx_6  reason: collision with root package name */
    public boolean f3475IMuAHx_6;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final int f2097KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public X6FRs_4.FSaI4_7.KQgRr5e_0.KQgRr5e_0 f2098KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public SearchableInfo f2099KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Intent f2100KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Rect f2101KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Drawable f2102KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Bundle f2103KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public TextWatcher f2104KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public View.OnClickListener f2105KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public View.OnFocusChangeListener f2106KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public View.OnKeyListener f2107KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final View f2108KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final AdapterView.OnItemClickListener f2109KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final AdapterView.OnItemSelectedListener f2110KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final ImageView f2111KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final TextView.OnEditorActionListener f2112KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public EuDEkJe_12 f2113KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public KNBe_11 f2114KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final SearchAutoComplete f2115KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public WwEq_13 f2116KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public YghfZG_14 f2117KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final CharSequence f2118KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Runnable f2119KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final WeakHashMap<String, Drawable.ConstantState> f2120KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public int[] f2121KQgRr5e_0;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public int f3476Mqv2r_3;

    /* renamed from: Mqv2r_3  reason: collision with other field name */
    public final View f2122Mqv2r_3;

    /* renamed from: Mqv2r_3  reason: collision with other field name */
    public final ImageView f2123Mqv2r_3;

    /* renamed from: Mqv2r_3  reason: collision with other field name */
    public CharSequence f2124Mqv2r_3;

    /* renamed from: Mqv2r_3  reason: collision with other field name */
    public boolean f2125Mqv2r_3;
    public int PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public final View f2126PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public final ImageView f2127PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public CharSequence f2128PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public boolean f2129PGPF6hQ_2;
    public final int QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public final Intent f2130QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public Rect f2131QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public final View.OnClickListener f2132QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public final View f2133QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public final ImageView f2134QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public CharSequence f2135QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public Runnable f2136QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f2137QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public int[] f2138QxJ9d_1;

    /* renamed from: X6FRs_4  reason: collision with root package name */
    public final ImageView f3477X6FRs_4;

    /* renamed from: X6FRs_4  reason: collision with other field name */
    public boolean f2139X6FRs_4;

    /* loaded from: classes.dex */
    public interface EuDEkJe_12 {
        boolean KQgRr5e_0(String str);

        boolean QxJ9d_1(String str);
    }

    /* loaded from: classes.dex */
    public class FSaI4_7 implements TextView.OnEditorActionListener {
        public FSaI4_7() {
        }

        @Override // android.widget.TextView.OnEditorActionListener
        public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
            SearchView.this.FSaI4_7();
            return true;
        }
    }

    /* loaded from: classes.dex */
    public class IFxWkV_5 implements View.OnClickListener {
        public IFxWkV_5() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            SearchView searchView = SearchView.this;
            if (view == searchView.f2111KQgRr5e_0) {
                searchView.IMuAHx_6();
            } else if (view == searchView.f2127PGPF6hQ_2) {
                searchView.IFxWkV_5();
            } else if (view == searchView.f2134QxJ9d_1) {
                searchView.FSaI4_7();
            } else if (view == searchView.f2123Mqv2r_3) {
                searchView.XnFJ5_9();
            } else if (view == searchView.f2115KQgRr5e_0) {
                searchView.X6FRs_4();
            }
        }
    }

    /* loaded from: classes.dex */
    public class IMuAHx_6 implements View.OnKeyListener {
        public IMuAHx_6() {
        }

        @Override // android.view.View.OnKeyListener
        public boolean onKey(View view, int i, KeyEvent keyEvent) {
            SearchView searchView = SearchView.this;
            if (searchView.f2099KQgRr5e_0 == null) {
                return false;
            }
            if (searchView.f2115KQgRr5e_0.isPopupShowing() && SearchView.this.f2115KQgRr5e_0.getListSelection() != -1) {
                return SearchView.this.KQgRr5e_0(view, i, keyEvent);
            }
            if (!SearchView.this.f2115KQgRr5e_0.m853KQgRr5e_0() && keyEvent.hasNoModifiers() && keyEvent.getAction() == 1 && i == 66) {
                view.cancelLongPress();
                SearchView searchView2 = SearchView.this;
                searchView2.KQgRr5e_0(0, (String) null, searchView2.f2115KQgRr5e_0.getText().toString());
                return true;
            }
            return false;
        }
    }

    /* loaded from: classes.dex */
    public interface KNBe_11 {
        boolean KQgRr5e_0();
    }

    /* loaded from: classes.dex */
    public class KQgRr5e_0 implements TextWatcher {
        public KQgRr5e_0() {
        }

        @Override // android.text.TextWatcher
        public void afterTextChanged(Editable editable) {
        }

        @Override // android.text.TextWatcher
        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        @Override // android.text.TextWatcher
        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            SearchView.this.QxJ9d_1(charSequence);
        }
    }

    /* loaded from: classes.dex */
    public class Mqv2r_3 implements View.OnFocusChangeListener {
        public Mqv2r_3() {
        }

        @Override // android.view.View.OnFocusChangeListener
        public void onFocusChange(View view, boolean z) {
            SearchView searchView = SearchView.this;
            View.OnFocusChangeListener onFocusChangeListener = searchView.f2106KQgRr5e_0;
            if (onFocusChangeListener != null) {
                onFocusChangeListener.onFocusChange(searchView, z);
            }
        }
    }

    /* loaded from: classes.dex */
    public class PGPF6hQ_2 implements Runnable {
        public PGPF6hQ_2() {
        }

        @Override // java.lang.Runnable
        public void run() {
            X6FRs_4.FSaI4_7.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0 = SearchView.this.f2098KQgRr5e_0;
            if (kQgRr5e_0 == null || !(kQgRr5e_0 instanceof SI64pbG_23)) {
                return;
            }
            kQgRr5e_0.KQgRr5e_0((Cursor) null);
        }
    }

    /* loaded from: classes.dex */
    public class QxJ9d_1 implements Runnable {
        public QxJ9d_1() {
        }

        @Override // java.lang.Runnable
        public void run() {
            SearchView.this.EuDEkJe_12();
        }
    }

    /* loaded from: classes.dex */
    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new KQgRr5e_0();
        public boolean QxJ9d_1;

        /* loaded from: classes.dex */
        public static class KQgRr5e_0 implements Parcelable.ClassLoaderCreator<SavedState> {
            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: KQgRr5e_0 */
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "SearchView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " isIconified=" + this.QxJ9d_1 + "}";
        }

        @Override // androidx.customview.view.AbsSavedState, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeValue(Boolean.valueOf(this.QxJ9d_1));
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.QxJ9d_1 = ((Boolean) parcel.readValue(null)).booleanValue();
        }
    }

    /* loaded from: classes.dex */
    public static class SearchAutoComplete extends AppCompatAutoCompleteTextView {
        public int KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public SearchView f2140KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Runnable f2141KQgRr5e_0;
        public boolean QxJ9d_1;

        /* loaded from: classes.dex */
        public class KQgRr5e_0 implements Runnable {
            public KQgRr5e_0() {
            }

            @Override // java.lang.Runnable
            public void run() {
                SearchAutoComplete.this.KQgRr5e_0();
            }
        }

        public SearchAutoComplete(Context context) {
            this(context, null);
        }

        private int getSearchViewTextMinWidthDp() {
            Configuration configuration = getResources().getConfiguration();
            int i = configuration.screenWidthDp;
            int i2 = configuration.screenHeightDp;
            if (i < 960 || i2 < 720 || configuration.orientation != 2) {
                if (i < 600) {
                    return (i < 640 || i2 < 480) ? 160 : 192;
                }
                return 192;
            }
            return RecyclerView.WGk6X_27.FLAG_TMP_DETACHED;
        }

        /* renamed from: KQgRr5e_0  reason: collision with other method in class */
        public boolean m853KQgRr5e_0() {
            return TextUtils.getTrimmedLength(getText()) == 0;
        }

        @Override // android.widget.AutoCompleteTextView
        public boolean enoughToFilter() {
            return this.KQgRr5e_0 <= 0 || super.enoughToFilter();
        }

        @Override // androidx.appcompat.widget.AppCompatAutoCompleteTextView, android.widget.TextView, android.view.View
        public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
            InputConnection onCreateInputConnection = super.onCreateInputConnection(editorInfo);
            if (this.QxJ9d_1) {
                removeCallbacks(this.f2141KQgRr5e_0);
                post(this.f2141KQgRr5e_0);
            }
            return onCreateInputConnection;
        }

        @Override // android.view.View
        public void onFinishInflate() {
            super.onFinishInflate();
            setMinWidth((int) TypedValue.applyDimension(1, getSearchViewTextMinWidthDp(), getResources().getDisplayMetrics()));
        }

        @Override // android.widget.AutoCompleteTextView, android.widget.TextView, android.view.View
        public void onFocusChanged(boolean z, int i, Rect rect) {
            super.onFocusChanged(z, i, rect);
            this.f2140KQgRr5e_0.Xgtqvk_8();
        }

        @Override // android.widget.AutoCompleteTextView, android.widget.TextView, android.view.View
        public boolean onKeyPreIme(int i, KeyEvent keyEvent) {
            if (i == 4) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState keyDispatcherState = getKeyDispatcherState();
                    if (keyDispatcherState != null) {
                        keyDispatcherState.startTracking(keyEvent, this);
                    }
                    return true;
                } else if (keyEvent.getAction() == 1) {
                    KeyEvent.DispatcherState keyDispatcherState2 = getKeyDispatcherState();
                    if (keyDispatcherState2 != null) {
                        keyDispatcherState2.handleUpEvent(keyEvent);
                    }
                    if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                        this.f2140KQgRr5e_0.clearFocus();
                        setImeVisibility(false);
                        return true;
                    }
                }
            }
            return super.onKeyPreIme(i, keyEvent);
        }

        @Override // android.widget.AutoCompleteTextView, android.widget.TextView, android.view.View
        public void onWindowFocusChanged(boolean z) {
            super.onWindowFocusChanged(z);
            if (z && this.f2140KQgRr5e_0.hasFocus() && getVisibility() == 0) {
                this.QxJ9d_1 = true;
                if (SearchView.KQgRr5e_0(getContext())) {
                    SearchView.KQgRr5e_0.KQgRr5e_0(this, true);
                }
            }
        }

        @Override // android.widget.AutoCompleteTextView
        public void performCompletion() {
        }

        @Override // android.widget.AutoCompleteTextView
        public void replaceText(CharSequence charSequence) {
        }

        public void setImeVisibility(boolean z) {
            InputMethodManager inputMethodManager = (InputMethodManager) getContext().getSystemService("input_method");
            if (!z) {
                this.QxJ9d_1 = false;
                removeCallbacks(this.f2141KQgRr5e_0);
                inputMethodManager.hideSoftInputFromWindow(getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this)) {
                this.QxJ9d_1 = false;
                removeCallbacks(this.f2141KQgRr5e_0);
                inputMethodManager.showSoftInput(this, 0);
            } else {
                this.QxJ9d_1 = true;
            }
        }

        public void setSearchView(SearchView searchView) {
            this.f2140KQgRr5e_0 = searchView;
        }

        @Override // android.widget.AutoCompleteTextView
        public void setThreshold(int i) {
            super.setThreshold(i);
            this.KQgRr5e_0 = i;
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet) {
            this(context, attributeSet, X6FRs_4.KQgRr5e_0.KQgRr5e_0.autoCompleteTextViewStyle);
        }

        public void KQgRr5e_0() {
            if (this.QxJ9d_1) {
                ((InputMethodManager) getContext().getSystemService("input_method")).showSoftInput(this, 0);
                this.QxJ9d_1 = false;
            }
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int i) {
            super(context, attributeSet, i);
            this.f2141KQgRr5e_0 = new KQgRr5e_0();
            this.KQgRr5e_0 = getThreshold();
        }
    }

    /* loaded from: classes.dex */
    public interface WwEq_13 {
        boolean KQgRr5e_0(int i);

        boolean QxJ9d_1(int i);
    }

    /* loaded from: classes.dex */
    public class X6FRs_4 implements View.OnLayoutChangeListener {
        public X6FRs_4() {
        }

        @Override // android.view.View.OnLayoutChangeListener
        public void onLayoutChange(View view, int i, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
            SearchView.this.PGPF6hQ_2();
        }
    }

    /* loaded from: classes.dex */
    public class Xgtqvk_8 implements AdapterView.OnItemClickListener {
        public Xgtqvk_8() {
        }

        @Override // android.widget.AdapterView.OnItemClickListener
        public void onItemClick(AdapterView<?> adapterView, View view, int i, long j) {
            SearchView.this.QxJ9d_1(i, 0, null);
        }
    }

    /* loaded from: classes.dex */
    public class XnFJ5_9 implements AdapterView.OnItemSelectedListener {
        public XnFJ5_9() {
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onItemSelected(AdapterView<?> adapterView, View view, int i, long j) {
            SearchView.this.m851KQgRr5e_0(i);
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onNothingSelected(AdapterView<?> adapterView) {
        }
    }

    /* loaded from: classes.dex */
    public static class YghfZG_14 extends TouchDelegate {
        public final int KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Rect f2142KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final View f2143KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public boolean f2144KQgRr5e_0;
        public final Rect PGPF6hQ_2;
        public final Rect QxJ9d_1;

        public YghfZG_14(Rect rect, Rect rect2, View view) {
            super(rect, view);
            this.KQgRr5e_0 = ViewConfiguration.get(view.getContext()).getScaledTouchSlop();
            this.f2142KQgRr5e_0 = new Rect();
            this.PGPF6hQ_2 = new Rect();
            this.QxJ9d_1 = new Rect();
            KQgRr5e_0(rect, rect2);
            this.f2143KQgRr5e_0 = view;
        }

        public void KQgRr5e_0(Rect rect, Rect rect2) {
            this.f2142KQgRr5e_0.set(rect);
            this.PGPF6hQ_2.set(rect);
            Rect rect3 = this.PGPF6hQ_2;
            int i = this.KQgRr5e_0;
            rect3.inset(-i, -i);
            this.QxJ9d_1.set(rect2);
        }

        @Override // android.view.TouchDelegate
        public boolean onTouchEvent(MotionEvent motionEvent) {
            boolean z;
            boolean z2;
            int x = (int) motionEvent.getX();
            int y = (int) motionEvent.getY();
            int action = motionEvent.getAction();
            boolean z3 = true;
            if (action != 0) {
                if (action == 1 || action == 2) {
                    z2 = this.f2144KQgRr5e_0;
                    if (z2 && !this.PGPF6hQ_2.contains(x, y)) {
                        z3 = z2;
                        z = false;
                    }
                } else {
                    if (action == 3) {
                        z2 = this.f2144KQgRr5e_0;
                        this.f2144KQgRr5e_0 = false;
                    }
                    z = true;
                    z3 = false;
                }
                z3 = z2;
                z = true;
            } else {
                if (this.f2142KQgRr5e_0.contains(x, y)) {
                    this.f2144KQgRr5e_0 = true;
                    z = true;
                }
                z = true;
                z3 = false;
            }
            if (z3) {
                if (z && !this.QxJ9d_1.contains(x, y)) {
                    motionEvent.setLocation(this.f2143KQgRr5e_0.getWidth() / 2, this.f2143KQgRr5e_0.getHeight() / 2);
                } else {
                    Rect rect = this.QxJ9d_1;
                    motionEvent.setLocation(x - rect.left, y - rect.top);
                }
                return this.f2143KQgRr5e_0.dispatchTouchEvent(motionEvent);
            }
            return false;
        }
    }

    public SearchView(Context context) {
        this(context, null);
    }

    private int getPreferredHeight() {
        return getContext().getResources().getDimensionPixelSize(X6FRs_4.KQgRr5e_0.Mqv2r_3.abc_search_view_preferred_height);
    }

    private int getPreferredWidth() {
        return getContext().getResources().getDimensionPixelSize(X6FRs_4.KQgRr5e_0.Mqv2r_3.abc_search_view_preferred_width);
    }

    private void setQuery(CharSequence charSequence) {
        this.f2115KQgRr5e_0.setText(charSequence);
        this.f2115KQgRr5e_0.setSelection(TextUtils.isEmpty(charSequence) ? 0 : charSequence.length());
    }

    public void EuDEkJe_12() {
        int[] iArr = this.f2115KQgRr5e_0.hasFocus() ? ViewGroup.FOCUSED_STATE_SET : ViewGroup.EMPTY_STATE_SET;
        Drawable background = this.f2133QxJ9d_1.getBackground();
        if (background != null) {
            background.setState(iArr);
        }
        Drawable background2 = this.f2126PGPF6hQ_2.getBackground();
        if (background2 != null) {
            background2.setState(iArr);
        }
        invalidate();
    }

    public void FSaI4_7() {
        Editable text = this.f2115KQgRr5e_0.getText();
        if (text == null || TextUtils.getTrimmedLength(text) <= 0) {
            return;
        }
        EuDEkJe_12 euDEkJe_12 = this.f2113KQgRr5e_0;
        if (euDEkJe_12 == null || !euDEkJe_12.KQgRr5e_0(text.toString())) {
            if (this.f2099KQgRr5e_0 != null) {
                KQgRr5e_0(0, (String) null, text.toString());
            }
            this.f2115KQgRr5e_0.setImeVisibility(false);
            Mqv2r_3();
        }
    }

    public void IFxWkV_5() {
        if (TextUtils.isEmpty(this.f2115KQgRr5e_0.getText())) {
            if (this.f2137QxJ9d_1) {
                KNBe_11 kNBe_11 = this.f2114KQgRr5e_0;
                if (kNBe_11 == null || !kNBe_11.KQgRr5e_0()) {
                    clearFocus();
                    QxJ9d_1(true);
                    return;
                }
                return;
            }
            return;
        }
        this.f2115KQgRr5e_0.setText(BuildConfig.FLAVOR);
        this.f2115KQgRr5e_0.requestFocus();
        this.f2115KQgRr5e_0.setImeVisibility(true);
    }

    public void IMuAHx_6() {
        QxJ9d_1(false);
        this.f2115KQgRr5e_0.requestFocus();
        this.f2115KQgRr5e_0.setImeVisibility(true);
        View.OnClickListener onClickListener = this.f2105KQgRr5e_0;
        if (onClickListener != null) {
            onClickListener.onClick(this);
        }
    }

    public final void KNBe_11() {
        boolean z = true;
        boolean z2 = !TextUtils.isEmpty(this.f2115KQgRr5e_0.getText());
        if (!z2 && (!this.f2137QxJ9d_1 || this.f3473FSaI4_7)) {
            z = false;
        }
        this.f2127PGPF6hQ_2.setVisibility(z ? 0 : 8);
        Drawable drawable = this.f2127PGPF6hQ_2.getDrawable();
        if (drawable != null) {
            drawable.setState(z2 ? ViewGroup.ENABLED_STATE_SET : ViewGroup.EMPTY_STATE_SET);
        }
    }

    public void KQgRr5e_0(CharSequence charSequence, boolean z) {
        this.f2115KQgRr5e_0.setText(charSequence);
        if (charSequence != null) {
            SearchAutoComplete searchAutoComplete = this.f2115KQgRr5e_0;
            searchAutoComplete.setSelection(searchAutoComplete.length());
            this.f2124Mqv2r_3 = charSequence;
        }
        if (!z || TextUtils.isEmpty(charSequence)) {
            return;
        }
        FSaI4_7();
    }

    public final void LGe8pk_15() {
        this.f2126PGPF6hQ_2.setVisibility((m852PGPF6hQ_2() && (this.f2134QxJ9d_1.getVisibility() == 0 || this.f2123Mqv2r_3.getVisibility() == 0)) ? 0 : 8);
    }

    public final void Mqv2r_3() {
        this.f2115KQgRr5e_0.dismissDropDown();
    }

    public final void Nm6q_10() {
        post(this.f2119KQgRr5e_0);
    }

    /* renamed from: PGPF6hQ_2  reason: collision with other method in class */
    public final boolean m852PGPF6hQ_2() {
        return (this.f2125Mqv2r_3 || this.f3475IMuAHx_6) && !QxJ9d_1();
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.PGPF6hQ_2
    public boolean QxJ9d_1() {
        return this.f2129PGPF6hQ_2;
    }

    public final void WwEq_13() {
        CharSequence queryHint = getQueryHint();
        SearchAutoComplete searchAutoComplete = this.f2115KQgRr5e_0;
        if (queryHint == null) {
            queryHint = BuildConfig.FLAVOR;
        }
        searchAutoComplete.setHint(KQgRr5e_0(queryHint));
    }

    public void X6FRs_4() {
        KQgRr5e_0.QxJ9d_1(this.f2115KQgRr5e_0);
        KQgRr5e_0.KQgRr5e_0(this.f2115KQgRr5e_0);
    }

    public void Xgtqvk_8() {
        QxJ9d_1(QxJ9d_1());
        Nm6q_10();
        if (this.f2115KQgRr5e_0.hasFocus()) {
            X6FRs_4();
        }
    }

    public void XnFJ5_9() {
        SearchableInfo searchableInfo = this.f2099KQgRr5e_0;
        if (searchableInfo == null) {
            return;
        }
        try {
            if (searchableInfo.getVoiceSearchLaunchWebSearch()) {
                getContext().startActivity(QxJ9d_1(this.f2100KQgRr5e_0, searchableInfo));
            } else if (searchableInfo.getVoiceSearchLaunchRecognizer()) {
                getContext().startActivity(KQgRr5e_0(this.f2130QxJ9d_1, searchableInfo));
            }
        } catch (ActivityNotFoundException unused) {
            Log.w("SearchView", "Could not find voice search activity");
        }
    }

    public final void YghfZG_14() {
        this.f2115KQgRr5e_0.setThreshold(this.f2099KQgRr5e_0.getSuggestThreshold());
        this.f2115KQgRr5e_0.setImeOptions(this.f2099KQgRr5e_0.getImeOptions());
        int inputType = this.f2099KQgRr5e_0.getInputType();
        if ((inputType & 15) == 1) {
            inputType &= -65537;
            if (this.f2099KQgRr5e_0.getSuggestAuthority() != null) {
                inputType = inputType | 65536 | 524288;
            }
        }
        this.f2115KQgRr5e_0.setInputType(inputType);
        X6FRs_4.FSaI4_7.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0 = this.f2098KQgRr5e_0;
        if (kQgRr5e_0 != null) {
            kQgRr5e_0.KQgRr5e_0((Cursor) null);
        }
        if (this.f2099KQgRr5e_0.getSuggestAuthority() != null) {
            SI64pbG_23 sI64pbG_23 = new SI64pbG_23(getContext(), this, this.f2099KQgRr5e_0, this.f2120KQgRr5e_0);
            this.f2098KQgRr5e_0 = sI64pbG_23;
            this.f2115KQgRr5e_0.setAdapter(sI64pbG_23);
            ((SI64pbG_23) this.f2098KQgRr5e_0).KQgRr5e_0(this.f2139X6FRs_4 ? 2 : 1);
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public void clearFocus() {
        this.f3474IFxWkV_5 = true;
        super.clearFocus();
        this.f2115KQgRr5e_0.clearFocus();
        this.f2115KQgRr5e_0.setImeVisibility(false);
        this.f3474IFxWkV_5 = false;
    }

    public int getImeOptions() {
        return this.f2115KQgRr5e_0.getImeOptions();
    }

    public int getInputType() {
        return this.f2115KQgRr5e_0.getInputType();
    }

    public int getMaxWidth() {
        return this.PGPF6hQ_2;
    }

    public CharSequence getQuery() {
        return this.f2115KQgRr5e_0.getText();
    }

    public CharSequence getQueryHint() {
        CharSequence charSequence = this.f2135QxJ9d_1;
        if (charSequence != null) {
            return charSequence;
        }
        SearchableInfo searchableInfo = this.f2099KQgRr5e_0;
        if (searchableInfo != null && searchableInfo.getHintId() != 0) {
            return getContext().getText(this.f2099KQgRr5e_0.getHintId());
        }
        return this.f2118KQgRr5e_0;
    }

    public int getSuggestionCommitIconResId() {
        return this.QxJ9d_1;
    }

    public int getSuggestionRowLayout() {
        return this.f2097KQgRr5e_0;
    }

    public X6FRs_4.FSaI4_7.KQgRr5e_0.KQgRr5e_0 getSuggestionsAdapter() {
        return this.f2098KQgRr5e_0;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onDetachedFromWindow() {
        removeCallbacks(this.f2119KQgRr5e_0);
        post(this.f2136QxJ9d_1);
        super.onDetachedFromWindow();
    }

    @Override // androidx.appcompat.widget.LinearLayoutCompat, android.view.ViewGroup, android.view.View
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        if (z) {
            KQgRr5e_0(this.f2115KQgRr5e_0, this.f2101KQgRr5e_0);
            Rect rect = this.f2131QxJ9d_1;
            Rect rect2 = this.f2101KQgRr5e_0;
            rect.set(rect2.left, 0, rect2.right, i4 - i2);
            YghfZG_14 yghfZG_14 = this.f2117KQgRr5e_0;
            if (yghfZG_14 == null) {
                YghfZG_14 yghfZG_142 = new YghfZG_14(this.f2131QxJ9d_1, this.f2101KQgRr5e_0, this.f2115KQgRr5e_0);
                this.f2117KQgRr5e_0 = yghfZG_142;
                setTouchDelegate(yghfZG_142);
                return;
            }
            yghfZG_14.KQgRr5e_0(this.f2131QxJ9d_1, this.f2101KQgRr5e_0);
        }
    }

    @Override // androidx.appcompat.widget.LinearLayoutCompat, android.view.View
    public void onMeasure(int i, int i2) {
        int i3;
        if (QxJ9d_1()) {
            super.onMeasure(i, i2);
            return;
        }
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        if (mode == Integer.MIN_VALUE) {
            int i4 = this.PGPF6hQ_2;
            size = i4 > 0 ? Math.min(i4, size) : Math.min(getPreferredWidth(), size);
        } else if (mode == 0) {
            size = this.PGPF6hQ_2;
            if (size <= 0) {
                size = getPreferredWidth();
            }
        } else if (mode == 1073741824 && (i3 = this.PGPF6hQ_2) > 0) {
            size = Math.min(i3, size);
        }
        int mode2 = View.MeasureSpec.getMode(i2);
        int size2 = View.MeasureSpec.getSize(i2);
        if (mode2 == Integer.MIN_VALUE) {
            size2 = Math.min(getPreferredHeight(), size2);
        } else if (mode2 == 0) {
            size2 = getPreferredHeight();
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec(size, 1073741824), View.MeasureSpec.makeMeasureSpec(size2, 1073741824));
    }

    @Override // android.view.View
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        QxJ9d_1(savedState.QxJ9d_1);
        requestLayout();
    }

    @Override // android.view.View
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.QxJ9d_1 = QxJ9d_1();
        return savedState;
    }

    @Override // android.view.View
    public void onWindowFocusChanged(boolean z) {
        super.onWindowFocusChanged(z);
        Nm6q_10();
    }

    @Override // android.view.ViewGroup, android.view.View
    public boolean requestFocus(int i, Rect rect) {
        if (!this.f3474IFxWkV_5 && isFocusable()) {
            if (!QxJ9d_1()) {
                boolean requestFocus = this.f2115KQgRr5e_0.requestFocus(i, rect);
                if (requestFocus) {
                    QxJ9d_1(false);
                }
                return requestFocus;
            }
            return super.requestFocus(i, rect);
        }
        return false;
    }

    public void setAppSearchData(Bundle bundle) {
        this.f2103KQgRr5e_0 = bundle;
    }

    public void setIconified(boolean z) {
        if (z) {
            IFxWkV_5();
        } else {
            IMuAHx_6();
        }
    }

    public void setIconifiedByDefault(boolean z) {
        if (this.f2137QxJ9d_1 == z) {
            return;
        }
        this.f2137QxJ9d_1 = z;
        QxJ9d_1(z);
        WwEq_13();
    }

    public void setImeOptions(int i) {
        this.f2115KQgRr5e_0.setImeOptions(i);
    }

    public void setInputType(int i) {
        this.f2115KQgRr5e_0.setInputType(i);
    }

    public void setMaxWidth(int i) {
        this.PGPF6hQ_2 = i;
        requestLayout();
    }

    public void setOnCloseListener(KNBe_11 kNBe_11) {
        this.f2114KQgRr5e_0 = kNBe_11;
    }

    public void setOnQueryTextFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.f2106KQgRr5e_0 = onFocusChangeListener;
    }

    public void setOnQueryTextListener(EuDEkJe_12 euDEkJe_12) {
        this.f2113KQgRr5e_0 = euDEkJe_12;
    }

    public void setOnSearchClickListener(View.OnClickListener onClickListener) {
        this.f2105KQgRr5e_0 = onClickListener;
    }

    public void setOnSuggestionListener(WwEq_13 wwEq_13) {
        this.f2116KQgRr5e_0 = wwEq_13;
    }

    public void setQueryHint(CharSequence charSequence) {
        this.f2135QxJ9d_1 = charSequence;
        WwEq_13();
    }

    public void setQueryRefinementEnabled(boolean z) {
        this.f2139X6FRs_4 = z;
        X6FRs_4.FSaI4_7.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0 = this.f2098KQgRr5e_0;
        if (kQgRr5e_0 instanceof SI64pbG_23) {
            ((SI64pbG_23) kQgRr5e_0).KQgRr5e_0(z ? 2 : 1);
        }
    }

    public void setSearchableInfo(SearchableInfo searchableInfo) {
        this.f2099KQgRr5e_0 = searchableInfo;
        if (searchableInfo != null) {
            YghfZG_14();
            WwEq_13();
        }
        boolean KQgRr5e_02 = KQgRr5e_0();
        this.f3475IMuAHx_6 = KQgRr5e_02;
        if (KQgRr5e_02) {
            this.f2115KQgRr5e_0.setPrivateImeOptions("nm");
        }
        QxJ9d_1(QxJ9d_1());
    }

    public void setSubmitButtonEnabled(boolean z) {
        this.f2125Mqv2r_3 = z;
        QxJ9d_1(QxJ9d_1());
    }

    public void setSuggestionsAdapter(X6FRs_4.FSaI4_7.KQgRr5e_0.KQgRr5e_0 kQgRr5e_0) {
        this.f2098KQgRr5e_0 = kQgRr5e_0;
        this.f2115KQgRr5e_0.setAdapter(kQgRr5e_0);
    }

    /* loaded from: classes.dex */
    public static class Nm6q_10 {
        public Method KQgRr5e_0;
        public Method PGPF6hQ_2;
        public Method QxJ9d_1;

        public Nm6q_10() {
            try {
                Method declaredMethod = AutoCompleteTextView.class.getDeclaredMethod("doBeforeTextChanged", new Class[0]);
                this.KQgRr5e_0 = declaredMethod;
                declaredMethod.setAccessible(true);
            } catch (NoSuchMethodException unused) {
            }
            try {
                Method declaredMethod2 = AutoCompleteTextView.class.getDeclaredMethod("doAfterTextChanged", new Class[0]);
                this.QxJ9d_1 = declaredMethod2;
                declaredMethod2.setAccessible(true);
            } catch (NoSuchMethodException unused2) {
            }
            try {
                Method method = AutoCompleteTextView.class.getMethod("ensureImeVisible", Boolean.TYPE);
                this.PGPF6hQ_2 = method;
                method.setAccessible(true);
            } catch (NoSuchMethodException unused3) {
            }
        }

        public void KQgRr5e_0(AutoCompleteTextView autoCompleteTextView) {
            Method method = this.QxJ9d_1;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, new Object[0]);
                } catch (Exception unused) {
                }
            }
        }

        public void QxJ9d_1(AutoCompleteTextView autoCompleteTextView) {
            Method method = this.KQgRr5e_0;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, new Object[0]);
                } catch (Exception unused) {
                }
            }
        }

        public void KQgRr5e_0(AutoCompleteTextView autoCompleteTextView, boolean z) {
            Method method = this.PGPF6hQ_2;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, Boolean.valueOf(z));
                } catch (Exception unused) {
                }
            }
        }
    }

    public SearchView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, X6FRs_4.KQgRr5e_0.KQgRr5e_0.searchViewStyle);
    }

    public final void PGPF6hQ_2(boolean z) {
        int i = 8;
        if (this.f3475IMuAHx_6 && !QxJ9d_1() && z) {
            this.f2134QxJ9d_1.setVisibility(8);
            i = 0;
        }
        this.f2123Mqv2r_3.setVisibility(i);
    }

    public final void QxJ9d_1(boolean z) {
        this.f2129PGPF6hQ_2 = z;
        int i = 0;
        int i2 = z ? 0 : 8;
        boolean z2 = !TextUtils.isEmpty(this.f2115KQgRr5e_0.getText());
        this.f2111KQgRr5e_0.setVisibility(i2);
        KQgRr5e_0(z2);
        this.f2108KQgRr5e_0.setVisibility(z ? 8 : 0);
        this.f3477X6FRs_4.setVisibility((this.f3477X6FRs_4.getDrawable() == null || this.f2137QxJ9d_1) ? 8 : 8);
        KNBe_11();
        PGPF6hQ_2(!z2);
        LGe8pk_15();
    }

    public SearchView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f2101KQgRr5e_0 = new Rect();
        this.f2131QxJ9d_1 = new Rect();
        this.f2121KQgRr5e_0 = new int[2];
        this.f2138QxJ9d_1 = new int[2];
        this.f2119KQgRr5e_0 = new QxJ9d_1();
        this.f2136QxJ9d_1 = new PGPF6hQ_2();
        this.f2120KQgRr5e_0 = new WeakHashMap<>();
        this.f2132QxJ9d_1 = new IFxWkV_5();
        this.f2107KQgRr5e_0 = new IMuAHx_6();
        this.f2112KQgRr5e_0 = new FSaI4_7();
        this.f2109KQgRr5e_0 = new Xgtqvk_8();
        this.f2110KQgRr5e_0 = new XnFJ5_9();
        this.f2104KQgRr5e_0 = new KQgRr5e_0();
        NzhupJ_29 KQgRr5e_02 = NzhupJ_29.KQgRr5e_0(context, attributeSet, X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView, i, 0);
        LayoutInflater.from(context).inflate(KQgRr5e_02.IMuAHx_6(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_layout, X6FRs_4.KQgRr5e_0.IMuAHx_6.abc_search_view), (ViewGroup) this, true);
        SearchAutoComplete searchAutoComplete = (SearchAutoComplete) findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.search_src_text);
        this.f2115KQgRr5e_0 = searchAutoComplete;
        searchAutoComplete.setSearchView(this);
        this.f2108KQgRr5e_0 = findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.search_edit_frame);
        this.f2133QxJ9d_1 = findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.search_plate);
        this.f2126PGPF6hQ_2 = findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.submit_area);
        this.f2111KQgRr5e_0 = (ImageView) findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.search_button);
        this.f2134QxJ9d_1 = (ImageView) findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.search_go_btn);
        this.f2127PGPF6hQ_2 = (ImageView) findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.search_close_btn);
        this.f2123Mqv2r_3 = (ImageView) findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.search_voice_btn);
        this.f3477X6FRs_4 = (ImageView) findViewById(X6FRs_4.KQgRr5e_0.IFxWkV_5.search_mag_icon);
        ZzDuCHW_20.KQgRr5e_0(this.f2133QxJ9d_1, KQgRr5e_02.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_queryBackground));
        ZzDuCHW_20.KQgRr5e_0(this.f2126PGPF6hQ_2, KQgRr5e_02.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_submitBackground));
        this.f2111KQgRr5e_0.setImageDrawable(KQgRr5e_02.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_searchIcon));
        this.f2134QxJ9d_1.setImageDrawable(KQgRr5e_02.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_goIcon));
        this.f2127PGPF6hQ_2.setImageDrawable(KQgRr5e_02.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_closeIcon));
        this.f2123Mqv2r_3.setImageDrawable(KQgRr5e_02.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_voiceIcon));
        this.f3477X6FRs_4.setImageDrawable(KQgRr5e_02.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_searchIcon));
        this.f2102KQgRr5e_0 = KQgRr5e_02.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_searchHintIcon);
        DtqPmDY_31.KQgRr5e_0(this.f2111KQgRr5e_0, getResources().getString(X6FRs_4.KQgRr5e_0.FSaI4_7.abc_searchview_description_search));
        this.f2097KQgRr5e_0 = KQgRr5e_02.IMuAHx_6(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_suggestionRowLayout, X6FRs_4.KQgRr5e_0.IMuAHx_6.abc_search_dropdown_item_icons_2line);
        this.QxJ9d_1 = KQgRr5e_02.IMuAHx_6(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_commitIcon, 0);
        this.f2111KQgRr5e_0.setOnClickListener(this.f2132QxJ9d_1);
        this.f2127PGPF6hQ_2.setOnClickListener(this.f2132QxJ9d_1);
        this.f2134QxJ9d_1.setOnClickListener(this.f2132QxJ9d_1);
        this.f2123Mqv2r_3.setOnClickListener(this.f2132QxJ9d_1);
        this.f2115KQgRr5e_0.setOnClickListener(this.f2132QxJ9d_1);
        this.f2115KQgRr5e_0.addTextChangedListener(this.f2104KQgRr5e_0);
        this.f2115KQgRr5e_0.setOnEditorActionListener(this.f2112KQgRr5e_0);
        this.f2115KQgRr5e_0.setOnItemClickListener(this.f2109KQgRr5e_0);
        this.f2115KQgRr5e_0.setOnItemSelectedListener(this.f2110KQgRr5e_0);
        this.f2115KQgRr5e_0.setOnKeyListener(this.f2107KQgRr5e_0);
        this.f2115KQgRr5e_0.setOnFocusChangeListener(new Mqv2r_3());
        setIconifiedByDefault(KQgRr5e_02.KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_iconifiedByDefault, true));
        int PGPF6hQ_22 = KQgRr5e_02.PGPF6hQ_2(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_android_maxWidth, -1);
        if (PGPF6hQ_22 != -1) {
            setMaxWidth(PGPF6hQ_22);
        }
        this.f2118KQgRr5e_0 = KQgRr5e_02.m417KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_defaultQueryHint);
        this.f2135QxJ9d_1 = KQgRr5e_02.m417KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_queryHint);
        int Mqv2r_32 = KQgRr5e_02.Mqv2r_3(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_android_imeOptions, -1);
        if (Mqv2r_32 != -1) {
            setImeOptions(Mqv2r_32);
        }
        int Mqv2r_33 = KQgRr5e_02.Mqv2r_3(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_android_inputType, -1);
        if (Mqv2r_33 != -1) {
            setInputType(Mqv2r_33);
        }
        setFocusable(KQgRr5e_02.KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.SearchView_android_focusable, true));
        KQgRr5e_02.KQgRr5e_0();
        Intent intent = new Intent("android.speech.action.WEB_SEARCH");
        this.f2100KQgRr5e_0 = intent;
        intent.addFlags(268435456);
        this.f2100KQgRr5e_0.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        Intent intent2 = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.f2130QxJ9d_1 = intent2;
        intent2.addFlags(268435456);
        View findViewById = findViewById(this.f2115KQgRr5e_0.getDropDownAnchor());
        this.f2122Mqv2r_3 = findViewById;
        if (findViewById != null) {
            findViewById.addOnLayoutChangeListener(new X6FRs_4());
        }
        QxJ9d_1(this.f2137QxJ9d_1);
        WwEq_13();
    }

    public void PGPF6hQ_2() {
        int i;
        if (this.f2122Mqv2r_3.getWidth() > 1) {
            Resources resources = getContext().getResources();
            int paddingLeft = this.f2133QxJ9d_1.getPaddingLeft();
            Rect rect = new Rect();
            boolean m429KQgRr5e_0 = R6WQ_35.m429KQgRr5e_0((View) this);
            int dimensionPixelSize = this.f2137QxJ9d_1 ? resources.getDimensionPixelSize(X6FRs_4.KQgRr5e_0.Mqv2r_3.abc_dropdownitem_icon_width) + resources.getDimensionPixelSize(X6FRs_4.KQgRr5e_0.Mqv2r_3.abc_dropdownitem_text_padding_left) : 0;
            this.f2115KQgRr5e_0.getDropDownBackground().getPadding(rect);
            if (m429KQgRr5e_0) {
                i = -rect.left;
            } else {
                i = paddingLeft - (rect.left + dimensionPixelSize);
            }
            this.f2115KQgRr5e_0.setDropDownHorizontalOffset(i);
            this.f2115KQgRr5e_0.setDropDownWidth((((this.f2122Mqv2r_3.getWidth() + rect.left) + rect.right) + dimensionPixelSize) - paddingLeft);
        }
    }

    public final void KQgRr5e_0(View view, Rect rect) {
        view.getLocationInWindow(this.f2121KQgRr5e_0);
        getLocationInWindow(this.f2138QxJ9d_1);
        int[] iArr = this.f2121KQgRr5e_0;
        int i = iArr[1];
        int[] iArr2 = this.f2138QxJ9d_1;
        int i2 = i - iArr2[1];
        int i3 = iArr[0] - iArr2[0];
        rect.set(i3, i2, view.getWidth() + i3, view.getHeight() + i2);
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.PGPF6hQ_2
    public final boolean KQgRr5e_0() {
        SearchableInfo searchableInfo = this.f2099KQgRr5e_0;
        if (searchableInfo == null || !searchableInfo.getVoiceSearchEnabled()) {
            return false;
        }
        Intent intent = null;
        if (this.f2099KQgRr5e_0.getVoiceSearchLaunchWebSearch()) {
            intent = this.f2100KQgRr5e_0;
        } else if (this.f2099KQgRr5e_0.getVoiceSearchLaunchRecognizer()) {
            intent = this.f2130QxJ9d_1;
        }
        return (intent == null || getContext().getPackageManager().resolveActivity(intent, 65536) == null) ? false : true;
    }

    public void QxJ9d_1(CharSequence charSequence) {
        Editable text = this.f2115KQgRr5e_0.getText();
        this.f2124Mqv2r_3 = text;
        boolean z = !TextUtils.isEmpty(text);
        KQgRr5e_0(z);
        PGPF6hQ_2(!z);
        KNBe_11();
        LGe8pk_15();
        if (this.f2113KQgRr5e_0 != null && !TextUtils.equals(charSequence, this.f2128PGPF6hQ_2)) {
            this.f2113KQgRr5e_0.QxJ9d_1(charSequence.toString());
        }
        this.f2128PGPF6hQ_2 = charSequence.toString();
    }

    public final void KQgRr5e_0(boolean z) {
        this.f2134QxJ9d_1.setVisibility((this.f2125Mqv2r_3 && m852PGPF6hQ_2() && hasFocus() && (z || !this.f3475IMuAHx_6)) ? 0 : 8);
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public void m850KQgRr5e_0(CharSequence charSequence) {
        setQuery(charSequence);
    }

    public boolean KQgRr5e_0(View view, int i, KeyEvent keyEvent) {
        if (this.f2099KQgRr5e_0 != null && this.f2098KQgRr5e_0 != null && keyEvent.getAction() == 0 && keyEvent.hasNoModifiers()) {
            if (i == 66 || i == 84 || i == 61) {
                return QxJ9d_1(this.f2115KQgRr5e_0.getListSelection(), 0, null);
            }
            if (i != 21 && i != 22) {
                if (i != 19 || this.f2115KQgRr5e_0.getListSelection() == 0) {
                    return false;
                }
            } else {
                this.f2115KQgRr5e_0.setSelection(i == 21 ? 0 : this.f2115KQgRr5e_0.length());
                this.f2115KQgRr5e_0.setListSelection(0);
                this.f2115KQgRr5e_0.clearListSelection();
                KQgRr5e_0.KQgRr5e_0(this.f2115KQgRr5e_0, true);
                return true;
            }
        }
        return false;
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.PGPF6hQ_2
    public void QxJ9d_1() {
        if (this.f3473FSaI4_7) {
            return;
        }
        this.f3473FSaI4_7 = true;
        int imeOptions = this.f2115KQgRr5e_0.getImeOptions();
        this.f3476Mqv2r_3 = imeOptions;
        this.f2115KQgRr5e_0.setImeOptions(imeOptions | 33554432);
        this.f2115KQgRr5e_0.setText(BuildConfig.FLAVOR);
        setIconified(false);
    }

    public boolean QxJ9d_1(int i, int i2, String str) {
        WwEq_13 wwEq_13 = this.f2116KQgRr5e_0;
        if (wwEq_13 == null || !wwEq_13.KQgRr5e_0(i)) {
            KQgRr5e_0(i, 0, (String) null);
            this.f2115KQgRr5e_0.setImeVisibility(false);
            Mqv2r_3();
            return true;
        }
        return false;
    }

    public final CharSequence KQgRr5e_0(CharSequence charSequence) {
        if (!this.f2137QxJ9d_1 || this.f2102KQgRr5e_0 == null) {
            return charSequence;
        }
        double textSize = this.f2115KQgRr5e_0.getTextSize();
        Double.isNaN(textSize);
        int i = (int) (textSize * 1.25d);
        this.f2102KQgRr5e_0.setBounds(0, 0, i, i);
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder("   ");
        spannableStringBuilder.setSpan(new ImageSpan(this.f2102KQgRr5e_0), 1, 2, 33);
        spannableStringBuilder.append(charSequence);
        return spannableStringBuilder;
    }

    public final Intent QxJ9d_1(Intent intent, SearchableInfo searchableInfo) {
        Intent intent2 = new Intent(intent);
        ComponentName searchActivity = searchableInfo.getSearchActivity();
        intent2.putExtra("calling_package", searchActivity == null ? null : searchActivity.flattenToShortString());
        return intent2;
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.PGPF6hQ_2
    public void KQgRr5e_0() {
        KQgRr5e_0(BuildConfig.FLAVOR, false);
        clearFocus();
        QxJ9d_1(true);
        this.f2115KQgRr5e_0.setImeOptions(this.f3476Mqv2r_3);
        this.f3473FSaI4_7 = false;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public boolean m851KQgRr5e_0(int i) {
        WwEq_13 wwEq_13 = this.f2116KQgRr5e_0;
        if (wwEq_13 == null || !wwEq_13.QxJ9d_1(i)) {
            KQgRr5e_0(i);
            return true;
        }
        return false;
    }

    public final void KQgRr5e_0(int i) {
        Editable text = this.f2115KQgRr5e_0.getText();
        Cursor KQgRr5e_02 = this.f2098KQgRr5e_0.KQgRr5e_0();
        if (KQgRr5e_02 == null) {
            return;
        }
        if (KQgRr5e_02.moveToPosition(i)) {
            CharSequence KQgRr5e_03 = this.f2098KQgRr5e_0.KQgRr5e_0(KQgRr5e_02);
            if (KQgRr5e_03 != null) {
                setQuery(KQgRr5e_03);
                return;
            } else {
                setQuery(text);
                return;
            }
        }
        setQuery(text);
    }

    public final boolean KQgRr5e_0(int i, int i2, String str) {
        Cursor KQgRr5e_02 = this.f2098KQgRr5e_0.KQgRr5e_0();
        if (KQgRr5e_02 == null || !KQgRr5e_02.moveToPosition(i)) {
            return false;
        }
        KQgRr5e_0(KQgRr5e_0(KQgRr5e_02, i2, str));
        return true;
    }

    public final void KQgRr5e_0(Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            getContext().startActivity(intent);
        } catch (RuntimeException e) {
            Log.e("SearchView", "Failed launch activity: " + intent, e);
        }
    }

    public void KQgRr5e_0(int i, String str, String str2) {
        getContext().startActivity(KQgRr5e_0("android.intent.action.SEARCH", null, null, str2, i, str));
    }

    public final Intent KQgRr5e_0(String str, Uri uri, String str2, String str3, int i, String str4) {
        Intent intent = new Intent(str);
        intent.addFlags(268435456);
        if (uri != null) {
            intent.setData(uri);
        }
        intent.putExtra("user_query", this.f2124Mqv2r_3);
        if (str3 != null) {
            intent.putExtra("query", str3);
        }
        if (str2 != null) {
            intent.putExtra("intent_extra_data_key", str2);
        }
        Bundle bundle = this.f2103KQgRr5e_0;
        if (bundle != null) {
            intent.putExtra("app_data", bundle);
        }
        if (i != 0) {
            intent.putExtra("action_key", i);
            intent.putExtra("action_msg", str4);
        }
        intent.setComponent(this.f2099KQgRr5e_0.getSearchActivity());
        return intent;
    }

    public final Intent KQgRr5e_0(Intent intent, SearchableInfo searchableInfo) {
        ComponentName searchActivity = searchableInfo.getSearchActivity();
        Intent intent2 = new Intent("android.intent.action.SEARCH");
        intent2.setComponent(searchActivity);
        PendingIntent activity = PendingIntent.getActivity(getContext(), 0, intent2, 1073741824);
        Bundle bundle = new Bundle();
        Bundle bundle2 = this.f2103KQgRr5e_0;
        if (bundle2 != null) {
            bundle.putParcelable("app_data", bundle2);
        }
        Intent intent3 = new Intent(intent);
        Resources resources = getResources();
        String string = searchableInfo.getVoiceLanguageModeId() != 0 ? resources.getString(searchableInfo.getVoiceLanguageModeId()) : "free_form";
        String string2 = searchableInfo.getVoicePromptTextId() != 0 ? resources.getString(searchableInfo.getVoicePromptTextId()) : null;
        String string3 = searchableInfo.getVoiceLanguageId() != 0 ? resources.getString(searchableInfo.getVoiceLanguageId()) : null;
        int voiceMaxResults = searchableInfo.getVoiceMaxResults() != 0 ? searchableInfo.getVoiceMaxResults() : 1;
        intent3.putExtra("android.speech.extra.LANGUAGE_MODEL", string);
        intent3.putExtra("android.speech.extra.PROMPT", string2);
        intent3.putExtra("android.speech.extra.LANGUAGE", string3);
        intent3.putExtra("android.speech.extra.MAX_RESULTS", voiceMaxResults);
        intent3.putExtra("calling_package", searchActivity != null ? searchActivity.flattenToShortString() : null);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", activity);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", bundle);
        return intent3;
    }

    public final Intent KQgRr5e_0(Cursor cursor, int i, String str) {
        int i2;
        String KQgRr5e_02;
        try {
            String KQgRr5e_03 = SI64pbG_23.KQgRr5e_0(cursor, "suggest_intent_action");
            if (KQgRr5e_03 == null) {
                KQgRr5e_03 = this.f2099KQgRr5e_0.getSuggestIntentAction();
            }
            if (KQgRr5e_03 == null) {
                KQgRr5e_03 = "android.intent.action.SEARCH";
            }
            String str2 = KQgRr5e_03;
            String KQgRr5e_04 = SI64pbG_23.KQgRr5e_0(cursor, "suggest_intent_data");
            if (KQgRr5e_04 == null) {
                KQgRr5e_04 = this.f2099KQgRr5e_0.getSuggestIntentData();
            }
            if (KQgRr5e_04 != null && (KQgRr5e_02 = SI64pbG_23.KQgRr5e_0(cursor, "suggest_intent_data_id")) != null) {
                KQgRr5e_04 = KQgRr5e_04 + "/" + Uri.encode(KQgRr5e_02);
            }
            return KQgRr5e_0(str2, KQgRr5e_04 == null ? null : Uri.parse(KQgRr5e_04), SI64pbG_23.KQgRr5e_0(cursor, "suggest_intent_extra_data"), SI64pbG_23.KQgRr5e_0(cursor, "suggest_intent_query"), i, str);
        } catch (RuntimeException e) {
            try {
                i2 = cursor.getPosition();
            } catch (RuntimeException unused) {
                i2 = -1;
            }
            Log.w("SearchView", "Search suggestions cursor at row " + i2 + " returned exception.", e);
            return null;
        }
    }

    public static boolean KQgRr5e_0(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }
}
