package androidx.appcompat.widget;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import X6FRs_4.IMuAHx_6.WwEq_13.FSaI4_7;
import X6FRs_4.KQgRr5e_0.LGe8pk_15.LGe8pk_15;
import X6FRs_4.KQgRr5e_0.XnFJ5_9;
import X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import java.lang.reflect.Method;
/* loaded from: classes.dex */
public class ListPopupWindow implements Eps4cJe_18 {
    public static Method KQgRr5e_0;
    public static Method PGPF6hQ_2;
    public static Method QxJ9d_1;

    /* renamed from: FSaI4_7  reason: collision with root package name */
    public int f3468FSaI4_7;

    /* renamed from: IFxWkV_5  reason: collision with root package name */
    public int f3469IFxWkV_5;

    /* renamed from: IFxWkV_5  reason: collision with other field name */
    public boolean f2071IFxWkV_5;

    /* renamed from: IMuAHx_6  reason: collision with root package name */
    public int f3470IMuAHx_6;

    /* renamed from: IMuAHx_6  reason: collision with other field name */
    public boolean f2072IMuAHx_6;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public int f2073KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public LGe8pk_15 f2074KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Context f2075KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public DataSetObserver f2076KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Rect f2077KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Drawable f2078KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Handler f2079KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public View f2080KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public AdapterView.OnItemClickListener f2081KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public AdapterView.OnItemSelectedListener f2082KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public ListAdapter f2083KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public PopupWindow f2084KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final IFxWkV_5 f2085KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final IMuAHx_6 f2086KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final PGPF6hQ_2 f2087KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final X6FRs_4 f2088KQgRr5e_0;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public int f3471Mqv2r_3;

    /* renamed from: Mqv2r_3  reason: collision with other field name */
    public boolean f2089Mqv2r_3;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public int f2090PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public boolean f2091PGPF6hQ_2;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public int f2092QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public Rect f2093QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public View f2094QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f2095QxJ9d_1;

    /* renamed from: X6FRs_4  reason: collision with root package name */
    public int f3472X6FRs_4;

    /* renamed from: X6FRs_4  reason: collision with other field name */
    public boolean f2096X6FRs_4;

    /* loaded from: classes.dex */
    public class IFxWkV_5 implements View.OnTouchListener {
        public IFxWkV_5() {
        }

        @Override // android.view.View.OnTouchListener
        public boolean onTouch(View view, MotionEvent motionEvent) {
            PopupWindow popupWindow;
            int action = motionEvent.getAction();
            int x = (int) motionEvent.getX();
            int y = (int) motionEvent.getY();
            if (action == 0 && (popupWindow = ListPopupWindow.this.f2084KQgRr5e_0) != null && popupWindow.isShowing() && x >= 0 && x < ListPopupWindow.this.f2084KQgRr5e_0.getWidth() && y >= 0 && y < ListPopupWindow.this.f2084KQgRr5e_0.getHeight()) {
                ListPopupWindow listPopupWindow = ListPopupWindow.this;
                listPopupWindow.f2079KQgRr5e_0.postDelayed(listPopupWindow.f2086KQgRr5e_0, 250L);
                return false;
            } else if (action == 1) {
                ListPopupWindow listPopupWindow2 = ListPopupWindow.this;
                listPopupWindow2.f2079KQgRr5e_0.removeCallbacks(listPopupWindow2.f2086KQgRr5e_0);
                return false;
            } else {
                return false;
            }
        }
    }

    /* loaded from: classes.dex */
    public class IMuAHx_6 implements Runnable {
        public IMuAHx_6() {
        }

        @Override // java.lang.Runnable
        public void run() {
            LGe8pk_15 lGe8pk_15 = ListPopupWindow.this.f2074KQgRr5e_0;
            if (lGe8pk_15 == null || !ZzDuCHW_20.m250IMuAHx_6((View) lGe8pk_15) || ListPopupWindow.this.f2074KQgRr5e_0.getCount() <= ListPopupWindow.this.f2074KQgRr5e_0.getChildCount()) {
                return;
            }
            int childCount = ListPopupWindow.this.f2074KQgRr5e_0.getChildCount();
            ListPopupWindow listPopupWindow = ListPopupWindow.this;
            if (childCount <= listPopupWindow.f3470IMuAHx_6) {
                listPopupWindow.f2084KQgRr5e_0.setInputMethodMode(2);
                ListPopupWindow.this.show();
            }
        }
    }

    /* loaded from: classes.dex */
    public class KQgRr5e_0 implements Runnable {
        public KQgRr5e_0() {
        }

        @Override // java.lang.Runnable
        public void run() {
            View KQgRr5e_0 = ListPopupWindow.this.KQgRr5e_0();
            if (KQgRr5e_0 == null || KQgRr5e_0.getWindowToken() == null) {
                return;
            }
            ListPopupWindow.this.show();
        }
    }

    /* loaded from: classes.dex */
    public class Mqv2r_3 extends DataSetObserver {
        public Mqv2r_3() {
        }

        @Override // android.database.DataSetObserver
        public void onChanged() {
            if (ListPopupWindow.this.KQgRr5e_0()) {
                ListPopupWindow.this.show();
            }
        }

        @Override // android.database.DataSetObserver
        public void onInvalidated() {
            ListPopupWindow.this.dismiss();
        }
    }

    /* loaded from: classes.dex */
    public class PGPF6hQ_2 implements Runnable {
        public PGPF6hQ_2() {
        }

        @Override // java.lang.Runnable
        public void run() {
            ListPopupWindow.this.KQgRr5e_0();
        }
    }

    /* loaded from: classes.dex */
    public class QxJ9d_1 implements AdapterView.OnItemSelectedListener {
        public QxJ9d_1() {
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onItemSelected(AdapterView<?> adapterView, View view, int i, long j) {
            LGe8pk_15 lGe8pk_15;
            if (i == -1 || (lGe8pk_15 = ListPopupWindow.this.f2074KQgRr5e_0) == null) {
                return;
            }
            lGe8pk_15.setListSelectionHidden(false);
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onNothingSelected(AdapterView<?> adapterView) {
        }
    }

    /* loaded from: classes.dex */
    public class X6FRs_4 implements AbsListView.OnScrollListener {
        public X6FRs_4() {
        }

        @Override // android.widget.AbsListView.OnScrollListener
        public void onScroll(AbsListView absListView, int i, int i2, int i3) {
        }

        @Override // android.widget.AbsListView.OnScrollListener
        public void onScrollStateChanged(AbsListView absListView, int i) {
            if (i != 1 || ListPopupWindow.this.m849QxJ9d_1() || ListPopupWindow.this.f2084KQgRr5e_0.getContentView() == null) {
                return;
            }
            ListPopupWindow listPopupWindow = ListPopupWindow.this;
            listPopupWindow.f2079KQgRr5e_0.removeCallbacks(listPopupWindow.f2086KQgRr5e_0);
            ListPopupWindow.this.f2086KQgRr5e_0.run();
        }
    }

    static {
        try {
            KQgRr5e_0 = PopupWindow.class.getDeclaredMethod("setClipToScreenEnabled", Boolean.TYPE);
        } catch (NoSuchMethodException unused) {
            Log.i("ListPopupWindow", "Could not find method setClipToScreenEnabled() on PopupWindow. Oh well.");
        }
        try {
            QxJ9d_1 = PopupWindow.class.getDeclaredMethod("getMaxAvailableHeight", View.class, Integer.TYPE, Boolean.TYPE);
        } catch (NoSuchMethodException unused2) {
            Log.i("ListPopupWindow", "Could not find method getMaxAvailableHeight(View, int, boolean) on PopupWindow. Oh well.");
        }
        try {
            PGPF6hQ_2 = PopupWindow.class.getDeclaredMethod("setEpicenterBounds", Rect.class);
        } catch (NoSuchMethodException unused3) {
            Log.i("ListPopupWindow", "Could not find method setEpicenterBounds(Rect) on PopupWindow. Oh well.");
        }
    }

    public ListPopupWindow(Context context) {
        this(context, null, X6FRs_4.KQgRr5e_0.KQgRr5e_0.listPopupWindowStyle);
    }

    public void FSaI4_7(int i) {
        this.f3471Mqv2r_3 = i;
        this.f2095QxJ9d_1 = true;
    }

    public void IFxWkV_5(int i) {
        this.f3468FSaI4_7 = i;
    }

    public void IMuAHx_6(int i) {
        LGe8pk_15 lGe8pk_15 = this.f2074KQgRr5e_0;
        if (!KQgRr5e_0() || lGe8pk_15 == null) {
            return;
        }
        lGe8pk_15.setListSelectionHidden(false);
        lGe8pk_15.setSelection(i);
        if (lGe8pk_15.getChoiceMode() != 0) {
            lGe8pk_15.setItemChecked(i, true);
        }
    }

    public void KQgRr5e_0(ListAdapter listAdapter) {
        DataSetObserver dataSetObserver = this.f2076KQgRr5e_0;
        if (dataSetObserver == null) {
            this.f2076KQgRr5e_0 = new Mqv2r_3();
        } else {
            ListAdapter listAdapter2 = this.f2083KQgRr5e_0;
            if (listAdapter2 != null) {
                listAdapter2.unregisterDataSetObserver(dataSetObserver);
            }
        }
        this.f2083KQgRr5e_0 = listAdapter;
        if (listAdapter != null) {
            listAdapter.registerDataSetObserver(this.f2076KQgRr5e_0);
        }
        LGe8pk_15 lGe8pk_15 = this.f2074KQgRr5e_0;
        if (lGe8pk_15 != null) {
            lGe8pk_15.setAdapter(this.f2083KQgRr5e_0);
        }
    }

    public void Mqv2r_3(int i) {
        this.f2090PGPF6hQ_2 = i;
    }

    /* renamed from: PGPF6hQ_2  reason: collision with other method in class */
    public boolean m847PGPF6hQ_2() {
        return this.f2072IMuAHx_6;
    }

    public int QxJ9d_1() {
        return this.f2090PGPF6hQ_2;
    }

    public void X6FRs_4(int i) {
        this.f2084KQgRr5e_0.setInputMethodMode(i);
    }

    public void Xgtqvk_8(int i) {
        this.f2092QxJ9d_1 = i;
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18
    public void dismiss() {
        this.f2084KQgRr5e_0.dismiss();
        m848QxJ9d_1();
        this.f2084KQgRr5e_0.setContentView(null);
        this.f2074KQgRr5e_0 = null;
        this.f2079KQgRr5e_0.removeCallbacks(this.f2086KQgRr5e_0);
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18
    public void show() {
        int KQgRr5e_02 = KQgRr5e_0();
        boolean m849QxJ9d_1 = m849QxJ9d_1();
        FSaI4_7.KQgRr5e_0(this.f2084KQgRr5e_0, this.f3472X6FRs_4);
        boolean z = true;
        if (this.f2084KQgRr5e_0.isShowing()) {
            if (ZzDuCHW_20.m250IMuAHx_6(KQgRr5e_0())) {
                int i = this.f2092QxJ9d_1;
                if (i == -1) {
                    i = -1;
                } else if (i == -2) {
                    i = KQgRr5e_0().getWidth();
                }
                int i2 = this.f2073KQgRr5e_0;
                if (i2 == -1) {
                    if (!m849QxJ9d_1) {
                        KQgRr5e_02 = -1;
                    }
                    if (m849QxJ9d_1) {
                        this.f2084KQgRr5e_0.setWidth(this.f2092QxJ9d_1 == -1 ? -1 : 0);
                        this.f2084KQgRr5e_0.setHeight(0);
                    } else {
                        this.f2084KQgRr5e_0.setWidth(this.f2092QxJ9d_1 == -1 ? -1 : 0);
                        this.f2084KQgRr5e_0.setHeight(-1);
                    }
                } else if (i2 != -2) {
                    KQgRr5e_02 = i2;
                }
                this.f2084KQgRr5e_0.setOutsideTouchable((this.f2071IFxWkV_5 || this.f2096X6FRs_4) ? false : false);
                this.f2084KQgRr5e_0.update(KQgRr5e_0(), this.f2090PGPF6hQ_2, this.f3471Mqv2r_3, i < 0 ? -1 : i, KQgRr5e_02 < 0 ? -1 : KQgRr5e_02);
                return;
            }
            return;
        }
        int i3 = this.f2092QxJ9d_1;
        if (i3 == -1) {
            i3 = -1;
        } else if (i3 == -2) {
            i3 = KQgRr5e_0().getWidth();
        }
        int i4 = this.f2073KQgRr5e_0;
        if (i4 == -1) {
            KQgRr5e_02 = -1;
        } else if (i4 != -2) {
            KQgRr5e_02 = i4;
        }
        this.f2084KQgRr5e_0.setWidth(i3);
        this.f2084KQgRr5e_0.setHeight(KQgRr5e_02);
        PGPF6hQ_2(true);
        this.f2084KQgRr5e_0.setOutsideTouchable((this.f2071IFxWkV_5 || this.f2096X6FRs_4) ? false : true);
        this.f2084KQgRr5e_0.setTouchInterceptor(this.f2085KQgRr5e_0);
        if (this.f2089Mqv2r_3) {
            FSaI4_7.KQgRr5e_0(this.f2084KQgRr5e_0, this.f2091PGPF6hQ_2);
        }
        Method method = PGPF6hQ_2;
        if (method != null) {
            try {
                method.invoke(this.f2084KQgRr5e_0, this.f2093QxJ9d_1);
            } catch (Exception e) {
                Log.e("ListPopupWindow", "Could not invoke setEpicenterBounds on PopupWindow", e);
            }
        }
        FSaI4_7.KQgRr5e_0(this.f2084KQgRr5e_0, KQgRr5e_0(), this.f2090PGPF6hQ_2, this.f3471Mqv2r_3, this.f3469IFxWkV_5);
        this.f2074KQgRr5e_0.setSelection(-1);
        if (!this.f2072IMuAHx_6 || this.f2074KQgRr5e_0.isInTouchMode()) {
            KQgRr5e_0();
        }
        if (this.f2072IMuAHx_6) {
            return;
        }
        this.f2079KQgRr5e_0.post(this.f2087KQgRr5e_0);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, X6FRs_4.KQgRr5e_0.KQgRr5e_0.listPopupWindowStyle);
    }

    public int Mqv2r_3() {
        return this.f2092QxJ9d_1;
    }

    public int PGPF6hQ_2() {
        if (this.f2095QxJ9d_1) {
            return this.f3471Mqv2r_3;
        }
        return 0;
    }

    public void QxJ9d_1(int i) {
        Drawable background = this.f2084KQgRr5e_0.getBackground();
        if (background != null) {
            background.getPadding(this.f2077KQgRr5e_0);
            Rect rect = this.f2077KQgRr5e_0;
            this.f2092QxJ9d_1 = rect.left + rect.right + i;
            return;
        }
        Xgtqvk_8(i);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int i) {
        this(context, attributeSet, i, 0);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int i, int i2) {
        this.f2073KQgRr5e_0 = -2;
        this.f2092QxJ9d_1 = -2;
        this.f3472X6FRs_4 = 1002;
        this.f3469IFxWkV_5 = 0;
        this.f2096X6FRs_4 = false;
        this.f2071IFxWkV_5 = false;
        this.f3470IMuAHx_6 = Integer.MAX_VALUE;
        this.f3468FSaI4_7 = 0;
        this.f2086KQgRr5e_0 = new IMuAHx_6();
        this.f2085KQgRr5e_0 = new IFxWkV_5();
        this.f2088KQgRr5e_0 = new X6FRs_4();
        this.f2087KQgRr5e_0 = new PGPF6hQ_2();
        this.f2077KQgRr5e_0 = new Rect();
        this.f2075KQgRr5e_0 = context;
        this.f2079KQgRr5e_0 = new Handler(context.getMainLooper());
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, XnFJ5_9.ListPopupWindow, i, i2);
        this.f2090PGPF6hQ_2 = obtainStyledAttributes.getDimensionPixelOffset(XnFJ5_9.ListPopupWindow_android_dropDownHorizontalOffset, 0);
        int dimensionPixelOffset = obtainStyledAttributes.getDimensionPixelOffset(XnFJ5_9.ListPopupWindow_android_dropDownVerticalOffset, 0);
        this.f3471Mqv2r_3 = dimensionPixelOffset;
        if (dimensionPixelOffset != 0) {
            this.f2095QxJ9d_1 = true;
        }
        obtainStyledAttributes.recycle();
        AppCompatPopupWindow appCompatPopupWindow = new AppCompatPopupWindow(context, attributeSet, i, i2);
        this.f2084KQgRr5e_0 = appCompatPopupWindow;
        appCompatPopupWindow.setInputMethodMode(1);
    }

    public void PGPF6hQ_2(int i) {
        this.f3469IFxWkV_5 = i;
    }

    public final void PGPF6hQ_2(boolean z) {
        Method method = KQgRr5e_0;
        if (method != null) {
            try {
                method.invoke(this.f2084KQgRr5e_0, Boolean.valueOf(z));
            } catch (Exception unused) {
                Log.i("ListPopupWindow", "Could not call setClipToScreenEnabled() on PopupWindow. Oh well.");
            }
        }
    }

    /* renamed from: QxJ9d_1  reason: collision with other method in class */
    public final void m848QxJ9d_1() {
        View view = this.f2080KQgRr5e_0;
        if (view != null) {
            ViewParent parent = view.getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup) parent).removeView(this.f2080KQgRr5e_0);
            }
        }
    }

    public void KQgRr5e_0(boolean z) {
        this.f2072IMuAHx_6 = z;
        this.f2084KQgRr5e_0.setFocusable(z);
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18
    public Drawable KQgRr5e_0() {
        return this.f2084KQgRr5e_0.getBackground();
    }

    /* renamed from: QxJ9d_1  reason: collision with other method in class */
    public boolean m849QxJ9d_1() {
        return this.f2084KQgRr5e_0.getInputMethodMode() == 2;
    }

    public void KQgRr5e_0(Drawable drawable) {
        this.f2084KQgRr5e_0.setBackgroundDrawable(drawable);
    }

    public void QxJ9d_1(boolean z) {
        this.f2089Mqv2r_3 = true;
        this.f2091PGPF6hQ_2 = z;
    }

    public void KQgRr5e_0(int i) {
        this.f2084KQgRr5e_0.setAnimationStyle(i);
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18
    public View KQgRr5e_0() {
        return this.f2094QxJ9d_1;
    }

    public void KQgRr5e_0(View view) {
        this.f2094QxJ9d_1 = view;
    }

    public void KQgRr5e_0(Rect rect) {
        this.f2093QxJ9d_1 = rect;
    }

    public void KQgRr5e_0(AdapterView.OnItemClickListener onItemClickListener) {
        this.f2081KQgRr5e_0 = onItemClickListener;
    }

    public void KQgRr5e_0(PopupWindow.OnDismissListener onDismissListener) {
        this.f2084KQgRr5e_0.setOnDismissListener(onDismissListener);
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18
    public void KQgRr5e_0() {
        LGe8pk_15 lGe8pk_15 = this.f2074KQgRr5e_0;
        if (lGe8pk_15 != null) {
            lGe8pk_15.setListSelectionHidden(true);
            lGe8pk_15.requestLayout();
        }
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18
    public boolean KQgRr5e_0() {
        return this.f2084KQgRr5e_0.isShowing();
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18
    public ListView KQgRr5e_0() {
        return this.f2074KQgRr5e_0;
    }

    public LGe8pk_15 KQgRr5e_0(Context context, boolean z) {
        return new LGe8pk_15(context, z);
    }

    /* JADX WARN: Multi-variable type inference failed */
    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.Eps4cJe_18
    public final int KQgRr5e_0() {
        int i;
        int i2;
        int makeMeasureSpec;
        int i3;
        if (this.f2074KQgRr5e_0 == null) {
            Context context = this.f2075KQgRr5e_0;
            new KQgRr5e_0();
            LGe8pk_15 KQgRr5e_02 = KQgRr5e_0(context, !this.f2072IMuAHx_6);
            this.f2074KQgRr5e_0 = KQgRr5e_02;
            Drawable drawable = this.f2078KQgRr5e_0;
            if (drawable != null) {
                KQgRr5e_02.setSelector(drawable);
            }
            this.f2074KQgRr5e_0.setAdapter(this.f2083KQgRr5e_0);
            this.f2074KQgRr5e_0.setOnItemClickListener(this.f2081KQgRr5e_0);
            this.f2074KQgRr5e_0.setFocusable(true);
            this.f2074KQgRr5e_0.setFocusableInTouchMode(true);
            this.f2074KQgRr5e_0.setOnItemSelectedListener(new QxJ9d_1());
            this.f2074KQgRr5e_0.setOnScrollListener(this.f2088KQgRr5e_0);
            AdapterView.OnItemSelectedListener onItemSelectedListener = this.f2082KQgRr5e_0;
            if (onItemSelectedListener != null) {
                this.f2074KQgRr5e_0.setOnItemSelectedListener(onItemSelectedListener);
            }
            LGe8pk_15 lGe8pk_15 = this.f2074KQgRr5e_0;
            View view = this.f2080KQgRr5e_0;
            if (view != null) {
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(1);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                int i4 = this.f3468FSaI4_7;
                if (i4 == 0) {
                    linearLayout.addView(view);
                    linearLayout.addView(lGe8pk_15, layoutParams);
                } else if (i4 != 1) {
                    Log.e("ListPopupWindow", "Invalid hint position " + this.f3468FSaI4_7);
                } else {
                    linearLayout.addView(lGe8pk_15, layoutParams);
                    linearLayout.addView(view);
                }
                int i5 = this.f2092QxJ9d_1;
                if (i5 >= 0) {
                    i3 = X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0.INVALID_ID;
                } else {
                    i5 = 0;
                    i3 = 0;
                }
                view.measure(View.MeasureSpec.makeMeasureSpec(i5, i3), 0);
                LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams) view.getLayoutParams();
                i = view.getMeasuredHeight() + layoutParams2.topMargin + layoutParams2.bottomMargin;
                lGe8pk_15 = linearLayout;
            } else {
                i = 0;
            }
            this.f2084KQgRr5e_0.setContentView(lGe8pk_15);
        } else {
            ViewGroup viewGroup = (ViewGroup) this.f2084KQgRr5e_0.getContentView();
            View view2 = this.f2080KQgRr5e_0;
            if (view2 != null) {
                LinearLayout.LayoutParams layoutParams3 = (LinearLayout.LayoutParams) view2.getLayoutParams();
                i = view2.getMeasuredHeight() + layoutParams3.topMargin + layoutParams3.bottomMargin;
            } else {
                i = 0;
            }
        }
        Drawable background = this.f2084KQgRr5e_0.getBackground();
        if (background != null) {
            background.getPadding(this.f2077KQgRr5e_0);
            Rect rect = this.f2077KQgRr5e_0;
            int i6 = rect.top;
            i2 = rect.bottom + i6;
            if (!this.f2095QxJ9d_1) {
                this.f3471Mqv2r_3 = -i6;
            }
        } else {
            this.f2077KQgRr5e_0.setEmpty();
            i2 = 0;
        }
        int KQgRr5e_03 = KQgRr5e_0(KQgRr5e_0(), this.f3471Mqv2r_3, this.f2084KQgRr5e_0.getInputMethodMode() == 2);
        if (this.f2096X6FRs_4 || this.f2073KQgRr5e_0 == -1) {
            return KQgRr5e_03 + i2;
        }
        int i7 = this.f2092QxJ9d_1;
        if (i7 == -2) {
            int i8 = this.f2075KQgRr5e_0.getResources().getDisplayMetrics().widthPixels;
            Rect rect2 = this.f2077KQgRr5e_0;
            makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i8 - (rect2.left + rect2.right), X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0.INVALID_ID);
        } else if (i7 != -1) {
            makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i7, 1073741824);
        } else {
            int i9 = this.f2075KQgRr5e_0.getResources().getDisplayMetrics().widthPixels;
            Rect rect3 = this.f2077KQgRr5e_0;
            makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i9 - (rect3.left + rect3.right), 1073741824);
        }
        int KQgRr5e_04 = this.f2074KQgRr5e_0.KQgRr5e_0(makeMeasureSpec, 0, -1, KQgRr5e_03 - i, -1);
        if (KQgRr5e_04 > 0) {
            i += i2 + this.f2074KQgRr5e_0.getPaddingTop() + this.f2074KQgRr5e_0.getPaddingBottom();
        }
        return KQgRr5e_04 + i;
    }

    public final int KQgRr5e_0(View view, int i, boolean z) {
        Method method = QxJ9d_1;
        if (method != null) {
            try {
                return ((Integer) method.invoke(this.f2084KQgRr5e_0, view, Integer.valueOf(i), Boolean.valueOf(z))).intValue();
            } catch (Exception unused) {
                Log.i("ListPopupWindow", "Could not call getMaxAvailableHeightMethod(View, int, boolean) on PopupWindow. Using the public version.");
            }
        }
        return this.f2084KQgRr5e_0.getMaxAvailableHeight(view, i);
    }
}
