package androidx.appcompat.widget;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import X6FRs_4.KQgRr5e_0.IFxWkV_5;
import X6FRs_4.KQgRr5e_0.XnFJ5_9;
import X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
/* loaded from: classes.dex */
public class ButtonBarLayout extends LinearLayout {
    public int KQgRr5e_0;
    public int QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f2067QxJ9d_1;

    public ButtonBarLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.KQgRr5e_0 = -1;
        this.QxJ9d_1 = 0;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, XnFJ5_9.ButtonBarLayout);
        this.f2067QxJ9d_1 = obtainStyledAttributes.getBoolean(XnFJ5_9.ButtonBarLayout_allowStacking, true);
        obtainStyledAttributes.recycle();
    }

    private void setStacked(boolean z) {
        setOrientation(z ? 1 : 0);
        setGravity(z ? 5 : 80);
        View findViewById = findViewById(IFxWkV_5.spacer);
        if (findViewById != null) {
            findViewById.setVisibility(z ? 8 : 4);
        }
        for (int childCount = getChildCount() - 2; childCount >= 0; childCount--) {
            bringChildToFront(getChildAt(childCount));
        }
    }

    public final int KQgRr5e_0(int i) {
        int childCount = getChildCount();
        while (i < childCount) {
            if (getChildAt(i).getVisibility() == 0) {
                return i;
            }
            i++;
        }
        return -1;
    }

    @Override // android.view.View
    public int getMinimumHeight() {
        return Math.max(this.QxJ9d_1, super.getMinimumHeight());
    }

    @Override // android.widget.LinearLayout, android.view.View
    public void onMeasure(int i, int i2) {
        int i3;
        boolean z;
        int size = View.MeasureSpec.getSize(i);
        int i4 = 0;
        if (this.f2067QxJ9d_1) {
            if (size > this.KQgRr5e_0 && KQgRr5e_0()) {
                setStacked(false);
            }
            this.KQgRr5e_0 = size;
        }
        if (KQgRr5e_0() || View.MeasureSpec.getMode(i) != 1073741824) {
            i3 = i;
            z = false;
        } else {
            i3 = View.MeasureSpec.makeMeasureSpec(size, KQgRr5e_0.INVALID_ID);
            z = true;
        }
        super.onMeasure(i3, i2);
        if (this.f2067QxJ9d_1 && !KQgRr5e_0()) {
            if ((getMeasuredWidthAndState() & (-16777216)) == 16777216) {
                setStacked(true);
                z = true;
            }
        }
        if (z) {
            super.onMeasure(i, i2);
        }
        int KQgRr5e_0 = KQgRr5e_0(0);
        if (KQgRr5e_0 >= 0) {
            View childAt = getChildAt(KQgRr5e_0);
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) childAt.getLayoutParams();
            int paddingTop = getPaddingTop() + childAt.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin + 0;
            if (KQgRr5e_0()) {
                int KQgRr5e_02 = KQgRr5e_0(KQgRr5e_0 + 1);
                if (KQgRr5e_02 >= 0) {
                    paddingTop += getChildAt(KQgRr5e_02).getPaddingTop() + ((int) (getResources().getDisplayMetrics().density * 16.0f));
                }
                i4 = paddingTop;
            } else {
                i4 = paddingTop + getPaddingBottom();
            }
        }
        if (ZzDuCHW_20.X6FRs_4((View) this) != i4) {
            setMinimumHeight(i4);
        }
    }

    public void setAllowStacking(boolean z) {
        if (this.f2067QxJ9d_1 != z) {
            this.f2067QxJ9d_1 = z;
            if (!z && getOrientation() == 1) {
                setStacked(false);
            }
            requestLayout();
        }
    }

    public final boolean KQgRr5e_0() {
        return getOrientation() == 1;
    }
}
