package androidx.appcompat.widget;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import X6FRs_4.KQgRr5e_0.IFxWkV_5;
import X6FRs_4.KQgRr5e_0.LGe8pk_15.H5YG8fq_22;
import X6FRs_4.KQgRr5e_0.LGe8pk_15.QxJ9d_1;
import X6FRs_4.KQgRr5e_0.XnFJ5_9;
import X6FRs_4.Xgtqvk_8.KQgRr5e_0.KQgRr5e_0;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
/* loaded from: classes.dex */
public class ActionBarContainer extends FrameLayout {
    public int KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Drawable f1972KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public View f1973KQgRr5e_0;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public boolean f3451Mqv2r_3;
    public Drawable PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public View f1974PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public boolean f1975PGPF6hQ_2;
    public Drawable QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public View f1976QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f1977QxJ9d_1;

    public ActionBarContainer(Context context) {
        this(context, null);
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public final boolean m833KQgRr5e_0(View view) {
        return view == null || view.getVisibility() == 8 || view.getMeasuredHeight() == 0;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.f1972KQgRr5e_0;
        if (drawable != null && drawable.isStateful()) {
            this.f1972KQgRr5e_0.setState(getDrawableState());
        }
        Drawable drawable2 = this.QxJ9d_1;
        if (drawable2 != null && drawable2.isStateful()) {
            this.QxJ9d_1.setState(getDrawableState());
        }
        Drawable drawable3 = this.PGPF6hQ_2;
        if (drawable3 == null || !drawable3.isStateful()) {
            return;
        }
        this.PGPF6hQ_2.setState(getDrawableState());
    }

    public View getTabContainer() {
        return this.f1973KQgRr5e_0;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        Drawable drawable = this.f1972KQgRr5e_0;
        if (drawable != null) {
            drawable.jumpToCurrentState();
        }
        Drawable drawable2 = this.QxJ9d_1;
        if (drawable2 != null) {
            drawable2.jumpToCurrentState();
        }
        Drawable drawable3 = this.PGPF6hQ_2;
        if (drawable3 != null) {
            drawable3.jumpToCurrentState();
        }
    }

    @Override // android.view.View
    public void onFinishInflate() {
        super.onFinishInflate();
        this.f1976QxJ9d_1 = findViewById(IFxWkV_5.action_bar);
        this.f1974PGPF6hQ_2 = findViewById(IFxWkV_5.action_context_bar);
    }

    @Override // android.view.View
    public boolean onHoverEvent(MotionEvent motionEvent) {
        super.onHoverEvent(motionEvent);
        return true;
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.f1977QxJ9d_1 || super.onInterceptTouchEvent(motionEvent);
    }

    @Override // android.widget.FrameLayout, android.view.ViewGroup, android.view.View
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        Drawable drawable;
        super.onLayout(z, i, i2, i3, i4);
        View view = this.f1973KQgRr5e_0;
        boolean z2 = true;
        boolean z3 = false;
        boolean z4 = (view == null || view.getVisibility() == 8) ? false : true;
        if (view != null && view.getVisibility() != 8) {
            int measuredHeight = getMeasuredHeight();
            int i5 = ((FrameLayout.LayoutParams) view.getLayoutParams()).bottomMargin;
            view.layout(i, (measuredHeight - view.getMeasuredHeight()) - i5, i3, measuredHeight - i5);
        }
        if (this.f1975PGPF6hQ_2) {
            Drawable drawable2 = this.PGPF6hQ_2;
            if (drawable2 != null) {
                drawable2.setBounds(0, 0, getMeasuredWidth(), getMeasuredHeight());
            } else {
                z2 = false;
            }
        } else {
            if (this.f1972KQgRr5e_0 != null) {
                if (this.f1976QxJ9d_1.getVisibility() == 0) {
                    this.f1972KQgRr5e_0.setBounds(this.f1976QxJ9d_1.getLeft(), this.f1976QxJ9d_1.getTop(), this.f1976QxJ9d_1.getRight(), this.f1976QxJ9d_1.getBottom());
                } else {
                    View view2 = this.f1974PGPF6hQ_2;
                    if (view2 != null && view2.getVisibility() == 0) {
                        this.f1972KQgRr5e_0.setBounds(this.f1974PGPF6hQ_2.getLeft(), this.f1974PGPF6hQ_2.getTop(), this.f1974PGPF6hQ_2.getRight(), this.f1974PGPF6hQ_2.getBottom());
                    } else {
                        this.f1972KQgRr5e_0.setBounds(0, 0, 0, 0);
                    }
                }
                z3 = true;
            }
            this.f3451Mqv2r_3 = z4;
            if (!z4 || (drawable = this.QxJ9d_1) == null) {
                z2 = z3;
            } else {
                drawable.setBounds(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            }
        }
        if (z2) {
            invalidate();
        }
    }

    @Override // android.widget.FrameLayout, android.view.View
    public void onMeasure(int i, int i2) {
        int KQgRr5e_0;
        int i3;
        if (this.f1976QxJ9d_1 == null && View.MeasureSpec.getMode(i2) == Integer.MIN_VALUE && (i3 = this.KQgRr5e_0) >= 0) {
            i2 = View.MeasureSpec.makeMeasureSpec(Math.min(i3, View.MeasureSpec.getSize(i2)), KQgRr5e_0.INVALID_ID);
        }
        super.onMeasure(i, i2);
        if (this.f1976QxJ9d_1 == null) {
            return;
        }
        int mode = View.MeasureSpec.getMode(i2);
        View view = this.f1973KQgRr5e_0;
        if (view == null || view.getVisibility() == 8 || mode == 1073741824) {
            return;
        }
        if (!m833KQgRr5e_0(this.f1976QxJ9d_1)) {
            KQgRr5e_0 = KQgRr5e_0(this.f1976QxJ9d_1);
        } else {
            KQgRr5e_0 = !m833KQgRr5e_0(this.f1974PGPF6hQ_2) ? KQgRr5e_0(this.f1974PGPF6hQ_2) : 0;
        }
        setMeasuredDimension(getMeasuredWidth(), Math.min(KQgRr5e_0 + KQgRr5e_0(this.f1973KQgRr5e_0), mode == Integer.MIN_VALUE ? View.MeasureSpec.getSize(i2) : Integer.MAX_VALUE));
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return true;
    }

    public void setPrimaryBackground(Drawable drawable) {
        Drawable drawable2 = this.f1972KQgRr5e_0;
        if (drawable2 != null) {
            drawable2.setCallback(null);
            unscheduleDrawable(this.f1972KQgRr5e_0);
        }
        this.f1972KQgRr5e_0 = drawable;
        if (drawable != null) {
            drawable.setCallback(this);
            View view = this.f1976QxJ9d_1;
            if (view != null) {
                this.f1972KQgRr5e_0.setBounds(view.getLeft(), this.f1976QxJ9d_1.getTop(), this.f1976QxJ9d_1.getRight(), this.f1976QxJ9d_1.getBottom());
            }
        }
        boolean z = true;
        if (!this.f1975PGPF6hQ_2 ? this.f1972KQgRr5e_0 != null || this.QxJ9d_1 != null : this.PGPF6hQ_2 != null) {
            z = false;
        }
        setWillNotDraw(z);
        invalidate();
    }

    public void setSplitBackground(Drawable drawable) {
        Drawable drawable2;
        Drawable drawable3 = this.PGPF6hQ_2;
        if (drawable3 != null) {
            drawable3.setCallback(null);
            unscheduleDrawable(this.PGPF6hQ_2);
        }
        this.PGPF6hQ_2 = drawable;
        boolean z = false;
        if (drawable != null) {
            drawable.setCallback(this);
            if (this.f1975PGPF6hQ_2 && (drawable2 = this.PGPF6hQ_2) != null) {
                drawable2.setBounds(0, 0, getMeasuredWidth(), getMeasuredHeight());
            }
        }
        if (!this.f1975PGPF6hQ_2 ? !(this.f1972KQgRr5e_0 != null || this.QxJ9d_1 != null) : this.PGPF6hQ_2 == null) {
            z = true;
        }
        setWillNotDraw(z);
        invalidate();
    }

    public void setStackedBackground(Drawable drawable) {
        Drawable drawable2;
        Drawable drawable3 = this.QxJ9d_1;
        if (drawable3 != null) {
            drawable3.setCallback(null);
            unscheduleDrawable(this.QxJ9d_1);
        }
        this.QxJ9d_1 = drawable;
        if (drawable != null) {
            drawable.setCallback(this);
            if (this.f3451Mqv2r_3 && (drawable2 = this.QxJ9d_1) != null) {
                drawable2.setBounds(this.f1973KQgRr5e_0.getLeft(), this.f1973KQgRr5e_0.getTop(), this.f1973KQgRr5e_0.getRight(), this.f1973KQgRr5e_0.getBottom());
            }
        }
        boolean z = true;
        if (!this.f1975PGPF6hQ_2 ? this.f1972KQgRr5e_0 != null || this.QxJ9d_1 != null : this.PGPF6hQ_2 != null) {
            z = false;
        }
        setWillNotDraw(z);
        invalidate();
    }

    public void setTabContainer(H5YG8fq_22 h5YG8fq_22) {
        View view = this.f1973KQgRr5e_0;
        if (view != null) {
            removeView(view);
        }
        this.f1973KQgRr5e_0 = h5YG8fq_22;
        if (h5YG8fq_22 != null) {
            addView(h5YG8fq_22);
            ViewGroup.LayoutParams layoutParams = h5YG8fq_22.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = -2;
            h5YG8fq_22.setAllowCollapse(false);
        }
    }

    public void setTransitioning(boolean z) {
        this.f1977QxJ9d_1 = z;
        setDescendantFocusability(z ? 393216 : 262144);
    }

    @Override // android.view.View
    public void setVisibility(int i) {
        super.setVisibility(i);
        boolean z = i == 0;
        Drawable drawable = this.f1972KQgRr5e_0;
        if (drawable != null) {
            drawable.setVisible(z, false);
        }
        Drawable drawable2 = this.QxJ9d_1;
        if (drawable2 != null) {
            drawable2.setVisible(z, false);
        }
        Drawable drawable3 = this.PGPF6hQ_2;
        if (drawable3 != null) {
            drawable3.setVisible(z, false);
        }
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        return null;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback, int i) {
        if (i != 0) {
            return super.startActionModeForChild(view, callback, i);
        }
        return null;
    }

    @Override // android.view.View
    public boolean verifyDrawable(Drawable drawable) {
        return (drawable == this.f1972KQgRr5e_0 && !this.f1975PGPF6hQ_2) || (drawable == this.QxJ9d_1 && this.f3451Mqv2r_3) || ((drawable == this.PGPF6hQ_2 && this.f1975PGPF6hQ_2) || super.verifyDrawable(drawable));
    }

    public ActionBarContainer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        ZzDuCHW_20.KQgRr5e_0(this, new QxJ9d_1(this));
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, XnFJ5_9.ActionBar);
        this.f1972KQgRr5e_0 = obtainStyledAttributes.getDrawable(XnFJ5_9.ActionBar_background);
        this.QxJ9d_1 = obtainStyledAttributes.getDrawable(XnFJ5_9.ActionBar_backgroundStacked);
        this.KQgRr5e_0 = obtainStyledAttributes.getDimensionPixelSize(XnFJ5_9.ActionBar_height, -1);
        boolean z = true;
        if (getId() == IFxWkV_5.split_action_bar) {
            this.f1975PGPF6hQ_2 = true;
            this.PGPF6hQ_2 = obtainStyledAttributes.getDrawable(XnFJ5_9.ActionBar_backgroundSplit);
        }
        obtainStyledAttributes.recycle();
        if (!this.f1975PGPF6hQ_2 ? this.f1972KQgRr5e_0 != null || this.QxJ9d_1 != null : this.PGPF6hQ_2 != null) {
            z = false;
        }
        setWillNotDraw(z);
    }

    public final int KQgRr5e_0(View view) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) view.getLayoutParams();
        return view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
    }
}
