package androidx.appcompat.view.menu;

import X6FRs_4.IMuAHx_6.EuDEkJe_12.ZzDuCHW_20;
import X6FRs_4.KQgRr5e_0.IFxWkV_5;
import X6FRs_4.KQgRr5e_0.IMuAHx_6;
import X6FRs_4.KQgRr5e_0.KQgRr5e_0;
import X6FRs_4.KQgRr5e_0.LGe8pk_15.NzhupJ_29;
import X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.LGe8pk_15;
import X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.XnFJ5_9;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
/* loaded from: classes.dex */
public class ListMenuItemView extends LinearLayout implements LGe8pk_15.KQgRr5e_0, AbsListView.SelectionBoundsAdjuster {
    public int KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public XnFJ5_9 f1959KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Context f1960KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public Drawable f1961KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public LayoutInflater f1962KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public CheckBox f1963KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public ImageView f1964KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public LinearLayout f1965KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public RadioButton f1966KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public TextView f1967KQgRr5e_0;

    /* renamed from: Mqv2r_3  reason: collision with root package name */
    public boolean f3450Mqv2r_3;
    public ImageView PGPF6hQ_2;

    /* renamed from: PGPF6hQ_2  reason: collision with other field name */
    public boolean f1968PGPF6hQ_2;
    public Drawable QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public ImageView f1969QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public TextView f1970QxJ9d_1;

    /* renamed from: QxJ9d_1  reason: collision with other field name */
    public boolean f1971QxJ9d_1;

    public ListMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, KQgRr5e_0.listMenuViewStyle);
    }

    private LayoutInflater getInflater() {
        if (this.f1962KQgRr5e_0 == null) {
            this.f1962KQgRr5e_0 = LayoutInflater.from(getContext());
        }
        return this.f1962KQgRr5e_0;
    }

    private void setSubMenuArrowVisible(boolean z) {
        ImageView imageView = this.f1969QxJ9d_1;
        if (imageView != null) {
            imageView.setVisibility(z ? 0 : 8);
        }
    }

    public final void KQgRr5e_0(View view) {
        KQgRr5e_0(view, -1);
    }

    public final void PGPF6hQ_2() {
        RadioButton radioButton = (RadioButton) getInflater().inflate(IMuAHx_6.abc_list_menu_item_radio, (ViewGroup) this, false);
        this.f1966KQgRr5e_0 = radioButton;
        KQgRr5e_0(radioButton);
    }

    public final void QxJ9d_1() {
        ImageView imageView = (ImageView) getInflater().inflate(IMuAHx_6.abc_list_menu_item_icon, (ViewGroup) this, false);
        this.f1964KQgRr5e_0 = imageView;
        KQgRr5e_0(imageView, 0);
    }

    @Override // android.widget.AbsListView.SelectionBoundsAdjuster
    public void adjustListItemSelectionBounds(Rect rect) {
        ImageView imageView = this.PGPF6hQ_2;
        if (imageView == null || imageView.getVisibility() != 0) {
            return;
        }
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) this.PGPF6hQ_2.getLayoutParams();
        rect.top += this.PGPF6hQ_2.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.LGe8pk_15.KQgRr5e_0
    public XnFJ5_9 getItemData() {
        return this.f1959KQgRr5e_0;
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.LGe8pk_15.KQgRr5e_0
    public void initialize(XnFJ5_9 xnFJ5_9, int i) {
        this.f1959KQgRr5e_0 = xnFJ5_9;
        setVisibility(xnFJ5_9.isVisible() ? 0 : 8);
        setTitle(xnFJ5_9.KQgRr5e_0((LGe8pk_15.KQgRr5e_0) this));
        setCheckable(xnFJ5_9.isCheckable());
        KQgRr5e_0(xnFJ5_9.FSaI4_7(), xnFJ5_9.KQgRr5e_0());
        setIcon(xnFJ5_9.getIcon());
        setEnabled(xnFJ5_9.isEnabled());
        setSubMenuArrowVisible(xnFJ5_9.hasSubMenu());
        setContentDescription(xnFJ5_9.getContentDescription());
    }

    @Override // android.view.View
    public void onFinishInflate() {
        super.onFinishInflate();
        ZzDuCHW_20.KQgRr5e_0(this, this.f1961KQgRr5e_0);
        TextView textView = (TextView) findViewById(IFxWkV_5.title);
        this.f1967KQgRr5e_0 = textView;
        int i = this.KQgRr5e_0;
        if (i != -1) {
            textView.setTextAppearance(this.f1960KQgRr5e_0, i);
        }
        this.f1970QxJ9d_1 = (TextView) findViewById(IFxWkV_5.shortcut);
        ImageView imageView = (ImageView) findViewById(IFxWkV_5.submenuarrow);
        this.f1969QxJ9d_1 = imageView;
        if (imageView != null) {
            imageView.setImageDrawable(this.QxJ9d_1);
        }
        this.PGPF6hQ_2 = (ImageView) findViewById(IFxWkV_5.group_divider);
        this.f1965KQgRr5e_0 = (LinearLayout) findViewById(IFxWkV_5.content);
    }

    @Override // android.widget.LinearLayout, android.view.View
    public void onMeasure(int i, int i2) {
        if (this.f1964KQgRr5e_0 != null && this.f1971QxJ9d_1) {
            ViewGroup.LayoutParams layoutParams = getLayoutParams();
            LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams) this.f1964KQgRr5e_0.getLayoutParams();
            int i3 = layoutParams.height;
            if (i3 > 0 && layoutParams2.width <= 0) {
                layoutParams2.width = i3;
            }
        }
        super.onMeasure(i, i2);
    }

    @Override // X6FRs_4.KQgRr5e_0.YghfZG_14.XnFJ5_9.LGe8pk_15.KQgRr5e_0
    public boolean prefersCondensedTitle() {
        return false;
    }

    public void setCheckable(boolean z) {
        CompoundButton compoundButton;
        CompoundButton compoundButton2;
        if (!z && this.f1966KQgRr5e_0 == null && this.f1963KQgRr5e_0 == null) {
            return;
        }
        if (this.f1959KQgRr5e_0.Mqv2r_3()) {
            if (this.f1966KQgRr5e_0 == null) {
                PGPF6hQ_2();
            }
            compoundButton = this.f1966KQgRr5e_0;
            compoundButton2 = this.f1963KQgRr5e_0;
        } else {
            if (this.f1963KQgRr5e_0 == null) {
                KQgRr5e_0();
            }
            compoundButton = this.f1963KQgRr5e_0;
            compoundButton2 = this.f1966KQgRr5e_0;
        }
        if (z) {
            compoundButton.setChecked(this.f1959KQgRr5e_0.isChecked());
            if (compoundButton.getVisibility() != 0) {
                compoundButton.setVisibility(0);
            }
            if (compoundButton2 == null || compoundButton2.getVisibility() == 8) {
                return;
            }
            compoundButton2.setVisibility(8);
            return;
        }
        CheckBox checkBox = this.f1963KQgRr5e_0;
        if (checkBox != null) {
            checkBox.setVisibility(8);
        }
        RadioButton radioButton = this.f1966KQgRr5e_0;
        if (radioButton != null) {
            radioButton.setVisibility(8);
        }
    }

    public void setChecked(boolean z) {
        CompoundButton compoundButton;
        if (this.f1959KQgRr5e_0.Mqv2r_3()) {
            if (this.f1966KQgRr5e_0 == null) {
                PGPF6hQ_2();
            }
            compoundButton = this.f1966KQgRr5e_0;
        } else {
            if (this.f1963KQgRr5e_0 == null) {
                KQgRr5e_0();
            }
            compoundButton = this.f1963KQgRr5e_0;
        }
        compoundButton.setChecked(z);
    }

    public void setForceShowIcon(boolean z) {
        this.f3450Mqv2r_3 = z;
        this.f1971QxJ9d_1 = z;
    }

    public void setGroupDividerEnabled(boolean z) {
        ImageView imageView = this.PGPF6hQ_2;
        if (imageView != null) {
            imageView.setVisibility((this.f1968PGPF6hQ_2 || !z) ? 8 : 0);
        }
    }

    public void setIcon(Drawable drawable) {
        boolean z = this.f1959KQgRr5e_0.IMuAHx_6() || this.f3450Mqv2r_3;
        if (z || this.f1971QxJ9d_1) {
            if (this.f1964KQgRr5e_0 == null && drawable == null && !this.f1971QxJ9d_1) {
                return;
            }
            if (this.f1964KQgRr5e_0 == null) {
                QxJ9d_1();
            }
            if (drawable == null && !this.f1971QxJ9d_1) {
                this.f1964KQgRr5e_0.setVisibility(8);
                return;
            }
            ImageView imageView = this.f1964KQgRr5e_0;
            if (!z) {
                drawable = null;
            }
            imageView.setImageDrawable(drawable);
            if (this.f1964KQgRr5e_0.getVisibility() != 0) {
                this.f1964KQgRr5e_0.setVisibility(0);
            }
        }
    }

    public void setTitle(CharSequence charSequence) {
        if (charSequence != null) {
            this.f1967KQgRr5e_0.setText(charSequence);
            if (this.f1967KQgRr5e_0.getVisibility() != 0) {
                this.f1967KQgRr5e_0.setVisibility(0);
            }
        } else if (this.f1967KQgRr5e_0.getVisibility() != 8) {
            this.f1967KQgRr5e_0.setVisibility(8);
        }
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet);
        NzhupJ_29 KQgRr5e_0 = NzhupJ_29.KQgRr5e_0(getContext(), attributeSet, X6FRs_4.KQgRr5e_0.XnFJ5_9.MenuView, i, 0);
        this.f1961KQgRr5e_0 = KQgRr5e_0.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.MenuView_android_itemBackground);
        this.KQgRr5e_0 = KQgRr5e_0.IMuAHx_6(X6FRs_4.KQgRr5e_0.XnFJ5_9.MenuView_android_itemTextAppearance, -1);
        this.f1971QxJ9d_1 = KQgRr5e_0.KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.MenuView_preserveIconSpacing, false);
        this.f1960KQgRr5e_0 = context;
        this.QxJ9d_1 = KQgRr5e_0.m416KQgRr5e_0(X6FRs_4.KQgRr5e_0.XnFJ5_9.MenuView_subMenuArrow);
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(null, new int[]{16843049}, KQgRr5e_0.dropDownListViewStyle, 0);
        this.f1968PGPF6hQ_2 = obtainStyledAttributes.hasValue(0);
        KQgRr5e_0.KQgRr5e_0();
        obtainStyledAttributes.recycle();
    }

    public final void KQgRr5e_0(View view, int i) {
        LinearLayout linearLayout = this.f1965KQgRr5e_0;
        if (linearLayout != null) {
            linearLayout.addView(view, i);
        } else {
            addView(view, i);
        }
    }

    public void KQgRr5e_0(boolean z, char c) {
        int i = (z && this.f1959KQgRr5e_0.FSaI4_7()) ? 0 : 8;
        if (i == 0) {
            this.f1970QxJ9d_1.setText(this.f1959KQgRr5e_0.KQgRr5e_0());
        }
        if (this.f1970QxJ9d_1.getVisibility() != i) {
            this.f1970QxJ9d_1.setVisibility(i);
        }
    }

    public final void KQgRr5e_0() {
        CheckBox checkBox = (CheckBox) getInflater().inflate(IMuAHx_6.abc_list_menu_item_checkbox, (ViewGroup) this, false);
        this.f1963KQgRr5e_0 = checkBox;
        KQgRr5e_0(checkBox);
    }
}
