package android.support.v4.media;

import Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.IFxWkV_5.QxJ9d_1;
import Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0;
import Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.QxJ9d_1;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
/* loaded from: classes.dex */
public final class MediaBrowserCompat {
    public static final boolean KQgRr5e_0 = Log.isLoggable("MediaBrowserCompat", 3);

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final X6FRs_4 f1763KQgRr5e_0;

    /* loaded from: classes.dex */
    public static class CustomActionResultReceiver extends ResultReceiver {
        public final Bundle KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final PGPF6hQ_2 f1764KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final String f1765KQgRr5e_0;

        @Override // android.support.v4.os.ResultReceiver
        public void KQgRr5e_0(int i, Bundle bundle) {
            if (this.f1764KQgRr5e_0 == null) {
                return;
            }
            MediaSessionCompat.KQgRr5e_0(bundle);
            if (i == -1) {
                this.f1764KQgRr5e_0.KQgRr5e_0(this.f1765KQgRr5e_0, this.KQgRr5e_0, bundle);
            } else if (i == 0) {
                this.f1764KQgRr5e_0.PGPF6hQ_2(this.f1765KQgRr5e_0, this.KQgRr5e_0, bundle);
            } else if (i != 1) {
                Log.w("MediaBrowserCompat", "Unknown result code: " + i + " (extras=" + this.KQgRr5e_0 + ", resultData=" + bundle + ")");
            } else {
                this.f1764KQgRr5e_0.QxJ9d_1(this.f1765KQgRr5e_0, this.KQgRr5e_0, bundle);
            }
        }
    }

    /* loaded from: classes.dex */
    public static class EuDEkJe_12 {
        public final List<WwEq_13> KQgRr5e_0 = new ArrayList();
        public final List<Bundle> QxJ9d_1 = new ArrayList();

        public List<WwEq_13> KQgRr5e_0() {
            return this.KQgRr5e_0;
        }

        public List<Bundle> QxJ9d_1() {
            return this.QxJ9d_1;
        }

        public WwEq_13 KQgRr5e_0(Bundle bundle) {
            for (int i = 0; i < this.QxJ9d_1.size(); i++) {
                if (X6FRs_4.WwEq_13.Mqv2r_3.KQgRr5e_0(this.QxJ9d_1.get(i), bundle)) {
                    return this.KQgRr5e_0.get(i);
                }
            }
            return null;
        }
    }

    /* loaded from: classes.dex */
    public static class FSaI4_7 extends IMuAHx_6 {
        public FSaI4_7(Context context, ComponentName componentName, QxJ9d_1 qxJ9d_1, Bundle bundle) {
            super(context, componentName, qxJ9d_1, bundle);
        }
    }

    /* loaded from: classes.dex */
    public static class IMuAHx_6 extends IFxWkV_5 {
        public IMuAHx_6(Context context, ComponentName componentName, QxJ9d_1 qxJ9d_1, Bundle bundle) {
            super(context, componentName, qxJ9d_1, bundle);
        }
    }

    /* loaded from: classes.dex */
    public static class ItemReceiver extends ResultReceiver {
        public final Mqv2r_3 KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final String f1773KQgRr5e_0;

        @Override // android.support.v4.os.ResultReceiver
        public void KQgRr5e_0(int i, Bundle bundle) {
            MediaSessionCompat.KQgRr5e_0(bundle);
            if (i == 0 && bundle != null && bundle.containsKey("media_item")) {
                Parcelable parcelable = bundle.getParcelable("media_item");
                if (parcelable != null && !(parcelable instanceof MediaItem)) {
                    this.KQgRr5e_0.KQgRr5e_0(this.f1773KQgRr5e_0);
                    return;
                } else {
                    this.KQgRr5e_0.KQgRr5e_0((MediaItem) parcelable);
                    return;
                }
            }
            this.KQgRr5e_0.KQgRr5e_0(this.f1773KQgRr5e_0);
        }
    }

    /* loaded from: classes.dex */
    public static class KQgRr5e_0 extends Handler {
        public final WeakReference<XnFJ5_9> KQgRr5e_0;
        public WeakReference<Messenger> QxJ9d_1;

        public KQgRr5e_0(XnFJ5_9 xnFJ5_9) {
            this.KQgRr5e_0 = new WeakReference<>(xnFJ5_9);
        }

        public void KQgRr5e_0(Messenger messenger) {
            this.QxJ9d_1 = new WeakReference<>(messenger);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            WeakReference<Messenger> weakReference = this.QxJ9d_1;
            if (weakReference == null || weakReference.get() == null || this.KQgRr5e_0.get() == null) {
                return;
            }
            Bundle data = message.getData();
            MediaSessionCompat.KQgRr5e_0(data);
            XnFJ5_9 xnFJ5_9 = this.KQgRr5e_0.get();
            Messenger messenger = this.QxJ9d_1.get();
            try {
                int i = message.what;
                if (i == 1) {
                    Bundle bundle = data.getBundle("data_root_hints");
                    MediaSessionCompat.KQgRr5e_0(bundle);
                    xnFJ5_9.KQgRr5e_0(messenger, data.getString("data_media_item_id"), (MediaSessionCompat.Token) data.getParcelable("data_media_session_token"), bundle);
                } else if (i == 2) {
                    xnFJ5_9.KQgRr5e_0(messenger);
                } else if (i != 3) {
                    Log.w("MediaBrowserCompat", "Unhandled message: " + message + "\n  Client version: 1\n  Service version: " + message.arg1);
                } else {
                    Bundle bundle2 = data.getBundle("data_options");
                    MediaSessionCompat.KQgRr5e_0(bundle2);
                    Bundle bundle3 = data.getBundle("data_notify_children_changed_options");
                    MediaSessionCompat.KQgRr5e_0(bundle3);
                    xnFJ5_9.KQgRr5e_0(messenger, data.getString("data_media_item_id"), data.getParcelableArrayList("data_media_item_list"), bundle2, bundle3);
                }
            } catch (BadParcelableException unused) {
                Log.e("MediaBrowserCompat", "Could not unparcel the data.");
                if (message.what == 1) {
                    xnFJ5_9.KQgRr5e_0(messenger);
                }
            }
        }
    }

    /* loaded from: classes.dex */
    public static abstract class Mqv2r_3 {
        public abstract void KQgRr5e_0(MediaItem mediaItem);

        public abstract void KQgRr5e_0(String str);
    }

    /* loaded from: classes.dex */
    public static abstract class Nm6q_10 {
        public abstract void KQgRr5e_0(String str, Bundle bundle);

        public abstract void KQgRr5e_0(String str, Bundle bundle, List<MediaItem> list);
    }

    /* loaded from: classes.dex */
    public static abstract class PGPF6hQ_2 {
        public abstract void KQgRr5e_0(String str, Bundle bundle, Bundle bundle2);

        public abstract void PGPF6hQ_2(String str, Bundle bundle, Bundle bundle2);

        public abstract void QxJ9d_1(String str, Bundle bundle, Bundle bundle2);
    }

    /* loaded from: classes.dex */
    public static class QxJ9d_1 {
        public KQgRr5e_0 KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Object f1776KQgRr5e_0;

        /* loaded from: classes.dex */
        public interface KQgRr5e_0 {
            void KQgRr5e_0();

            void PGPF6hQ_2();

            void QxJ9d_1();
        }

        /* renamed from: android.support.v4.media.MediaBrowserCompat$QxJ9d_1$QxJ9d_1  reason: collision with other inner class name */
        /* loaded from: classes.dex */
        public class C0084QxJ9d_1 implements KQgRr5e_0.InterfaceC0030KQgRr5e_0 {
            public C0084QxJ9d_1() {
            }

            @Override // Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.InterfaceC0030KQgRr5e_0
            public void KQgRr5e_0() {
                KQgRr5e_0 kQgRr5e_0 = QxJ9d_1.this.KQgRr5e_0;
                if (kQgRr5e_0 != null) {
                    kQgRr5e_0.KQgRr5e_0();
                }
                QxJ9d_1.this.QxJ9d_1();
            }

            @Override // Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.InterfaceC0030KQgRr5e_0
            public void PGPF6hQ_2() {
                KQgRr5e_0 kQgRr5e_0 = QxJ9d_1.this.KQgRr5e_0;
                if (kQgRr5e_0 != null) {
                    kQgRr5e_0.PGPF6hQ_2();
                }
                QxJ9d_1.this.KQgRr5e_0();
            }

            @Override // Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.InterfaceC0030KQgRr5e_0
            public void QxJ9d_1() {
                KQgRr5e_0 kQgRr5e_0 = QxJ9d_1.this.KQgRr5e_0;
                if (kQgRr5e_0 != null) {
                    kQgRr5e_0.QxJ9d_1();
                }
                QxJ9d_1.this.PGPF6hQ_2();
            }
        }

        public QxJ9d_1() {
            if (Build.VERSION.SDK_INT >= 21) {
                this.f1776KQgRr5e_0 = Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.KQgRr5e_0((KQgRr5e_0.InterfaceC0030KQgRr5e_0) new C0084QxJ9d_1());
            } else {
                this.f1776KQgRr5e_0 = null;
            }
        }

        public void KQgRr5e_0() {
            throw null;
        }

        public void KQgRr5e_0(KQgRr5e_0 kQgRr5e_0) {
            this.KQgRr5e_0 = kQgRr5e_0;
        }

        public void PGPF6hQ_2() {
            throw null;
        }

        public void QxJ9d_1() {
            throw null;
        }
    }

    /* loaded from: classes.dex */
    public static class SearchResultReceiver extends ResultReceiver {
        public final Bundle KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Nm6q_10 f1777KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final String f1778KQgRr5e_0;

        @Override // android.support.v4.os.ResultReceiver
        public void KQgRr5e_0(int i, Bundle bundle) {
            MediaSessionCompat.KQgRr5e_0(bundle);
            if (i == 0 && bundle != null && bundle.containsKey("search_results")) {
                Parcelable[] parcelableArray = bundle.getParcelableArray("search_results");
                ArrayList arrayList = null;
                if (parcelableArray != null) {
                    arrayList = new ArrayList();
                    for (Parcelable parcelable : parcelableArray) {
                        arrayList.add((MediaItem) parcelable);
                    }
                }
                this.f1777KQgRr5e_0.KQgRr5e_0(this.f1778KQgRr5e_0, this.KQgRr5e_0, arrayList);
                return;
            }
            this.f1777KQgRr5e_0.KQgRr5e_0(this.f1778KQgRr5e_0, this.KQgRr5e_0);
        }
    }

    /* loaded from: classes.dex */
    public interface X6FRs_4 {
        MediaSessionCompat.Token KQgRr5e_0();

        void Mqv2r_3();

        void X6FRs_4();
    }

    /* loaded from: classes.dex */
    public static class Xgtqvk_8 implements X6FRs_4, XnFJ5_9 {

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final ComponentName f1781KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Context f1782KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Bundle f1783KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public Messenger f1784KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public KNBe_11 f1785KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final QxJ9d_1 f1787KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public PGPF6hQ_2 f1788KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public MediaSessionCompat.Token f1789KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public String f1790KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final KQgRr5e_0 f1786KQgRr5e_0 = new KQgRr5e_0(this);

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final X6FRs_4.Mqv2r_3.KQgRr5e_0<String, EuDEkJe_12> f1780KQgRr5e_0 = new X6FRs_4.Mqv2r_3.KQgRr5e_0<>();
        public int KQgRr5e_0 = 1;

        /* loaded from: classes.dex */
        public class KQgRr5e_0 implements Runnable {
            public KQgRr5e_0() {
            }

            @Override // java.lang.Runnable
            public void run() {
                Xgtqvk_8 xgtqvk_8 = Xgtqvk_8.this;
                if (xgtqvk_8.KQgRr5e_0 == 0) {
                    return;
                }
                xgtqvk_8.KQgRr5e_0 = 2;
                if (MediaBrowserCompat.KQgRr5e_0 && xgtqvk_8.f1788KQgRr5e_0 != null) {
                    throw new RuntimeException("mServiceConnection should be null. Instead it is " + Xgtqvk_8.this.f1788KQgRr5e_0);
                }
                Xgtqvk_8 xgtqvk_82 = Xgtqvk_8.this;
                if (xgtqvk_82.f1785KQgRr5e_0 == null) {
                    if (xgtqvk_82.f1784KQgRr5e_0 == null) {
                        Intent intent = new Intent("android.media.browse.MediaBrowserService");
                        intent.setComponent(Xgtqvk_8.this.f1781KQgRr5e_0);
                        Xgtqvk_8 xgtqvk_83 = Xgtqvk_8.this;
                        xgtqvk_83.f1788KQgRr5e_0 = new PGPF6hQ_2();
                        boolean z = false;
                        try {
                            z = Xgtqvk_8.this.f1782KQgRr5e_0.bindService(intent, Xgtqvk_8.this.f1788KQgRr5e_0, 1);
                        } catch (Exception unused) {
                            Log.e("MediaBrowserCompat", "Failed binding to service " + Xgtqvk_8.this.f1781KQgRr5e_0);
                        }
                        if (!z) {
                            Xgtqvk_8.this.QxJ9d_1();
                            Xgtqvk_8.this.f1787KQgRr5e_0.QxJ9d_1();
                        }
                        if (MediaBrowserCompat.KQgRr5e_0) {
                            Log.d("MediaBrowserCompat", "connect...");
                            Xgtqvk_8.this.KQgRr5e_0();
                            return;
                        }
                        return;
                    }
                    throw new RuntimeException("mCallbacksMessenger should be null. Instead it is " + Xgtqvk_8.this.f1784KQgRr5e_0);
                }
                throw new RuntimeException("mServiceBinderWrapper should be null. Instead it is " + Xgtqvk_8.this.f1785KQgRr5e_0);
            }
        }

        /* loaded from: classes.dex */
        public class QxJ9d_1 implements Runnable {
            public QxJ9d_1() {
            }

            @Override // java.lang.Runnable
            public void run() {
                Xgtqvk_8 xgtqvk_8 = Xgtqvk_8.this;
                Messenger messenger = xgtqvk_8.f1784KQgRr5e_0;
                if (messenger != null) {
                    try {
                        xgtqvk_8.f1785KQgRr5e_0.KQgRr5e_0(messenger);
                    } catch (RemoteException unused) {
                        Log.w("MediaBrowserCompat", "RemoteException during connect for " + Xgtqvk_8.this.f1781KQgRr5e_0);
                    }
                }
                Xgtqvk_8 xgtqvk_82 = Xgtqvk_8.this;
                int i = xgtqvk_82.KQgRr5e_0;
                xgtqvk_82.QxJ9d_1();
                if (i != 0) {
                    Xgtqvk_8.this.KQgRr5e_0 = i;
                }
                if (MediaBrowserCompat.KQgRr5e_0) {
                    Log.d("MediaBrowserCompat", "disconnect...");
                    Xgtqvk_8.this.KQgRr5e_0();
                }
            }
        }

        public Xgtqvk_8(Context context, ComponentName componentName, QxJ9d_1 qxJ9d_1, Bundle bundle) {
            if (context == null) {
                throw new IllegalArgumentException("context must not be null");
            }
            if (componentName == null) {
                throw new IllegalArgumentException("service component must not be null");
            }
            if (qxJ9d_1 != null) {
                this.f1782KQgRr5e_0 = context;
                this.f1781KQgRr5e_0 = componentName;
                this.f1787KQgRr5e_0 = qxJ9d_1;
                this.f1783KQgRr5e_0 = bundle == null ? null : new Bundle(bundle);
                return;
            }
            throw new IllegalArgumentException("connection callback must not be null");
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4, android.support.v4.media.MediaBrowserCompat.QxJ9d_1.KQgRr5e_0
        public boolean KQgRr5e_0() {
            return this.KQgRr5e_0 == 3;
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4
        public void Mqv2r_3() {
            this.KQgRr5e_0 = 0;
            this.f1786KQgRr5e_0.post(new QxJ9d_1());
        }

        public void QxJ9d_1() {
            PGPF6hQ_2 pGPF6hQ_2 = this.f1788KQgRr5e_0;
            if (pGPF6hQ_2 != null) {
                this.f1782KQgRr5e_0.unbindService(pGPF6hQ_2);
            }
            this.KQgRr5e_0 = 1;
            this.f1788KQgRr5e_0 = null;
            this.f1785KQgRr5e_0 = null;
            this.f1784KQgRr5e_0 = null;
            this.f1786KQgRr5e_0.KQgRr5e_0(null);
            this.f1790KQgRr5e_0 = null;
            this.f1789KQgRr5e_0 = null;
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4
        public void X6FRs_4() {
            int i = this.KQgRr5e_0;
            if (i != 0 && i != 1) {
                throw new IllegalStateException("connect() called while neigther disconnecting nor disconnected (state=" + KQgRr5e_0(this.KQgRr5e_0) + ")");
            }
            this.KQgRr5e_0 = 2;
            this.f1786KQgRr5e_0.post(new KQgRr5e_0());
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4, android.support.v4.media.MediaBrowserCompat.QxJ9d_1.KQgRr5e_0
        public MediaSessionCompat.Token KQgRr5e_0() {
            if (KQgRr5e_0()) {
                return this.f1789KQgRr5e_0;
            }
            throw new IllegalStateException("getSessionToken() called while not connected(state=" + this.KQgRr5e_0 + ")");
        }

        /* loaded from: classes.dex */
        public class PGPF6hQ_2 implements ServiceConnection {

            /* loaded from: classes.dex */
            public class KQgRr5e_0 implements Runnable {
                public final /* synthetic */ ComponentName KQgRr5e_0;

                /* renamed from: KQgRr5e_0  reason: collision with other field name */
                public final /* synthetic */ IBinder f1791KQgRr5e_0;

                public KQgRr5e_0(ComponentName componentName, IBinder iBinder) {
                    this.KQgRr5e_0 = componentName;
                    this.f1791KQgRr5e_0 = iBinder;
                }

                @Override // java.lang.Runnable
                public void run() {
                    if (MediaBrowserCompat.KQgRr5e_0) {
                        Log.d("MediaBrowserCompat", "MediaServiceConnection.onServiceConnected name=" + this.KQgRr5e_0 + " binder=" + this.f1791KQgRr5e_0);
                        Xgtqvk_8.this.KQgRr5e_0();
                    }
                    if (PGPF6hQ_2.this.KQgRr5e_0("onServiceConnected")) {
                        Xgtqvk_8 xgtqvk_8 = Xgtqvk_8.this;
                        xgtqvk_8.f1785KQgRr5e_0 = new KNBe_11(this.f1791KQgRr5e_0, xgtqvk_8.f1783KQgRr5e_0);
                        Xgtqvk_8.this.f1784KQgRr5e_0 = new Messenger(Xgtqvk_8.this.f1786KQgRr5e_0);
                        Xgtqvk_8 xgtqvk_82 = Xgtqvk_8.this;
                        xgtqvk_82.f1786KQgRr5e_0.KQgRr5e_0(xgtqvk_82.f1784KQgRr5e_0);
                        Xgtqvk_8.this.KQgRr5e_0 = 2;
                        try {
                            if (MediaBrowserCompat.KQgRr5e_0) {
                                Log.d("MediaBrowserCompat", "ServiceCallbacks.onConnect...");
                                Xgtqvk_8.this.KQgRr5e_0();
                            }
                            Xgtqvk_8.this.f1785KQgRr5e_0.KQgRr5e_0(Xgtqvk_8.this.f1782KQgRr5e_0, Xgtqvk_8.this.f1784KQgRr5e_0);
                        } catch (RemoteException unused) {
                            Log.w("MediaBrowserCompat", "RemoteException during connect for " + Xgtqvk_8.this.f1781KQgRr5e_0);
                            if (MediaBrowserCompat.KQgRr5e_0) {
                                Log.d("MediaBrowserCompat", "ServiceCallbacks.onConnect...");
                                Xgtqvk_8.this.KQgRr5e_0();
                            }
                        }
                    }
                }
            }

            /* loaded from: classes.dex */
            public class QxJ9d_1 implements Runnable {
                public final /* synthetic */ ComponentName KQgRr5e_0;

                public QxJ9d_1(ComponentName componentName) {
                    this.KQgRr5e_0 = componentName;
                }

                @Override // java.lang.Runnable
                public void run() {
                    if (MediaBrowserCompat.KQgRr5e_0) {
                        Log.d("MediaBrowserCompat", "MediaServiceConnection.onServiceDisconnected name=" + this.KQgRr5e_0 + " this=" + this + " mServiceConnection=" + Xgtqvk_8.this.f1788KQgRr5e_0);
                        Xgtqvk_8.this.KQgRr5e_0();
                    }
                    if (PGPF6hQ_2.this.KQgRr5e_0("onServiceDisconnected")) {
                        Xgtqvk_8 xgtqvk_8 = Xgtqvk_8.this;
                        xgtqvk_8.f1785KQgRr5e_0 = null;
                        xgtqvk_8.f1784KQgRr5e_0 = null;
                        xgtqvk_8.f1786KQgRr5e_0.KQgRr5e_0(null);
                        Xgtqvk_8 xgtqvk_82 = Xgtqvk_8.this;
                        xgtqvk_82.KQgRr5e_0 = 4;
                        xgtqvk_82.f1787KQgRr5e_0.PGPF6hQ_2();
                    }
                }
            }

            public PGPF6hQ_2() {
            }

            public final void KQgRr5e_0(Runnable runnable) {
                if (Thread.currentThread() == Xgtqvk_8.this.f1786KQgRr5e_0.getLooper().getThread()) {
                    runnable.run();
                } else {
                    Xgtqvk_8.this.f1786KQgRr5e_0.post(runnable);
                }
            }

            @Override // android.content.ServiceConnection
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                KQgRr5e_0(new KQgRr5e_0(componentName, iBinder));
            }

            @Override // android.content.ServiceConnection
            public void onServiceDisconnected(ComponentName componentName) {
                KQgRr5e_0(new QxJ9d_1(componentName));
            }

            public boolean KQgRr5e_0(String str) {
                int i;
                Xgtqvk_8 xgtqvk_8 = Xgtqvk_8.this;
                if (xgtqvk_8.f1788KQgRr5e_0 != this || (i = xgtqvk_8.KQgRr5e_0) == 0 || i == 1) {
                    int i2 = Xgtqvk_8.this.KQgRr5e_0;
                    if (i2 == 0 || i2 == 1) {
                        return false;
                    }
                    Log.i("MediaBrowserCompat", str + " for " + Xgtqvk_8.this.f1781KQgRr5e_0 + " with mServiceConnection=" + Xgtqvk_8.this.f1788KQgRr5e_0 + " this=" + this);
                    return false;
                }
                return true;
            }
        }

        @Override // android.support.v4.media.MediaBrowserCompat.XnFJ5_9
        public void KQgRr5e_0(Messenger messenger, String str, MediaSessionCompat.Token token, Bundle bundle) {
            if (KQgRr5e_0(messenger, "onConnect")) {
                if (this.KQgRr5e_0 != 2) {
                    Log.w("MediaBrowserCompat", "onConnect from service while mState=" + KQgRr5e_0(this.KQgRr5e_0) + "... ignoring");
                    return;
                }
                this.f1790KQgRr5e_0 = str;
                this.f1789KQgRr5e_0 = token;
                this.KQgRr5e_0 = 3;
                if (MediaBrowserCompat.KQgRr5e_0) {
                    Log.d("MediaBrowserCompat", "ServiceCallbacks.onConnect...");
                    KQgRr5e_0();
                }
                this.f1787KQgRr5e_0.KQgRr5e_0();
                try {
                    for (Map.Entry<String, EuDEkJe_12> entry : this.f1780KQgRr5e_0.entrySet()) {
                        String key = entry.getKey();
                        EuDEkJe_12 value = entry.getValue();
                        List<WwEq_13> KQgRr5e_02 = value.KQgRr5e_0();
                        List<Bundle> QxJ9d_12 = value.QxJ9d_1();
                        for (int i = 0; i < KQgRr5e_02.size(); i++) {
                            this.f1785KQgRr5e_0.KQgRr5e_0(key, KQgRr5e_02.get(i).KQgRr5e_0, QxJ9d_12.get(i), this.f1784KQgRr5e_0);
                        }
                    }
                } catch (RemoteException unused) {
                    Log.d("MediaBrowserCompat", "addSubscription failed with RemoteException.");
                }
            }
        }

        @Override // android.support.v4.media.MediaBrowserCompat.XnFJ5_9
        public void KQgRr5e_0(Messenger messenger) {
            Log.e("MediaBrowserCompat", "onConnectFailed for " + this.f1781KQgRr5e_0);
            if (KQgRr5e_0(messenger, "onConnectFailed")) {
                if (this.KQgRr5e_0 != 2) {
                    Log.w("MediaBrowserCompat", "onConnect from service while mState=" + KQgRr5e_0(this.KQgRr5e_0) + "... ignoring");
                    return;
                }
                QxJ9d_1();
                this.f1787KQgRr5e_0.QxJ9d_1();
            }
        }

        @Override // android.support.v4.media.MediaBrowserCompat.XnFJ5_9
        public void KQgRr5e_0(Messenger messenger, String str, List list, Bundle bundle, Bundle bundle2) {
            if (KQgRr5e_0(messenger, "onLoadChildren")) {
                if (MediaBrowserCompat.KQgRr5e_0) {
                    Log.d("MediaBrowserCompat", "onLoadChildren for " + this.f1781KQgRr5e_0 + " id=" + str);
                }
                EuDEkJe_12 euDEkJe_12 = this.f1780KQgRr5e_0.get(str);
                if (euDEkJe_12 == null) {
                    if (MediaBrowserCompat.KQgRr5e_0) {
                        Log.d("MediaBrowserCompat", "onLoadChildren for id that isn't subscribed id=" + str);
                        return;
                    }
                    return;
                }
                WwEq_13 KQgRr5e_02 = euDEkJe_12.KQgRr5e_0(bundle);
                if (KQgRr5e_02 != null) {
                    if (bundle == null) {
                        if (list == null) {
                            KQgRr5e_02.KQgRr5e_0(str);
                        } else {
                            KQgRr5e_02.KQgRr5e_0(str, list);
                        }
                    } else if (list == null) {
                        KQgRr5e_02.KQgRr5e_0(str, bundle);
                    } else {
                        KQgRr5e_02.KQgRr5e_0(str, list, bundle);
                    }
                }
            }
        }

        public static String KQgRr5e_0(int i) {
            if (i != 0) {
                if (i != 1) {
                    if (i != 2) {
                        if (i != 3) {
                            if (i != 4) {
                                return "UNKNOWN/" + i;
                            }
                            return "CONNECT_STATE_SUSPENDED";
                        }
                        return "CONNECT_STATE_CONNECTED";
                    }
                    return "CONNECT_STATE_CONNECTING";
                }
                return "CONNECT_STATE_DISCONNECTED";
            }
            return "CONNECT_STATE_DISCONNECTING";
        }

        public final boolean KQgRr5e_0(Messenger messenger, String str) {
            int i;
            if (this.f1784KQgRr5e_0 != messenger || (i = this.KQgRr5e_0) == 0 || i == 1) {
                int i2 = this.KQgRr5e_0;
                if (i2 == 0 || i2 == 1) {
                    return false;
                }
                Log.i("MediaBrowserCompat", str + " for " + this.f1781KQgRr5e_0 + " with mCallbacksMessenger=" + this.f1784KQgRr5e_0 + " this=" + this);
                return false;
            }
            return true;
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4, android.support.v4.media.MediaBrowserCompat.QxJ9d_1.KQgRr5e_0
        public void KQgRr5e_0() {
            Log.d("MediaBrowserCompat", "MediaBrowserCompat...");
            Log.d("MediaBrowserCompat", "  mServiceComponent=" + this.f1781KQgRr5e_0);
            Log.d("MediaBrowserCompat", "  mCallback=" + this.f1787KQgRr5e_0);
            Log.d("MediaBrowserCompat", "  mRootHints=" + this.f1783KQgRr5e_0);
            Log.d("MediaBrowserCompat", "  mState=" + KQgRr5e_0(this.KQgRr5e_0));
            Log.d("MediaBrowserCompat", "  mServiceConnection=" + this.f1788KQgRr5e_0);
            Log.d("MediaBrowserCompat", "  mServiceBinderWrapper=" + this.f1785KQgRr5e_0);
            Log.d("MediaBrowserCompat", "  mCallbacksMessenger=" + this.f1784KQgRr5e_0);
            Log.d("MediaBrowserCompat", "  mRootId=" + this.f1790KQgRr5e_0);
            Log.d("MediaBrowserCompat", "  mMediaSessionToken=" + this.f1789KQgRr5e_0);
        }
    }

    /* loaded from: classes.dex */
    public interface XnFJ5_9 {
        void KQgRr5e_0(Messenger messenger);

        void KQgRr5e_0(Messenger messenger, String str, MediaSessionCompat.Token token, Bundle bundle);

        void KQgRr5e_0(Messenger messenger, String str, List list, Bundle bundle, Bundle bundle2);
    }

    public MediaBrowserCompat(Context context, ComponentName componentName, QxJ9d_1 qxJ9d_1, Bundle bundle) {
        int i = Build.VERSION.SDK_INT;
        if (i >= 26) {
            this.f1763KQgRr5e_0 = new FSaI4_7(context, componentName, qxJ9d_1, bundle);
        } else if (i >= 23) {
            this.f1763KQgRr5e_0 = new IMuAHx_6(context, componentName, qxJ9d_1, bundle);
        } else if (i >= 21) {
            this.f1763KQgRr5e_0 = new IFxWkV_5(context, componentName, qxJ9d_1, bundle);
        } else {
            this.f1763KQgRr5e_0 = new Xgtqvk_8(context, componentName, qxJ9d_1, bundle);
        }
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public void m817KQgRr5e_0() {
        this.f1763KQgRr5e_0.X6FRs_4();
    }

    public void QxJ9d_1() {
        this.f1763KQgRr5e_0.Mqv2r_3();
    }

    /* loaded from: classes.dex */
    public static abstract class WwEq_13 {
        public final IBinder KQgRr5e_0 = new Binder();

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public WeakReference<EuDEkJe_12> f1779KQgRr5e_0;

        public WwEq_13() {
            int i = Build.VERSION.SDK_INT;
            if (i >= 26) {
                Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.QxJ9d_1.KQgRr5e_0(new QxJ9d_1());
            } else if (i >= 21) {
                Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.KQgRr5e_0((KQgRr5e_0.Mqv2r_3) new KQgRr5e_0());
            }
        }

        public void KQgRr5e_0(String str) {
        }

        public void KQgRr5e_0(String str, Bundle bundle) {
        }

        public void KQgRr5e_0(String str, List<MediaItem> list) {
        }

        public void KQgRr5e_0(String str, List<MediaItem> list, Bundle bundle) {
        }

        /* loaded from: classes.dex */
        public class QxJ9d_1 extends KQgRr5e_0 implements QxJ9d_1.KQgRr5e_0 {
            public QxJ9d_1() {
                super();
            }

            @Override // Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.QxJ9d_1.KQgRr5e_0
            public void KQgRr5e_0(String str, List<?> list, Bundle bundle) {
                WwEq_13.this.KQgRr5e_0(str, MediaItem.KQgRr5e_0(list), bundle);
            }

            @Override // Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.QxJ9d_1.KQgRr5e_0
            public void KQgRr5e_0(String str, Bundle bundle) {
                WwEq_13.this.KQgRr5e_0(str, bundle);
            }
        }

        /* loaded from: classes.dex */
        public class KQgRr5e_0 implements KQgRr5e_0.Mqv2r_3 {
            public KQgRr5e_0() {
            }

            @Override // Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.Mqv2r_3
            public void KQgRr5e_0(String str, List<?> list) {
                WeakReference<EuDEkJe_12> weakReference = WwEq_13.this.f1779KQgRr5e_0;
                EuDEkJe_12 euDEkJe_12 = weakReference == null ? null : weakReference.get();
                if (euDEkJe_12 == null) {
                    WwEq_13.this.KQgRr5e_0(str, MediaItem.KQgRr5e_0(list));
                    return;
                }
                List<MediaItem> KQgRr5e_0 = MediaItem.KQgRr5e_0(list);
                List<WwEq_13> KQgRr5e_02 = euDEkJe_12.KQgRr5e_0();
                List<Bundle> QxJ9d_1 = euDEkJe_12.QxJ9d_1();
                for (int i = 0; i < KQgRr5e_02.size(); i++) {
                    Bundle bundle = QxJ9d_1.get(i);
                    if (bundle == null) {
                        WwEq_13.this.KQgRr5e_0(str, KQgRr5e_0);
                    } else {
                        WwEq_13.this.KQgRr5e_0(str, KQgRr5e_0(KQgRr5e_0, bundle), bundle);
                    }
                }
            }

            @Override // Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.Mqv2r_3
            public void KQgRr5e_0(String str) {
                WwEq_13.this.KQgRr5e_0(str);
            }

            public List<MediaItem> KQgRr5e_0(List<MediaItem> list, Bundle bundle) {
                if (list == null) {
                    return null;
                }
                int i = bundle.getInt("android.media.browse.extra.PAGE", -1);
                int i2 = bundle.getInt("android.media.browse.extra.PAGE_SIZE", -1);
                if (i == -1 && i2 == -1) {
                    return list;
                }
                int i3 = i2 * i;
                int i4 = i3 + i2;
                if (i >= 0 && i2 >= 1 && i3 < list.size()) {
                    if (i4 > list.size()) {
                        i4 = list.size();
                    }
                    return list.subList(i3, i4);
                }
                return Collections.emptyList();
            }
        }
    }

    public MediaSessionCompat.Token KQgRr5e_0() {
        return this.f1763KQgRr5e_0.KQgRr5e_0();
    }

    /* loaded from: classes.dex */
    public static class KNBe_11 {
        public Bundle KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public Messenger f1774KQgRr5e_0;

        public KNBe_11(IBinder iBinder, Bundle bundle) {
            this.f1774KQgRr5e_0 = new Messenger(iBinder);
            this.KQgRr5e_0 = bundle;
        }

        public void KQgRr5e_0(Context context, Messenger messenger) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_package_name", context.getPackageName());
            bundle.putBundle("data_root_hints", this.KQgRr5e_0);
            KQgRr5e_0(1, bundle, messenger);
        }

        public void QxJ9d_1(Context context, Messenger messenger) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_package_name", context.getPackageName());
            bundle.putBundle("data_root_hints", this.KQgRr5e_0);
            KQgRr5e_0(6, bundle, messenger);
        }

        public void KQgRr5e_0(Messenger messenger) throws RemoteException {
            KQgRr5e_0(2, null, messenger);
        }

        public void QxJ9d_1(Messenger messenger) throws RemoteException {
            KQgRr5e_0(7, null, messenger);
        }

        public void KQgRr5e_0(String str, IBinder iBinder, Bundle bundle, Messenger messenger) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_media_item_id", str);
            X6FRs_4.IMuAHx_6.Mqv2r_3.PGPF6hQ_2.KQgRr5e_0(bundle2, "data_callback_token", iBinder);
            bundle2.putBundle("data_options", bundle);
            KQgRr5e_0(3, bundle2, messenger);
        }

        public final void KQgRr5e_0(int i, Bundle bundle, Messenger messenger) throws RemoteException {
            Message obtain = Message.obtain();
            obtain.what = i;
            obtain.arg1 = 1;
            obtain.setData(bundle);
            obtain.replyTo = messenger;
            this.f1774KQgRr5e_0.send(obtain);
        }
    }

    /* loaded from: classes.dex */
    public static class IFxWkV_5 implements X6FRs_4, XnFJ5_9, QxJ9d_1.KQgRr5e_0 {

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Context f1766KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Bundle f1767KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public Messenger f1768KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public KNBe_11 f1769KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public MediaSessionCompat.Token f1771KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final Object f1772KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final KQgRr5e_0 f1770KQgRr5e_0 = new KQgRr5e_0(this);
        public final X6FRs_4.Mqv2r_3.KQgRr5e_0<String, EuDEkJe_12> KQgRr5e_0 = new X6FRs_4.Mqv2r_3.KQgRr5e_0<>();

        public IFxWkV_5(Context context, ComponentName componentName, QxJ9d_1 qxJ9d_1, Bundle bundle) {
            this.f1766KQgRr5e_0 = context;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            this.f1767KQgRr5e_0 = bundle2;
            bundle2.putInt("extra_client_version", 1);
            qxJ9d_1.KQgRr5e_0(this);
            this.f1772KQgRr5e_0 = Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.KQgRr5e_0(context, componentName, qxJ9d_1.f1776KQgRr5e_0, this.f1767KQgRr5e_0);
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4, android.support.v4.media.MediaBrowserCompat.QxJ9d_1.KQgRr5e_0
        public MediaSessionCompat.Token KQgRr5e_0() {
            if (this.f1771KQgRr5e_0 == null) {
                this.f1771KQgRr5e_0 = MediaSessionCompat.Token.KQgRr5e_0(Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.m149KQgRr5e_0(this.f1772KQgRr5e_0));
            }
            return this.f1771KQgRr5e_0;
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4, android.support.v4.media.MediaBrowserCompat.QxJ9d_1.KQgRr5e_0
        public void KQgRr5e_0() {
        }

        @Override // android.support.v4.media.MediaBrowserCompat.XnFJ5_9
        public void KQgRr5e_0(Messenger messenger) {
        }

        @Override // android.support.v4.media.MediaBrowserCompat.XnFJ5_9
        public void KQgRr5e_0(Messenger messenger, String str, MediaSessionCompat.Token token, Bundle bundle) {
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4
        public void Mqv2r_3() {
            Messenger messenger;
            KNBe_11 kNBe_11 = this.f1769KQgRr5e_0;
            if (kNBe_11 != null && (messenger = this.f1768KQgRr5e_0) != null) {
                try {
                    kNBe_11.QxJ9d_1(messenger);
                } catch (RemoteException unused) {
                    Log.i("MediaBrowserCompat", "Remote error unregistering client messenger.");
                }
            }
            Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.QxJ9d_1(this.f1772KQgRr5e_0);
        }

        @Override // android.support.v4.media.MediaBrowserCompat.QxJ9d_1.KQgRr5e_0
        public void PGPF6hQ_2() {
            Bundle KQgRr5e_0 = Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.KQgRr5e_0(this.f1772KQgRr5e_0);
            if (KQgRr5e_0 == null) {
                return;
            }
            KQgRr5e_0.getInt("extra_service_version", 0);
            IBinder KQgRr5e_02 = X6FRs_4.IMuAHx_6.Mqv2r_3.PGPF6hQ_2.KQgRr5e_0(KQgRr5e_0, "extra_messenger");
            if (KQgRr5e_02 != null) {
                this.f1769KQgRr5e_0 = new KNBe_11(KQgRr5e_02, this.f1767KQgRr5e_0);
                Messenger messenger = new Messenger(this.f1770KQgRr5e_0);
                this.f1768KQgRr5e_0 = messenger;
                this.f1770KQgRr5e_0.KQgRr5e_0(messenger);
                try {
                    this.f1769KQgRr5e_0.QxJ9d_1(this.f1766KQgRr5e_0, this.f1768KQgRr5e_0);
                } catch (RemoteException unused) {
                    Log.i("MediaBrowserCompat", "Remote error registering client messenger.");
                }
            }
            Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.IFxWkV_5.QxJ9d_1 KQgRr5e_03 = QxJ9d_1.KQgRr5e_0.KQgRr5e_0(X6FRs_4.IMuAHx_6.Mqv2r_3.PGPF6hQ_2.KQgRr5e_0(KQgRr5e_0, "extra_session_binder"));
            if (KQgRr5e_03 != null) {
                this.f1771KQgRr5e_0 = MediaSessionCompat.Token.KQgRr5e_0(Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.m149KQgRr5e_0(this.f1772KQgRr5e_0), KQgRr5e_03);
            }
        }

        @Override // android.support.v4.media.MediaBrowserCompat.QxJ9d_1.KQgRr5e_0
        public void QxJ9d_1() {
            this.f1769KQgRr5e_0 = null;
            this.f1768KQgRr5e_0 = null;
            this.f1771KQgRr5e_0 = null;
            this.f1770KQgRr5e_0.KQgRr5e_0(null);
        }

        @Override // android.support.v4.media.MediaBrowserCompat.X6FRs_4
        public void X6FRs_4() {
            Mqv2r_3.KQgRr5e_0.KQgRr5e_0.QxJ9d_1.KQgRr5e_0.m150KQgRr5e_0(this.f1772KQgRr5e_0);
        }

        @Override // android.support.v4.media.MediaBrowserCompat.XnFJ5_9
        public void KQgRr5e_0(Messenger messenger, String str, List list, Bundle bundle, Bundle bundle2) {
            if (this.f1768KQgRr5e_0 != messenger) {
                return;
            }
            EuDEkJe_12 euDEkJe_12 = this.KQgRr5e_0.get(str);
            if (euDEkJe_12 == null) {
                if (MediaBrowserCompat.KQgRr5e_0) {
                    Log.d("MediaBrowserCompat", "onLoadChildren for id that isn't subscribed id=" + str);
                    return;
                }
                return;
            }
            WwEq_13 KQgRr5e_0 = euDEkJe_12.KQgRr5e_0(bundle);
            if (KQgRr5e_0 != null) {
                if (bundle == null) {
                    if (list == null) {
                        KQgRr5e_0.KQgRr5e_0(str);
                    } else {
                        KQgRr5e_0.KQgRr5e_0(str, list);
                    }
                } else if (list == null) {
                    KQgRr5e_0.KQgRr5e_0(str, bundle);
                } else {
                    KQgRr5e_0.KQgRr5e_0(str, list, bundle);
                }
            }
        }
    }

    /* loaded from: classes.dex */
    public static class MediaItem implements Parcelable {
        public static final Parcelable.Creator<MediaItem> CREATOR = new KQgRr5e_0();
        public final int KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final MediaDescriptionCompat f1775KQgRr5e_0;

        /* loaded from: classes.dex */
        public static class KQgRr5e_0 implements Parcelable.Creator<MediaItem> {
            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public MediaItem createFromParcel(Parcel parcel) {
                return new MediaItem(parcel);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: KQgRr5e_0 */
            public MediaItem[] newArray(int i) {
                return new MediaItem[i];
            }
        }

        public MediaItem(MediaDescriptionCompat mediaDescriptionCompat, int i) {
            if (mediaDescriptionCompat != null) {
                if (!TextUtils.isEmpty(mediaDescriptionCompat.m818KQgRr5e_0())) {
                    this.KQgRr5e_0 = i;
                    this.f1775KQgRr5e_0 = mediaDescriptionCompat;
                    return;
                }
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            throw new IllegalArgumentException("description cannot be null");
        }

        public static MediaItem KQgRr5e_0(Object obj) {
            if (obj == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            return new MediaItem(MediaDescriptionCompat.KQgRr5e_0(KQgRr5e_0.PGPF6hQ_2.m151KQgRr5e_0(obj)), KQgRr5e_0.PGPF6hQ_2.KQgRr5e_0(obj));
        }

        @Override // android.os.Parcelable
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "MediaItem{mFlags=" + this.KQgRr5e_0 + ", mDescription=" + this.f1775KQgRr5e_0 + '}';
        }

        @Override // android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.KQgRr5e_0);
            this.f1775KQgRr5e_0.writeToParcel(parcel, i);
        }

        public static List<MediaItem> KQgRr5e_0(List<?> list) {
            if (list == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            ArrayList arrayList = new ArrayList(list.size());
            Iterator<?> it = list.iterator();
            while (it.hasNext()) {
                arrayList.add(KQgRr5e_0(it.next()));
            }
            return arrayList;
        }

        public MediaItem(Parcel parcel) {
            this.KQgRr5e_0 = parcel.readInt();
            this.f1775KQgRr5e_0 = MediaDescriptionCompat.CREATOR.createFromParcel(parcel);
        }
    }
}
