package XnFJ5_9;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
/* compiled from: CertificatePinner.java */
/* loaded from: classes.dex */
public final class KNBe_11 {
    public static final KNBe_11 KQgRr5e_0 = new KQgRr5e_0().KQgRr5e_0();
    @Nullable

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final XnFJ5_9.Ft6VRog_36.WwEq_13.PGPF6hQ_2 f1658KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final Set<QxJ9d_1> f1659KQgRr5e_0;

    /* compiled from: CertificatePinner.java */
    /* loaded from: classes.dex */
    public static final class KQgRr5e_0 {
        public final List<QxJ9d_1> KQgRr5e_0 = new ArrayList();

        public KNBe_11 KQgRr5e_0() {
            return new KNBe_11(new LinkedHashSet(this.KQgRr5e_0), null);
        }
    }

    /* compiled from: CertificatePinner.java */
    /* loaded from: classes.dex */
    public static final class QxJ9d_1 {
        public final Nm6q_10.FSaI4_7 KQgRr5e_0;

        /* renamed from: KQgRr5e_0  reason: collision with other field name */
        public final String f1660KQgRr5e_0;
        public final String PGPF6hQ_2;
        public final String QxJ9d_1;

        public boolean KQgRr5e_0(String str) {
            if (this.f1660KQgRr5e_0.startsWith("*.")) {
                int indexOf = str.indexOf(46);
                if ((str.length() - indexOf) - 1 == this.QxJ9d_1.length()) {
                    String str2 = this.QxJ9d_1;
                    if (str.regionMatches(false, indexOf + 1, str2, 0, str2.length())) {
                        return true;
                    }
                }
                return false;
            }
            return str.equals(this.QxJ9d_1);
        }

        public boolean equals(Object obj) {
            if (obj instanceof QxJ9d_1) {
                QxJ9d_1 qxJ9d_1 = (QxJ9d_1) obj;
                if (this.f1660KQgRr5e_0.equals(qxJ9d_1.f1660KQgRr5e_0) && this.PGPF6hQ_2.equals(qxJ9d_1.PGPF6hQ_2) && this.KQgRr5e_0.equals(qxJ9d_1.KQgRr5e_0)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return ((((527 + this.f1660KQgRr5e_0.hashCode()) * 31) + this.PGPF6hQ_2.hashCode()) * 31) + this.KQgRr5e_0.hashCode();
        }

        public String toString() {
            return this.PGPF6hQ_2 + this.KQgRr5e_0.m158KQgRr5e_0();
        }
    }

    public KNBe_11(Set<QxJ9d_1> set, @Nullable XnFJ5_9.Ft6VRog_36.WwEq_13.PGPF6hQ_2 pGPF6hQ_2) {
        this.f1659KQgRr5e_0 = set;
        this.f1658KQgRr5e_0 = pGPF6hQ_2;
    }

    public static Nm6q_10.FSaI4_7 QxJ9d_1(X509Certificate x509Certificate) {
        return Nm6q_10.FSaI4_7.KQgRr5e_0(x509Certificate.getPublicKey().getEncoded()).m166QxJ9d_1();
    }

    public void KQgRr5e_0(String str, List<Certificate> list) throws SSLPeerUnverifiedException {
        List<QxJ9d_1> KQgRr5e_02 = KQgRr5e_0(str);
        if (KQgRr5e_02.isEmpty()) {
            return;
        }
        XnFJ5_9.Ft6VRog_36.WwEq_13.PGPF6hQ_2 pGPF6hQ_2 = this.f1658KQgRr5e_0;
        if (pGPF6hQ_2 != null) {
            list = pGPF6hQ_2.KQgRr5e_0(list, str);
        }
        int size = list.size();
        for (int i = 0; i < size; i++) {
            X509Certificate x509Certificate = (X509Certificate) list.get(i);
            int size2 = KQgRr5e_02.size();
            Nm6q_10.FSaI4_7 fSaI4_7 = null;
            Nm6q_10.FSaI4_7 fSaI4_72 = null;
            for (int i2 = 0; i2 < size2; i2++) {
                QxJ9d_1 qxJ9d_1 = KQgRr5e_02.get(i2);
                if (qxJ9d_1.PGPF6hQ_2.equals("sha256/")) {
                    if (fSaI4_7 == null) {
                        fSaI4_7 = QxJ9d_1(x509Certificate);
                    }
                    if (qxJ9d_1.KQgRr5e_0.equals(fSaI4_7)) {
                        return;
                    }
                } else if (qxJ9d_1.PGPF6hQ_2.equals("sha1/")) {
                    if (fSaI4_72 == null) {
                        fSaI4_72 = KQgRr5e_0(x509Certificate);
                    }
                    if (qxJ9d_1.KQgRr5e_0.equals(fSaI4_72)) {
                        return;
                    }
                } else {
                    throw new AssertionError("unsupported hashAlgorithm: " + qxJ9d_1.PGPF6hQ_2);
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate pinning failure!");
        sb.append("\n  Peer certificate chain:");
        int size3 = list.size();
        for (int i3 = 0; i3 < size3; i3++) {
            X509Certificate x509Certificate2 = (X509Certificate) list.get(i3);
            sb.append("\n    ");
            sb.append(KQgRr5e_0((Certificate) x509Certificate2));
            sb.append(": ");
            sb.append(x509Certificate2.getSubjectDN().getName());
        }
        sb.append("\n  Pinned certificates for ");
        sb.append(str);
        sb.append(":");
        int size4 = KQgRr5e_02.size();
        for (int i4 = 0; i4 < size4; i4++) {
            sb.append("\n    ");
            sb.append(KQgRr5e_02.get(i4));
        }
        throw new SSLPeerUnverifiedException(sb.toString());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KNBe_11) {
            KNBe_11 kNBe_11 = (KNBe_11) obj;
            if (defpackage.QxJ9d_1.KQgRr5e_0(this.f1658KQgRr5e_0, kNBe_11.f1658KQgRr5e_0) && this.f1659KQgRr5e_0.equals(kNBe_11.f1659KQgRr5e_0)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (defpackage.KQgRr5e_0.KQgRr5e_0(this.f1658KQgRr5e_0) * 31) + this.f1659KQgRr5e_0.hashCode();
    }

    public List<QxJ9d_1> KQgRr5e_0(String str) {
        List<QxJ9d_1> emptyList = Collections.emptyList();
        for (QxJ9d_1 qxJ9d_1 : this.f1659KQgRr5e_0) {
            if (qxJ9d_1.KQgRr5e_0(str)) {
                if (emptyList.isEmpty()) {
                    emptyList = new ArrayList<>();
                }
                emptyList.add(qxJ9d_1);
            }
        }
        return emptyList;
    }

    public KNBe_11 KQgRr5e_0(@Nullable XnFJ5_9.Ft6VRog_36.WwEq_13.PGPF6hQ_2 pGPF6hQ_2) {
        return defpackage.QxJ9d_1.KQgRr5e_0(this.f1658KQgRr5e_0, pGPF6hQ_2) ? this : new KNBe_11(this.f1659KQgRr5e_0, pGPF6hQ_2);
    }

    public static String KQgRr5e_0(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            return "sha256/" + QxJ9d_1((X509Certificate) certificate).m158KQgRr5e_0();
        }
        throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
    }

    public static Nm6q_10.FSaI4_7 KQgRr5e_0(X509Certificate x509Certificate) {
        return Nm6q_10.FSaI4_7.KQgRr5e_0(x509Certificate.getPublicKey().getEncoded()).m157KQgRr5e_0();
    }
}
