package XnFJ5_9;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
/* compiled from: Handshake.java */
/* loaded from: classes.dex */
public final class H5YG8fq_22 {
    public final EuDEkJe_12 KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final R6WQ_35 f1645KQgRr5e_0;

    /* renamed from: KQgRr5e_0  reason: collision with other field name */
    public final List<Certificate> f1646KQgRr5e_0;
    public final List<Certificate> QxJ9d_1;

    public H5YG8fq_22(R6WQ_35 r6wq_35, EuDEkJe_12 euDEkJe_12, List<Certificate> list, List<Certificate> list2) {
        this.f1645KQgRr5e_0 = r6wq_35;
        this.KQgRr5e_0 = euDEkJe_12;
        this.f1646KQgRr5e_0 = list;
        this.QxJ9d_1 = list2;
    }

    public static H5YG8fq_22 KQgRr5e_0(SSLSession sSLSession) throws IOException {
        Certificate[] certificateArr;
        List emptyList;
        List emptyList2;
        String cipherSuite = sSLSession.getCipherSuite();
        if (cipherSuite != null) {
            if (!"SSL_NULL_WITH_NULL_NULL".equals(cipherSuite)) {
                EuDEkJe_12 KQgRr5e_0 = EuDEkJe_12.KQgRr5e_0(cipherSuite);
                String protocol = sSLSession.getProtocol();
                if (protocol != null) {
                    if (!"NONE".equals(protocol)) {
                        R6WQ_35 KQgRr5e_02 = R6WQ_35.KQgRr5e_0(protocol);
                        try {
                            certificateArr = sSLSession.getPeerCertificates();
                        } catch (SSLPeerUnverifiedException unused) {
                            certificateArr = null;
                        }
                        if (certificateArr != null) {
                            emptyList = XnFJ5_9.Ft6VRog_36.X6FRs_4.KQgRr5e_0(certificateArr);
                        } else {
                            emptyList = Collections.emptyList();
                        }
                        Certificate[] localCertificates = sSLSession.getLocalCertificates();
                        if (localCertificates != null) {
                            emptyList2 = XnFJ5_9.Ft6VRog_36.X6FRs_4.KQgRr5e_0(localCertificates);
                        } else {
                            emptyList2 = Collections.emptyList();
                        }
                        return new H5YG8fq_22(KQgRr5e_02, KQgRr5e_0, emptyList, emptyList2);
                    }
                    throw new IOException("tlsVersion == NONE");
                }
                throw new IllegalStateException("tlsVersion == null");
            }
            throw new IOException("cipherSuite == SSL_NULL_WITH_NULL_NULL");
        }
        throw new IllegalStateException("cipherSuite == null");
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof H5YG8fq_22) {
            H5YG8fq_22 h5YG8fq_22 = (H5YG8fq_22) obj;
            return this.f1645KQgRr5e_0.equals(h5YG8fq_22.f1645KQgRr5e_0) && this.KQgRr5e_0.equals(h5YG8fq_22.KQgRr5e_0) && this.f1646KQgRr5e_0.equals(h5YG8fq_22.f1646KQgRr5e_0) && this.QxJ9d_1.equals(h5YG8fq_22.QxJ9d_1);
        }
        return false;
    }

    public int hashCode() {
        return ((((((527 + this.f1645KQgRr5e_0.hashCode()) * 31) + this.KQgRr5e_0.hashCode()) * 31) + this.f1646KQgRr5e_0.hashCode()) * 31) + this.QxJ9d_1.hashCode();
    }

    public String toString() {
        return "Handshake{tlsVersion=" + this.f1645KQgRr5e_0 + " cipherSuite=" + this.KQgRr5e_0 + " peerCertificates=" + KQgRr5e_0(this.f1646KQgRr5e_0) + " localCertificates=" + KQgRr5e_0(this.QxJ9d_1) + '}';
    }

    public EuDEkJe_12 KQgRr5e_0() {
        return this.KQgRr5e_0;
    }

    /* renamed from: KQgRr5e_0  reason: collision with other method in class */
    public List<Certificate> m758KQgRr5e_0() {
        return this.f1646KQgRr5e_0;
    }

    public final List<String> KQgRr5e_0(List<Certificate> list) {
        ArrayList arrayList = new ArrayList();
        for (Certificate certificate : list) {
            if (certificate instanceof X509Certificate) {
                arrayList.add(String.valueOf(((X509Certificate) certificate).getSubjectDN()));
            } else {
                arrayList.add(certificate.getType());
            }
        }
        return arrayList;
    }
}
