package XnFJ5_9.Ft6VRog_36.WwEq_13;

import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
/* compiled from: BasicTrustRootIndex.java */
/* loaded from: classes.dex */
public final class QxJ9d_1 implements X6FRs_4 {
    public final Map<X500Principal, Set<X509Certificate>> KQgRr5e_0 = new LinkedHashMap();

    public QxJ9d_1(X509Certificate... x509CertificateArr) {
        for (X509Certificate x509Certificate : x509CertificateArr) {
            X500Principal subjectX500Principal = x509Certificate.getSubjectX500Principal();
            Set<X509Certificate> set = this.KQgRr5e_0.get(subjectX500Principal);
            if (set == null) {
                set = new LinkedHashSet<>(1);
                this.KQgRr5e_0.put(subjectX500Principal, set);
            }
            set.add(x509Certificate);
        }
    }

    @Override // XnFJ5_9.Ft6VRog_36.WwEq_13.X6FRs_4
    public X509Certificate KQgRr5e_0(X509Certificate x509Certificate) {
        Set<X509Certificate> set = this.KQgRr5e_0.get(x509Certificate.getIssuerX500Principal());
        if (set == null) {
            return null;
        }
        for (X509Certificate x509Certificate2 : set) {
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
                return x509Certificate2;
            } catch (Exception unused) {
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return (obj instanceof QxJ9d_1) && ((QxJ9d_1) obj).KQgRr5e_0.equals(this.KQgRr5e_0);
    }

    public int hashCode() {
        return this.KQgRr5e_0.hashCode();
    }
}
