package ῲ.ῲ.㴹;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.RectF;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.method.TransformationMethod;
import android.util.Log;
import android.util.TypedValue;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatEditText;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

/* renamed from: ῲ.ῲ.㴹.Ԕ  reason: contains not printable characters */
/* compiled from: AppCompatTextViewAutoSizeHelper */
public class C1991 {

    /* renamed from: Ԕ  reason: contains not printable characters */
    public static ConcurrentHashMap<String, Field> f6754 = new ConcurrentHashMap<>();

    /* renamed from: 㑃  reason: contains not printable characters */
    public static final RectF f6755 = new RectF();

    /* renamed from: 䁗  reason: contains not printable characters */
    public static ConcurrentHashMap<String, Method> f6756 = new ConcurrentHashMap<>();

    /* renamed from: ʬ  reason: contains not printable characters */
    public float f6757 = -1.0f;

    /* renamed from: ඓ  reason: contains not printable characters */
    public float f6758 = -1.0f;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public final C1992 f6759;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final TextView f6760;

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean f6761 = false;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public boolean f6762 = false;

    /* renamed from: K  reason: contains not printable characters */
    public int f6763 = 0;

    /* renamed from: 㳳  reason: contains not printable characters */
    public final Context f6764;

    /* renamed from: 㴹  reason: contains not printable characters */
    public int[] f6765 = new int[0];

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f6766 = -1.0f;

    /* renamed from: 㿎  reason: contains not printable characters */
    public TextPaint f6767;

    /* renamed from: ῲ.ῲ.㴹.Ԕ$ʬ  reason: contains not printable characters */
    /* compiled from: AppCompatTextViewAutoSizeHelper */
    public static class C1992 {
        /* renamed from: K  reason: contains not printable characters */
        public void m5156(StaticLayout.Builder builder, TextView textView) {
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m5157(TextView textView) {
            return ((Boolean) C1991.m5146((Object) textView, "getHorizontallyScrolling", (Object) false)).booleanValue();
        }
    }

    /* renamed from: ῲ.ῲ.㴹.Ԕ$ῲ  reason: contains not printable characters */
    /* compiled from: AppCompatTextViewAutoSizeHelper */
    public static class C1993 extends C1994 {
        @Override // ῲ.ῲ.㴹.C1991.C1992
        /* renamed from: K  reason: contains not printable characters */
        public boolean m5159(TextView textView) {
            return textView.isHorizontallyScrollable();
        }

        @Override // ῲ.ῲ.㴹.C1991.C1994, ῲ.ῲ.㴹.C1991.C1992
        /* renamed from: K  reason: contains not printable characters */
        public void m5158(StaticLayout.Builder builder, TextView textView) {
            builder.setTextDirection(textView.getTextDirectionHeuristic());
        }
    }

    /* renamed from: ῲ.ῲ.㴹.Ԕ$K  reason: contains not printable characters */
    /* compiled from: AppCompatTextViewAutoSizeHelper */
    public static class C1994 extends C1992 {
        @Override // ῲ.ῲ.㴹.C1991.C1992
        /* renamed from: K  reason: contains not printable characters */
        public void m5160(StaticLayout.Builder builder, TextView textView) {
            builder.setTextDirection((TextDirectionHeuristic) C1991.m5146(textView, "getTextDirectionHeuristic", TextDirectionHeuristics.FIRSTSTRONG_LTR));
        }
    }

    public C1991(TextView textView) {
        this.f6760 = textView;
        this.f6764 = this.f6760.getContext();
        int i = Build.VERSION.SDK_INT;
        if (i >= 29) {
            this.f6759 = new C1993();
        } else if (i >= 23) {
            this.f6759 = new C1994();
        } else {
            this.f6759 = new C1992();
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final boolean m5148() {
        int length = this.f6765.length;
        this.f6762 = length > 0;
        if (this.f6762) {
            this.f6763 = 1;
            int[] iArr = this.f6765;
            this.f6766 = (float) iArr[0];
            this.f6758 = (float) iArr[length - 1];
            this.f6757 = -1.0f;
        }
        return this.f6762;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final boolean m5149() {
        if (!m5155() || this.f6763 != 1) {
            this.f6761 = false;
        } else {
            if (!this.f6762 || this.f6765.length == 0) {
                int floor = ((int) Math.floor((double) ((this.f6758 - this.f6766) / this.f6757))) + 1;
                int[] iArr = new int[floor];
                for (int i = 0; i < floor; i++) {
                    iArr[i] = Math.round((((float) i) * this.f6757) + this.f6766);
                }
                this.f6765 = m5154(iArr);
            }
            this.f6761 = true;
        }
        return this.f6761;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int[] m5154(int[] iArr) {
        int length = iArr.length;
        if (length == 0) {
            return iArr;
        }
        Arrays.sort(iArr);
        ArrayList arrayList = new ArrayList();
        for (int i : iArr) {
            if (i > 0 && Collections.binarySearch(arrayList, Integer.valueOf(i)) < 0) {
                arrayList.add(Integer.valueOf(i));
            }
        }
        if (length == arrayList.size()) {
            return iArr;
        }
        int size = arrayList.size();
        int[] iArr2 = new int[size];
        for (int i2 = 0; i2 < size; i2++) {
            iArr2[i2] = ((Integer) arrayList.get(i2)).intValue();
        }
        return iArr2;
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public final boolean m5155() {
        return !(this.f6760 instanceof AppCompatEditText);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m5152(float f, float f2, float f3) throws IllegalArgumentException {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Minimum auto-size text size (" + f + "px) is less or equal to (0px)");
        } else if (f2 <= f) {
            throw new IllegalArgumentException("Maximum auto-size text size (" + f2 + "px) is less or equal to minimum auto-size text size (" + f + "px)");
        } else if (f3 > 0.0f) {
            this.f6763 = 1;
            this.f6766 = f;
            this.f6758 = f2;
            this.f6757 = f3;
            this.f6762 = false;
        } else {
            throw new IllegalArgumentException("The auto-size step granularity (" + f3 + "px) is less or equal to (0px)");
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m5153(int i, float f) {
        Resources resources;
        Context context = this.f6764;
        if (context == null) {
            resources = Resources.getSystem();
        } else {
            resources = context.getResources();
        }
        float applyDimension = TypedValue.applyDimension(i, f, resources.getDisplayMetrics());
        if (applyDimension != this.f6760.getPaint().getTextSize()) {
            this.f6760.getPaint().setTextSize(applyDimension);
            int i2 = Build.VERSION.SDK_INT;
            boolean isInLayout = this.f6760.isInLayout();
            if (this.f6760.getLayout() != null) {
                this.f6761 = false;
                try {
                    Method r0 = m5147("nullLayouts");
                    if (r0 != null) {
                        r0.invoke(this.f6760, new Object[0]);
                    }
                } catch (Exception e) {
                    Log.w("ACTVAutoSizeHelper", "Failed to invoke TextView#nullLayouts() method", e);
                }
                if (!isInLayout) {
                    this.f6760.requestLayout();
                } else {
                    this.f6760.forceLayout();
                }
                this.f6760.invalidate();
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m5150(RectF rectF) {
        StaticLayout staticLayout;
        int i;
        CharSequence transformation;
        int length = this.f6765.length;
        if (length != 0) {
            int i2 = 0;
            int i3 = length - 1;
            int i4 = 1;
            int i5 = 0;
            while (i4 <= i3) {
                int i6 = (i4 + i3) / 2;
                int i7 = this.f6765[i6];
                CharSequence text = this.f6760.getText();
                TransformationMethod transformationMethod = this.f6760.getTransformationMethod();
                if (!(transformationMethod == null || (transformation = transformationMethod.getTransformation(text, this.f6760)) == null)) {
                    text = transformation;
                }
                int i8 = Build.VERSION.SDK_INT;
                int maxLines = this.f6760.getMaxLines();
                TextPaint textPaint = this.f6767;
                if (textPaint == null) {
                    this.f6767 = new TextPaint();
                } else {
                    textPaint.reset();
                }
                this.f6767.set(this.f6760.getPaint());
                this.f6767.setTextSize((float) i7);
                Layout.Alignment alignment = (Layout.Alignment) m5146(this.f6760, "getLayoutAlignment", Layout.Alignment.ALIGN_NORMAL);
                int round = Math.round(rectF.right);
                if (Build.VERSION.SDK_INT >= 23) {
                    StaticLayout.Builder obtain = StaticLayout.Builder.obtain(text, i2, text.length(), this.f6767, round);
                    obtain.setAlignment(alignment).setLineSpacing(this.f6760.getLineSpacingExtra(), this.f6760.getLineSpacingMultiplier()).setIncludePad(this.f6760.getIncludeFontPadding()).setBreakStrategy(this.f6760.getBreakStrategy()).setHyphenationFrequency(this.f6760.getHyphenationFrequency()).setMaxLines(maxLines == -1 ? Integer.MAX_VALUE : maxLines);
                    try {
                        this.f6759.m5156(obtain, this.f6760);
                    } catch (ClassCastException unused) {
                        Log.w("ACTVAutoSizeHelper", "Failed to obtain TextDirectionHeuristic, auto size may be incorrect");
                    }
                    staticLayout = obtain.build();
                    i = -1;
                } else {
                    i = -1;
                    staticLayout = new StaticLayout(text, this.f6767, round, alignment, this.f6760.getLineSpacingMultiplier(), this.f6760.getLineSpacingExtra(), this.f6760.getIncludeFontPadding());
                }
                if ((maxLines == i || (staticLayout.getLineCount() <= maxLines && staticLayout.getLineEnd(staticLayout.getLineCount() - 1) == text.length())) && ((float) staticLayout.getHeight()) <= rectF.bottom) {
                    int i9 = i6 + 1;
                    i5 = i4;
                    i4 = i9;
                } else {
                    i5 = i6 - 1;
                    i3 = i5;
                }
                i2 = 0;
            }
            return this.f6765[i5];
        }
        throw new IllegalStateException("No available text sizes to choose from.");
    }

    /* renamed from: K  reason: contains not printable characters */
    public static <T> T m5146(Object obj, String str, T t) {
        try {
            return (T) m5147(str).invoke(obj, new Object[0]);
        } catch (Exception e) {
            Log.w("ACTVAutoSizeHelper", "Failed to invoke TextView#" + str + "() method", e);
            return t;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static Method m5147(String str) {
        try {
            Method method = f6756.get(str);
            if (method == null && (method = TextView.class.getDeclaredMethod(str, new Class[0])) != null) {
                method.setAccessible(true);
                f6756.put(str, method);
            }
            return method;
        } catch (Exception e) {
            Log.w("ACTVAutoSizeHelper", "Failed to retrieve TextView#" + str + "() method", e);
            return null;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m5151() {
        int i;
        if (m5155() && this.f6763 != 0) {
            if (this.f6761) {
                if (this.f6760.getMeasuredHeight() > 0 && this.f6760.getMeasuredWidth() > 0) {
                    if (this.f6759.m5157(this.f6760)) {
                        i = 1048576;
                    } else {
                        i = (this.f6760.getMeasuredWidth() - this.f6760.getTotalPaddingLeft()) - this.f6760.getTotalPaddingRight();
                    }
                    int height = (this.f6760.getHeight() - this.f6760.getCompoundPaddingBottom()) - this.f6760.getCompoundPaddingTop();
                    if (i > 0 && height > 0) {
                        synchronized (f6755) {
                            f6755.setEmpty();
                            f6755.right = (float) i;
                            f6755.bottom = (float) height;
                            float r0 = (float) m5150(f6755);
                            if (r0 != this.f6760.getTextSize()) {
                                m5153(0, r0);
                            }
                        }
                    } else {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.f6761 = true;
        }
    }
}
