package ῲ.ῲ.ඓ.㳳;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewConfiguration;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import ῲ.ᨨ.ᨨ.AbstractC1743;
import ῲ.ᨨ.ᨨ.C1739;
import ῲ.ᨨ.ῲ.C1806;
import ῲ.ᨨ.㸾.K.AbstractMenuC1864;
import ῲ.ῲ.ඓ.㳳.MenuItemC1904;

/* renamed from: ῲ.ῲ.ඓ.㳳.ⁱ  reason: contains not printable characters */
/* compiled from: MenuBuilder */
public class C1912 implements AbstractMenuC1864 {
    public static final String ACTION_VIEW_STATES_KEY = "android:menu:actionviewstates";
    public static final String EXPANDED_ACTION_VIEW_ID = "android:menu:expandedactionview";
    public static final String PRESENTER_KEY = "android:menu:presenters";
    public static final String TAG = "MenuBuilder";
    public static final int[] sCategoryToOrder = {1, 4, 5, 3, 2, 0};
    public ArrayList<C1922> mActionItems;
    public AbstractC1914 mCallback;
    public final Context mContext;
    public ContextMenu.ContextMenuInfo mCurrentMenuInfo;
    public int mDefaultShowAsAction = 0;
    public C1922 mExpandedItem;
    public boolean mGroupDividerEnabled = false;
    public Drawable mHeaderIcon;
    public CharSequence mHeaderTitle;
    public View mHeaderView;
    public boolean mIsActionItemsStale;
    public boolean mIsClosing = false;
    public boolean mIsVisibleItemsStale;
    public ArrayList<C1922> mItems;
    public boolean mItemsChangedWhileDispatchPrevented = false;
    public ArrayList<C1922> mNonActionItems;
    public boolean mOptionalIconsVisible = false;
    public boolean mOverrideVisibleItems;
    public CopyOnWriteArrayList<WeakReference<AbstractC1897>> mPresenters = new CopyOnWriteArrayList<>();
    public boolean mPreventDispatchingItemsChanged = false;
    public boolean mQwertyMode;
    public final Resources mResources;
    public boolean mShortcutsVisible;
    public boolean mStructureChangedWhileDispatchPrevented = false;
    public ArrayList<C1922> mTempShortcutItemList = new ArrayList<>();
    public ArrayList<C1922> mVisibleItems;

    /* renamed from: ῲ.ῲ.ඓ.㳳.ⁱ$ῲ  reason: contains not printable characters */
    /* compiled from: MenuBuilder */
    public interface AbstractC1913 {
        /* renamed from: K  reason: contains not printable characters */
        boolean m4935(C1922 v);
    }

    /* renamed from: ῲ.ῲ.ඓ.㳳.ⁱ$K  reason: contains not printable characters */
    /* compiled from: MenuBuilder */
    public interface AbstractC1914 {
        boolean onMenuItemSelected(C1912 v, MenuItem menuItem);

        void onMenuModeChange(C1912 v);
    }

    public C1912(Context context) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mItems = new ArrayList<>();
        this.mVisibleItems = new ArrayList<>();
        this.mIsVisibleItemsStale = true;
        this.mActionItems = new ArrayList<>();
        this.mNonActionItems = new ArrayList<>();
        this.mIsActionItemsStale = true;
        setShortcutsVisibleInner(true);
    }

    private C1922 createNewMenuItem(int i, int i2, int i3, int i4, CharSequence charSequence, int i5) {
        return new C1922(this, i, i2, i3, i4, charSequence, i5);
    }

    private void dispatchPresenterUpdate(boolean z) {
        if (!this.mPresenters.isEmpty()) {
            stopDispatchingItemsChanged();
            Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
            while (it2.hasNext()) {
                WeakReference<AbstractC1897> next = it2.next();
                AbstractC1897 r2 = next.get();
                if (r2 == null) {
                    this.mPresenters.remove(next);
                } else {
                    r2.updateMenuView(z);
                }
            }
            startDispatchingItemsChanged();
        }
    }

    private void dispatchRestoreInstanceState(Bundle bundle) {
        Parcelable parcelable;
        SparseArray sparseParcelableArray = bundle.getSparseParcelableArray(PRESENTER_KEY);
        if (sparseParcelableArray != null && !this.mPresenters.isEmpty()) {
            Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
            while (it2.hasNext()) {
                WeakReference<AbstractC1897> next = it2.next();
                AbstractC1897 r2 = next.get();
                if (r2 == null) {
                    this.mPresenters.remove(next);
                } else {
                    int id = r2.getId();
                    if (id > 0 && (parcelable = (Parcelable) sparseParcelableArray.get(id)) != null) {
                        r2.onRestoreInstanceState(parcelable);
                    }
                }
            }
        }
    }

    private void dispatchSaveInstanceState(Bundle bundle) {
        Parcelable onSaveInstanceState;
        if (!this.mPresenters.isEmpty()) {
            SparseArray<? extends Parcelable> sparseArray = new SparseArray<>();
            Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
            while (it2.hasNext()) {
                WeakReference<AbstractC1897> next = it2.next();
                AbstractC1897 r3 = next.get();
                if (r3 == null) {
                    this.mPresenters.remove(next);
                } else {
                    int id = r3.getId();
                    if (id > 0 && (onSaveInstanceState = r3.onSaveInstanceState()) != null) {
                        sparseArray.put(id, onSaveInstanceState);
                    }
                }
            }
            bundle.putSparseParcelableArray(PRESENTER_KEY, sparseArray);
        }
    }

    private boolean dispatchSubMenuSelected(SubMenuC1900 r4, AbstractC1897 r5) {
        boolean z = false;
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        if (r5 != null) {
            z = r5.onSubMenuSelected(r4);
        }
        Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
        while (it2.hasNext()) {
            WeakReference<AbstractC1897> next = it2.next();
            AbstractC1897 r2 = next.get();
            if (r2 == null) {
                this.mPresenters.remove(next);
            } else if (!z) {
                z = r2.onSubMenuSelected(r4);
            }
        }
        return z;
    }

    public static int findInsertIndex(ArrayList<C1922> arrayList, int i) {
        for (int size = arrayList.size() - 1; size >= 0; size--) {
            if (arrayList.get(size).f6540 <= i) {
                return size + 1;
            }
        }
        return 0;
    }

    public static int getOrdering(int i) {
        int i2 = (-65536 & i) >> 16;
        if (i2 >= 0) {
            int[] iArr = sCategoryToOrder;
            if (i2 < iArr.length) {
                return (i & 65535) | (iArr[i2] << 16);
            }
        }
        throw new IllegalArgumentException("order does not contain a valid category.");
    }

    private void removeItemAtInt(int i, boolean z) {
        if (i >= 0 && i < this.mItems.size()) {
            this.mItems.remove(i);
            if (z) {
                onItemsChanged(true);
            }
        }
    }

    private void setHeaderInternal(int i, CharSequence charSequence, int i2, Drawable drawable, View view) {
        Resources resources = getResources();
        if (view != null) {
            this.mHeaderView = view;
            this.mHeaderTitle = null;
            this.mHeaderIcon = null;
        } else {
            if (i > 0) {
                this.mHeaderTitle = resources.getText(i);
            } else if (charSequence != null) {
                this.mHeaderTitle = charSequence;
            }
            if (i2 > 0) {
                this.mHeaderIcon = C1806.m4683(getContext(), i2);
            } else if (drawable != null) {
                this.mHeaderIcon = drawable;
            }
            this.mHeaderView = null;
        }
        onItemsChanged(false);
    }

    private void setShortcutsVisibleInner(boolean z) {
        boolean z2 = true;
        if (!z || this.mResources.getConfiguration().keyboard == 1 || !C1739.m4536(ViewConfiguration.get(this.mContext), this.mContext)) {
            z2 = false;
        }
        this.mShortcutsVisible = z2;
    }

    @Override // android.view.Menu
    public MenuItem add(CharSequence charSequence) {
        return addInternal(0, 0, 0, charSequence);
    }

    public int addIntentOptions(int i, int i2, int i3, ComponentName componentName, Intent[] intentArr, Intent intent, int i4, MenuItem[] menuItemArr) {
        int i5;
        PackageManager packageManager = this.mContext.getPackageManager();
        List<ResolveInfo> queryIntentActivityOptions = packageManager.queryIntentActivityOptions(componentName, intentArr, intent, 0);
        int size = queryIntentActivityOptions != null ? queryIntentActivityOptions.size() : 0;
        if ((i4 & 1) == 0) {
            removeGroup(i);
        }
        for (int i6 = 0; i6 < size; i6++) {
            ResolveInfo resolveInfo = queryIntentActivityOptions.get(i6);
            int i7 = resolveInfo.specificIndex;
            Intent intent2 = new Intent(i7 < 0 ? intent : intentArr[i7]);
            intent2.setComponent(new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name));
            MenuItem intent3 = add(i, i2, i3, resolveInfo.loadLabel(packageManager)).setIcon(resolveInfo.loadIcon(packageManager)).setIntent(intent2);
            if (menuItemArr != null && (i5 = resolveInfo.specificIndex) >= 0) {
                menuItemArr[i5] = intent3;
            }
        }
        return size;
    }

    public MenuItem addInternal(int i, int i2, int i3, CharSequence charSequence) {
        int ordering = getOrdering(i3);
        C1922 createNewMenuItem = createNewMenuItem(i, i2, i3, ordering, charSequence, this.mDefaultShowAsAction);
        ContextMenu.ContextMenuInfo contextMenuInfo = this.mCurrentMenuInfo;
        if (contextMenuInfo != null) {
            createNewMenuItem.f6520 = contextMenuInfo;
        }
        ArrayList<C1922> arrayList = this.mItems;
        arrayList.add(findInsertIndex(arrayList, ordering), createNewMenuItem);
        onItemsChanged(true);
        return createNewMenuItem;
    }

    public void addMenuPresenter(AbstractC1897 r2) {
        addMenuPresenter(r2, this.mContext);
    }

    @Override // android.view.Menu
    public SubMenu addSubMenu(CharSequence charSequence) {
        return addSubMenu(0, 0, 0, charSequence);
    }

    public void changeMenuMode() {
        AbstractC1914 k = this.mCallback;
        if (k != null) {
            k.onMenuModeChange(this);
        }
    }

    public void clear() {
        C1922 r0 = this.mExpandedItem;
        if (r0 != null) {
            collapseItemActionView(r0);
        }
        this.mItems.clear();
        onItemsChanged(true);
    }

    public void clearAll() {
        this.mPreventDispatchingItemsChanged = true;
        clear();
        clearHeader();
        this.mPresenters.clear();
        this.mPreventDispatchingItemsChanged = false;
        this.mItemsChangedWhileDispatchPrevented = false;
        this.mStructureChangedWhileDispatchPrevented = false;
        onItemsChanged(true);
    }

    public void clearHeader() {
        this.mHeaderIcon = null;
        this.mHeaderTitle = null;
        this.mHeaderView = null;
        onItemsChanged(false);
    }

    public final void close(boolean z) {
        if (!this.mIsClosing) {
            this.mIsClosing = true;
            Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
            while (it2.hasNext()) {
                WeakReference<AbstractC1897> next = it2.next();
                AbstractC1897 r2 = next.get();
                if (r2 == null) {
                    this.mPresenters.remove(next);
                } else {
                    r2.onCloseMenu(this, z);
                }
            }
            this.mIsClosing = false;
        }
    }

    public boolean collapseItemActionView(C1922 r5) {
        boolean z = false;
        if (!this.mPresenters.isEmpty() && this.mExpandedItem == r5) {
            stopDispatchingItemsChanged();
            Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
            while (it2.hasNext()) {
                WeakReference<AbstractC1897> next = it2.next();
                AbstractC1897 r3 = next.get();
                if (r3 == null) {
                    this.mPresenters.remove(next);
                } else {
                    z = r3.collapseItemActionView(this, r5);
                    if (z) {
                        break;
                    }
                }
            }
            startDispatchingItemsChanged();
            if (z) {
                this.mExpandedItem = null;
            }
        }
        return z;
    }

    public boolean dispatchMenuItemSelected(C1912 r2, MenuItem menuItem) {
        AbstractC1914 k = this.mCallback;
        return k != null && k.onMenuItemSelected(r2, menuItem);
    }

    public boolean expandItemActionView(C1922 r5) {
        boolean z = false;
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        stopDispatchingItemsChanged();
        Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
        while (it2.hasNext()) {
            WeakReference<AbstractC1897> next = it2.next();
            AbstractC1897 r3 = next.get();
            if (r3 == null) {
                this.mPresenters.remove(next);
            } else {
                z = r3.expandItemActionView(this, r5);
                if (z) {
                    break;
                }
            }
        }
        startDispatchingItemsChanged();
        if (z) {
            this.mExpandedItem = r5;
        }
        return z;
    }

    public int findGroupIndex(int i) {
        return findGroupIndex(i, 0);
    }

    public MenuItem findItem(int i) {
        MenuItem findItem;
        int size = size();
        for (int i2 = 0; i2 < size; i2++) {
            C1922 r2 = this.mItems.get(i2);
            if (r2.f6529 == i) {
                return r2;
            }
            if (r2.hasSubMenu() && (findItem = r2.f6533.findItem(i)) != null) {
                return findItem;
            }
        }
        return null;
    }

    public int findItemIndex(int i) {
        int size = size();
        for (int i2 = 0; i2 < size; i2++) {
            if (this.mItems.get(i2).f6529 == i) {
                return i2;
            }
        }
        return -1;
    }

    public C1922 findItemWithShortcutForKey(int i, KeyEvent keyEvent) {
        char c;
        ArrayList<C1922> arrayList = this.mTempShortcutItemList;
        arrayList.clear();
        findItemsWithShortcutForKey(arrayList, i, keyEvent);
        if (arrayList.isEmpty()) {
            return null;
        }
        int metaState = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        keyEvent.getKeyData(keyData);
        int size = arrayList.size();
        if (size == 1) {
            return arrayList.get(0);
        }
        boolean isQwertyMode = isQwertyMode();
        for (int i2 = 0; i2 < size; i2++) {
            C1922 r7 = arrayList.get(i2);
            if (isQwertyMode) {
                c = r7.f6536;
            } else {
                c = r7.f6541;
            }
            if ((c == keyData.meta[0] && (metaState & 2) == 0) || ((c == keyData.meta[2] && (metaState & 2) != 0) || (isQwertyMode && c == '\b' && i == 67))) {
                return r7;
            }
        }
        return null;
    }

    public void findItemsWithShortcutForKey(List<C1922> list, int i, KeyEvent keyEvent) {
        char c;
        int i2;
        boolean isQwertyMode = isQwertyMode();
        int modifiers = keyEvent.getModifiers();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        if (keyEvent.getKeyData(keyData) || i == 67) {
            int size = this.mItems.size();
            for (int i3 = 0; i3 < size; i3++) {
                C1922 r7 = this.mItems.get(i3);
                if (r7.hasSubMenu()) {
                    r7.f6533.findItemsWithShortcutForKey(list, i, keyEvent);
                }
                if (isQwertyMode) {
                    c = r7.f6536;
                } else {
                    c = r7.f6541;
                }
                if (isQwertyMode) {
                    i2 = r7.f6524;
                } else {
                    i2 = r7.f6526;
                }
                if (((modifiers & 69647) == (i2 & 69647)) && c != 0) {
                    char[] cArr = keyData.meta;
                    if ((c == cArr[0] || c == cArr[2] || (isQwertyMode && c == '\b' && i == 67)) && r7.isEnabled()) {
                        list.add(r7);
                    }
                }
            }
        }
    }

    public void flagActionItems() {
        ArrayList<C1922> visibleItems = getVisibleItems();
        if (this.mIsActionItemsStale) {
            Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
            boolean z = false;
            while (it2.hasNext()) {
                WeakReference<AbstractC1897> next = it2.next();
                AbstractC1897 r5 = next.get();
                if (r5 == null) {
                    this.mPresenters.remove(next);
                } else {
                    z |= r5.flagActionItems();
                }
            }
            if (z) {
                this.mActionItems.clear();
                this.mNonActionItems.clear();
                int size = visibleItems.size();
                for (int i = 0; i < size; i++) {
                    C1922 r4 = visibleItems.get(i);
                    if (r4.m4973()) {
                        this.mActionItems.add(r4);
                    } else {
                        this.mNonActionItems.add(r4);
                    }
                }
            } else {
                this.mActionItems.clear();
                this.mNonActionItems.clear();
                this.mNonActionItems.addAll(getVisibleItems());
            }
            this.mIsActionItemsStale = false;
        }
    }

    public ArrayList<C1922> getActionItems() {
        flagActionItems();
        return this.mActionItems;
    }

    public String getActionViewStatesKey() {
        return ACTION_VIEW_STATES_KEY;
    }

    public Context getContext() {
        return this.mContext;
    }

    public C1922 getExpandedItem() {
        return this.mExpandedItem;
    }

    public Drawable getHeaderIcon() {
        return this.mHeaderIcon;
    }

    public CharSequence getHeaderTitle() {
        return this.mHeaderTitle;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    public MenuItem getItem(int i) {
        return this.mItems.get(i);
    }

    public ArrayList<C1922> getNonActionItems() {
        flagActionItems();
        return this.mNonActionItems;
    }

    public boolean getOptionalIconsVisible() {
        return this.mOptionalIconsVisible;
    }

    public Resources getResources() {
        return this.mResources;
    }

    public C1912 getRootMenu() {
        return this;
    }

    public ArrayList<C1922> getVisibleItems() {
        if (!this.mIsVisibleItemsStale) {
            return this.mVisibleItems;
        }
        this.mVisibleItems.clear();
        int size = this.mItems.size();
        for (int i = 0; i < size; i++) {
            C1922 r3 = this.mItems.get(i);
            if (r3.isVisible()) {
                this.mVisibleItems.add(r3);
            }
        }
        this.mIsVisibleItemsStale = false;
        this.mIsActionItemsStale = true;
        return this.mVisibleItems;
    }

    public boolean hasVisibleItems() {
        if (this.mOverrideVisibleItems) {
            return true;
        }
        int size = size();
        for (int i = 0; i < size; i++) {
            if (this.mItems.get(i).isVisible()) {
                return true;
            }
        }
        return false;
    }

    public boolean isGroupDividerEnabled() {
        return this.mGroupDividerEnabled;
    }

    public boolean isQwertyMode() {
        return this.mQwertyMode;
    }

    public boolean isShortcutKey(int i, KeyEvent keyEvent) {
        return findItemWithShortcutForKey(i, keyEvent) != null;
    }

    public boolean isShortcutsVisible() {
        return this.mShortcutsVisible;
    }

    public void onItemActionRequestChanged(C1922 r1) {
        this.mIsActionItemsStale = true;
        onItemsChanged(true);
    }

    public void onItemVisibleChanged(C1922 r1) {
        this.mIsVisibleItemsStale = true;
        onItemsChanged(true);
    }

    public void onItemsChanged(boolean z) {
        if (!this.mPreventDispatchingItemsChanged) {
            if (z) {
                this.mIsVisibleItemsStale = true;
                this.mIsActionItemsStale = true;
            }
            dispatchPresenterUpdate(z);
            return;
        }
        this.mItemsChangedWhileDispatchPrevented = true;
        if (z) {
            this.mStructureChangedWhileDispatchPrevented = true;
        }
    }

    public boolean performIdentifierAction(int i, int i2) {
        return performItemAction(findItem(i), i2);
    }

    public boolean performItemAction(MenuItem menuItem, int i) {
        return performItemAction(menuItem, null, i);
    }

    public boolean performShortcut(int i, KeyEvent keyEvent, int i2) {
        C1922 findItemWithShortcutForKey = findItemWithShortcutForKey(i, keyEvent);
        boolean performItemAction = findItemWithShortcutForKey != null ? performItemAction(findItemWithShortcutForKey, i2) : false;
        if ((i2 & 2) != 0) {
            close(true);
        }
        return performItemAction;
    }

    public void removeGroup(int i) {
        int findGroupIndex = findGroupIndex(i);
        if (findGroupIndex >= 0) {
            int size = this.mItems.size() - findGroupIndex;
            int i2 = 0;
            while (true) {
                int i3 = i2 + 1;
                if (i2 >= size || this.mItems.get(findGroupIndex).f6527 != i) {
                    onItemsChanged(true);
                } else {
                    removeItemAtInt(findGroupIndex, false);
                    i2 = i3;
                }
            }
            onItemsChanged(true);
        }
    }

    public void removeItem(int i) {
        removeItemAtInt(findItemIndex(i), true);
    }

    public void removeItemAt(int i) {
        removeItemAtInt(i, true);
    }

    public void removeMenuPresenter(AbstractC1897 r4) {
        Iterator<WeakReference<AbstractC1897>> it2 = this.mPresenters.iterator();
        while (it2.hasNext()) {
            WeakReference<AbstractC1897> next = it2.next();
            AbstractC1897 r2 = next.get();
            if (r2 == null || r2 == r4) {
                this.mPresenters.remove(next);
            }
        }
    }

    public void restoreActionViewStates(Bundle bundle) {
        MenuItem findItem;
        if (bundle != null) {
            SparseArray<Parcelable> sparseParcelableArray = bundle.getSparseParcelableArray(getActionViewStatesKey());
            int size = size();
            for (int i = 0; i < size; i++) {
                MenuItem item = getItem(i);
                View actionView = item.getActionView();
                if (!(actionView == null || actionView.getId() == -1)) {
                    actionView.restoreHierarchyState(sparseParcelableArray);
                }
                if (item.hasSubMenu()) {
                    ((SubMenuC1900) item.getSubMenu()).restoreActionViewStates(bundle);
                }
            }
            int i2 = bundle.getInt(EXPANDED_ACTION_VIEW_ID);
            if (i2 > 0 && (findItem = findItem(i2)) != null) {
                findItem.expandActionView();
            }
        }
    }

    public void restorePresenterStates(Bundle bundle) {
        dispatchRestoreInstanceState(bundle);
    }

    public void saveActionViewStates(Bundle bundle) {
        int size = size();
        SparseArray<? extends Parcelable> sparseArray = null;
        for (int i = 0; i < size; i++) {
            MenuItem item = getItem(i);
            View actionView = item.getActionView();
            if (!(actionView == null || actionView.getId() == -1)) {
                if (sparseArray == null) {
                    sparseArray = new SparseArray<>();
                }
                actionView.saveHierarchyState(sparseArray);
                if (item.isActionViewExpanded()) {
                    bundle.putInt(EXPANDED_ACTION_VIEW_ID, item.getItemId());
                }
            }
            if (item.hasSubMenu()) {
                ((SubMenuC1900) item.getSubMenu()).saveActionViewStates(bundle);
            }
        }
        if (sparseArray != null) {
            bundle.putSparseParcelableArray(getActionViewStatesKey(), sparseArray);
        }
    }

    public void savePresenterStates(Bundle bundle) {
        dispatchSaveInstanceState(bundle);
    }

    public void setCallback(AbstractC1914 k) {
        this.mCallback = k;
    }

    public void setCurrentMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mCurrentMenuInfo = contextMenuInfo;
    }

    public C1912 setDefaultShowAsAction(int i) {
        this.mDefaultShowAsAction = i;
        return this;
    }

    public void setExclusiveItemChecked(MenuItem menuItem) {
        int groupId = menuItem.getGroupId();
        int size = this.mItems.size();
        stopDispatchingItemsChanged();
        for (int i = 0; i < size; i++) {
            C1922 r4 = this.mItems.get(i);
            if (r4.f6527 == groupId && r4.m4965() && r4.isCheckable()) {
                r4.m4971(r4 == menuItem);
            }
        }
        startDispatchingItemsChanged();
    }

    public void setGroupCheckable(int i, boolean z, boolean z2) {
        int size = this.mItems.size();
        for (int i2 = 0; i2 < size; i2++) {
            C1922 r2 = this.mItems.get(i2);
            if (r2.f6527 == i) {
                r2.m4967(z2);
                r2.setCheckable(z);
            }
        }
    }

    public void setGroupDividerEnabled(boolean z) {
        this.mGroupDividerEnabled = z;
    }

    public void setGroupEnabled(int i, boolean z) {
        int size = this.mItems.size();
        for (int i2 = 0; i2 < size; i2++) {
            C1922 r2 = this.mItems.get(i2);
            if (r2.f6527 == i) {
                r2.setEnabled(z);
            }
        }
    }

    public void setGroupVisible(int i, boolean z) {
        int size = this.mItems.size();
        boolean z2 = false;
        for (int i2 = 0; i2 < size; i2++) {
            C1922 r4 = this.mItems.get(i2);
            if (r4.f6527 == i && r4.m4974(z)) {
                z2 = true;
            }
        }
        if (z2) {
            onItemsChanged(true);
        }
    }

    public C1912 setHeaderIconInt(Drawable drawable) {
        setHeaderInternal(0, null, 0, drawable, null);
        return this;
    }

    public C1912 setHeaderTitleInt(CharSequence charSequence) {
        setHeaderInternal(0, charSequence, 0, null, null);
        return this;
    }

    public C1912 setHeaderViewInt(View view) {
        setHeaderInternal(0, null, 0, null, view);
        return this;
    }

    public void setOptionalIconsVisible(boolean z) {
        this.mOptionalIconsVisible = z;
    }

    public void setOverrideVisibleItems(boolean z) {
        this.mOverrideVisibleItems = z;
    }

    public void setQwertyMode(boolean z) {
        this.mQwertyMode = z;
        onItemsChanged(false);
    }

    public void setShortcutsVisible(boolean z) {
        if (this.mShortcutsVisible != z) {
            setShortcutsVisibleInner(z);
            onItemsChanged(false);
        }
    }

    public int size() {
        return this.mItems.size();
    }

    public void startDispatchingItemsChanged() {
        this.mPreventDispatchingItemsChanged = false;
        if (this.mItemsChangedWhileDispatchPrevented) {
            this.mItemsChangedWhileDispatchPrevented = false;
            onItemsChanged(this.mStructureChangedWhileDispatchPrevented);
        }
    }

    public void stopDispatchingItemsChanged() {
        if (!this.mPreventDispatchingItemsChanged) {
            this.mPreventDispatchingItemsChanged = true;
            this.mItemsChangedWhileDispatchPrevented = false;
            this.mStructureChangedWhileDispatchPrevented = false;
        }
    }

    @Override // android.view.Menu
    public MenuItem add(int i) {
        return addInternal(0, 0, 0, this.mResources.getString(i));
    }

    public void addMenuPresenter(AbstractC1897 r3, Context context) {
        this.mPresenters.add(new WeakReference<>(r3));
        r3.initForMenu(context, this);
        this.mIsActionItemsStale = true;
    }

    @Override // android.view.Menu
    public SubMenu addSubMenu(int i) {
        return addSubMenu(0, 0, 0, this.mResources.getString(i));
    }

    public int findGroupIndex(int i, int i2) {
        int size = size();
        if (i2 < 0) {
            i2 = 0;
        }
        while (i2 < size) {
            if (this.mItems.get(i2).f6527 == i) {
                return i2;
            }
            i2++;
        }
        return -1;
    }

    /* JADX WARNING: Removed duplicated region for block: B:33:0x006b  */
    /* JADX WARNING: Removed duplicated region for block: B:36:0x0076  */
    public boolean performItemAction(MenuItem menuItem, AbstractC1897 r8, int i) {
        boolean z;
        C1922 r7 = (C1922) menuItem;
        if (r7 == null || !r7.isEnabled()) {
            return false;
        }
        MenuItem.OnMenuItemClickListener onMenuItemClickListener = r7.f6523;
        if (onMenuItemClickListener == null || !onMenuItemClickListener.onMenuItemClick(r7)) {
            C1912 r1 = r7.f6515;
            if (!r1.dispatchMenuItemSelected(r1, r7)) {
                Runnable runnable = r7.f6517;
                if (runnable != null) {
                    runnable.run();
                } else {
                    if (r7.f6528 != null) {
                        try {
                            r7.f6515.getContext().startActivity(r7.f6528);
                        } catch (ActivityNotFoundException e) {
                            Log.e("MenuItemImpl", "Can't find activity to handle intent; ignoring", e);
                        }
                    }
                    AbstractC1743 r12 = r7.f6535;
                    if (r12 == null || !((MenuItemC1904.C1908) r12).f6458.onPerformDefaultAction()) {
                        z = false;
                        AbstractC1743 r3 = r7.f6535;
                        boolean z2 = r3 == null && ((MenuItemC1904.C1908) r3).f6458.hasSubMenu();
                        if (!r7.m4964()) {
                            z |= r7.expandActionView();
                            if (z) {
                                close(true);
                            }
                        } else if (r7.hasSubMenu() || z2) {
                            if ((i & 4) == 0) {
                                close(false);
                            }
                            if (!r7.hasSubMenu()) {
                                SubMenuC1900 r9 = new SubMenuC1900(getContext(), this, r7);
                                r7.f6533 = r9;
                                r9.setHeaderTitle(r7.f6519);
                            }
                            SubMenuC1900 r72 = r7.f6533;
                            if (z2) {
                                MenuItemC1904.C1908 k = (MenuItemC1904.C1908) r3;
                                k.f6458.onPrepareSubMenu(MenuItemC1904.this.m4921(r72));
                            }
                            z |= dispatchSubMenuSelected(r72, r8);
                            if (!z) {
                                close(true);
                            }
                        } else if ((i & 1) == 0) {
                            close(true);
                        }
                        return z;
                    }
                }
            }
        }
        z = true;
        AbstractC1743 r32 = r7.f6535;
        if (r32 == null) {
        }
        if (!r7.m4964()) {
        }
        return z;
    }

    public C1912 setHeaderIconInt(int i) {
        setHeaderInternal(0, null, i, null, null);
        return this;
    }

    public C1912 setHeaderTitleInt(int i) {
        setHeaderInternal(i, null, 0, null, null);
        return this;
    }

    @Override // android.view.Menu
    public MenuItem add(int i, int i2, int i3, CharSequence charSequence) {
        return addInternal(i, i2, i3, charSequence);
    }

    @Override // android.view.Menu
    public SubMenu addSubMenu(int i, int i2, int i3, CharSequence charSequence) {
        C1922 r1 = (C1922) addInternal(i, i2, i3, charSequence);
        SubMenuC1900 r2 = new SubMenuC1900(this.mContext, this, r1);
        r1.f6533 = r2;
        r2.setHeaderTitle(r1.f6519);
        return r2;
    }

    @Override // android.view.Menu
    public MenuItem add(int i, int i2, int i3, int i4) {
        return addInternal(i, i2, i3, this.mResources.getString(i4));
    }

    @Override // android.view.Menu
    public SubMenu addSubMenu(int i, int i2, int i3, int i4) {
        return addSubMenu(i, i2, i3, this.mResources.getString(i4));
    }

    public void close() {
        close(true);
    }
}
