package ῲ.ᕣ.K;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.internal.NativeProtocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1747;
import ῲ.ᨨ.ᨨ.䃖.C1778;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ᨨ.㳳.C1841;
import ῲ.㴹.C2276;

/* renamed from: ῲ.ᕣ.K.K  reason: contains not printable characters */
/* compiled from: ExploreByTouchHelper */
public abstract class AbstractC1703 extends C1747 {
    public static final String DEFAULT_CLASS_NAME = "android.view.View";
    public static final int HOST_ID = -1;
    public static final int INVALID_ID = Integer.MIN_VALUE;
    public static final Rect INVALID_PARENT_BOUNDS = new Rect(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    public static final AbstractC1702<C1782> NODE_ADAPTER = new C1706();
    public static final AbstractC1697<C2276<C1782>, C1782> SPARSE_VALUES_ADAPTER = new C1705();
    public int mAccessibilityFocusedVirtualViewId = Integer.MIN_VALUE;
    public final View mHost;
    public int mHoveredVirtualViewId = Integer.MIN_VALUE;
    public int mKeyboardFocusedVirtualViewId = Integer.MIN_VALUE;
    public final AccessibilityManager mManager;
    public C1704 mNodeProvider;
    public final int[] mTempGlobalRect = new int[2];
    public final Rect mTempParentRect = new Rect();
    public final Rect mTempScreenRect = new Rect();
    public final Rect mTempVisibleRect = new Rect();

    /* renamed from: ῲ.ᕣ.K.K$K  reason: contains not printable characters */
    /* compiled from: ExploreByTouchHelper */
    public static class C1706 implements AbstractC1702<C1782> {
        /* renamed from: K  reason: contains not printable characters */
        public void m4377(Object obj, Rect rect) {
            ((C1782) obj).f6124.getBoundsInParent(rect);
        }
    }

    public AbstractC1703(View view) {
        if (view != null) {
            this.mHost = view;
            this.mManager = (AccessibilityManager) view.getContext().getSystemService("accessibility");
            view.setFocusable(true);
            if (C1729.m4454(view) == 0) {
                int i = Build.VERSION.SDK_INT;
                view.setImportantForAccessibility(1);
                return;
            }
            return;
        }
        throw new IllegalArgumentException("View may not be null");
    }

    private boolean clearAccessibilityFocus(int i) {
        if (this.mAccessibilityFocusedVirtualViewId != i) {
            return false;
        }
        this.mAccessibilityFocusedVirtualViewId = Integer.MIN_VALUE;
        this.mHost.invalidate();
        sendEventForVirtualView(i, NativeProtocol.MESSAGE_GET_ACCESS_TOKEN_REQUEST);
        return true;
    }

    private boolean clickKeyboardFocusedVirtualView() {
        int i = this.mKeyboardFocusedVirtualViewId;
        return i != Integer.MIN_VALUE && onPerformActionForVirtualView(i, 16, null);
    }

    private AccessibilityEvent createEvent(int i, int i2) {
        if (i != -1) {
            return createEventForChild(i, i2);
        }
        return createEventForHost(i2);
    }

    private AccessibilityEvent createEventForChild(int i, int i2) {
        AccessibilityEvent obtain = AccessibilityEvent.obtain(i2);
        C1782 obtainAccessibilityNodeInfo = obtainAccessibilityNodeInfo(i);
        obtain.getText().add(obtainAccessibilityNodeInfo.m4669());
        obtain.setContentDescription(obtainAccessibilityNodeInfo.m4647());
        obtain.setScrollable(obtainAccessibilityNodeInfo.f6124.isScrollable());
        obtain.setPassword(obtainAccessibilityNodeInfo.f6124.isPassword());
        obtain.setEnabled(obtainAccessibilityNodeInfo.m4671());
        obtain.setChecked(obtainAccessibilityNodeInfo.f6124.isChecked());
        onPopulateEventForVirtualView(i, obtain);
        if (!obtain.getText().isEmpty() || obtain.getContentDescription() != null) {
            obtain.setClassName(obtainAccessibilityNodeInfo.m4652());
            View view = this.mHost;
            int i3 = Build.VERSION.SDK_INT;
            obtain.setSource(view, i);
            obtain.setPackageName(this.mHost.getContext().getPackageName());
            return obtain;
        }
        throw new RuntimeException("Callbacks must add text or a content description in populateEventForVirtualViewId()");
    }

    private AccessibilityEvent createEventForHost(int i) {
        AccessibilityEvent obtain = AccessibilityEvent.obtain(i);
        this.mHost.onInitializeAccessibilityEvent(obtain);
        return obtain;
    }

    private C1782 createNodeForChild(int i) {
        C1782 r1 = new C1782(AccessibilityNodeInfo.obtain());
        r1.f6124.setEnabled(true);
        r1.f6124.setFocusable(true);
        r1.f6124.setClassName("android.view.View");
        r1.f6124.setBoundsInParent(INVALID_PARENT_BOUNDS);
        r1.f6124.setBoundsInScreen(INVALID_PARENT_BOUNDS);
        r1.m4653(this.mHost);
        onPopulateNodeForVirtualView(i, r1);
        if (r1.m4669() == null && r1.m4647() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateNodeForVirtualViewId()");
        }
        r1.f6124.getBoundsInParent(this.mTempParentRect);
        if (!this.mTempParentRect.equals(INVALID_PARENT_BOUNDS)) {
            int r0 = r1.m4658();
            if ((r0 & 64) != 0) {
                throw new RuntimeException("Callbacks must not add ACTION_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
            } else if ((r0 & 128) == 0) {
                r1.f6124.setPackageName(this.mHost.getContext().getPackageName());
                View view = this.mHost;
                r1.f6122 = i;
                int i2 = Build.VERSION.SDK_INT;
                r1.f6124.setSource(view, i);
                if (this.mAccessibilityFocusedVirtualViewId == i) {
                    r1.m4665(true);
                    r1.f6124.addAction(128);
                } else {
                    r1.m4665(false);
                    r1.f6124.addAction(64);
                }
                boolean z = this.mKeyboardFocusedVirtualViewId == i;
                if (z) {
                    r1.f6124.addAction(2);
                } else if (r1.m4651()) {
                    r1.f6124.addAction(1);
                }
                r1.f6124.setFocused(z);
                this.mHost.getLocationOnScreen(this.mTempGlobalRect);
                r1.f6124.getBoundsInScreen(this.mTempScreenRect);
                if (this.mTempScreenRect.equals(INVALID_PARENT_BOUNDS)) {
                    r1.f6124.getBoundsInParent(this.mTempScreenRect);
                    if (r1.f6123 != -1) {
                        C1782 r3 = new C1782(AccessibilityNodeInfo.obtain());
                        for (int i3 = r1.f6123; i3 != -1; i3 = r3.f6123) {
                            View view2 = this.mHost;
                            r3.f6123 = -1;
                            int i4 = Build.VERSION.SDK_INT;
                            r3.f6124.setParent(view2, -1);
                            r3.f6124.setBoundsInParent(INVALID_PARENT_BOUNDS);
                            onPopulateNodeForVirtualView(i3, r3);
                            r3.f6124.getBoundsInParent(this.mTempParentRect);
                            Rect rect = this.mTempScreenRect;
                            Rect rect2 = this.mTempParentRect;
                            rect.offset(rect2.left, rect2.top);
                        }
                        r3.f6124.recycle();
                    }
                    this.mTempScreenRect.offset(this.mTempGlobalRect[0] - this.mHost.getScrollX(), this.mTempGlobalRect[1] - this.mHost.getScrollY());
                }
                if (this.mHost.getLocalVisibleRect(this.mTempVisibleRect)) {
                    this.mTempVisibleRect.offset(this.mTempGlobalRect[0] - this.mHost.getScrollX(), this.mTempGlobalRect[1] - this.mHost.getScrollY());
                    if (this.mTempScreenRect.intersect(this.mTempVisibleRect)) {
                        r1.f6124.setBoundsInScreen(this.mTempScreenRect);
                        if (isVisibleToUser(this.mTempScreenRect)) {
                            r1.m4648(true);
                        }
                    }
                }
                return r1;
            } else {
                throw new RuntimeException("Callbacks must not add ACTION_CLEAR_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
            }
        } else {
            throw new RuntimeException("Callbacks must set parent bounds in populateNodeForVirtualViewId()");
        }
    }

    private C1782 createNodeForHost() {
        C1782 r1 = new C1782(AccessibilityNodeInfo.obtain(this.mHost));
        C1729.m4487(this.mHost, r1);
        ArrayList arrayList = new ArrayList();
        getVisibleVirtualViews(arrayList);
        if (r1.f6124.getChildCount() <= 0 || arrayList.size() <= 0) {
            int size = arrayList.size();
            for (int i = 0; i < size; i++) {
                View view = this.mHost;
                int intValue = ((Integer) arrayList.get(i)).intValue();
                int i2 = Build.VERSION.SDK_INT;
                r1.f6124.addChild(view, intValue);
            }
            return r1;
        }
        throw new RuntimeException("Views cannot have both real and virtual children");
    }

    private C2276<C1782> getAllNodes() {
        ArrayList arrayList = new ArrayList();
        getVisibleVirtualViews(arrayList);
        C2276<C1782> r1 = new C2276<>(10);
        for (int i = 0; i < arrayList.size(); i++) {
            r1.m5922(i, createNodeForChild(i));
        }
        return r1;
    }

    private void getBoundsInParent(int i, Rect rect) {
        obtainAccessibilityNodeInfo(i).f6124.getBoundsInParent(rect);
    }

    public static Rect guessPreviouslyFocusedRect(View view, int i, Rect rect) {
        int width = view.getWidth();
        int height = view.getHeight();
        if (i == 17) {
            rect.set(width, 0, width, height);
        } else if (i == 33) {
            rect.set(0, height, width, height);
        } else if (i == 66) {
            rect.set(-1, 0, -1, height);
        } else if (i == 130) {
            rect.set(0, -1, width, -1);
        } else {
            throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
        }
        return rect;
    }

    private boolean isVisibleToUser(Rect rect) {
        if (rect == null || rect.isEmpty() || this.mHost.getWindowVisibility() != 0) {
            return false;
        }
        ViewParent parent = this.mHost.getParent();
        while (parent instanceof View) {
            View view = (View) parent;
            if (view.getAlpha() <= 0.0f || view.getVisibility() != 0) {
                return false;
            }
            parent = view.getParent();
        }
        if (parent != null) {
            return true;
        }
        return false;
    }

    public static int keyToDirection(int i) {
        if (i == 19) {
            return 33;
        }
        if (i != 21) {
            return i != 22 ? 130 : 66;
        }
        return 17;
    }

    private boolean moveFocus(int i, Rect rect) {
        C1782 r4;
        int i2;
        C1782 r1;
        int i3;
        C1782 r16;
        int i4;
        C2276<C1782> allNodes = getAllNodes();
        int i5 = this.mKeyboardFocusedVirtualViewId;
        if (i5 == Integer.MIN_VALUE) {
            r4 = null;
        } else {
            r4 = allNodes.m5926(i5);
        }
        if (i == 1 || i == 2) {
            boolean z = C1729.m4511(this.mHost) == 1;
            AbstractC1697<C2276<C1782>, C1782> r5 = SPARSE_VALUES_ADAPTER;
            AbstractC1702<C1782> r6 = NODE_ADAPTER;
            C1705 r52 = (C1705) r5;
            int r7 = r52.m4375(allNodes);
            ArrayList arrayList = new ArrayList(r7);
            for (int i6 = 0; i6 < r7; i6++) {
                arrayList.add(r52.m4376(allNodes, i6));
            }
            Collections.sort(arrayList, new C1707(z, r6));
            if (i == 1) {
                int size = arrayList.size();
                if (r4 != null) {
                    size = arrayList.indexOf(r4);
                }
                i2 = -1;
                int i7 = size - 1;
                r16 = i7 >= 0 ? arrayList.get(i7) : null;
            } else if (i == 2) {
                int size2 = arrayList.size();
                if (r4 == null) {
                    i4 = -1;
                } else {
                    i4 = arrayList.lastIndexOf(r4);
                }
                int i8 = i4 + 1;
                r16 = i8 < size2 ? arrayList.get(i8) : null;
                i2 = -1;
            } else {
                throw new IllegalArgumentException("direction must be one of {FOCUS_FORWARD, FOCUS_BACKWARD}.");
            }
            r1 = r16;
        } else if (i == 17 || i == 33 || i == 66 || i == 130) {
            Rect rect2 = new Rect();
            int i9 = this.mKeyboardFocusedVirtualViewId;
            if (i9 != Integer.MIN_VALUE) {
                getBoundsInParent(i9, rect2);
            } else if (rect != null) {
                rect2.set(rect);
            } else {
                guessPreviouslyFocusedRect(this.mHost, i, rect2);
            }
            AbstractC1697<C2276<C1782>, C1782> r2 = SPARSE_VALUES_ADAPTER;
            AbstractC1702<C1782> r15 = NODE_ADAPTER;
            Rect rect3 = new Rect(rect2);
            if (i == 17) {
                rect3.offset(rect2.width() + 1, 0);
            } else if (i == 33) {
                rect3.offset(0, rect2.height() + 1);
            } else if (i == 66) {
                rect3.offset(-(rect2.width() + 1), 0);
            } else if (i == 130) {
                rect3.offset(0, -(rect2.height() + 1));
            } else {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            C1705 r22 = (C1705) r2;
            int r8 = r22.m4375(allNodes);
            Rect rect4 = new Rect();
            C1782 r162 = null;
            for (int i10 = 0; i10 < r8; i10++) {
                Object r13 = r22.m4376(allNodes, i10);
                if (r13 != r4) {
                    ((C1706) r15).m4377(r13, rect4);
                    if (C1841.m4800(rect2, rect4, i) && (!C1841.m4800(rect2, rect3, i) || C1841.m4799(i, rect2, rect4, rect3) || (!C1841.m4799(i, rect2, rect3, rect4) && C1841.m4768(C1841.m4752(i, rect2, rect4), C1841.m4739(i, rect2, rect4)) < C1841.m4768(C1841.m4752(i, rect2, rect3), C1841.m4739(i, rect2, rect3))))) {
                        rect3.set(rect4);
                        r162 = r13;
                    }
                }
            }
            r1 = r162;
            i2 = -1;
        } else {
            throw new IllegalArgumentException("direction must be one of {FOCUS_FORWARD, FOCUS_BACKWARD, FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
        }
        if (r1 == null) {
            i3 = Integer.MIN_VALUE;
        } else {
            if (allNodes.f7873) {
                allNodes.m5927();
            }
            int i11 = 0;
            while (true) {
                if (i11 >= allNodes.f7872) {
                    break;
                } else if (allNodes.f7874[i11] == r1) {
                    i2 = i11;
                    break;
                } else {
                    i11++;
                }
            }
            i3 = allNodes.m5924(i2);
        }
        return requestKeyboardFocusForVirtualView(i3);
    }

    private boolean performActionForChild(int i, int i2, Bundle bundle) {
        if (i2 == 1) {
            return requestKeyboardFocusForVirtualView(i);
        }
        if (i2 == 2) {
            return clearKeyboardFocusForVirtualView(i);
        }
        if (i2 == 64) {
            return requestAccessibilityFocus(i);
        }
        if (i2 != 128) {
            return onPerformActionForVirtualView(i, i2, bundle);
        }
        return clearAccessibilityFocus(i);
    }

    private boolean performActionForHost(int i, Bundle bundle) {
        return C1729.m4490(this.mHost, i, bundle);
    }

    private boolean requestAccessibilityFocus(int i) {
        int i2;
        if (!this.mManager.isEnabled() || !this.mManager.isTouchExplorationEnabled() || (i2 = this.mAccessibilityFocusedVirtualViewId) == i) {
            return false;
        }
        if (i2 != Integer.MIN_VALUE) {
            clearAccessibilityFocus(i2);
        }
        this.mAccessibilityFocusedVirtualViewId = i;
        this.mHost.invalidate();
        sendEventForVirtualView(i, 32768);
        return true;
    }

    private void updateHoveredVirtualView(int i) {
        int i2 = this.mHoveredVirtualViewId;
        if (i2 != i) {
            this.mHoveredVirtualViewId = i;
            sendEventForVirtualView(i, 128);
            sendEventForVirtualView(i2, 256);
        }
    }

    public final boolean clearKeyboardFocusForVirtualView(int i) {
        if (this.mKeyboardFocusedVirtualViewId != i) {
            return false;
        }
        this.mKeyboardFocusedVirtualViewId = Integer.MIN_VALUE;
        onVirtualViewKeyboardFocusChanged(i, false);
        sendEventForVirtualView(i, 8);
        return true;
    }

    public final boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (!this.mManager.isEnabled() || !this.mManager.isTouchExplorationEnabled()) {
            return false;
        }
        int action = motionEvent.getAction();
        if (action == 7 || action == 9) {
            int virtualViewAt = getVirtualViewAt(motionEvent.getX(), motionEvent.getY());
            updateHoveredVirtualView(virtualViewAt);
            if (virtualViewAt != Integer.MIN_VALUE) {
                return true;
            }
            return false;
        } else if (action != 10 || this.mHoveredVirtualViewId == Integer.MIN_VALUE) {
            return false;
        } else {
            updateHoveredVirtualView(Integer.MIN_VALUE);
            return true;
        }
    }

    public final boolean dispatchKeyEvent(KeyEvent keyEvent) {
        int i = 0;
        if (keyEvent.getAction() == 1) {
            return false;
        }
        int keyCode = keyEvent.getKeyCode();
        if (keyCode != 61) {
            if (keyCode != 66) {
                switch (keyCode) {
                    case 19:
                    case 20:
                    case 21:
                    case 22:
                        if (!keyEvent.hasNoModifiers()) {
                            return false;
                        }
                        int keyToDirection = keyToDirection(keyCode);
                        int repeatCount = keyEvent.getRepeatCount() + 1;
                        boolean z = false;
                        while (i < repeatCount && moveFocus(keyToDirection, null)) {
                            i++;
                            z = true;
                        }
                        return z;
                    case 23:
                        break;
                    default:
                        return false;
                }
            }
            if (!keyEvent.hasNoModifiers() || keyEvent.getRepeatCount() != 0) {
                return false;
            }
            clickKeyboardFocusedVirtualView();
            return true;
        } else if (keyEvent.hasNoModifiers()) {
            return moveFocus(2, null);
        } else {
            if (keyEvent.hasModifiers(1)) {
                return moveFocus(1, null);
            }
            return false;
        }
    }

    public final int getAccessibilityFocusedVirtualViewId() {
        return this.mAccessibilityFocusedVirtualViewId;
    }

    @Override // ῲ.ᨨ.ᨨ.C1747
    public C1778 getAccessibilityNodeProvider(View view) {
        if (this.mNodeProvider == null) {
            this.mNodeProvider = new C1704();
        }
        return this.mNodeProvider;
    }

    @Deprecated
    public int getFocusedVirtualView() {
        return getAccessibilityFocusedVirtualViewId();
    }

    public final int getKeyboardFocusedVirtualViewId() {
        return this.mKeyboardFocusedVirtualViewId;
    }

    public abstract int getVirtualViewAt(float f, float f2);

    public abstract void getVisibleVirtualViews(List<Integer> list);

    public final void invalidateRoot() {
        invalidateVirtualView(-1, 1);
    }

    public final void invalidateVirtualView(int i) {
        invalidateVirtualView(i, 0);
    }

    public C1782 obtainAccessibilityNodeInfo(int i) {
        if (i == -1) {
            return createNodeForHost();
        }
        return createNodeForChild(i);
    }

    public final void onFocusChanged(boolean z, int i, Rect rect) {
        int i2 = this.mKeyboardFocusedVirtualViewId;
        if (i2 != Integer.MIN_VALUE) {
            clearKeyboardFocusForVirtualView(i2);
        }
        if (z) {
            moveFocus(i, rect);
        }
    }

    @Override // ῲ.ᨨ.ᨨ.C1747
    public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(view, accessibilityEvent);
        onPopulateEventForHost(accessibilityEvent);
    }

    @Override // ῲ.ᨨ.ᨨ.C1747
    public void onInitializeAccessibilityNodeInfo(View view, C1782 r2) {
        super.onInitializeAccessibilityNodeInfo(view, r2);
        onPopulateNodeForHost(r2);
    }

    public abstract boolean onPerformActionForVirtualView(int i, int i2, Bundle bundle);

    public void onPopulateEventForHost(AccessibilityEvent accessibilityEvent) {
    }

    public void onPopulateEventForVirtualView(int i, AccessibilityEvent accessibilityEvent) {
    }

    public void onPopulateNodeForHost(C1782 r1) {
    }

    public abstract void onPopulateNodeForVirtualView(int i, C1782 v);

    public void onVirtualViewKeyboardFocusChanged(int i, boolean z) {
    }

    public boolean performAction(int i, int i2, Bundle bundle) {
        if (i != -1) {
            return performActionForChild(i, i2, bundle);
        }
        return performActionForHost(i2, bundle);
    }

    public final boolean requestKeyboardFocusForVirtualView(int i) {
        int i2;
        if ((!this.mHost.isFocused() && !this.mHost.requestFocus()) || (i2 = this.mKeyboardFocusedVirtualViewId) == i) {
            return false;
        }
        if (i2 != Integer.MIN_VALUE) {
            clearKeyboardFocusForVirtualView(i2);
        }
        this.mKeyboardFocusedVirtualViewId = i;
        onVirtualViewKeyboardFocusChanged(i, true);
        sendEventForVirtualView(i, 8);
        return true;
    }

    public final boolean sendEventForVirtualView(int i, int i2) {
        ViewParent parent;
        if (i == Integer.MIN_VALUE || !this.mManager.isEnabled() || (parent = this.mHost.getParent()) == null) {
            return false;
        }
        return parent.requestSendAccessibilityEvent(this.mHost, createEvent(i, i2));
    }

    public final void invalidateVirtualView(int i, int i2) {
        ViewParent parent;
        if (i != Integer.MIN_VALUE && this.mManager.isEnabled() && (parent = this.mHost.getParent()) != null) {
            AccessibilityEvent createEvent = createEvent(i, RecyclerView.AbstractC0269.FLAG_MOVED);
            int i3 = Build.VERSION.SDK_INT;
            createEvent.setContentChangeTypes(i2);
            parent.requestSendAccessibilityEvent(this.mHost, createEvent);
        }
    }

    /* renamed from: ῲ.ᕣ.K.K$ʬ  reason: contains not printable characters */
    /* compiled from: ExploreByTouchHelper */
    public class C1704 extends C1778 {
        public C1704() {
        }

        @Override // ῲ.ᨨ.ᨨ.䃖.C1778
        /* renamed from: ῲ  reason: contains not printable characters */
        public C1782 m4372(int i) {
            int i2 = i == 2 ? AbstractC1703.this.mAccessibilityFocusedVirtualViewId : AbstractC1703.this.mKeyboardFocusedVirtualViewId;
            if (i2 == Integer.MIN_VALUE) {
                return null;
            }
            return m4373(i2);
        }

        @Override // ῲ.ᨨ.ᨨ.䃖.C1778
        /* renamed from: K  reason: contains not printable characters */
        public C1782 m4373(int i) {
            return C1782.m4646(AbstractC1703.this.obtainAccessibilityNodeInfo(i));
        }

        @Override // ῲ.ᨨ.ᨨ.䃖.C1778
        /* renamed from: K  reason: contains not printable characters */
        public boolean m4374(int i, int i2, Bundle bundle) {
            return AbstractC1703.this.performAction(i, i2, bundle);
        }
    }

    /* renamed from: ῲ.ᕣ.K.K$ῲ  reason: contains not printable characters */
    /* compiled from: ExploreByTouchHelper */
    public static class C1705 implements AbstractC1697<C2276<C1782>, C1782> {
        /* renamed from: K  reason: contains not printable characters */
        public Object m4376(Object obj, int i) {
            C2276 r2 = (C2276) obj;
            if (r2.f7873) {
                r2.m5927();
            }
            return (C1782) r2.f7874[i];
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m4375(Object obj) {
            return ((C2276) obj).m5923();
        }
    }
}
