package ῲ.ᓆ;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ListView;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.㳳.C1841;
import ῲ.㴹.C2275;
import ῲ.㴹.C2284;
import ῲ.㴹.C2287;
import K.K.K.ʬ.C2369;

/* renamed from: ῲ.ᓆ.ᕣ  reason: contains not printable characters */
/* compiled from: Transition */
public abstract class AbstractC1647 implements Cloneable {
    public static final boolean DBG = false;
    public static final int[] DEFAULT_MATCH_ORDER = {2, 1, 3, 4};
    public static final String LOG_TAG = "Transition";
    public static final int MATCH_FIRST = 1;
    public static final int MATCH_ID = 3;
    public static final String MATCH_ID_STR = "id";
    public static final int MATCH_INSTANCE = 1;
    public static final String MATCH_INSTANCE_STR = "instance";
    public static final int MATCH_ITEM_ID = 4;
    public static final String MATCH_ITEM_ID_STR = "itemId";
    public static final int MATCH_LAST = 4;
    public static final int MATCH_NAME = 2;
    public static final String MATCH_NAME_STR = "name";
    public static final AbstractC1672 STRAIGHT_PATH_MOTION = new C1651();
    public static ThreadLocal<C2284<Animator, C1653>> sRunningAnimators = new ThreadLocal<>();
    public ArrayList<Animator> mAnimators = new ArrayList<>();
    public boolean mCanRemoveViews = false;
    public ArrayList<Animator> mCurrentAnimators = new ArrayList<>();
    public long mDuration = -1;
    public C1666 mEndValues = new C1666();
    public ArrayList<C1646> mEndValuesList;
    public boolean mEnded = false;
    public AbstractC1649 mEpicenterCallback;
    public TimeInterpolator mInterpolator = null;
    public ArrayList<AbstractC1652> mListeners = null;
    public int[] mMatchOrder = DEFAULT_MATCH_ORDER;
    public String mName = getClass().getName();
    public C2284<String, String> mNameOverrides;
    public int mNumInstances = 0;
    public C1663 mParent = null;
    public AbstractC1672 mPathMotion = STRAIGHT_PATH_MOTION;
    public boolean mPaused = false;
    public AbstractC1630 mPropagation;
    public ViewGroup mSceneRoot = null;
    public long mStartDelay = -1;
    public C1666 mStartValues = new C1666();
    public ArrayList<C1646> mStartValuesList;
    public ArrayList<View> mTargetChildExcludes = null;
    public ArrayList<View> mTargetExcludes = null;
    public ArrayList<Integer> mTargetIdChildExcludes = null;
    public ArrayList<Integer> mTargetIdExcludes = null;
    public ArrayList<Integer> mTargetIds = new ArrayList<>();
    public ArrayList<String> mTargetNameExcludes = null;
    public ArrayList<String> mTargetNames = null;
    public ArrayList<Class<?>> mTargetTypeChildExcludes = null;
    public ArrayList<Class<?>> mTargetTypeExcludes = null;
    public ArrayList<Class<?>> mTargetTypes = null;
    public ArrayList<View> mTargets = new ArrayList<>();

    /* renamed from: ῲ.ᓆ.ᕣ$ʬ  reason: contains not printable characters */
    /* compiled from: Transition */
    public class C1648 extends AnimatorListenerAdapter {
        public C1648() {
        }

        public void onAnimationEnd(Animator animator) {
            AbstractC1647.this.end();
            animator.removeListener(this);
        }
    }

    /* renamed from: ῲ.ᓆ.ᕣ$ඓ  reason: contains not printable characters */
    /* compiled from: Transition */
    public static abstract class AbstractC1649 {
        /* renamed from: K  reason: contains not printable characters */
        public abstract Rect m4239(AbstractC1647 v);
    }

    /* renamed from: ῲ.ᓆ.ᕣ$ῲ  reason: contains not printable characters */
    /* compiled from: Transition */
    public class C1650 extends AnimatorListenerAdapter {

        /* renamed from: K  reason: contains not printable characters */
        public final /* synthetic */ C2284 f5886;

        public C1650(C2284 k) {
            this.f5886 = k;
        }

        public void onAnimationEnd(Animator animator) {
            this.f5886.remove(animator);
            AbstractC1647.this.mCurrentAnimators.remove(animator);
        }

        public void onAnimationStart(Animator animator) {
            AbstractC1647.this.mCurrentAnimators.add(animator);
        }
    }

    /* renamed from: ῲ.ᓆ.ᕣ$K  reason: contains not printable characters */
    /* compiled from: Transition */
    public static class C1651 extends AbstractC1672 {
        @Override // ῲ.ᓆ.AbstractC1672
        public Path getPath(float f, float f2, float f3, float f4) {
            Path path = new Path();
            path.moveTo(f, f2);
            path.lineTo(f3, f4);
            return path;
        }
    }

    /* renamed from: ῲ.ᓆ.ᕣ$㴹  reason: contains not printable characters */
    /* compiled from: Transition */
    public interface AbstractC1652 {
        void onTransitionCancel(AbstractC1647 v);

        void onTransitionEnd(AbstractC1647 v);

        void onTransitionPause(AbstractC1647 v);

        void onTransitionResume(AbstractC1647 v);

        void onTransitionStart(AbstractC1647 v);
    }

    /* renamed from: ῲ.ᓆ.ᕣ$㸾  reason: contains not printable characters */
    /* compiled from: Transition */
    public static class C1653 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public C1646 f5887;

        /* renamed from: ඓ  reason: contains not printable characters */
        public AbstractC1647 f5888;

        /* renamed from: ῲ  reason: contains not printable characters */
        public String f5889;

        /* renamed from: K  reason: contains not printable characters */
        public View f5890;

        /* renamed from: 㸾  reason: contains not printable characters */
        public AbstractC1643 f5891;

        public C1653(View view, String str, AbstractC1647 r3, AbstractC1643 r4, C1646 r5) {
            this.f5890 = view;
            this.f5889 = str;
            this.f5887 = r5;
            this.f5891 = r4;
            this.f5888 = r3;
        }
    }

    public AbstractC1647() {
    }

    private void addUnmatched(C2284<View, C1646> k, C2284<View, C1646> k2) {
        for (int i = 0; i < k.f7909; i++) {
            C1646 r2 = k.m5973(i);
            if (isValidTarget(r2.f5882)) {
                this.mStartValuesList.add(r2);
                this.mEndValuesList.add(null);
            }
        }
        for (int i2 = 0; i2 < k2.f7909; i2++) {
            C1646 r6 = k2.m5973(i2);
            if (isValidTarget(r6.f5882)) {
                this.mEndValuesList.add(r6);
                this.mStartValuesList.add(null);
            }
        }
    }

    public static void addViewValues(C1666 r6, View view, C1646 r8) {
        r6.f5911.put(view, r8);
        int id = view.getId();
        if (id >= 0) {
            if (r6.f5910.indexOfKey(id) >= 0) {
                r6.f5910.put(id, null);
            } else {
                r6.f5910.put(id, view);
            }
        }
        String r82 = C1729.m4443(view);
        if (r82 != null) {
            if (r6.f5912.m5977(r82) >= 0) {
                r6.f5912.put(r82, null);
            } else {
                r6.f5912.put(r82, view);
            }
        }
        if (view.getParent() instanceof ListView) {
            ListView listView = (ListView) view.getParent();
            if (listView.getAdapter().hasStableIds()) {
                long itemIdAtPosition = listView.getItemIdAtPosition(listView.getPositionForView(view));
                C2275<View> r83 = r6.f5909;
                if (r83.f7868) {
                    r83.m5916();
                }
                if (C2287.m5969(r83.f7866, r83.f7867, itemIdAtPosition) >= 0) {
                    View r7 = r6.f5909.m5918(itemIdAtPosition);
                    if (r7 != null) {
                        int i = Build.VERSION.SDK_INT;
                        r7.setHasTransientState(false);
                        r6.f5909.m5914(itemIdAtPosition, null);
                        return;
                    }
                    return;
                }
                int i2 = Build.VERSION.SDK_INT;
                view.setHasTransientState(true);
                r6.f5909.m5914(itemIdAtPosition, view);
            }
        }
    }

    public static boolean alreadyContains(int[] iArr, int i) {
        int i2 = iArr[i];
        for (int i3 = 0; i3 < i; i3++) {
            if (iArr[i3] == i2) {
                return true;
            }
        }
        return false;
    }

    private void captureHierarchy(View view, boolean z) {
        if (view != null) {
            int id = view.getId();
            ArrayList<Integer> arrayList = this.mTargetIdExcludes;
            if (arrayList == null || !arrayList.contains(Integer.valueOf(id))) {
                ArrayList<View> arrayList2 = this.mTargetExcludes;
                if (arrayList2 == null || !arrayList2.contains(view)) {
                    ArrayList<Class<?>> arrayList3 = this.mTargetTypeExcludes;
                    if (arrayList3 != null) {
                        int size = arrayList3.size();
                        for (int i = 0; i < size; i++) {
                            if (this.mTargetTypeExcludes.get(i).isInstance(view)) {
                                return;
                            }
                        }
                    }
                    if (view.getParent() instanceof ViewGroup) {
                        C1646 r1 = new C1646(view);
                        if (z) {
                            captureStartValues(r1);
                        } else {
                            captureEndValues(r1);
                        }
                        r1.f5881.add(this);
                        capturePropagationValues(r1);
                        if (z) {
                            addViewValues(this.mStartValues, view, r1);
                        } else {
                            addViewValues(this.mEndValues, view, r1);
                        }
                    }
                    if (view instanceof ViewGroup) {
                        ArrayList<Integer> arrayList4 = this.mTargetIdChildExcludes;
                        if (arrayList4 == null || !arrayList4.contains(Integer.valueOf(id))) {
                            ArrayList<View> arrayList5 = this.mTargetChildExcludes;
                            if (arrayList5 == null || !arrayList5.contains(view)) {
                                ArrayList<Class<?>> arrayList6 = this.mTargetTypeChildExcludes;
                                if (arrayList6 != null) {
                                    int size2 = arrayList6.size();
                                    for (int i2 = 0; i2 < size2; i2++) {
                                        if (this.mTargetTypeChildExcludes.get(i2).isInstance(view)) {
                                            return;
                                        }
                                    }
                                }
                                ViewGroup viewGroup = (ViewGroup) view;
                                for (int i3 = 0; i3 < viewGroup.getChildCount(); i3++) {
                                    captureHierarchy(viewGroup.getChildAt(i3), z);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private ArrayList<Integer> excludeId(ArrayList<Integer> arrayList, int i, boolean z) {
        if (i <= 0) {
            return arrayList;
        }
        if (z) {
            return C1841.m4789(arrayList, Integer.valueOf(i));
        }
        return C1841.m4757(arrayList, Integer.valueOf(i));
    }

    public static <T> ArrayList<T> excludeObject(ArrayList<T> arrayList, T t, boolean z) {
        if (t == null) {
            return arrayList;
        }
        if (z) {
            return C1841.m4789((ArrayList) arrayList, (Object) t);
        }
        return C1841.m4757(arrayList, t);
    }

    private ArrayList<Class<?>> excludeType(ArrayList<Class<?>> arrayList, Class<?> cls, boolean z) {
        if (cls == null) {
            return arrayList;
        }
        if (z) {
            return C1841.m4789(arrayList, cls);
        }
        return C1841.m4757(arrayList, cls);
    }

    private ArrayList<View> excludeView(ArrayList<View> arrayList, View view, boolean z) {
        if (view == null) {
            return arrayList;
        }
        if (z) {
            return C1841.m4789(arrayList, view);
        }
        return C1841.m4757(arrayList, view);
    }

    public static C2284<Animator, C1653> getRunningAnimators() {
        C2284<Animator, C1653> k = sRunningAnimators.get();
        if (k != null) {
            return k;
        }
        C2284<Animator, C1653> k2 = new C2284<>();
        sRunningAnimators.set(k2);
        return k2;
    }

    public static boolean isValidMatch(int i) {
        return i >= 1 && i <= 4;
    }

    public static boolean isValueChanged(C1646 r0, C1646 r1, String str) {
        Object obj = r0.f5883.get(str);
        Object obj2 = r1.f5883.get(str);
        if (obj == null && obj2 == null) {
            return false;
        }
        if (obj == null || obj2 == null) {
            return true;
        }
        return true ^ obj.equals(obj2);
    }

    private void matchIds(C2284<View, C1646> k, C2284<View, C1646> k2, SparseArray<View> sparseArray, SparseArray<View> sparseArray2) {
        View view;
        int size = sparseArray.size();
        for (int i = 0; i < size; i++) {
            View valueAt = sparseArray.valueAt(i);
            if (valueAt != null && isValidTarget(valueAt) && (view = sparseArray2.get(sparseArray.keyAt(i))) != null && isValidTarget(view)) {
                C1646 orDefault = k.getOrDefault(valueAt, null);
                C1646 orDefault2 = k2.getOrDefault(view, null);
                if (!(orDefault == null || orDefault2 == null)) {
                    this.mStartValuesList.add(orDefault);
                    this.mEndValuesList.add(orDefault2);
                    k.remove(valueAt);
                    k2.remove(view);
                }
            }
        }
    }

    private void matchInstances(C2284<View, C1646> k, C2284<View, C1646> k2) {
        C1646 remove;
        for (int i = k.f7909 - 1; i >= 0; i--) {
            View r1 = k.m5972(i);
            if (r1 != null && isValidTarget(r1) && (remove = k2.remove(r1)) != null && isValidTarget(remove.f5882)) {
                this.mStartValuesList.add(k.m5982(i));
                this.mEndValuesList.add(remove);
            }
        }
    }

    private void matchItemIds(C2284<View, C1646> k, C2284<View, C1646> k2, C2275<View> r10, C2275<View> r11) {
        int r0 = r10.m5913();
        for (int i = 0; i < r0; i++) {
            View r2 = r10.m5917(i);
            if (r2 != null && isValidTarget(r2)) {
                if (r10.f7868) {
                    r10.m5916();
                }
                View r3 = r11.m5918(r10.f7866[i]);
                if (r3 != null && isValidTarget(r3)) {
                    C1646 orDefault = k.getOrDefault(r2, null);
                    C1646 orDefault2 = k2.getOrDefault(r3, null);
                    if (!(orDefault == null || orDefault2 == null)) {
                        this.mStartValuesList.add(orDefault);
                        this.mEndValuesList.add(orDefault2);
                        k.remove(r2);
                        k2.remove(r3);
                    }
                }
            }
        }
    }

    private void matchNames(C2284<View, C1646> k, C2284<View, C1646> k2, C2284<String, View> k3, C2284<String, View> k4) {
        View view;
        int i = k3.f7909;
        for (int i2 = 0; i2 < i; i2++) {
            View r2 = k3.m5973(i2);
            if (r2 != null && isValidTarget(r2) && (view = k4.get(k3.m5972(i2))) != null && isValidTarget(view)) {
                C1646 orDefault = k.getOrDefault(r2, null);
                C1646 orDefault2 = k2.getOrDefault(view, null);
                if (!(orDefault == null || orDefault2 == null)) {
                    this.mStartValuesList.add(orDefault);
                    this.mEndValuesList.add(orDefault2);
                    k.remove(r2);
                    k2.remove(view);
                }
            }
        }
    }

    private void matchStartAndEnd(C1666 r6, C1666 r7) {
        C2284<View, C1646> k = new C2284<>(r6.f5911);
        C2284<View, C1646> k2 = new C2284<>(r7.f5911);
        int i = 0;
        while (true) {
            int[] iArr = this.mMatchOrder;
            if (i < iArr.length) {
                int i2 = iArr[i];
                if (i2 == 1) {
                    matchInstances(k, k2);
                } else if (i2 == 2) {
                    matchNames(k, k2, r6.f5912, r7.f5912);
                } else if (i2 == 3) {
                    matchIds(k, k2, r6.f5910, r7.f5910);
                } else if (i2 == 4) {
                    matchItemIds(k, k2, r6.f5909, r7.f5909);
                }
                i++;
            } else {
                addUnmatched(k, k2);
                return;
            }
        }
    }

    public static int[] parseMatchOrder(String str) {
        StringTokenizer stringTokenizer = new StringTokenizer(str, ",");
        int[] iArr = new int[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String trim = stringTokenizer.nextToken().trim();
            if ("id".equalsIgnoreCase(trim)) {
                iArr[i] = 3;
            } else if (MATCH_INSTANCE_STR.equalsIgnoreCase(trim)) {
                iArr[i] = 1;
            } else if ("name".equalsIgnoreCase(trim)) {
                iArr[i] = 2;
            } else if (MATCH_ITEM_ID_STR.equalsIgnoreCase(trim)) {
                iArr[i] = 4;
            } else if (trim.isEmpty()) {
                int[] iArr2 = new int[(iArr.length - 1)];
                System.arraycopy(iArr, 0, iArr2, 0, i);
                i--;
                iArr = iArr2;
            } else {
                throw new InflateException(C1293.m3413("Unknown match type in matchOrder: '", trim, "'"));
            }
            i++;
        }
        return iArr;
    }

    private void runAnimator(Animator animator, C2284<Animator, C1653> k) {
        if (animator != null) {
            animator.addListener(new C1650(k));
            animate(animator);
        }
    }

    public AbstractC1647 addListener(AbstractC1652 r2) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<>();
        }
        this.mListeners.add(r2);
        return this;
    }

    public AbstractC1647 addTarget(View view) {
        this.mTargets.add(view);
        return this;
    }

    public void animate(Animator animator) {
        if (animator == null) {
            end();
            return;
        }
        if (getDuration() >= 0) {
            animator.setDuration(getDuration());
        }
        if (getStartDelay() >= 0) {
            animator.setStartDelay(animator.getStartDelay() + getStartDelay());
        }
        if (getInterpolator() != null) {
            animator.setInterpolator(getInterpolator());
        }
        animator.addListener(new C1648());
        animator.start();
    }

    public void cancel() {
        for (int size = this.mCurrentAnimators.size() - 1; size >= 0; size--) {
            this.mCurrentAnimators.get(size).cancel();
        }
        ArrayList<AbstractC1652> arrayList = this.mListeners;
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
            int size2 = arrayList2.size();
            for (int i = 0; i < size2; i++) {
                ((AbstractC1652) arrayList2.get(i)).onTransitionCancel(this);
            }
        }
    }

    public abstract void captureEndValues(C1646 v);

    public void capturePropagationValues(C1646 r1) {
    }

    public abstract void captureStartValues(C1646 v);

    public void captureValues(ViewGroup viewGroup, boolean z) {
        C2284<String, String> k;
        ArrayList<String> arrayList;
        ArrayList<Class<?>> arrayList2;
        clearValues(z);
        if ((this.mTargetIds.size() > 0 || this.mTargets.size() > 0) && (((arrayList = this.mTargetNames) == null || arrayList.isEmpty()) && ((arrayList2 = this.mTargetTypes) == null || arrayList2.isEmpty()))) {
            for (int i = 0; i < this.mTargetIds.size(); i++) {
                View findViewById = viewGroup.findViewById(this.mTargetIds.get(i).intValue());
                if (findViewById != null) {
                    C1646 r3 = new C1646(findViewById);
                    if (z) {
                        captureStartValues(r3);
                    } else {
                        captureEndValues(r3);
                    }
                    r3.f5881.add(this);
                    capturePropagationValues(r3);
                    if (z) {
                        addViewValues(this.mStartValues, findViewById, r3);
                    } else {
                        addViewValues(this.mEndValues, findViewById, r3);
                    }
                }
            }
            for (int i2 = 0; i2 < this.mTargets.size(); i2++) {
                View view = this.mTargets.get(i2);
                C1646 r2 = new C1646(view);
                if (z) {
                    captureStartValues(r2);
                } else {
                    captureEndValues(r2);
                }
                r2.f5881.add(this);
                capturePropagationValues(r2);
                if (z) {
                    addViewValues(this.mStartValues, view, r2);
                } else {
                    addViewValues(this.mEndValues, view, r2);
                }
            }
        } else {
            captureHierarchy(viewGroup, z);
        }
        if (!(z || (k = this.mNameOverrides) == null)) {
            int i3 = k.f7909;
            ArrayList arrayList3 = new ArrayList(i3);
            for (int i4 = 0; i4 < i3; i4++) {
                arrayList3.add(this.mStartValues.f5912.remove(this.mNameOverrides.m5972(i4)));
            }
            for (int i5 = 0; i5 < i3; i5++) {
                View view2 = (View) arrayList3.get(i5);
                if (view2 != null) {
                    this.mStartValues.f5912.put(this.mNameOverrides.m5973(i5), view2);
                }
            }
        }
    }

    public void clearValues(boolean z) {
        if (z) {
            this.mStartValues.f5911.clear();
            this.mStartValues.f5910.clear();
            this.mStartValues.f5909.m5919();
            return;
        }
        this.mEndValues.f5911.clear();
        this.mEndValues.f5910.clear();
        this.mEndValues.f5909.m5919();
    }

    public Animator createAnimator(ViewGroup viewGroup, C1646 r2, C1646 r3) {
        return null;
    }

    public void createAnimators(ViewGroup viewGroup, C1666 r21, C1666 r22, ArrayList<C1646> arrayList, ArrayList<C1646> arrayList2) {
        int i;
        Animator animator;
        C1646 r5;
        View view;
        C1646 r4;
        Animator animator2;
        C2284<Animator, C1653> runningAnimators = getRunningAnimators();
        SparseIntArray sparseIntArray = new SparseIntArray();
        int size = arrayList.size();
        int i2 = 0;
        while (i2 < size) {
            C1646 r0 = arrayList.get(i2);
            C1646 r1 = arrayList2.get(i2);
            if (r0 != null && !r0.f5881.contains(this)) {
                r0 = null;
            }
            if (r1 != null && !r1.f5881.contains(this)) {
                r1 = null;
            }
            if (!(r0 == null && r1 == null)) {
                if (r0 == null || r1 == null || isTransitionRequired(r0, r1)) {
                    Animator createAnimator = createAnimator(viewGroup, r0, r1);
                    if (createAnimator != null) {
                        if (r1 != null) {
                            View view2 = r1.f5882;
                            String[] transitionProperties = getTransitionProperties();
                            if (transitionProperties != null && transitionProperties.length > 0) {
                                r4 = new C1646(view2);
                                C1646 r52 = r22.f5911.get(view2);
                                if (r52 != null) {
                                    int i3 = 0;
                                    while (i3 < transitionProperties.length) {
                                        r4.f5883.put(transitionProperties[i3], r52.f5883.get(transitionProperties[i3]));
                                        i3++;
                                        createAnimator = createAnimator;
                                        size = size;
                                        r52 = r52;
                                    }
                                }
                                i = size;
                                int i4 = runningAnimators.f7909;
                                int i5 = 0;
                                while (true) {
                                    if (i5 >= i4) {
                                        animator2 = createAnimator;
                                        break;
                                    }
                                    C1653 r3 = runningAnimators.get(runningAnimators.m5972(i5));
                                    if (r3.f5887 != null && r3.f5890 == view2 && r3.f5889.equals(getName()) && r3.f5887.equals(r4)) {
                                        animator2 = null;
                                        break;
                                    }
                                    i5++;
                                }
                            } else {
                                i = size;
                                animator2 = createAnimator;
                                r4 = null;
                            }
                            view = view2;
                            animator = animator2;
                            r5 = r4;
                        } else {
                            i = size;
                            view = r0.f5882;
                            animator = createAnimator;
                            r5 = null;
                        }
                        if (animator != null) {
                            runningAnimators.put(animator, new C1653(view, getName(), this, C1669.m4257(viewGroup), r5));
                            this.mAnimators.add(animator);
                        }
                        i2++;
                        size = i;
                    }
                    i = size;
                    i2++;
                    size = i;
                }
            }
            i = size;
            i2++;
            size = i;
        }
        if (sparseIntArray.size() != 0) {
            for (int i6 = 0; i6 < sparseIntArray.size(); i6++) {
                Animator animator3 = this.mAnimators.get(sparseIntArray.keyAt(i6));
                animator3.setStartDelay(animator3.getStartDelay() + (((long) sparseIntArray.valueAt(i6)) - RecyclerView.FOREVER_NS));
            }
        }
    }

    public void end() {
        this.mNumInstances--;
        if (this.mNumInstances == 0) {
            ArrayList<AbstractC1652> arrayList = this.mListeners;
            if (arrayList != null && arrayList.size() > 0) {
                ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
                int size = arrayList2.size();
                for (int i = 0; i < size; i++) {
                    ((AbstractC1652) arrayList2.get(i)).onTransitionEnd(this);
                }
            }
            for (int i2 = 0; i2 < this.mStartValues.f5909.m5913(); i2++) {
                View r3 = this.mStartValues.f5909.m5917(i2);
                if (r3 != null) {
                    C1729.m4488(r3, false);
                }
            }
            for (int i3 = 0; i3 < this.mEndValues.f5909.m5913(); i3++) {
                View r32 = this.mEndValues.f5909.m5917(i3);
                if (r32 != null) {
                    C1729.m4488(r32, false);
                }
            }
            this.mEnded = true;
        }
    }

    public AbstractC1647 excludeChildren(View view, boolean z) {
        this.mTargetChildExcludes = excludeView(this.mTargetChildExcludes, view, z);
        return this;
    }

    public AbstractC1647 excludeTarget(View view, boolean z) {
        this.mTargetExcludes = excludeView(this.mTargetExcludes, view, z);
        return this;
    }

    public void forceToEnd(ViewGroup viewGroup) {
        C2284<Animator, C1653> runningAnimators = getRunningAnimators();
        int i = runningAnimators.f7909;
        if (!(viewGroup == null || i == 0)) {
            AbstractC1643 r5 = C1669.m4257(viewGroup);
            C2284 k = new C2284(runningAnimators);
            runningAnimators.clear();
            for (int i2 = i - 1; i2 >= 0; i2--) {
                C1653 r0 = (C1653) k.m5973(i2);
                if (r0.f5890 != null && r5.equals(r0.f5891)) {
                    ((Animator) k.m5972(i2)).end();
                }
            }
        }
    }

    public long getDuration() {
        return this.mDuration;
    }

    public Rect getEpicenter() {
        AbstractC1649 r0 = this.mEpicenterCallback;
        if (r0 == null) {
            return null;
        }
        return r0.m4239(this);
    }

    public AbstractC1649 getEpicenterCallback() {
        return this.mEpicenterCallback;
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public C1646 getMatchedTransitionValues(View view, boolean z) {
        C1663 r0 = this.mParent;
        if (r0 != null) {
            return r0.getMatchedTransitionValues(view, z);
        }
        ArrayList<C1646> arrayList = z ? this.mStartValuesList : this.mEndValuesList;
        if (arrayList == null) {
            return null;
        }
        int size = arrayList.size();
        int i = -1;
        int i2 = 0;
        while (true) {
            if (i2 >= size) {
                break;
            }
            C1646 r5 = arrayList.get(i2);
            if (r5 == null) {
                return null;
            }
            if (r5.f5882 == view) {
                i = i2;
                break;
            }
            i2++;
        }
        if (i < 0) {
            return null;
        }
        return (z ? this.mEndValuesList : this.mStartValuesList).get(i);
    }

    public String getName() {
        return this.mName;
    }

    public AbstractC1672 getPathMotion() {
        return this.mPathMotion;
    }

    public AbstractC1630 getPropagation() {
        return null;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    public List<Integer> getTargetIds() {
        return this.mTargetIds;
    }

    public List<String> getTargetNames() {
        return this.mTargetNames;
    }

    public List<Class<?>> getTargetTypes() {
        return this.mTargetTypes;
    }

    public List<View> getTargets() {
        return this.mTargets;
    }

    public String[] getTransitionProperties() {
        return null;
    }

    public C1646 getTransitionValues(View view, boolean z) {
        C1663 r0 = this.mParent;
        if (r0 != null) {
            return r0.getTransitionValues(view, z);
        }
        return (z ? this.mStartValues : this.mEndValues).f5911.getOrDefault(view, null);
    }

    public boolean isTransitionRequired(C1646 r7, C1646 r8) {
        if (r7 == null || r8 == null) {
            return false;
        }
        String[] transitionProperties = getTransitionProperties();
        if (transitionProperties != null) {
            for (String str : transitionProperties) {
                if (!isValueChanged(r7, r8, str)) {
                }
            }
            return false;
        }
        for (String str2 : r7.f5883.keySet()) {
            if (isValueChanged(r7, r8, str2)) {
            }
        }
        return false;
        return true;
    }

    public boolean isValidTarget(View view) {
        ArrayList<Class<?>> arrayList;
        ArrayList<String> arrayList2;
        int id = view.getId();
        ArrayList<Integer> arrayList3 = this.mTargetIdExcludes;
        if (arrayList3 != null && arrayList3.contains(Integer.valueOf(id))) {
            return false;
        }
        ArrayList<View> arrayList4 = this.mTargetExcludes;
        if (arrayList4 != null && arrayList4.contains(view)) {
            return false;
        }
        ArrayList<Class<?>> arrayList5 = this.mTargetTypeExcludes;
        if (arrayList5 != null) {
            int size = arrayList5.size();
            for (int i = 0; i < size; i++) {
                if (this.mTargetTypeExcludes.get(i).isInstance(view)) {
                    return false;
                }
            }
        }
        if (!(this.mTargetNameExcludes == null || C1729.m4443(view) == null || !this.mTargetNameExcludes.contains(C1729.m4443(view)))) {
            return false;
        }
        if ((this.mTargetIds.size() == 0 && this.mTargets.size() == 0 && (((arrayList = this.mTargetTypes) == null || arrayList.isEmpty()) && ((arrayList2 = this.mTargetNames) == null || arrayList2.isEmpty()))) || this.mTargetIds.contains(Integer.valueOf(id)) || this.mTargets.contains(view)) {
            return true;
        }
        ArrayList<String> arrayList6 = this.mTargetNames;
        if (arrayList6 != null && arrayList6.contains(C1729.m4443(view))) {
            return true;
        }
        if (this.mTargetTypes != null) {
            for (int i2 = 0; i2 < this.mTargetTypes.size(); i2++) {
                if (this.mTargetTypes.get(i2).isInstance(view)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void pause(View view) {
        if (!this.mEnded) {
            C2284<Animator, C1653> runningAnimators = getRunningAnimators();
            int i = runningAnimators.f7909;
            AbstractC1643 r6 = C1669.m4257(view);
            for (int i2 = i - 1; i2 >= 0; i2--) {
                C1653 r3 = runningAnimators.m5973(i2);
                if (r3.f5890 != null && r6.equals(r3.f5891)) {
                    int i3 = Build.VERSION.SDK_INT;
                    runningAnimators.m5972(i2).pause();
                }
            }
            ArrayList<AbstractC1652> arrayList = this.mListeners;
            if (arrayList != null && arrayList.size() > 0) {
                ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
                int size = arrayList2.size();
                for (int i4 = 0; i4 < size; i4++) {
                    ((AbstractC1652) arrayList2.get(i4)).onTransitionPause(this);
                }
            }
            this.mPaused = true;
        }
    }

    public void playTransition(ViewGroup viewGroup) {
        C1653 orDefault;
        this.mStartValuesList = new ArrayList<>();
        this.mEndValuesList = new ArrayList<>();
        matchStartAndEnd(this.mStartValues, this.mEndValues);
        C2284<Animator, C1653> runningAnimators = getRunningAnimators();
        int i = runningAnimators.f7909;
        AbstractC1643 r2 = C1669.m4257(viewGroup);
        for (int i2 = i - 1; i2 >= 0; i2--) {
            Animator r4 = runningAnimators.m5972(i2);
            if (!(r4 == null || (orDefault = runningAnimators.getOrDefault(r4, null)) == null || orDefault.f5890 == null || !r2.equals(orDefault.f5891))) {
                C1646 r6 = orDefault.f5887;
                View view = orDefault.f5890;
                C1646 transitionValues = getTransitionValues(view, true);
                C1646 matchedTransitionValues = getMatchedTransitionValues(view, true);
                if (transitionValues == null && matchedTransitionValues == null) {
                    matchedTransitionValues = this.mEndValues.f5911.get(view);
                }
                if (!(transitionValues == null && matchedTransitionValues == null) && orDefault.f5888.isTransitionRequired(r6, matchedTransitionValues)) {
                    if (r4.isRunning() || r4.isStarted()) {
                        r4.cancel();
                    } else {
                        runningAnimators.remove(r4);
                    }
                }
            }
        }
        createAnimators(viewGroup, this.mStartValues, this.mEndValues, this.mStartValuesList, this.mEndValuesList);
        runAnimators();
    }

    public AbstractC1647 removeListener(AbstractC1652 r2) {
        ArrayList<AbstractC1652> arrayList = this.mListeners;
        if (arrayList == null) {
            return this;
        }
        arrayList.remove(r2);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
        return this;
    }

    public AbstractC1647 removeTarget(View view) {
        this.mTargets.remove(view);
        return this;
    }

    public void resume(View view) {
        if (this.mPaused) {
            if (!this.mEnded) {
                C2284<Animator, C1653> runningAnimators = getRunningAnimators();
                int i = runningAnimators.f7909;
                AbstractC1643 r6 = C1669.m4257(view);
                for (int i2 = i - 1; i2 >= 0; i2--) {
                    C1653 r3 = runningAnimators.m5973(i2);
                    if (r3.f5890 != null && r6.equals(r3.f5891)) {
                        int i3 = Build.VERSION.SDK_INT;
                        runningAnimators.m5972(i2).resume();
                    }
                }
                ArrayList<AbstractC1652> arrayList = this.mListeners;
                if (arrayList != null && arrayList.size() > 0) {
                    ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
                    int size = arrayList2.size();
                    for (int i4 = 0; i4 < size; i4++) {
                        ((AbstractC1652) arrayList2.get(i4)).onTransitionResume(this);
                    }
                }
            }
            this.mPaused = false;
        }
    }

    public void runAnimators() {
        start();
        C2284<Animator, C1653> runningAnimators = getRunningAnimators();
        Iterator<Animator> it2 = this.mAnimators.iterator();
        while (it2.hasNext()) {
            Animator next = it2.next();
            if (runningAnimators.containsKey(next)) {
                start();
                runAnimator(next, runningAnimators);
            }
        }
        this.mAnimators.clear();
        end();
    }

    public void setCanRemoveViews(boolean z) {
        this.mCanRemoveViews = z;
    }

    public AbstractC1647 setDuration(long j) {
        this.mDuration = j;
        return this;
    }

    public void setEpicenterCallback(AbstractC1649 r1) {
        this.mEpicenterCallback = r1;
    }

    public AbstractC1647 setInterpolator(TimeInterpolator timeInterpolator) {
        this.mInterpolator = timeInterpolator;
        return this;
    }

    public void setMatchOrder(int... iArr) {
        if (iArr == null || iArr.length == 0) {
            this.mMatchOrder = DEFAULT_MATCH_ORDER;
            return;
        }
        for (int i = 0; i < iArr.length; i++) {
            if (!isValidMatch(iArr[i])) {
                throw new IllegalArgumentException("matches contains invalid value");
            } else if (alreadyContains(iArr, i)) {
                throw new IllegalArgumentException("matches contains a duplicate value");
            }
        }
        this.mMatchOrder = (int[]) iArr.clone();
    }

    public void setPathMotion(AbstractC1672 r1) {
        if (r1 == null) {
            this.mPathMotion = STRAIGHT_PATH_MOTION;
        } else {
            this.mPathMotion = r1;
        }
    }

    public void setPropagation(AbstractC1630 r1) {
    }

    public AbstractC1647 setSceneRoot(ViewGroup viewGroup) {
        this.mSceneRoot = viewGroup;
        return this;
    }

    public AbstractC1647 setStartDelay(long j) {
        this.mStartDelay = j;
        return this;
    }

    public void start() {
        if (this.mNumInstances == 0) {
            ArrayList<AbstractC1652> arrayList = this.mListeners;
            if (arrayList != null && arrayList.size() > 0) {
                ArrayList arrayList2 = (ArrayList) this.mListeners.clone();
                int size = arrayList2.size();
                for (int i = 0; i < size; i++) {
                    ((AbstractC1652) arrayList2.get(i)).onTransitionStart(this);
                }
            }
            this.mEnded = false;
        }
        this.mNumInstances++;
    }

    public String toString() {
        return toString("");
    }

    public AbstractC1647 addTarget(int i) {
        if (i != 0) {
            this.mTargetIds.add(Integer.valueOf(i));
        }
        return this;
    }

    @Override // java.lang.Object
    public AbstractC1647 clone() {
        try {
            AbstractC1647 r1 = (AbstractC1647) super.clone();
            r1.mAnimators = new ArrayList<>();
            r1.mStartValues = new C1666();
            r1.mEndValues = new C1666();
            r1.mStartValuesList = null;
            r1.mEndValuesList = null;
            return r1;
        } catch (CloneNotSupportedException unused) {
            return null;
        }
    }

    public AbstractC1647 excludeChildren(int i, boolean z) {
        this.mTargetIdChildExcludes = excludeId(this.mTargetIdChildExcludes, i, z);
        return this;
    }

    public AbstractC1647 excludeTarget(int i, boolean z) {
        this.mTargetIdExcludes = excludeId(this.mTargetIdExcludes, i, z);
        return this;
    }

    public AbstractC1647 removeTarget(int i) {
        if (i != 0) {
            this.mTargetIds.remove(Integer.valueOf(i));
        }
        return this;
    }

    public String toString(String str) {
        StringBuilder r7 = C1293.m3416(str);
        r7.append(getClass().getSimpleName());
        r7.append("@");
        r7.append(Integer.toHexString(hashCode()));
        r7.append(": ");
        String sb = r7.toString();
        if (this.mDuration != -1) {
            StringBuilder r72 = C1293.m3402(sb, "dur(");
            r72.append(this.mDuration);
            r72.append(") ");
            sb = r72.toString();
        }
        if (this.mStartDelay != -1) {
            StringBuilder r73 = C1293.m3402(sb, "dly(");
            r73.append(this.mStartDelay);
            r73.append(") ");
            sb = r73.toString();
        }
        if (this.mInterpolator != null) {
            StringBuilder r74 = C1293.m3402(sb, "interp(");
            r74.append(this.mInterpolator);
            r74.append(") ");
            sb = r74.toString();
        }
        if (this.mTargetIds.size() <= 0 && this.mTargets.size() <= 0) {
            return sb;
        }
        String r75 = C1293.m3412(sb, "tgts(");
        if (this.mTargetIds.size() > 0) {
            for (int i = 0; i < this.mTargetIds.size(); i++) {
                if (i > 0) {
                    r75 = C1293.m3412(r75, ", ");
                }
                StringBuilder r76 = C1293.m3416(r75);
                r76.append(this.mTargetIds.get(i));
                r75 = r76.toString();
            }
        }
        if (this.mTargets.size() > 0) {
            for (int i2 = 0; i2 < this.mTargets.size(); i2++) {
                if (i2 > 0) {
                    r75 = C1293.m3412(r75, ", ");
                }
                StringBuilder r77 = C1293.m3416(r75);
                r77.append(this.mTargets.get(i2));
                r75 = r77.toString();
            }
        }
        return C1293.m3412(r75, ")");
    }

    public AbstractC1647 addTarget(String str) {
        if (this.mTargetNames == null) {
            this.mTargetNames = new ArrayList<>();
        }
        this.mTargetNames.add(str);
        return this;
    }

    public AbstractC1647 excludeChildren(Class<?> cls, boolean z) {
        this.mTargetTypeChildExcludes = excludeType(this.mTargetTypeChildExcludes, cls, z);
        return this;
    }

    public AbstractC1647 excludeTarget(String str, boolean z) {
        this.mTargetNameExcludes = excludeObject(this.mTargetNameExcludes, str, z);
        return this;
    }

    public AbstractC1647 removeTarget(String str) {
        ArrayList<String> arrayList = this.mTargetNames;
        if (arrayList != null) {
            arrayList.remove(str);
        }
        return this;
    }

    public AbstractC1647 excludeTarget(Class<?> cls, boolean z) {
        this.mTargetTypeExcludes = excludeType(this.mTargetTypeExcludes, cls, z);
        return this;
    }

    public AbstractC1647 removeTarget(Class<?> cls) {
        ArrayList<Class<?>> arrayList = this.mTargetTypes;
        if (arrayList != null) {
            arrayList.remove(cls);
        }
        return this;
    }

    public AbstractC1647 addTarget(Class<?> cls) {
        if (this.mTargetTypes == null) {
            this.mTargetTypes = new ArrayList<>();
        }
        this.mTargetTypes.add(cls);
        return this;
    }

    @SuppressLint({"RestrictedApi"})
    public AbstractC1647(Context context, AttributeSet attributeSet) {
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, C1668.f5915);
        XmlResourceParser xmlResourceParser = (XmlResourceParser) attributeSet;
        long r3 = (long) C2369.m6277(obtainStyledAttributes, xmlResourceParser, "duration", 1, -1);
        if (r3 >= 0) {
            setDuration(r3);
        }
        long r2 = (long) C2369.m6277(obtainStyledAttributes, xmlResourceParser, "startDelay", 2, -1);
        if (r2 > 0) {
            setStartDelay(r2);
        }
        int r1 = C2369.m6266(obtainStyledAttributes, xmlResourceParser, "interpolator", 0, 0);
        if (r1 > 0) {
            setInterpolator(AnimationUtils.loadInterpolator(context, r1));
        }
        String r9 = C2369.m6315(obtainStyledAttributes, xmlResourceParser, "matchOrder", 3);
        if (r9 != null) {
            setMatchOrder(parseMatchOrder(r9));
        }
        obtainStyledAttributes.recycle();
    }
}
