package ඓ.ῲ.K.ᕣ.ᕣ.ⁱ;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.ImageHeaderParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import ඓ.ῲ.K.ComponentCallbacks2C1161;
import ඓ.ῲ.K.ᓣ.C0845;
import ඓ.ῲ.K.ᓣ.C0847;
import ඓ.ῲ.K.ᕣ.AbstractC0853;
import ඓ.ῲ.K.ᕣ.C1121;
import ඓ.ῲ.K.ᕣ.ᕣ.C0900;
import ඓ.ῲ.K.ᕣ.ᕣ.ⁱ.C0901;
import ඓ.ῲ.K.ᕣ.ᨨ.AbstractC1027;
import ඓ.ῲ.K.ᕣ.ᨨ.ゎ.AbstractC0967;
import ඓ.ῲ.K.ᕣ.ᨨ.ゎ.AbstractC0976;
import ඓ.ῲ.K.㳳.AbstractC1215;
import ඓ.ῲ.K.㳳.C1212;
import ඓ.ῲ.K.㳳.C1213;
import ඓ.ῲ.K.㳳.C1217;
import ඓ.K.K.K.C1293;

/* renamed from: ඓ.ῲ.K.ᕣ.ᕣ.ⁱ.K  reason: contains not printable characters */
/* compiled from: ByteBufferGifDecoder */
public class C0911 implements AbstractC0853<ByteBuffer, C0901> {

    /* renamed from: ⁱ  reason: contains not printable characters */
    public static final C0912 f4193 = new C0912();

    /* renamed from: 㴹  reason: contains not printable characters */
    public static final C0913 f4194 = new C0913();

    /* renamed from: ʬ  reason: contains not printable characters */
    public final C0912 f4195;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final C0905 f4196;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final List<ImageHeaderParser> f4197;

    /* renamed from: K  reason: contains not printable characters */
    public final Context f4198;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final C0913 f4199;

    /* renamed from: ඓ.ῲ.K.ᕣ.ᕣ.ⁱ.K$K  reason: contains not printable characters */
    /* compiled from: ByteBufferGifDecoder */
    public static class C0913 {
        /* renamed from: K  reason: contains not printable characters */
        public AbstractC1215 m2616(AbstractC1215.AbstractC1216 k, C1212 r3, ByteBuffer byteBuffer, int i) {
            return new C1213(k, r3, byteBuffer, i);
        }
    }

    public C0911(Context context, List<ImageHeaderParser> list, AbstractC0976 r5, AbstractC0967 r6) {
        C0912 r0 = f4193;
        C0913 k = f4194;
        this.f4198 = context.getApplicationContext();
        this.f4197 = list;
        this.f4199 = k;
        this.f4196 = new C0905(r5, r6);
        this.f4195 = r0;
    }

    /* Return type fixed from 'ඓ.ῲ.K.ᕣ.ᨨ.䀟' to match base method */
    /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object, int, int, ඓ.ῲ.K.ᕣ.㸾] */
    @Override // ඓ.ῲ.K.ᕣ.AbstractC0853
    /* renamed from: K  reason: contains not printable characters */
    public AbstractC1027<C0901> m2612(ByteBuffer byteBuffer, int i, int i2, C1121 r10) throws IOException {
        ByteBuffer byteBuffer2 = byteBuffer;
        C1217 r7 = this.f4195.m2614(byteBuffer2);
        try {
            return m2611(byteBuffer2, i, i2, r7, r10);
        } finally {
            this.f4195.m2615(r7);
        }
    }

    /* renamed from: ඓ.ῲ.K.ᕣ.ᕣ.ⁱ.K$ῲ  reason: contains not printable characters */
    /* compiled from: ByteBufferGifDecoder */
    public static class C0912 {

        /* renamed from: K  reason: contains not printable characters */
        public final Queue<C1217> f4200 = C0845.m2458(0);

        /* renamed from: K  reason: contains not printable characters */
        public synchronized void m2615(C1217 r2) {
            r2.f4827 = null;
            r2.f4826 = null;
            this.f4200.offer(r2);
        }

        /* renamed from: K  reason: contains not printable characters */
        public synchronized C1217 m2614(ByteBuffer byteBuffer) {
            C1217 poll;
            poll = this.f4200.poll();
            if (poll == null) {
                poll = new C1217();
            }
            poll.f4827 = null;
            Arrays.fill(poll.f4828, (byte) 0);
            poll.f4826 = new C1212();
            poll.f4829 = 0;
            poll.f4827 = byteBuffer.asReadOnlyBuffer();
            poll.f4827.position(0);
            poll.f4827.order(ByteOrder.LITTLE_ENDIAN);
            return poll;
        }
    }

    /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object, ඓ.ῲ.K.ᕣ.㸾] */
    @Override // ඓ.ῲ.K.ᕣ.AbstractC0853
    /* renamed from: K  reason: contains not printable characters */
    public boolean m2613(ByteBuffer byteBuffer, C1121 r7) throws IOException {
        ImageHeaderParser.ImageType imageType;
        ByteBuffer byteBuffer2 = byteBuffer;
        if (((Boolean) r7.m3002(C0904.f4167)).booleanValue()) {
            return false;
        }
        List<ImageHeaderParser> list = this.f4197;
        if (byteBuffer2 == null) {
            imageType = ImageHeaderParser.ImageType.UNKNOWN;
        } else {
            int size = list.size();
            int i = 0;
            while (true) {
                if (i >= size) {
                    imageType = ImageHeaderParser.ImageType.UNKNOWN;
                    break;
                }
                ImageHeaderParser.ImageType r3 = list.get(i).m1268(byteBuffer2);
                if (r3 != ImageHeaderParser.ImageType.UNKNOWN) {
                    imageType = r3;
                    break;
                }
                i++;
            }
        }
        if (imageType == ImageHeaderParser.ImageType.GIF) {
            return true;
        }
        return false;
    }

    /* renamed from: K  reason: contains not printable characters */
    public static int m2610(C1212 r4, int i, int i2) {
        int i3;
        int min = Math.min(r4.f4787 / i2, r4.f4791 / i);
        if (min == 0) {
            i3 = 0;
        } else {
            i3 = Integer.highestOneBit(min);
        }
        int max = Math.max(1, i3);
        if (Log.isLoggable("BufferGifDecoder", 2) && max > 1) {
            Log.v("BufferGifDecoder", "Downsampling GIF, sampleSize: " + max + ", target dimens: [" + i + "x" + i2 + "], actual dimens: [" + r4.f4791 + "x" + r4.f4787 + "]");
        }
        return max;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final C0903 m2611(ByteBuffer byteBuffer, int i, int i2, C1217 r20, C1121 r21) {
        Bitmap.Config config;
        long r4 = C0847.m2463();
        try {
            C1212 r6 = r20.m3281();
            if (r6.f4782 > 0) {
                if (r6.f4786 == 0) {
                    if (r21.m3002(C0904.f4168) == DecodeFormat.PREFER_RGB_565) {
                        config = Bitmap.Config.RGB_565;
                    } else {
                        config = Bitmap.Config.ARGB_8888;
                    }
                    AbstractC1215 r11 = this.f4199.m2616(this.f4196, r6, byteBuffer, m2610(r6, i, i2));
                    C1213 r62 = (C1213) r11;
                    r62.m3277(config);
                    r62.f4801 = (r62.f4801 + 1) % r62.f4806.f4782;
                    Bitmap r15 = r62.m3274();
                    if (r15 == null) {
                        if (Log.isLoggable("BufferGifDecoder", 2)) {
                            StringBuilder r0 = C1293.m3416("Decoded GIF from stream in ");
                            r0.append(C0847.m2462(r4));
                            Log.v("BufferGifDecoder", r0.toString());
                        }
                        return null;
                    }
                    return new C0903(new C0901(new C0901.C0902(new C0906(ComponentCallbacks2C1161.m3105(this.f4198), r11, i, i2, (C0900) C0900.f4154, r15))));
                }
            }
            if (Log.isLoggable("BufferGifDecoder", 2)) {
                StringBuilder r02 = C1293.m3416("Decoded GIF from stream in ");
                r02.append(C0847.m2462(r4));
                Log.v("BufferGifDecoder", r02.toString());
            }
            return null;
        } finally {
            if (Log.isLoggable("BufferGifDecoder", 2)) {
                StringBuilder r2 = C1293.m3416("Decoded GIF from stream in ");
                r2.append(C0847.m2462(r4));
                Log.v("BufferGifDecoder", r2.toString());
            }
        }
    }
}
