package retrofit2.converter.gson;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit2.Converter;
import retrofit2.Retrofit;
import 㿎.AbstractC2632;
import 㿎.AbstractC2651;

public final class GsonConverterFactory extends Converter.Factory {
    public final Gson gson;

    public GsonConverterFactory(Gson gson2) {
        if (gson2 != null) {
            this.gson = gson2;
            return;
        }
        throw new NullPointerException("gson == null");
    }

    public static GsonConverterFactory create() {
        return create(new Gson());
    }

    @Override // retrofit2.Converter.Factory
    public Converter<?, AbstractC2651> requestBodyConverter(Type type, Annotation[] annotationArr, Annotation[] annotationArr2, Retrofit retrofit) {
        return new GsonRequestBodyConverter(this.gson, this.gson.getAdapter(TypeToken.get(type)));
    }

    @Override // retrofit2.Converter.Factory
    public Converter<AbstractC2632, ?> responseBodyConverter(Type type, Annotation[] annotationArr, Retrofit retrofit) {
        return new GsonResponseBodyConverter(this.gson, this.gson.getAdapter(TypeToken.get(type)));
    }

    public static GsonConverterFactory create(Gson gson2) {
        return new GsonConverterFactory(gson2);
    }
}
