package retrofit2;

import okhttp3.Protocol;
import ඓ.K.K.K.C1293;
import 㿎.AbstractC2632;
import 㿎.C2644;
import 㿎.C2667;
import 㿎.C2671;

public final class Response<T> {
    public final T body;
    public final AbstractC2632 errorBody;
    public final C2671 rawResponse;

    public Response(C2671 r1, T t, AbstractC2632 r3) {
        this.rawResponse = r1;
        this.body = t;
        this.errorBody = r3;
    }

    public static <T> Response<T> error(int i, AbstractC2632 r3) {
        if (i >= 400) {
            C2671.C2672 k = new C2671.C2672();
            k.f9095 = i;
            k.f9105 = "Response.error()";
            k.f9099 = Protocol.HTTP_1_1;
            C2644.C2645 k2 = new C2644.C2645();
            k2.m6965("http://localhost/");
            k.f9101 = k2.m6970();
            return error(r3, k.m7010());
        }
        throw new IllegalArgumentException(C1293.m3408("code < 400: ", i));
    }

    public static <T> Response<T> success(T t) {
        C2671.C2672 k = new C2671.C2672();
        k.f9095 = 200;
        k.f9105 = "OK";
        k.f9099 = Protocol.HTTP_1_1;
        C2644.C2645 k2 = new C2644.C2645();
        k2.m6965("http://localhost/");
        k.f9101 = k2.m6970();
        return success(t, k.m7010());
    }

    public T body() {
        return this.body;
    }

    public int code() {
        return this.rawResponse.f9092;
    }

    public AbstractC2632 errorBody() {
        return this.errorBody;
    }

    public C2667 headers() {
        return this.rawResponse.f9088;
    }

    public boolean isSuccessful() {
        return this.rawResponse.m7006();
    }

    public String message() {
        return this.rawResponse.f9084;
    }

    public C2671 raw() {
        return this.rawResponse;
    }

    public String toString() {
        return this.rawResponse.toString();
    }

    public static <T> Response<T> success(T t, C2667 r3) {
        Utils.checkNotNull(r3, "headers == null");
        C2671.C2672 k = new C2671.C2672();
        k.f9095 = 200;
        k.f9105 = "OK";
        k.f9099 = Protocol.HTTP_1_1;
        k.m7008(r3);
        C2644.C2645 k2 = new C2644.C2645();
        k2.m6965("http://localhost/");
        k.f9101 = k2.m6970();
        return success(t, k.m7010());
    }

    public static <T> Response<T> error(AbstractC2632 r2, C2671 r3) {
        Utils.checkNotNull(r2, "body == null");
        Utils.checkNotNull(r3, "rawResponse == null");
        if (!r3.m7006()) {
            return new Response<>(r3, null, r2);
        }
        throw new IllegalArgumentException("rawResponse should not be successful response");
    }

    public static <T> Response<T> success(T t, C2671 r3) {
        Utils.checkNotNull(r3, "rawResponse == null");
        if (r3.m7006()) {
            return new Response<>(r3, t, null);
        }
        throw new IllegalArgumentException("rawResponse must be successful response");
    }
}
