package retrofit2;

import com.facebook.GraphRequest;
import java.io.IOException;
import ඓ.K.K.K.C1293;
import ᨨ.AbstractC1483;
import ᨨ.C1492;
import 㿎.AbstractC2651;
import 㿎.C2531;
import 㿎.C2628;
import 㿎.C2644;
import 㿎.C2649;
import 㿎.C2657;
import 㿎.C2667;

public final class RequestBuilder {
    public static final char[] HEX_DIGITS = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String PATH_SEGMENT_ALWAYS_ENCODE_SET = " \"<>^`{}|\\?#";
    public final C2531 baseUrl;
    public AbstractC2651 body;
    public C2628 contentType;
    public C2649.C2650 formBuilder;
    public final boolean hasBody;
    public final String method;
    public C2657.C2659 multipartBuilder;
    public String relativeUrl;
    public final C2644.C2645 requestBuilder = new C2644.C2645();
    public C2531.C2532 urlBuilder;

    public static class ContentTypeOverridingRequestBody extends AbstractC2651 {
        public final C2628 contentType;
        public final AbstractC2651 delegate;

        public ContentTypeOverridingRequestBody(AbstractC2651 r1, C2628 r2) {
            this.delegate = r1;
            this.contentType = r2;
        }

        @Override // 㿎.AbstractC2651
        public long contentLength() throws IOException {
            return this.delegate.contentLength();
        }

        @Override // 㿎.AbstractC2651
        public C2628 contentType() {
            return this.contentType;
        }

        @Override // 㿎.AbstractC2651
        public void writeTo(AbstractC1483 r2) throws IOException {
            this.delegate.writeTo(r2);
        }
    }

    public RequestBuilder(String str, C2531 r2, String str2, C2667 r4, C2628 r5, boolean z, boolean z2, boolean z3) {
        this.method = str;
        this.baseUrl = r2;
        this.relativeUrl = str2;
        this.contentType = r5;
        this.hasBody = z;
        if (r4 != null) {
            this.requestBuilder.m6969(r4);
        }
        if (z2) {
            this.formBuilder = new C2649.C2650();
        } else if (z3) {
            this.multipartBuilder = new C2657.C2659();
            this.multipartBuilder.m6985(C2657.f9032);
        }
    }

    public static String canonicalizeForPath(String str, boolean z) {
        int length = str.length();
        int i = 0;
        while (i < length) {
            int codePointAt = str.codePointAt(i);
            if (codePointAt < 32 || codePointAt >= 127 || PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(codePointAt) != -1 || (!z && (codePointAt == 47 || codePointAt == 37))) {
                C1492 r3 = new C1492();
                r3.m3793(str, 0, i);
                canonicalizeForPath(r3, str, i, length, z);
                return r3.m3800();
            }
            i += Character.charCount(codePointAt);
        }
        return str;
    }

    public void addFormField(String str, String str2, boolean z) {
        if (z) {
            this.formBuilder.m6977(str, str2);
        } else {
            this.formBuilder.m6978(str, str2);
        }
    }

    public void addHeader(String str, String str2) {
        if (GraphRequest.CONTENT_TYPE_HEADER.equalsIgnoreCase(str)) {
            C2628 r2 = C2628.m6936(str2);
            if (r2 != null) {
                this.contentType = r2;
                return;
            }
            throw new IllegalArgumentException(C1293.m3412("Malformed content type: ", str2));
        }
        this.requestBuilder.f8988.m7002(str, str2);
    }

    public void addPart(C2667 r2, AbstractC2651 r3) {
        this.multipartBuilder.m6987(r2, r3);
    }

    public void addPathParam(String str, String str2, boolean z) {
        String str3 = this.relativeUrl;
        if (str3 != null) {
            this.relativeUrl = str3.replace(C1293.m3413("{", str, "}"), canonicalizeForPath(str2, z));
            return;
        }
        throw new AssertionError();
    }

    public void addQueryParam(String str, String str2, boolean z) {
        String str3 = this.relativeUrl;
        if (str3 != null) {
            this.urlBuilder = this.baseUrl.m6598(str3);
            if (this.urlBuilder != null) {
                this.relativeUrl = null;
            } else {
                StringBuilder r4 = C1293.m3416("Malformed URL. Base: ");
                r4.append(this.baseUrl);
                r4.append(", Relative: ");
                r4.append(this.relativeUrl);
                throw new IllegalArgumentException(r4.toString());
            }
        }
        if (z) {
            this.urlBuilder.m6605(str, str2);
        } else {
            this.urlBuilder.m6603(str, str2);
        }
    }

    public C2644 build() {
        C2531 r0;
        C2531.C2532 k = this.urlBuilder;
        if (k != null) {
            r0 = k.m6607();
        } else {
            C2531.C2532 r02 = this.baseUrl.m6598(this.relativeUrl);
            r0 = r02 != null ? r02.m6607() : null;
            if (r0 == null) {
                StringBuilder r1 = C1293.m3416("Malformed URL. Base: ");
                r1.append(this.baseUrl);
                r1.append(", Relative: ");
                r1.append(this.relativeUrl);
                throw new IllegalArgumentException(r1.toString());
            }
        }
        ContentTypeOverridingRequestBody contentTypeOverridingRequestBody = this.body;
        if (contentTypeOverridingRequestBody == null) {
            C2649.C2650 k2 = this.formBuilder;
            if (k2 != null) {
                contentTypeOverridingRequestBody = new C2649(k2.f9012, k2.f9011);
            } else {
                C2657.C2659 k3 = this.multipartBuilder;
                if (k3 != null) {
                    contentTypeOverridingRequestBody = k3.m6988();
                } else if (this.hasBody) {
                    contentTypeOverridingRequestBody = AbstractC2651.create((C2628) null, new byte[0]);
                }
            }
        }
        C2628 r12 = this.contentType;
        if (r12 != null) {
            if (contentTypeOverridingRequestBody != null) {
                contentTypeOverridingRequestBody = new ContentTypeOverridingRequestBody(contentTypeOverridingRequestBody, r12);
            } else {
                this.requestBuilder.f8988.m7002(GraphRequest.CONTENT_TYPE_HEADER, r12.f8933);
            }
        }
        C2644.C2645 k4 = this.requestBuilder;
        k4.m6968(r0);
        k4.m6967(this.method, contentTypeOverridingRequestBody);
        return k4.m6970();
    }

    public void setBody(AbstractC2651 r1) {
        this.body = r1;
    }

    public void setRelativeUrl(Object obj) {
        this.relativeUrl = obj.toString();
    }

    public void addPart(C2657.C2658 r2) {
        this.multipartBuilder.m6986(r2);
    }

    public static void canonicalizeForPath(C1492 r6, String str, int i, int i2, boolean z) {
        C1492 r0 = null;
        while (i < i2) {
            int codePointAt = str.codePointAt(i);
            if (!z || !(codePointAt == 9 || codePointAt == 10 || codePointAt == 12 || codePointAt == 13)) {
                if (codePointAt < 32 || codePointAt >= 127 || PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(codePointAt) != -1 || (!z && (codePointAt == 47 || codePointAt == 37))) {
                    if (r0 == null) {
                        r0 = new C1492();
                    }
                    r0.m3775(codePointAt);
                    while (!r0.m3802()) {
                        int readByte = r0.readByte() & 255;
                        r6.writeByte(37);
                        r6.writeByte((int) HEX_DIGITS[(readByte >> 4) & 15]);
                        r6.writeByte((int) HEX_DIGITS[readByte & 15]);
                    }
                } else {
                    r6.m3775(codePointAt);
                }
            }
            i += Character.charCount(codePointAt);
        }
    }
}
