package retrofit2;

import java.io.IOException;
import ᨨ.AbstractC1490;
import ᨨ.AbstractC1496;
import ᨨ.C1486;
import ᨨ.C1492;
import 㿎.AbstractC2537;
import 㿎.AbstractC2632;
import 㿎.AbstractC2660;
import 㿎.C2628;
import 㿎.C2642;
import 㿎.C2644;
import 㿎.C2671;

public final class OkHttpCall<T> implements Call<T> {
    public final Object[] args;
    public volatile boolean canceled;
    public Throwable creationFailure;
    public boolean executed;
    public AbstractC2537 rawCall;
    public final ServiceMethod<T, ?> serviceMethod;

    public static final class ExceptionCatchingRequestBody extends AbstractC2632 {
        public final AbstractC2632 delegate;
        public IOException thrownException;

        public ExceptionCatchingRequestBody(AbstractC2632 r1) {
            this.delegate = r1;
        }

        @Override // java.io.Closeable, java.lang.AutoCloseable, 㿎.AbstractC2632
        public void close() {
            this.delegate.close();
        }

        @Override // 㿎.AbstractC2632
        public long contentLength() {
            return this.delegate.contentLength();
        }

        @Override // 㿎.AbstractC2632
        public C2628 contentType() {
            return this.delegate.contentType();
        }

        @Override // 㿎.AbstractC2632
        public AbstractC1496 source() {
            return C1486.m3741(new AbstractC1490(this.delegate.source()) {
                /* class retrofit2.OkHttpCall.ExceptionCatchingRequestBody.AnonymousClass1 */

                @Override // ᨨ.AbstractC1494, ᨨ.AbstractC1490
                public long read(C1492 r1, long j) throws IOException {
                    try {
                        return super.read(r1, j);
                    } catch (IOException e) {
                        ExceptionCatchingRequestBody.this.thrownException = e;
                        throw e;
                    }
                }
            });
        }

        public void throwIfCaught() throws IOException {
            IOException iOException = this.thrownException;
            if (iOException != null) {
                throw iOException;
            }
        }
    }

    public static final class NoContentResponseBody extends AbstractC2632 {
        public final long contentLength;
        public final C2628 contentType;

        public NoContentResponseBody(C2628 r1, long j) {
            this.contentType = r1;
            this.contentLength = j;
        }

        @Override // 㿎.AbstractC2632
        public long contentLength() {
            return this.contentLength;
        }

        @Override // 㿎.AbstractC2632
        public C2628 contentType() {
            return this.contentType;
        }

        @Override // 㿎.AbstractC2632
        public AbstractC1496 source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }

    public OkHttpCall(ServiceMethod<T, ?> serviceMethod2, Object[] objArr) {
        this.serviceMethod = serviceMethod2;
        this.args = objArr;
    }

    private AbstractC2537 createRawCall() throws IOException {
        AbstractC2537 call = this.serviceMethod.toCall(this.args);
        if (call != null) {
            return call;
        }
        throw new NullPointerException("Call.Factory returned null.");
    }

    @Override // retrofit2.Call
    public void cancel() {
        AbstractC2537 r0;
        this.canceled = true;
        synchronized (this) {
            r0 = this.rawCall;
        }
        if (r0 != null) {
            ((C2642) r0).m6956();
        }
    }

    @Override // retrofit2.Call
    public void enqueue(final Callback<T> callback) {
        AbstractC2537 r0;
        Throwable th;
        Utils.checkNotNull(callback, "callback == null");
        synchronized (this) {
            if (!this.executed) {
                this.executed = true;
                r0 = this.rawCall;
                th = this.creationFailure;
                if (r0 == null && th == null) {
                    try {
                        AbstractC2537 createRawCall = createRawCall();
                        this.rawCall = createRawCall;
                        r0 = createRawCall;
                    } catch (Throwable th2) {
                        th = th2;
                        Utils.throwIfFatal(th);
                        this.creationFailure = th;
                    }
                }
            } else {
                throw new IllegalStateException("Already executed.");
            }
        }
        if (th != null) {
            callback.onFailure(this, th);
            return;
        }
        if (this.canceled) {
            ((C2642) r0).m6956();
        }
        ((C2642) r0).m6957(new AbstractC2660() {
            /* class retrofit2.OkHttpCall.AnonymousClass1 */

            private void callFailure(Throwable th) {
                try {
                    callback.onFailure(OkHttpCall.this, th);
                } catch (Throwable th2) {
                    th2.printStackTrace();
                }
            }

            @Override // 㿎.AbstractC2660
            public void onFailure(AbstractC2537 r1, IOException iOException) {
                callFailure(iOException);
            }

            @Override // 㿎.AbstractC2660
            public void onResponse(AbstractC2537 r2, C2671 r3) {
                try {
                    try {
                        callback.onResponse(OkHttpCall.this, OkHttpCall.this.parseResponse(r3));
                    } catch (Throwable th) {
                        th.printStackTrace();
                    }
                } catch (Throwable th2) {
                    callFailure(th2);
                }
            }
        });
    }

    @Override // retrofit2.Call
    public Response<T> execute() throws IOException {
        AbstractC2537 r0;
        synchronized (this) {
            if (!this.executed) {
                this.executed = true;
                if (this.creationFailure == null) {
                    r0 = this.rawCall;
                    if (r0 == null) {
                        try {
                            r0 = createRawCall();
                            this.rawCall = r0;
                        } catch (IOException | Error | RuntimeException e) {
                            Utils.throwIfFatal(e);
                            this.creationFailure = e;
                            throw e;
                        }
                    }
                } else if (this.creationFailure instanceof IOException) {
                    throw ((IOException) this.creationFailure);
                } else if (this.creationFailure instanceof RuntimeException) {
                    throw ((RuntimeException) this.creationFailure);
                } else {
                    throw ((Error) this.creationFailure);
                }
            } else {
                throw new IllegalStateException("Already executed.");
            }
        }
        if (this.canceled) {
            ((C2642) r0).m6956();
        }
        return parseResponse(((C2642) r0).m6955());
    }

    @Override // retrofit2.Call
    public boolean isCanceled() {
        boolean z = true;
        if (this.canceled) {
            return true;
        }
        synchronized (this) {
            if (this.rawCall == null || !((C2642) this.rawCall).m6959()) {
                z = false;
            }
        }
        return z;
    }

    @Override // retrofit2.Call
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    public Response<T> parseResponse(C2671 r6) throws IOException {
        AbstractC2632 r0 = r6.f9093;
        C2671.C2672 k = new C2671.C2672(r6);
        k.f9100 = new NoContentResponseBody(r0.contentType(), r0.contentLength());
        C2671 r62 = k.m7010();
        int i = r62.f9092;
        if (i < 200 || i >= 300) {
            try {
                return Response.error(Utils.buffer(r0), r62);
            } finally {
                r0.close();
            }
        } else if (i == 204 || i == 205) {
            r0.close();
            return Response.success((Object) null, r62);
        } else {
            ExceptionCatchingRequestBody exceptionCatchingRequestBody = new ExceptionCatchingRequestBody(r0);
            try {
                return Response.success(this.serviceMethod.toResponse(exceptionCatchingRequestBody), r62);
            } catch (RuntimeException e) {
                exceptionCatchingRequestBody.throwIfCaught();
                throw e;
            }
        }
    }

    @Override // retrofit2.Call
    public synchronized C2644 request() {
        AbstractC2537 r0 = this.rawCall;
        if (r0 != null) {
            return ((C2642) r0).f8975;
        } else if (this.creationFailure == null) {
            try {
                AbstractC2537 createRawCall = createRawCall();
                this.rawCall = createRawCall;
                return ((C2642) createRawCall).f8975;
            } catch (Error | RuntimeException e) {
                Utils.throwIfFatal(e);
                this.creationFailure = e;
                throw e;
            } catch (IOException e2) {
                this.creationFailure = e2;
                throw new RuntimeException("Unable to create request.", e2);
            }
        } else if (this.creationFailure instanceof IOException) {
            throw new RuntimeException("Unable to create request.", this.creationFailure);
        } else if (this.creationFailure instanceof RuntimeException) {
            throw ((RuntimeException) this.creationFailure);
        } else {
            throw ((Error) this.creationFailure);
        }
    }

    @Override // java.lang.Object, retrofit2.Call
    public OkHttpCall<T> clone() {
        return new OkHttpCall<>(this.serviceMethod, this.args);
    }
}
