package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit2.Converter;
import retrofit2.http.Streaming;
import 㿎.AbstractC2632;
import 㿎.AbstractC2651;

public final class BuiltInConverters extends Converter.Factory {

    public static final class BufferingResponseBodyConverter implements Converter<AbstractC2632, AbstractC2632> {
        public static final BufferingResponseBodyConverter INSTANCE = new BufferingResponseBodyConverter();

        public AbstractC2632 convert(AbstractC2632 r2) throws IOException {
            try {
                return Utils.buffer(r2);
            } finally {
                r2.close();
            }
        }
    }

    public static final class RequestBodyConverter implements Converter<AbstractC2651, AbstractC2651> {
        public static final RequestBodyConverter INSTANCE = new RequestBodyConverter();

        public AbstractC2651 convert(AbstractC2651 r1) {
            return r1;
        }
    }

    public static final class StreamingResponseBodyConverter implements Converter<AbstractC2632, AbstractC2632> {
        public static final StreamingResponseBodyConverter INSTANCE = new StreamingResponseBodyConverter();

        public AbstractC2632 convert(AbstractC2632 r1) {
            return r1;
        }
    }

    public static final class ToStringConverter implements Converter<Object, String> {
        public static final ToStringConverter INSTANCE = new ToStringConverter();

        @Override // retrofit2.Converter
        public String convert(Object obj) {
            return obj.toString();
        }
    }

    public static final class VoidResponseBodyConverter implements Converter<AbstractC2632, Void> {
        public static final VoidResponseBodyConverter INSTANCE = new VoidResponseBodyConverter();

        public Void convert(AbstractC2632 r1) {
            r1.close();
            return null;
        }
    }

    @Override // retrofit2.Converter.Factory
    public Converter<?, AbstractC2651> requestBodyConverter(Type type, Annotation[] annotationArr, Annotation[] annotationArr2, Retrofit retrofit) {
        if (AbstractC2651.class.isAssignableFrom(Utils.getRawType(type))) {
            return RequestBodyConverter.INSTANCE;
        }
        return null;
    }

    @Override // retrofit2.Converter.Factory
    public Converter<AbstractC2632, ?> responseBodyConverter(Type type, Annotation[] annotationArr, Retrofit retrofit) {
        if (type == AbstractC2632.class) {
            if (Utils.isAnnotationPresent(annotationArr, Streaming.class)) {
                return StreamingResponseBodyConverter.INSTANCE;
            }
            return BufferingResponseBodyConverter.INSTANCE;
        } else if (type == Void.class) {
            return VoidResponseBodyConverter.INSTANCE;
        } else {
            return null;
        }
    }
}
