package org.angmarch.views;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.ListView;
import android.widget.PopupWindow;
import androidx.appcompat.widget.AppCompatTextView;
import java.util.Arrays;
import java.util.List;
import ῲ.ᨨ.ῲ.C1806;
import ῲ.㗗.K.K.C2239;
import K.K.K.ʬ.C2369;
import 㳳.K.K.AbstractC2424;
import 㳳.K.K.AbstractC2426;
import 㳳.K.K.AbstractC2429;
import 㳳.K.K.C2423;
import 㳳.K.K.C2425;
import 㳳.K.K.C2428;
import 㳳.K.K.RunnableC2427;

public class NiceSpinner extends AppCompatTextView {

    /* renamed from: ʬ  reason: contains not printable characters */
    public Drawable f3517;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int f3518;

    /* renamed from: ؿ  reason: contains not printable characters */
    public int f3519;

    /* renamed from: ݜ  reason: contains not printable characters */
    public PopUpTextAlignment f3520;

    /* renamed from: ඓ  reason: contains not printable characters */
    public AbstractC2429 f3521;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public AbstractC2426 f3522 = new C2428();

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f3523;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean f3524;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f3525;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public AdapterView.OnItemSelectedListener f3526;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f3527;

    /* renamed from: 㗗  reason: contains not printable characters */
    public int f3528;

    /* renamed from: 㗽  reason: contains not printable characters */
    public AbstractC2426 f3529 = new C2428();

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f3530;

    /* renamed from: 㴹  reason: contains not printable characters */
    public AdapterView.OnItemClickListener f3531;

    /* renamed from: 㸾  reason: contains not printable characters */
    public ListPopupWindow f3532;

    /* renamed from: 㿎  reason: contains not printable characters */
    public AbstractC2424 f3533;

    /* renamed from: 䀟  reason: contains not printable characters */
    public ObjectAnimator f3534 = null;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f3535;

    /* renamed from: org.angmarch.views.NiceSpinner$ῲ  reason: contains not printable characters */
    public class C0587 implements PopupWindow.OnDismissListener {
        public C0587() {
        }

        public void onDismiss() {
            NiceSpinner niceSpinner = NiceSpinner.this;
            if (!niceSpinner.f3524) {
                niceSpinner.m2017(false);
            }
        }
    }

    /* renamed from: org.angmarch.views.NiceSpinner$K  reason: contains not printable characters */
    public class C0588 implements AdapterView.OnItemClickListener {
        public C0588() {
        }

        @Override // android.widget.AdapterView.OnItemClickListener
        public void onItemClick(AdapterView<?> adapterView, View view, int i, long j) {
            NiceSpinner niceSpinner = NiceSpinner.this;
            if (i >= niceSpinner.f3525 && i < niceSpinner.f3521.getCount()) {
                i++;
            }
            NiceSpinner niceSpinner2 = NiceSpinner.this;
            niceSpinner2.f3525 = i;
            AbstractC2424 r1 = niceSpinner2.f3533;
            AdapterView.OnItemClickListener onItemClickListener = niceSpinner2.f3531;
            if (onItemClickListener != null) {
                onItemClickListener.onItemClick(adapterView, view, i, j);
            }
            AdapterView.OnItemSelectedListener onItemSelectedListener = NiceSpinner.this.f3526;
            if (onItemSelectedListener != null) {
                onItemSelectedListener.onItemSelected(adapterView, view, i, j);
            }
            NiceSpinner niceSpinner3 = NiceSpinner.this;
            AbstractC2429 r8 = niceSpinner3.f3521;
            r8.f8375 = i;
            niceSpinner3.setTextInternal(r8.m6485(i));
            NiceSpinner.this.m2013();
        }
    }

    public NiceSpinner(Context context) {
        super(context);
        m2015(context, (AttributeSet) null);
    }

    private int getParentVerticalOffset() {
        int i = this.f3518;
        if (i > 0) {
            return i;
        }
        int[] iArr = new int[2];
        getLocationOnScreen(iArr);
        int i2 = iArr[1];
        this.f3518 = i2;
        return i2;
    }

    private int getPopUpHeight() {
        return Math.max((this.f3535 - getParentVerticalOffset()) - getMeasuredHeight(), getParentVerticalOffset());
    }

    private <T> void setAdapterInternal(AbstractC2429<T> r2) {
        if (r2.getCount() > 0) {
            this.f3525 = 0;
            this.f3532.setAdapter(r2);
            setTextInternal(r2.m6485(this.f3525));
        }
    }

    private void setArrowDrawableOrHide(Drawable drawable) {
        if (this.f3524 || drawable == null) {
            setCompoundDrawablesWithIntrinsicBounds((Drawable) null, (Drawable) null, (Drawable) null, (Drawable) null);
        } else {
            setCompoundDrawablesWithIntrinsicBounds((Drawable) null, (Drawable) null, drawable, (Drawable) null);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void setTextInternal(Object obj) {
        AbstractC2426 r0 = this.f3529;
        if (r0 != null) {
            setText(((C2428) r0).m6484(obj));
        } else {
            setText(obj.toString());
        }
    }

    @Deprecated
    public void addOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.f3531 = onItemClickListener;
    }

    public int getDropDownListPaddingBottom() {
        return this.f3528;
    }

    public AbstractC2424 getOnSpinnerItemSelectedListener() {
        return null;
    }

    public PopUpTextAlignment getPopUpTextAlignment() {
        return this.f3520;
    }

    public int getSelectedIndex() {
        return this.f3525;
    }

    public Object getSelectedItem() {
        return this.f3521.m6485(this.f3525);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        int i = Build.VERSION.SDK_INT;
    }

    public void onDetachedFromWindow() {
        ObjectAnimator objectAnimator = this.f3534;
        if (objectAnimator != null) {
            objectAnimator.cancel();
        }
        super.onDetachedFromWindow();
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            Bundle bundle = (Bundle) parcelable;
            this.f3525 = bundle.getInt("selected_index");
            AbstractC2429 r0 = this.f3521;
            if (r0 != null) {
                setTextInternal(((C2428) this.f3529).m6484(r0.m6485(this.f3525)).toString());
                this.f3521.f8375 = this.f3525;
            }
            if (bundle.getBoolean("is_popup_showing") && this.f3532 != null) {
                post(new RunnableC2427(this));
            }
            this.f3524 = bundle.getBoolean("is_arrow_hidden", false);
            this.f3519 = bundle.getInt("arrow_drawable_res_id");
            parcelable = bundle.getParcelable("instance_state");
        }
        super.onRestoreInstanceState(parcelable);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instance_state", super.onSaveInstanceState());
        bundle.putInt("selected_index", this.f3525);
        bundle.putBoolean("is_arrow_hidden", this.f3524);
        bundle.putInt("arrow_drawable_res_id", this.f3519);
        ListPopupWindow listPopupWindow = this.f3532;
        if (listPopupWindow != null) {
            bundle.putBoolean("is_popup_showing", listPopupWindow.isShowing());
        }
        return bundle;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (isEnabled() && motionEvent.getAction() == 1) {
            if (!this.f3532.isShowing()) {
                m2018();
            } else {
                m2013();
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    public void onVisibilityChanged(View view, int i) {
        super.onVisibilityChanged(view, i);
        this.f3517 = m2014(this.f3527);
        setArrowDrawableOrHide(this.f3517);
    }

    public void setAdapter(ListAdapter listAdapter) {
        this.f3521 = new C2423(getContext(), listAdapter, this.f3530, this.f3523, this.f3522, this.f3520);
        setAdapterInternal(this.f3521);
    }

    public void setArrowDrawable(int i) {
        this.f3519 = i;
        this.f3517 = m2014(R$drawable.arrow);
        setArrowDrawableOrHide(this.f3517);
    }

    public void setArrowTintColor(int i) {
        Drawable drawable = this.f3517;
        if (drawable != null && !this.f3524) {
            int i2 = Build.VERSION.SDK_INT;
            drawable.setTint(i);
        }
    }

    public void setDropDownListPaddingBottom(int i) {
        this.f3528 = i;
    }

    @Deprecated
    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.f3526 = onItemSelectedListener;
    }

    public void setOnSpinnerItemSelectedListener(AbstractC2424 r1) {
    }

    public void setSelectedIndex(int i) {
        AbstractC2429 r0 = this.f3521;
        if (r0 == null) {
            return;
        }
        if (i < 0 || i > r0.getCount()) {
            throw new IllegalArgumentException("Position must be lower than adapter count!");
        }
        AbstractC2429 r02 = this.f3521;
        r02.f8375 = i;
        this.f3525 = i;
        setTextInternal(((C2428) this.f3529).m6484(r02.m6485(i)).toString());
    }

    public void setSelectedTextFormatter(AbstractC2426 r1) {
        this.f3529 = r1;
    }

    public void setSpinnerTextFormatter(AbstractC2426 r1) {
        this.f3522 = r1;
    }

    public void setTintColor(int i) {
        Drawable drawable = this.f3517;
        if (drawable != null && !this.f3524) {
            int r3 = C1806.m4686(getContext(), i);
            int i2 = Build.VERSION.SDK_INT;
            drawable.setTint(r3);
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m2013() {
        if (!this.f3524) {
            m2017(false);
        }
        this.f3532.dismiss();
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m2018() {
        if (!this.f3524) {
            m2017(true);
        }
        this.f3532.setAnchorView(this);
        this.f3532.show();
        ListView listView = this.f3532.getListView();
        if (listView != null) {
            listView.setVerticalScrollBarEnabled(false);
            listView.setHorizontalScrollBarEnabled(false);
            listView.setVerticalFadingEdgeEnabled(false);
            listView.setHorizontalFadingEdgeEnabled(false);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m2015(Context context, AttributeSet attributeSet) {
        Resources resources = getResources();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.NiceSpinner);
        int dimensionPixelSize = resources.getDimensionPixelSize(R$dimen.one_and_a_half_grid_unit);
        setGravity(8388627);
        setPadding(resources.getDimensionPixelSize(R$dimen.three_grid_unit), dimensionPixelSize, dimensionPixelSize, dimensionPixelSize);
        setClickable(true);
        this.f3523 = obtainStyledAttributes.getResourceId(R$styleable.NiceSpinner_backgroundSelector, R$drawable.selector);
        setBackgroundResource(this.f3523);
        int i = R$styleable.NiceSpinner_textTint;
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16842806, typedValue, true);
        TypedArray obtainStyledAttributes2 = context.obtainStyledAttributes(typedValue.data, new int[]{16842806});
        int color = obtainStyledAttributes2.getColor(0, -16777216);
        obtainStyledAttributes2.recycle();
        this.f3530 = obtainStyledAttributes.getColor(i, color);
        setTextColor(this.f3530);
        this.f3532 = new ListPopupWindow(context);
        this.f3532.setOnItemClickListener(new C0588());
        this.f3532.setModal(true);
        this.f3532.setOnDismissListener(new C0587());
        this.f3524 = obtainStyledAttributes.getBoolean(R$styleable.NiceSpinner_hideArrow, false);
        this.f3527 = obtainStyledAttributes.getColor(R$styleable.NiceSpinner_arrowTint, getResources().getColor(17170444));
        this.f3519 = obtainStyledAttributes.getResourceId(R$styleable.NiceSpinner_arrowDrawable, R$drawable.arrow);
        this.f3528 = obtainStyledAttributes.getDimensionPixelSize(R$styleable.NiceSpinner_dropDownListPaddingBottom, 0);
        this.f3520 = PopUpTextAlignment.fromId(obtainStyledAttributes.getInt(R$styleable.NiceSpinner_popupTextAlignment, PopUpTextAlignment.CENTER.ordinal()));
        CharSequence[] textArray = obtainStyledAttributes.getTextArray(R$styleable.NiceSpinner_entries);
        if (textArray != null) {
            m2016(Arrays.asList(textArray));
        }
        obtainStyledAttributes.recycle();
        this.f3535 = getContext().getResources().getDisplayMetrics().heightPixels;
    }

    public void setArrowDrawable(Drawable drawable) {
        this.f3517 = drawable;
        setArrowDrawableOrHide(this.f3517);
    }

    public NiceSpinner(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m2015(context, attributeSet);
    }

    public NiceSpinner(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m2015(context, attributeSet);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Drawable m2014(int i) {
        if (this.f3519 == 0) {
            return null;
        }
        Drawable r0 = C1806.m4683(getContext(), this.f3519);
        if (r0 != null) {
            r0 = C2369.m6273(r0).mutate();
            if (!(i == Integer.MAX_VALUE || i == 0)) {
                int i2 = Build.VERSION.SDK_INT;
                r0.setTint(i);
            }
        }
        return r0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public <T> void m2016(List<T> list) {
        this.f3521 = new C2425(getContext(), list, this.f3530, this.f3523, this.f3522, this.f3520);
        setAdapterInternal(this.f3521);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m2017(boolean z) {
        int i = 10000;
        int i2 = z ? 0 : 10000;
        if (!z) {
            i = 0;
        }
        this.f3534 = ObjectAnimator.ofInt(this.f3517, "level", i2, i);
        this.f3534.setInterpolator(new C2239());
        this.f3534.start();
    }
}
