package okhttp3.internal.publicsuffix;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import ᨨ.C1485;
import ᨨ.C1486;
import ᨨ.C1488;
import 㿎.ሽ.C2540;
import 㿎.ሽ.ᨨ.C2558;

public final class PublicSuffixDatabase {

    /* renamed from: ඓ  reason: contains not printable characters */
    public static final byte[] f3509 = {42};

    /* renamed from: ⁱ  reason: contains not printable characters */
    public static final String[] f3510 = {"*"};

    /* renamed from: 㴹  reason: contains not printable characters */
    public static final String[] f3511 = new String[0];

    /* renamed from: 㿎  reason: contains not printable characters */
    public static final PublicSuffixDatabase f3512 = new PublicSuffixDatabase();

    /* renamed from: ʬ  reason: contains not printable characters */
    public byte[] f3513;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final CountDownLatch f3514 = new CountDownLatch(1);

    /* renamed from: K  reason: contains not printable characters */
    public final AtomicBoolean f3515 = new AtomicBoolean(false);

    /* renamed from: 㸾  reason: contains not printable characters */
    public byte[] f3516;

    /* renamed from: K  reason: contains not printable characters */
    public String m2004(String str) {
        int i;
        int i2;
        if (str != null) {
            String[] split = IDN.toUnicode(str).split("\\.");
            String[] r2 = m2006(split);
            if (split.length == r2.length && r2[0].charAt(0) != '!') {
                return null;
            }
            if (r2[0].charAt(0) == '!') {
                i2 = split.length;
                i = r2.length;
            } else {
                i2 = split.length;
                i = r2.length + 1;
            }
            StringBuilder sb = new StringBuilder();
            String[] split2 = str.split("\\.");
            for (int i3 = i2 - i; i3 < split2.length; i3++) {
                sb.append(split2[i3]);
                sb.append('.');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        throw new NullPointerException("domain == null");
    }

    /* JADX WARNING: Code restructure failed: missing block: B:13:0x002b, code lost:
        if (r0 == false) goto L_0x0047;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:7:0x0016, code lost:
        if (r0 != false) goto L_0x0018;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:8:0x0018, code lost:
        java.lang.Thread.currentThread().interrupt();
     */
    /* JADX WARNING: Removed duplicated region for block: B:56:0x00a7  */
    /* JADX WARNING: Removed duplicated region for block: B:58:0x00bf  */
    /* renamed from: K  reason: contains not printable characters */
    public final String[] m2006(String[] strArr) {
        String str;
        String str2;
        String str3;
        String[] strArr2;
        String[] strArr3;
        int i = 0;
        if (this.f3515.get() || !this.f3515.compareAndSet(false, true)) {
            try {
                this.f3514.await();
            } catch (InterruptedException unused) {
                Thread.currentThread().interrupt();
            }
        } else {
            boolean z = false;
            while (true) {
                try {
                    m2005();
                    break;
                } catch (InterruptedIOException unused2) {
                    z = true;
                } catch (IOException e) {
                    C2558.f8643.m6731(5, "Failed to read public suffix list", e);
                } catch (Throwable th) {
                    if (z) {
                        Thread.currentThread().interrupt();
                    }
                    throw th;
                }
            }
        }
        synchronized (this) {
            if (this.f3513 == null) {
                throw new IllegalStateException("Unable to load publicsuffixes.gz resource from the classpath.");
            }
        }
        byte[][] bArr = new byte[strArr.length][];
        for (int i2 = 0; i2 < strArr.length; i2++) {
            bArr[i2] = strArr[i2].getBytes(C2540.f8566);
        }
        int i3 = 0;
        while (true) {
            if (i3 >= bArr.length) {
                str = null;
                break;
            }
            str = m2003(this.f3513, bArr, i3);
            if (str != null) {
                break;
            }
            i3++;
        }
        if (bArr.length > 1) {
            byte[][] bArr2 = (byte[][]) bArr.clone();
            int i4 = 0;
            while (true) {
                if (i4 >= bArr2.length - 1) {
                    break;
                }
                bArr2[i4] = f3509;
                str2 = m2003(this.f3513, bArr2, i4);
                if (str2 != null) {
                    break;
                }
                i4++;
            }
        }
        str2 = null;
        if (str2 != null) {
            while (true) {
                if (i >= bArr.length - 1) {
                    break;
                }
                str3 = m2003(this.f3516, bArr, i);
                if (str3 != null) {
                    break;
                }
                i++;
            }
            if (str3 == null) {
                return ("!" + str3).split("\\.");
            } else if (str == null && str2 == null) {
                return f3510;
            } else {
                if (str != null) {
                    strArr2 = str.split("\\.");
                } else {
                    strArr2 = f3511;
                }
                if (str2 != null) {
                    strArr3 = str2.split("\\.");
                } else {
                    strArr3 = f3511;
                }
                return strArr2.length > strArr3.length ? strArr2 : strArr3;
            }
        }
        str3 = null;
        if (str3 == null) {
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static String m2003(byte[] bArr, byte[][] bArr2, int i) {
        int i2;
        int i3;
        int i4;
        int length = bArr.length;
        int i5 = 0;
        while (i5 < length) {
            int i6 = (i5 + length) / 2;
            while (i6 > -1 && bArr[i6] != 10) {
                i6--;
            }
            int i7 = i6 + 1;
            int i8 = 1;
            while (true) {
                i2 = i7 + i8;
                if (bArr[i2] == 10) {
                    break;
                }
                i8++;
            }
            int i9 = i2 - i7;
            int i10 = i;
            boolean z = false;
            int i11 = 0;
            int i12 = 0;
            while (true) {
                if (z) {
                    z = false;
                    i3 = 46;
                } else {
                    i3 = bArr2[i10][i11] & 255;
                }
                i4 = i3 - (bArr[i7 + i12] & 255);
                if (i4 == 0) {
                    i12++;
                    i11++;
                    if (i12 == i9) {
                        break;
                    } else if (bArr2[i10].length == i11) {
                        if (i10 == bArr2.length - 1) {
                            break;
                        }
                        i10++;
                        z = true;
                        i11 = -1;
                    }
                } else {
                    break;
                }
            }
            if (i4 >= 0) {
                if (i4 <= 0) {
                    int i13 = i9 - i12;
                    int length2 = bArr2[i10].length - i11;
                    while (true) {
                        i10++;
                        if (i10 >= bArr2.length) {
                            break;
                        }
                        length2 += bArr2[i10].length;
                    }
                    if (length2 >= i13) {
                        if (length2 <= i13) {
                            return new String(bArr, i7, i9, C2540.f8566);
                        }
                    }
                }
                i5 = i2 + 1;
            }
            length = i7 - 1;
        }
        return null;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m2005() throws IOException {
        InputStream resourceAsStream = PublicSuffixDatabase.class.getResourceAsStream("publicsuffixes.gz");
        if (resourceAsStream != null) {
            C1488 r0 = new C1488(new C1485(C1486.m3739(resourceAsStream)));
            try {
                byte[] bArr = new byte[r0.readInt()];
                r0.m3754(bArr);
                byte[] bArr2 = new byte[r0.readInt()];
                r0.m3754(bArr2);
                synchronized (this) {
                    this.f3513 = bArr;
                    this.f3516 = bArr2;
                }
                this.f3514.countDown();
            } finally {
                C2540.m6651(r0);
            }
        }
    }
}
