package it.sephiroth.android.library.imagezoom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import ⁱ.K.K.K.ῲ.ῲ.AbstractC2351;
import ⁱ.K.K.K.ῲ.K.C2353;
import ⁱ.K.K.K.K.C2354;

public abstract class ImageViewTouchBase extends ImageView implements AbstractC2351 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public Matrix f3464;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public final float[] f3465;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public RectF f3466;

    /* renamed from: ؿ  reason: contains not printable characters */
    public int f3467;

    /* renamed from: ݜ  reason: contains not printable characters */
    public boolean f3468;

    /* renamed from: ඓ  reason: contains not printable characters */
    public Matrix f3469;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public RectF f3470;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public PointF f3471;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public boolean f3472;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public float f3473;

    /* renamed from: ῲ  reason: contains not printable characters */
    public C2354 f3474;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public Runnable f3475;

    /* renamed from: 㑃  reason: contains not printable characters */
    public boolean f3476;

    /* renamed from: 㗗  reason: contains not printable characters */
    public int f3477;

    /* renamed from: 㗽  reason: contains not printable characters */
    public DisplayType f3478;

    /* renamed from: 㳳  reason: contains not printable characters */
    public float f3479;

    /* renamed from: 㴹  reason: contains not printable characters */
    public Handler f3480;

    /* renamed from: 㶋  reason: contains not printable characters */
    public RectF f3481;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Matrix f3482;

    /* renamed from: 㿎  reason: contains not printable characters */
    public boolean f3483;

    /* renamed from: 䀟  reason: contains not printable characters */
    public boolean f3484;

    /* renamed from: 䁗  reason: contains not printable characters */
    public final Matrix f3485;

    public enum DisplayType {
        NONE,
        FIT_TO_SCREEN,
        FIT_IF_BIGGER
    }

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouchBase$ʬ  reason: contains not printable characters */
    public class RunnableC0582 implements Runnable {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final /* synthetic */ long f3487;

        /* renamed from: ඓ  reason: contains not printable characters */
        public final /* synthetic */ float f3488;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final /* synthetic */ float f3489;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public final /* synthetic */ float f3490;

        /* renamed from: 㴹  reason: contains not printable characters */
        public final /* synthetic */ float f3491;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final /* synthetic */ float f3492;

        public RunnableC0582(float f, long j, float f2, float f3, float f4, float f5) {
            this.f3489 = f;
            this.f3487 = j;
            this.f3492 = f2;
            this.f3488 = f3;
            this.f3491 = f4;
            this.f3490 = f5;
        }

        public void run() {
            float min = Math.min(this.f3489, (float) (System.currentTimeMillis() - this.f3487));
            ImageViewTouchBase.this.m1979(this.f3488 + ((float) ImageViewTouchBase.this.f3474.m6173((double) min, 0.0d, (double) this.f3492, (double) this.f3489)), this.f3491, this.f3490);
            if (min < this.f3489) {
                ImageViewTouchBase.this.f3480.post(this);
                return;
            }
            ImageViewTouchBase imageViewTouchBase = ImageViewTouchBase.this;
            imageViewTouchBase.m1989(imageViewTouchBase.getScale());
            ImageViewTouchBase.this.m2001(true, true);
        }
    }

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouchBase$ඓ  reason: contains not printable characters */
    public interface AbstractC0583 {
    }

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouchBase$ῲ  reason: contains not printable characters */
    public class RunnableC0584 implements Runnable {

        /* renamed from: ʬ  reason: contains not printable characters */
        public double f3494 = 0.0d;

        /* renamed from: ඓ  reason: contains not printable characters */
        public final /* synthetic */ long f3495;

        /* renamed from: ῲ  reason: contains not printable characters */
        public double f3496 = 0.0d;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public final /* synthetic */ double f3497;

        /* renamed from: 㴹  reason: contains not printable characters */
        public final /* synthetic */ double f3498;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final /* synthetic */ double f3499;

        public RunnableC0584(double d, long j, double d2, double d3) {
            this.f3499 = d;
            this.f3495 = j;
            this.f3498 = d2;
            this.f3497 = d3;
        }

        public void run() {
            double min = Math.min(this.f3499, (double) (System.currentTimeMillis() - this.f3495));
            double r2 = ImageViewTouchBase.this.f3474.m6172(min, 0.0d, this.f3498, this.f3499);
            double r4 = ImageViewTouchBase.this.f3474.m6172(min, 0.0d, this.f3497, this.f3499);
            ImageViewTouchBase.this.m1988(r2 - this.f3496, r4 - this.f3494);
            this.f3496 = r2;
            this.f3494 = r4;
            if (min < this.f3499) {
                ImageViewTouchBase.this.f3480.post(this);
                return;
            }
            ImageViewTouchBase imageViewTouchBase = ImageViewTouchBase.this;
            RectF r0 = imageViewTouchBase.m1987(imageViewTouchBase.f3482, true, true);
            if (r0.left != 0.0f || r0.top != 0.0f) {
                ImageViewTouchBase.this.m1978(r0.left, r0.top);
            }
        }
    }

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouchBase$K  reason: contains not printable characters */
    public class RunnableC0585 implements Runnable {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final /* synthetic */ Matrix f3501;

        /* renamed from: ඓ  reason: contains not printable characters */
        public final /* synthetic */ float f3502;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final /* synthetic */ Drawable f3503;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final /* synthetic */ float f3505;

        public RunnableC0585(Drawable drawable, Matrix matrix, float f, float f2) {
            this.f3503 = drawable;
            this.f3501 = matrix;
            this.f3505 = f;
            this.f3502 = f2;
        }

        public void run() {
            ImageViewTouchBase.this.m1982(this.f3503, this.f3501, this.f3505, this.f3502);
        }
    }

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouchBase$㸾  reason: contains not printable characters */
    public interface AbstractC0586 {
    }

    public ImageViewTouchBase(Context context) {
        this(context, null);
    }

    public float getBaseScale() {
        return m1971(this.f3464);
    }

    public RectF getBitmapRect() {
        return m1986(this.f3482);
    }

    public PointF getCenter() {
        return this.f3471;
    }

    public Matrix getDisplayMatrix() {
        return new Matrix(this.f3482);
    }

    public DisplayType getDisplayType() {
        return this.f3478;
    }

    public Matrix getImageViewMatrix() {
        return m1976(this.f3482);
    }

    public float getMaxScale() {
        if (this.f3473 == -1.0f) {
            this.f3473 = m1983();
        }
        return this.f3473;
    }

    public float getMinScale() {
        if (this.f3479 == -1.0f) {
            this.f3479 = m1975();
        }
        return this.f3479;
    }

    @SuppressLint({"Override"})
    public float getRotation() {
        return 0.0f;
    }

    public float getScale() {
        return m1971(this.f3482);
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        int i6;
        float f;
        super.onLayout(z, i, i2, i3, i4);
        if (z) {
            int i7 = this.f3477;
            int i8 = this.f3467;
            this.f3477 = i3 - i;
            this.f3467 = i4 - i2;
            int i9 = this.f3477;
            i6 = i9 - i7;
            int i10 = this.f3467;
            i5 = i10 - i8;
            PointF pointF = this.f3471;
            pointF.x = ((float) i9) / 2.0f;
            pointF.y = ((float) i10) / 2.0f;
        } else {
            i6 = 0;
            i5 = 0;
        }
        Runnable runnable = this.f3475;
        if (runnable != null) {
            this.f3475 = null;
            runnable.run();
        }
        Drawable drawable = getDrawable();
        if (drawable == null) {
            if (this.f3484) {
                m1981(drawable);
            }
            if (z || this.f3484 || this.f3468) {
                m1980(i, i2, i3, i4);
            }
            if (this.f3484) {
                this.f3484 = false;
            }
            if (this.f3468) {
                this.f3468 = false;
            }
        } else if (z || this.f3468 || this.f3484) {
            m1985(this.f3478);
            float r10 = m1971(this.f3464);
            float scale = getScale();
            float f2 = 1.0f;
            float min = Math.min(1.0f, 1.0f / r10);
            m1999(drawable, this.f3464);
            float r14 = m1971(this.f3464);
            if (this.f3484 || this.f3468) {
                Matrix matrix = this.f3469;
                if (matrix != null) {
                    this.f3482.set(matrix);
                    this.f3469 = null;
                    f = getScale();
                } else {
                    this.f3482.reset();
                    f = m1985(this.f3478);
                }
                f2 = f;
                setImageMatrix(getImageViewMatrix());
                if (f2 != getScale()) {
                    m1977(f2);
                }
            } else if (z) {
                if (!this.f3476) {
                    this.f3479 = -1.0f;
                }
                if (!this.f3472) {
                    this.f3473 = -1.0f;
                }
                setImageMatrix(getImageViewMatrix());
                m1990((float) (-i6), (float) (-i5));
                if (!this.f3483) {
                    f2 = m1985(this.f3478);
                    m1977(f2);
                } else {
                    if (((double) Math.abs(scale - min)) > 0.001d) {
                        f2 = (r10 / r14) * scale;
                    }
                    m1977(f2);
                }
            }
            this.f3483 = false;
            if (f2 > getMaxScale() || f2 < getMinScale()) {
                m1977(f2);
            }
            m2001(true, true);
            if (this.f3484) {
                m1981(drawable);
            }
            if (z || this.f3484 || this.f3468) {
                m1980(i, i2, i3, i4);
            }
            if (this.f3468) {
                this.f3468 = false;
            }
            if (this.f3484) {
                this.f3484 = false;
            }
        }
    }

    public void setDisplayType(DisplayType displayType) {
        if (displayType != this.f3478) {
            this.f3483 = false;
            this.f3478 = displayType;
            this.f3468 = true;
            requestLayout();
        }
    }

    public void setImageBitmap(Bitmap bitmap) {
        m1996(bitmap, (Matrix) null, -1.0f, -1.0f);
    }

    public void setImageDrawable(Drawable drawable) {
        m1982(drawable, (Matrix) null, -1.0f, -1.0f);
    }

    public void setImageMatrix(Matrix matrix) {
        Matrix imageMatrix = getImageMatrix();
        boolean z = (matrix == null && !imageMatrix.isIdentity()) || (matrix != null && !imageMatrix.equals(matrix));
        super.setImageMatrix(matrix);
        if (z) {
            m1972();
        }
    }

    public void setImageResource(int i) {
        setImageDrawable(getContext().getResources().getDrawable(i));
    }

    public void setMaxScale(float f) {
        this.f3473 = f;
    }

    public void setMinScale(float f) {
        this.f3479 = f;
    }

    public void setOnDrawableChangedListener(AbstractC0586 r1) {
    }

    public void setOnLayoutChangeListener(AbstractC0583 r1) {
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == ImageView.ScaleType.MATRIX) {
            super.setScaleType(scaleType);
        } else {
            Log.w("ImageViewTouchBase", "Unsupported scaletype. Only MATRIX can be used");
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public float m1971(Matrix matrix) {
        return m1984(matrix, 0);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m1972() {
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public void m1974() {
        this.f3482 = new Matrix();
        float r0 = m1985(this.f3478);
        setImageMatrix(getImageViewMatrix());
        if (r0 != getScale()) {
            m1977(r0);
        }
        postInvalidate();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1982(Drawable drawable, Matrix matrix, float f, float f2) {
        if (getWidth() <= 0) {
            this.f3475 = new RunnableC0585(drawable, matrix, f, f2);
        } else {
            m2000(drawable, matrix, f, f2);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1989(float f) {
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1994(int i, int i2, int i3, int i4) {
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1995(Context context, AttributeSet attributeSet, int i) {
        setScaleType(ImageView.ScaleType.MATRIX);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1998(Drawable drawable) {
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m2002() {
    }

    public ImageViewTouchBase(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m1973(float f, float f2) {
        PointF center = getCenter();
        m1993(f, center.x, center.y, f2);
    }

    /* renamed from: K  reason: contains not printable characters */
    public float m1985(DisplayType displayType) {
        if (displayType == DisplayType.FIT_TO_SCREEN) {
            return 1.0f;
        }
        if (displayType == DisplayType.FIT_IF_BIGGER) {
            return Math.min(1.0f, 1.0f / m1971(this.f3464));
        }
        return 1.0f / m1971(this.f3464);
    }

    public ImageViewTouchBase(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f3474 = new C2354();
        this.f3464 = new Matrix();
        this.f3482 = new Matrix();
        this.f3480 = new Handler();
        this.f3475 = null;
        this.f3483 = false;
        this.f3473 = -1.0f;
        this.f3479 = -1.0f;
        this.f3485 = new Matrix();
        this.f3465 = new float[9];
        this.f3477 = -1;
        this.f3467 = -1;
        this.f3471 = new PointF();
        this.f3478 = DisplayType.NONE;
        this.f3466 = new RectF();
        this.f3481 = new RectF();
        this.f3470 = new RectF();
        m1995(context, attributeSet, i);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1981(Drawable drawable) {
        m1998(drawable);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1980(int i, int i2, int i3, int i4) {
        m1994(i, i2, i3, i4);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public float m1975() {
        if (getDrawable() == null) {
            return 1.0f;
        }
        return Math.min(1.0f, 1.0f / m1971(this.f3464));
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1996(Bitmap bitmap, Matrix matrix, float f, float f2) {
        if (bitmap != null) {
            m1982(new C2353(bitmap), matrix, f, f2);
        } else {
            m1982((Drawable) null, matrix, f, f2);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m2000(Drawable drawable, Matrix matrix, float f, float f2) {
        if (drawable != null) {
            super.setImageDrawable(drawable);
        } else {
            this.f3464.reset();
            super.setImageDrawable(null);
        }
        if (f == -1.0f || f2 == -1.0f) {
            this.f3479 = -1.0f;
            this.f3473 = -1.0f;
            this.f3476 = false;
            this.f3472 = false;
        } else {
            float min = Math.min(f, f2);
            float max = Math.max(min, f2);
            this.f3479 = min;
            this.f3473 = max;
            this.f3476 = true;
            this.f3472 = true;
            DisplayType displayType = this.f3478;
            if (displayType == DisplayType.FIT_TO_SCREEN || displayType == DisplayType.FIT_IF_BIGGER) {
                if (this.f3479 >= 1.0f) {
                    this.f3476 = false;
                    this.f3479 = -1.0f;
                }
                if (this.f3473 <= 1.0f) {
                    this.f3472 = true;
                    this.f3473 = -1.0f;
                }
            }
        }
        if (matrix != null) {
            this.f3469 = new Matrix(matrix);
        }
        this.f3484 = true;
        requestLayout();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public Matrix m1976(Matrix matrix) {
        this.f3485.set(this.f3464);
        this.f3485.postConcat(matrix);
        return this.f3485;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1977(float f) {
        if (f > getMaxScale()) {
            f = getMaxScale();
        }
        if (f < getMinScale()) {
            f = getMinScale();
        }
        PointF center = getCenter();
        m1979(f, center.x, center.y);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1979(float f, float f2, float f3) {
        if (f > getMaxScale()) {
            f = getMaxScale();
        }
        m1992(f / getScale(), f2, f3);
        getScale();
        m2002();
        m2001(true, true);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1978(float f, float f2) {
        m1988((double) f, (double) f2);
    }

    /* renamed from: K  reason: contains not printable characters */
    public float m1983() {
        Drawable drawable = getDrawable();
        if (drawable == null) {
            return 1.0f;
        }
        return Math.max(((float) drawable.getIntrinsicWidth()) / ((float) this.f3477), ((float) drawable.getIntrinsicHeight()) / ((float) this.f3467)) * 8.0f;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1999(Drawable drawable, Matrix matrix) {
        float f = (float) this.f3477;
        float f2 = (float) this.f3467;
        float intrinsicWidth = (float) drawable.getIntrinsicWidth();
        float intrinsicHeight = (float) drawable.getIntrinsicHeight();
        matrix.reset();
        if (intrinsicWidth > f || intrinsicHeight > f2) {
            float min = Math.min(f / intrinsicWidth, f2 / intrinsicHeight);
            matrix.postScale(min, min);
            matrix.postTranslate((f - (intrinsicWidth * min)) / 2.0f, (f2 - (intrinsicHeight * min)) / 2.0f);
            return;
        }
        float min2 = Math.min(f / intrinsicWidth, f2 / intrinsicHeight);
        matrix.postScale(min2, min2);
        matrix.postTranslate((f - (intrinsicWidth * min2)) / 2.0f, (f2 - (intrinsicHeight * min2)) / 2.0f);
    }

    /* renamed from: K  reason: contains not printable characters */
    public float m1984(Matrix matrix, int i) {
        matrix.getValues(this.f3465);
        return this.f3465[i];
    }

    /* renamed from: K  reason: contains not printable characters */
    public RectF m1986(Matrix matrix) {
        Drawable drawable = getDrawable();
        if (drawable == null) {
            return null;
        }
        Matrix r5 = m1976(matrix);
        this.f3466.set(0.0f, 0.0f, (float) drawable.getIntrinsicWidth(), (float) drawable.getIntrinsicHeight());
        r5.mapRect(this.f3466);
        return this.f3466;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m2001(boolean z, boolean z2) {
        if (getDrawable() != null) {
            RectF r2 = m1987(this.f3482, z, z2);
            if (r2.left != 0.0f || r2.top != 0.0f) {
                m1990(r2.left, r2.top);
            }
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:25:0x005e, code lost:
        if (r7 < r8) goto L_0x004f;
     */
    /* JADX WARNING: Removed duplicated region for block: B:17:0x0044  */
    /* renamed from: K  reason: contains not printable characters */
    public RectF m1987(Matrix matrix, boolean z, boolean z2) {
        float f;
        float f2;
        float f3;
        if (getDrawable() == null) {
            return new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.f3481.set(0.0f, 0.0f, 0.0f, 0.0f);
        RectF r7 = m1986(matrix);
        float height = r7.height();
        float width = r7.width();
        if (z2) {
            int i = this.f3467;
            float f4 = (float) i;
            if (height < f4) {
                f = ((f4 - height) / 2.0f) - r7.top;
            } else {
                float f5 = r7.top;
                if (f5 > 0.0f) {
                    f = -f5;
                } else {
                    float f6 = r7.bottom;
                    if (f6 < f4) {
                        f = ((float) i) - f6;
                    }
                }
            }
            if (z) {
                float f7 = (float) this.f3477;
                if (width < f7) {
                    f7 = (f7 - width) / 2.0f;
                    f3 = r7.left;
                } else {
                    float f8 = r7.left;
                    if (f8 > 0.0f) {
                        f2 = -f8;
                        this.f3481.set(f2, f, 0.0f, 0.0f);
                        return this.f3481;
                    }
                    f3 = r7.right;
                }
                f2 = f7 - f3;
                this.f3481.set(f2, f, 0.0f, 0.0f);
                return this.f3481;
            }
            f2 = 0.0f;
            this.f3481.set(f2, f, 0.0f, 0.0f);
            return this.f3481;
        }
        f = 0.0f;
        if (z) {
        }
        f2 = 0.0f;
        this.f3481.set(f2, f, 0.0f, 0.0f);
        return this.f3481;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1990(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            this.f3482.postTranslate(f, f2);
            setImageMatrix(getImageViewMatrix());
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1992(float f, float f2, float f3) {
        this.f3482.postScale(f, f, f2, f3);
        setImageMatrix(getImageViewMatrix());
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1988(double d, double d2) {
        RectF bitmapRect = getBitmapRect();
        this.f3470.set((float) d, (float) d2, 0.0f, 0.0f);
        m1997(bitmapRect, this.f3470);
        RectF rectF = this.f3470;
        m1990(rectF.left, rectF.top);
        m2001(true, true);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1997(RectF rectF, RectF rectF2) {
        if (rectF != null) {
            if (rectF.top >= 0.0f && rectF.bottom <= ((float) this.f3467)) {
                rectF2.top = 0.0f;
            }
            if (rectF.left >= 0.0f && rectF.right <= ((float) this.f3477)) {
                rectF2.left = 0.0f;
            }
            float f = rectF.top;
            if (rectF2.top + f >= 0.0f && rectF.bottom > ((float) this.f3467)) {
                rectF2.top = (float) ((int) (0.0f - f));
            }
            float f2 = rectF.bottom;
            int i = this.f3467;
            if (rectF2.top + f2 <= ((float) (i + 0)) && rectF.top < 0.0f) {
                rectF2.top = (float) ((int) (((float) (i + 0)) - f2));
            }
            float f3 = rectF.left;
            if (rectF2.left + f3 >= 0.0f) {
                rectF2.left = (float) ((int) (0.0f - f3));
            }
            float f4 = rectF.right;
            int i2 = this.f3477;
            if (rectF2.left + f4 <= ((float) (i2 + 0))) {
                rectF2.left = (float) ((int) (((float) (i2 + 0)) - f4));
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1991(float f, float f2, double d) {
        this.f3480.post(new RunnableC0584(d, System.currentTimeMillis(), (double) f, (double) f2));
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1993(float f, float f2, float f3, float f4) {
        if (f > getMaxScale()) {
            f = getMaxScale();
        }
        long currentTimeMillis = System.currentTimeMillis();
        float scale = getScale();
        Matrix matrix = new Matrix(this.f3482);
        matrix.postScale(f, f, f2, f3);
        RectF r0 = m1987(matrix, true, true);
        this.f3480.post(new RunnableC0582(f4, currentTimeMillis, f - scale, scale, (r0.left * f) + f2, (r0.top * f) + f3));
    }
}
