package it.sephiroth.android.library.imagezoom;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewConfiguration;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import ඓ.ᨨ.K.ඓ.㸾.C0793;
import ඓ.ᨨ.K.㴹.AbstractC0807;
import ඓ.K.K.K.C1293;

public class ImageViewTouch extends ImageViewTouchBase {

    /* renamed from: ᆯ  reason: contains not printable characters */
    public boolean f3450;

    /* renamed from: ሽ  reason: contains not printable characters */
    public AbstractC0579 f3451;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public GestureDetector f3452;

    /* renamed from: ᑾ  reason: contains not printable characters */
    public AbstractC0578 f3453;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public boolean f3454;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public boolean f3455;

    /* renamed from: ゎ  reason: contains not printable characters */
    public float f3456;

    /* renamed from: ト  reason: contains not printable characters */
    public int f3457;

    /* renamed from: 㮔  reason: contains not printable characters */
    public GestureDetector.OnGestureListener f3458;

    /* renamed from: 㴪  reason: contains not printable characters */
    public ScaleGestureDetector f3459;

    /* renamed from: 䃖  reason: contains not printable characters */
    public ScaleGestureDetector.OnScaleGestureListener f3460;

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouch$ʬ  reason: contains not printable characters */
    public interface AbstractC0578 {
    }

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouch$ῲ  reason: contains not printable characters */
    public interface AbstractC0579 {
    }

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouch$K  reason: contains not printable characters */
    public class C0580 extends GestureDetector.SimpleOnGestureListener {
        public C0580() {
        }

        public boolean onDoubleTap(MotionEvent motionEvent) {
            StringBuilder r0 = C1293.m3416("onDoubleTap. double tap enabled? ");
            r0.append(ImageViewTouch.this.f3454);
            Log.i("ImageViewTouchBase", r0.toString());
            ImageViewTouch imageViewTouch = ImageViewTouch.this;
            if (imageViewTouch.f3454) {
                imageViewTouch.f3483 = true;
                float scale = imageViewTouch.getScale();
                ImageViewTouch imageViewTouch2 = ImageViewTouch.this;
                ImageViewTouch.this.m1993(Math.min(ImageViewTouch.this.getMaxScale(), Math.max(imageViewTouch2.m1969(scale, imageViewTouch2.getMaxScale()), ImageViewTouch.this.getMinScale())), motionEvent.getX(), motionEvent.getY(), 200.0f);
                ImageViewTouch.this.invalidate();
            }
            AbstractC0579 r02 = ImageViewTouch.this.f3451;
            return super.onDoubleTap(motionEvent);
        }

        public boolean onDown(MotionEvent motionEvent) {
            return ImageViewTouch.this.m1968();
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            if (ImageViewTouch.this.f3455 && motionEvent.getPointerCount() <= 1 && motionEvent2.getPointerCount() <= 1 && !ImageViewTouch.this.f3459.isInProgress() && ImageViewTouch.this.getScale() != 1.0f) {
                return ImageViewTouch.this.m1967(motionEvent, motionEvent2, f, f2);
            }
            return false;
        }

        public void onLongPress(MotionEvent motionEvent) {
            if (ImageViewTouch.this.isLongClickable() && !ImageViewTouch.this.f3459.isInProgress()) {
                ImageViewTouch.this.setPressed(true);
                ImageViewTouch.this.performLongClick();
            }
        }

        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            if (ImageViewTouch.this.f3455 && motionEvent != null && motionEvent2 != null && motionEvent.getPointerCount() <= 1 && motionEvent2.getPointerCount() <= 1 && !ImageViewTouch.this.f3459.isInProgress()) {
                return ImageViewTouch.this.m1960(f, f2);
            }
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            AbstractC0807 r1;
            AbstractC0578 r12 = ImageViewTouch.this.f3453;
            if (!(r12 == null || (r1 = C0793.this.f3987) == null)) {
                r1.m2396();
            }
            return ImageViewTouch.this.m1962();
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return ImageViewTouch.this.m1970();
        }
    }

    /* renamed from: it.sephiroth.android.library.imagezoom.ImageViewTouch$㸾  reason: contains not printable characters */
    public class C0581 extends ScaleGestureDetector.SimpleOnScaleGestureListener {

        /* renamed from: K  reason: contains not printable characters */
        public boolean f3463 = false;

        public C0581() {
        }

        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            float currentSpan = scaleGestureDetector.getCurrentSpan() - scaleGestureDetector.getPreviousSpan();
            float scaleFactor = scaleGestureDetector.getScaleFactor() * ImageViewTouch.this.getScale();
            ImageViewTouch imageViewTouch = ImageViewTouch.this;
            if (imageViewTouch.f3450) {
                if (this.f3463 && currentSpan != 0.0f) {
                    imageViewTouch.f3483 = true;
                    ImageViewTouch.this.m1979(Math.min(imageViewTouch.getMaxScale(), Math.max(scaleFactor, ImageViewTouch.this.getMinScale() - 0.1f)), scaleGestureDetector.getFocusX(), scaleGestureDetector.getFocusY());
                    ImageViewTouch imageViewTouch2 = ImageViewTouch.this;
                    imageViewTouch2.f3457 = 1;
                    imageViewTouch2.invalidate();
                    return true;
                } else if (!this.f3463) {
                    this.f3463 = true;
                }
            }
            return true;
        }
    }

    public ImageViewTouch(Context context) {
        super(context);
        this.f3454 = true;
        this.f3450 = true;
        this.f3455 = true;
    }

    public boolean getDoubleTapEnabled() {
        return this.f3454;
    }

    public GestureDetector.OnGestureListener getGestureListener() {
        return new C0580();
    }

    public ScaleGestureDetector.OnScaleGestureListener getScaleListener() {
        return new C0581();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.f3459.onTouchEvent(motionEvent);
        if (!this.f3459.isInProgress()) {
            this.f3452.onTouchEvent(motionEvent);
        }
        if ((motionEvent.getAction() & BaseProgressIndicator.MAX_ALPHA) != 1) {
            return true;
        }
        return m1961();
    }

    public void setDoubleTapEnabled(boolean z) {
        this.f3454 = z;
    }

    public void setDoubleTapListener(AbstractC0579 r1) {
    }

    public void setScaleEnabled(boolean z) {
        this.f3450 = z;
    }

    public void setScrollEnabled(boolean z) {
        this.f3455 = z;
    }

    public void setSingleTapListener(AbstractC0578 r1) {
        this.f3453 = r1;
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m1960(float f, float f2) {
        if (getScale() == 1.0f) {
            return false;
        }
        this.f3483 = true;
        m1978(-f, -f2);
        invalidate();
        return true;
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean m1961() {
        if (getScale() >= getMinScale()) {
            return true;
        }
        m1973(getMinScale(), 50.0f);
        return true;
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public boolean m1962() {
        return true;
    }

    @Override // it.sephiroth.android.library.imagezoom.ImageViewTouchBase
    /* renamed from: K  reason: contains not printable characters */
    public void m1964(Context context, AttributeSet attributeSet, int i) {
        super.m1995(context, attributeSet, i);
        ViewConfiguration.get(getContext()).getScaledTouchSlop();
        this.f3458 = getGestureListener();
        this.f3460 = getScaleListener();
        this.f3459 = new ScaleGestureDetector(getContext(), this.f3460);
        this.f3452 = new GestureDetector(getContext(), this.f3458, null, true);
        this.f3457 = 1;
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean m1968() {
        return true;
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public float m1969(float f, float f2) {
        if (this.f3457 == 1) {
            float f3 = this.f3456;
            if ((2.0f * f3) + f <= f2) {
                return f + f3;
            }
            this.f3457 = -1;
            return f2;
        }
        this.f3457 = 1;
        return 1.0f;
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public boolean m1970() {
        return true;
    }

    public ImageViewTouch(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ImageViewTouch(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f3454 = true;
        this.f3450 = true;
        this.f3455 = true;
    }

    @Override // it.sephiroth.android.library.imagezoom.ImageViewTouchBase
    /* renamed from: K  reason: contains not printable characters */
    public void m1965(Drawable drawable, Matrix matrix, float f, float f2) {
        super.m2000(drawable, matrix, f, f2);
        this.f3456 = getMaxScale() / 3.0f;
    }

    @Override // it.sephiroth.android.library.imagezoom.ImageViewTouchBase
    /* renamed from: K  reason: contains not printable characters */
    public void m1963(float f) {
        if (f < getMinScale()) {
            m1973(getMinScale(), 50.0f);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m1967(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        float x = motionEvent2.getX() - motionEvent.getX();
        float y = motionEvent2.getY() - motionEvent.getY();
        if (Math.abs(f) <= 800.0f && Math.abs(f2) <= 800.0f) {
            return false;
        }
        this.f3483 = true;
        m1991(x / 2.0f, y / 2.0f, 300.0d);
        invalidate();
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m1966(int i) {
        RectF bitmapRect = getBitmapRect();
        m1997(bitmapRect, this.f3470);
        Rect rect = new Rect();
        getGlobalVisibleRect(rect);
        if (bitmapRect == null) {
            return false;
        }
        float f = bitmapRect.right;
        int i2 = rect.right;
        if (f < ((float) i2) || i >= 0) {
            if (((double) Math.abs(bitmapRect.left - this.f3470.left)) > 1.0d) {
                return true;
            }
            return false;
        } else if (Math.abs(f - ((float) i2)) > 1.0f) {
            return true;
        } else {
            return false;
        }
    }
}
