package io.reactivex.internal.subscribers;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import ඓ.ⁱ.K.ඓ.C1252;
import 㳳.ʬ.AbstractC2396;
import 㴹.K.AbstractC2431;
import 㴹.K.Ԕ.ῲ.C2457;
import 㴹.K.㑃.AbstractC2514;
import 㴹.K.䁗.AbstractC2522;
import 㴹.K.䁗.AbstractC2523;

public final class LambdaSubscriber<T> extends AtomicReference<AbstractC2396> implements AbstractC2431<T>, AbstractC2396, AbstractC2514 {
    public static final long serialVersionUID = -7251123623727029452L;
    public final AbstractC2523 onComplete;
    public final AbstractC2522<? super Throwable> onError;
    public final AbstractC2522<? super T> onNext;
    public final AbstractC2522<? super AbstractC2396> onSubscribe;

    public LambdaSubscriber(AbstractC2522<? super T> r1, AbstractC2522<? super Throwable> r2, AbstractC2523 k, AbstractC2522<? super AbstractC2396> r4) {
        this.onNext = r1;
        this.onError = r2;
        this.onComplete = k;
        this.onSubscribe = r4;
    }

    @Override // 㳳.ʬ.AbstractC2396
    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    @Override // 㴹.K.㑃.AbstractC2514
    public void dispose() {
        cancel();
    }

    @Override // 㴹.K.㑃.AbstractC2514
    public boolean isDisposed() {
        return get() == SubscriptionHelper.CANCELLED;
    }

    @Override // 㳳.ʬ.AbstractC2397
    public void onComplete() {
        Object obj = get();
        SubscriptionHelper subscriptionHelper = SubscriptionHelper.CANCELLED;
        if (obj != subscriptionHelper) {
            lazySet(subscriptionHelper);
            try {
                ((C2457.C2462) this.onComplete).m6502();
            } catch (Throwable th) {
                C1252.m3329(th);
                C1252.m3349(th);
            }
        }
    }

    @Override // 㳳.ʬ.AbstractC2397
    public void onError(Throwable th) {
        Object obj = get();
        SubscriptionHelper subscriptionHelper = SubscriptionHelper.CANCELLED;
        if (obj != subscriptionHelper) {
            lazySet(subscriptionHelper);
            try {
                this.onError.accept(th);
            } catch (Throwable th2) {
                C1252.m3329(th2);
                C1252.m3349(new CompositeException(th, th2));
            }
        } else {
            C1252.m3349(th);
        }
    }

    @Override // 㳳.ʬ.AbstractC2397
    public void onNext(T t) {
        if (!isDisposed()) {
            try {
                this.onNext.accept(t);
            } catch (Throwable th) {
                C1252.m3329(th);
                ((AbstractC2396) get()).cancel();
                onError(th);
            }
        }
    }

    @Override // 㳳.ʬ.AbstractC2397, 㴹.K.AbstractC2431
    public void onSubscribe(AbstractC2396 r2) {
        if (SubscriptionHelper.setOnce(this, r2)) {
            try {
                this.onSubscribe.accept(this);
            } catch (Throwable th) {
                C1252.m3329(th);
                r2.cancel();
                onError(th);
            }
        }
    }

    @Override // 㳳.ʬ.AbstractC2396
    public void request(long j) {
        ((AbstractC2396) get()).request(j);
    }
}
