package io.reactivex.internal.schedulers;

import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import 㴹.K.Ԕ.ῲ.C2457;
import 㴹.K.㑃.AbstractC2514;

public abstract class AbstractDirectTask extends AtomicReference<Future<?>> implements AbstractC2514 {
    public static final FutureTask<Void> DISPOSED = new FutureTask<>(C2457.f8413, null);
    public static final FutureTask<Void> FINISHED = new FutureTask<>(C2457.f8413, null);
    public static final long serialVersionUID = 1811839108042568751L;
    public final Runnable runnable;
    public Thread runner;

    public AbstractDirectTask(Runnable runnable2) {
        this.runnable = runnable2;
    }

    @Override // 㴹.K.㑃.AbstractC2514
    public final void dispose() {
        FutureTask<Void> futureTask;
        Future future = (Future) get();
        if (future != FINISHED && future != (futureTask = DISPOSED) && compareAndSet(future, futureTask) && future != null) {
            future.cancel(this.runner != Thread.currentThread());
        }
    }

    @Override // 㴹.K.㑃.AbstractC2514
    public final boolean isDisposed() {
        Future future = (Future) get();
        return future == FINISHED || future == DISPOSED;
    }

    public final void setFuture(Future<?> future) {
        Future future2;
        do {
            future2 = (Future) get();
            if (future2 != FINISHED) {
                if (future2 == DISPOSED) {
                    future.cancel(this.runner != Thread.currentThread());
                    return;
                }
            } else {
                return;
            }
        } while (!compareAndSet(future2, future));
    }
}
