package io.reactivex.internal.operators.observable;

import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import ඓ.ⁱ.K.ඓ.C1252;
import 㴹.K.AbstractC2500;
import 㴹.K.AbstractC2518;
import 㴹.K.AbstractC2520;
import 㴹.K.Ԕ.ʬ.AbstractC2432;
import 㴹.K.Ԕ.ʬ.AbstractC2435;
import 㴹.K.Ԕ.ʬ.AbstractC2439;
import 㴹.K.Ԕ.ඓ.ῲ.AbstractC2445;
import 㴹.K.Ԕ.ῲ.C2456;
import 㴹.K.Ԕ.㴹.C2487;
import 㴹.K.㑃.AbstractC2514;
import 㴹.K.䁗.AbstractC2521;

public final class ObservableFlatMap<T, U> extends AbstractC2445<T, U> {

    /* renamed from: ʬ  reason: contains not printable characters */
    public final AbstractC2521<? super T, ? extends AbstractC2518<? extends U>> f3428;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final int f3429;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final int f3430;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final boolean f3431;

    public static final class InnerObserver<T, U> extends AtomicReference<AbstractC2514> implements AbstractC2520<U> {
        public static final long serialVersionUID = -4606175640614850599L;
        public volatile boolean done;
        public int fusionMode;
        public final long id;
        public final MergeObserver<T, U> parent;
        public volatile AbstractC2439<U> queue;

        public InnerObserver(MergeObserver<T, U> mergeObserver, long j) {
            this.id = j;
            this.parent = mergeObserver;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override // 㴹.K.AbstractC2520
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        @Override // 㴹.K.AbstractC2520
        public void onError(Throwable th) {
            if (this.parent.errors.addThrowable(th)) {
                MergeObserver<T, U> mergeObserver = this.parent;
                if (!mergeObserver.delayErrors) {
                    mergeObserver.disposeAll();
                }
                this.done = true;
                this.parent.drain();
                return;
            }
            C1252.m3349(th);
        }

        @Override // 㴹.K.AbstractC2520
        public void onNext(U u) {
            if (this.fusionMode == 0) {
                this.parent.tryEmit(u, this);
            } else {
                this.parent.drain();
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onSubscribe(AbstractC2514 r3) {
            if (DisposableHelper.setOnce(this, r3) && (r3 instanceof AbstractC2432)) {
                AbstractC2432 r32 = (AbstractC2432) r3;
                int requestFusion = r32.requestFusion(7);
                if (requestFusion == 1) {
                    this.fusionMode = requestFusion;
                    this.queue = r32;
                    this.done = true;
                    this.parent.drain();
                } else if (requestFusion == 2) {
                    this.fusionMode = requestFusion;
                    this.queue = r32;
                }
            }
        }
    }

    public static final class MergeObserver<T, U> extends AtomicInteger implements AbstractC2514, AbstractC2520<T> {
        public static final InnerObserver<?, ?>[] CANCELLED = new InnerObserver[0];
        public static final InnerObserver<?, ?>[] EMPTY = new InnerObserver[0];
        public static final long serialVersionUID = -2117620485640801370L;
        public final AbstractC2520<? super U> actual;
        public final int bufferSize;
        public volatile boolean cancelled;
        public final boolean delayErrors;
        public volatile boolean done;
        public final AtomicThrowable errors = new AtomicThrowable();
        public long lastId;
        public int lastIndex;
        public final AbstractC2521<? super T, ? extends AbstractC2518<? extends U>> mapper;
        public final int maxConcurrency;
        public final AtomicReference<InnerObserver<?, ?>[]> observers;
        public volatile AbstractC2435<U> queue;
        public AbstractC2514 s;
        public Queue<AbstractC2518<? extends U>> sources;
        public long uniqueId;
        public int wip;

        public MergeObserver(AbstractC2520<? super U> r2, AbstractC2521<? super T, ? extends AbstractC2518<? extends U>> r3, boolean z, int i, int i2) {
            this.actual = r2;
            this.mapper = r3;
            this.delayErrors = z;
            this.maxConcurrency = i;
            this.bufferSize = i2;
            if (i != Integer.MAX_VALUE) {
                this.sources = new ArrayDeque(i);
            }
            this.observers = new AtomicReference<>(EMPTY);
        }

        /* JADX DEBUG: Multi-variable search result rejected for r1v2, resolved type: java.util.concurrent.atomic.AtomicReference<io.reactivex.internal.operators.observable.ObservableFlatMap$InnerObserver<?, ?>[]> */
        /* JADX WARN: Multi-variable type inference failed */
        public boolean addInner(InnerObserver<T, U> innerObserver) {
            InnerObserver<?, ?>[] innerObserverArr;
            InnerObserver[] innerObserverArr2;
            do {
                innerObserverArr = this.observers.get();
                if (innerObserverArr == CANCELLED) {
                    innerObserver.dispose();
                    return false;
                }
                int length = innerObserverArr.length;
                innerObserverArr2 = new InnerObserver[(length + 1)];
                System.arraycopy(innerObserverArr, 0, innerObserverArr2, 0, length);
                innerObserverArr2[length] = innerObserver;
            } while (!this.observers.compareAndSet(innerObserverArr, innerObserverArr2));
            return true;
        }

        public boolean checkTerminate() {
            if (this.cancelled) {
                return true;
            }
            Throwable th = (Throwable) this.errors.get();
            if (this.delayErrors || th == null) {
                return false;
            }
            disposeAll();
            Throwable terminate = this.errors.terminate();
            if (terminate != ExceptionHelper.f3444) {
                this.actual.onError(terminate);
            }
            return true;
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public void dispose() {
            Throwable terminate;
            if (!this.cancelled) {
                this.cancelled = true;
                if (disposeAll() && (terminate = this.errors.terminate()) != null && terminate != ExceptionHelper.f3444) {
                    C1252.m3349(terminate);
                }
            }
        }

        public boolean disposeAll() {
            InnerObserver<?, ?>[] andSet;
            this.s.dispose();
            InnerObserver<?, ?>[] innerObserverArr = this.observers.get();
            InnerObserver<?, ?>[] innerObserverArr2 = CANCELLED;
            if (innerObserverArr == innerObserverArr2 || (andSet = this.observers.getAndSet(innerObserverArr2)) == CANCELLED) {
                return false;
            }
            for (InnerObserver<?, ?> innerObserver : andSet) {
                innerObserver.dispose();
            }
            return true;
        }

        public void drain() {
            if (getAndIncrement() == 0) {
                drainLoop();
            }
        }

        /* JADX WARNING: Code restructure failed: missing block: B:55:0x00a2, code lost:
            if (r11 != null) goto L_0x0090;
         */
        public void drainLoop() {
            AbstractC2520<? super U> r0 = this.actual;
            int i = 1;
            while (!checkTerminate()) {
                AbstractC2435<U> r3 = this.queue;
                if (r3 != null) {
                    while (!checkTerminate()) {
                        U poll = r3.poll();
                        if (poll != null) {
                            r0.onNext(poll);
                        } else if (poll == null) {
                        }
                    }
                    return;
                }
                boolean z = this.done;
                AbstractC2435<U> r4 = this.queue;
                InnerObserver<?, ?>[] innerObserverArr = this.observers.get();
                int length = innerObserverArr.length;
                if (!z || ((r4 != null && !r4.isEmpty()) || length != 0)) {
                    boolean z2 = false;
                    if (length != 0) {
                        long j = this.lastId;
                        int i2 = this.lastIndex;
                        if (length <= i2 || innerObserverArr[i2].id != j) {
                            if (length <= i2) {
                                i2 = 0;
                            }
                            int i3 = i2;
                            for (int i4 = 0; i4 < length && innerObserverArr[i3].id != j; i4++) {
                                i3++;
                                if (i3 == length) {
                                    i3 = 0;
                                }
                            }
                            this.lastIndex = i3;
                            this.lastId = innerObserverArr[i3].id;
                            i2 = i3;
                        }
                        int i5 = i2;
                        int i6 = 0;
                        boolean z3 = false;
                        while (i6 < length) {
                            if (!checkTerminate()) {
                                InnerObserver<T, U> innerObserver = innerObserverArr[i5];
                                while (!checkTerminate()) {
                                    AbstractC2439<U> r10 = innerObserver.queue;
                                    if (r10 != null) {
                                        while (true) {
                                            try {
                                                U poll2 = r10.poll();
                                                if (poll2 == null) {
                                                    break;
                                                }
                                                r0.onNext(poll2);
                                                if (checkTerminate()) {
                                                    return;
                                                }
                                            } catch (Throwable th) {
                                                C1252.m3329(th);
                                                innerObserver.dispose();
                                                this.errors.addThrowable(th);
                                                if (!checkTerminate()) {
                                                    removeInner(innerObserver);
                                                    i6++;
                                                    z3 = true;
                                                } else {
                                                    return;
                                                }
                                            }
                                        }
                                    }
                                    boolean z4 = innerObserver.done;
                                    AbstractC2439<U> r11 = innerObserver.queue;
                                    if (z4 && (r11 == null || r11.isEmpty())) {
                                        removeInner(innerObserver);
                                        if (!checkTerminate()) {
                                            z3 = true;
                                        } else {
                                            return;
                                        }
                                    }
                                    i5++;
                                    if (i5 == length) {
                                        i5 = 0;
                                    }
                                    i6++;
                                }
                                return;
                            }
                            return;
                        }
                        this.lastIndex = i5;
                        this.lastId = innerObserverArr[i5].id;
                        z2 = z3;
                    }
                    if (!z2) {
                        i = addAndGet(-i);
                        if (i == 0) {
                            return;
                        }
                    } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                        synchronized (this) {
                            AbstractC2518<? extends U> poll3 = this.sources.poll();
                            if (poll3 == null) {
                                this.wip--;
                            } else {
                                subscribeInner(poll3);
                            }
                        }
                    } else {
                        continue;
                    }
                } else {
                    Throwable terminate = this.errors.terminate();
                    if (terminate == ExceptionHelper.f3444) {
                        return;
                    }
                    if (terminate == null) {
                        r0.onComplete();
                        return;
                    } else {
                        r0.onError(terminate);
                        return;
                    }
                }
            }
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override // 㴹.K.AbstractC2520
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                drain();
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onError(Throwable th) {
            if (this.done) {
                C1252.m3349(th);
            } else if (this.errors.addThrowable(th)) {
                this.done = true;
                drain();
            } else {
                C1252.m3349(th);
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onNext(T t) {
            if (!this.done) {
                try {
                    Object apply = this.mapper.apply(t);
                    C2456.m6500(apply, "The mapper returned a null ObservableSource");
                    AbstractC2518<? extends U> r3 = (AbstractC2518) apply;
                    if (this.maxConcurrency != Integer.MAX_VALUE) {
                        synchronized (this) {
                            if (this.wip == this.maxConcurrency) {
                                this.sources.offer(r3);
                                return;
                            }
                            this.wip++;
                        }
                    }
                    subscribeInner(r3);
                } catch (Throwable th) {
                    C1252.m3329(th);
                    this.s.dispose();
                    onError(th);
                }
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onSubscribe(AbstractC2514 r2) {
            if (DisposableHelper.validate(this.s, r2)) {
                this.s = r2;
                this.actual.onSubscribe(this);
            }
        }

        public void removeInner(InnerObserver<T, U> innerObserver) {
            InnerObserver<?, ?>[] innerObserverArr;
            InnerObserver<?, ?>[] innerObserverArr2;
            do {
                innerObserverArr = this.observers.get();
                int length = innerObserverArr.length;
                if (length != 0) {
                    int i = -1;
                    int i2 = 0;
                    while (true) {
                        if (i2 >= length) {
                            break;
                        } else if (innerObserverArr[i2] == innerObserver) {
                            i = i2;
                            break;
                        } else {
                            i2++;
                        }
                    }
                    if (i >= 0) {
                        if (length == 1) {
                            innerObserverArr2 = EMPTY;
                        } else {
                            InnerObserver<?, ?>[] innerObserverArr3 = new InnerObserver[(length - 1)];
                            System.arraycopy(innerObserverArr, 0, innerObserverArr3, 0, i);
                            System.arraycopy(innerObserverArr, i + 1, innerObserverArr3, i, (length - i) - 1);
                            innerObserverArr2 = innerObserverArr3;
                        }
                    } else {
                        return;
                    }
                } else {
                    return;
                }
            } while (!this.observers.compareAndSet(innerObserverArr, innerObserverArr2));
        }

        public void subscribeInner(AbstractC2518<? extends U> r6) {
            while (r6 instanceof Callable) {
                tryEmitScalar((Callable) r6);
                if (this.maxConcurrency != Integer.MAX_VALUE) {
                    synchronized (this) {
                        r6 = this.sources.poll();
                        if (r6 == null) {
                            this.wip--;
                            return;
                        }
                    }
                } else {
                    return;
                }
            }
            long j = this.uniqueId;
            this.uniqueId = 1 + j;
            InnerObserver<T, U> innerObserver = new InnerObserver<>(this, j);
            if (addInner(innerObserver)) {
                ((AbstractC2500) r6).m6545((AbstractC2520) innerObserver);
            }
        }

        public void tryEmit(U u, InnerObserver<T, U> innerObserver) {
            if (get() != 0 || !compareAndSet(0, 1)) {
                AbstractC2439 r0 = innerObserver.queue;
                if (r0 == null) {
                    r0 = new C2487(this.bufferSize);
                    innerObserver.queue = r0;
                }
                r0.offer(u);
                if (getAndIncrement() != 0) {
                    return;
                }
            } else {
                this.actual.onNext(u);
                if (decrementAndGet() == 0) {
                    return;
                }
            }
            drainLoop();
        }

        /* JADX WARN: Multi-variable type inference failed */
        /* JADX WARN: Type inference failed for: r0v3, types: [㴹.K.Ԕ.ʬ.㿎] */
        public void tryEmitScalar(Callable<? extends U> callable) {
            SpscArrayQueue spscArrayQueue;
            try {
                Object call = callable.call();
                if (call != null) {
                    if (get() != 0 || !compareAndSet(0, 1)) {
                        AbstractC2435<U> r0 = this.queue;
                        AbstractC2435<U> r02 = r0;
                        if (r0 == null) {
                            int i = this.maxConcurrency;
                            if (i == Integer.MAX_VALUE) {
                                spscArrayQueue = new C2487(this.bufferSize);
                            } else {
                                spscArrayQueue = new SpscArrayQueue(i);
                            }
                            this.queue = spscArrayQueue;
                            r02 = spscArrayQueue;
                        }
                        if (!r02.offer(call)) {
                            onError(new IllegalStateException("Scalar queue full?!"));
                            return;
                        } else if (getAndIncrement() != 0) {
                            return;
                        }
                    } else {
                        this.actual.onNext(call);
                        if (decrementAndGet() == 0) {
                            return;
                        }
                    }
                    drainLoop();
                }
            } catch (Throwable th) {
                C1252.m3329(th);
                this.errors.addThrowable(th);
                drain();
            }
        }
    }

    public ObservableFlatMap(AbstractC2518<T> r1, AbstractC2521<? super T, ? extends AbstractC2518<? extends U>> r2, boolean z, int i, int i2) {
        super(r1);
        this.f3428 = r2;
        this.f3431 = z;
        this.f3429 = i;
        this.f3430 = i2;
    }

    @Override // 㴹.K.AbstractC2500
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1951(AbstractC2520<? super U> r9) {
        if (!C1252.m3351(this.f8388, r9, this.f3428)) {
            ((AbstractC2500) this.f8388).m6545((AbstractC2520) new MergeObserver(r9, this.f3428, this.f3431, this.f3429, this.f3430));
        }
    }
}
