package io.reactivex.internal.operators.observable;

import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import ඓ.ⁱ.K.ඓ.C1252;
import 㴹.K.AbstractC2500;
import 㴹.K.AbstractC2518;
import 㴹.K.AbstractC2520;
import 㴹.K.Ԕ.ʬ.AbstractC2432;
import 㴹.K.Ԕ.ʬ.AbstractC2439;
import 㴹.K.Ԕ.ඓ.ῲ.AbstractC2445;
import 㴹.K.Ԕ.ῲ.C2456;
import 㴹.K.Ԕ.㴹.C2487;
import 㴹.K.㑃.AbstractC2514;
import 㴹.K.㗗.C2516;
import 㴹.K.䁗.AbstractC2521;

public final class ObservableConcatMap<T, U> extends AbstractC2445<T, U> {

    /* renamed from: ʬ  reason: contains not printable characters */
    public final AbstractC2521<? super T, ? extends AbstractC2518<? extends U>> f3421;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final ErrorMode f3422;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final int f3423;

    public static final class ConcatMapDelayErrorObserver<T, R> extends AtomicInteger implements AbstractC2520<T>, AbstractC2514 {
        public static final long serialVersionUID = -6951100001833242599L;
        public volatile boolean active;
        public final AbstractC2520<? super R> actual;
        public final SequentialDisposable arbiter;
        public final int bufferSize;
        public volatile boolean cancelled;
        public AbstractC2514 d;
        public volatile boolean done;
        public final AtomicThrowable error = new AtomicThrowable();
        public final AbstractC2521<? super T, ? extends AbstractC2518<? extends R>> mapper;
        public final C0573<R> observer;
        public AbstractC2439<T> queue;
        public int sourceMode;
        public final boolean tillTheEnd;

        /* renamed from: io.reactivex.internal.operators.observable.ObservableConcatMap$ConcatMapDelayErrorObserver$K  reason: contains not printable characters */
        public static final class C0573<R> implements AbstractC2520<R> {

            /* renamed from: ʬ  reason: contains not printable characters */
            public final ConcatMapDelayErrorObserver<?, R> f3424;

            /* renamed from: ῲ  reason: contains not printable characters */
            public final AbstractC2520<? super R> f3425;

            public C0573(AbstractC2520<? super R> r1, ConcatMapDelayErrorObserver<?, R> concatMapDelayErrorObserver) {
                this.f3425 = r1;
                this.f3424 = concatMapDelayErrorObserver;
            }

            @Override // 㴹.K.AbstractC2520
            public void onComplete() {
                ConcatMapDelayErrorObserver<?, R> concatMapDelayErrorObserver = this.f3424;
                concatMapDelayErrorObserver.active = false;
                concatMapDelayErrorObserver.drain();
            }

            @Override // 㴹.K.AbstractC2520
            public void onError(Throwable th) {
                ConcatMapDelayErrorObserver<?, R> concatMapDelayErrorObserver = this.f3424;
                if (concatMapDelayErrorObserver.error.addThrowable(th)) {
                    if (!concatMapDelayErrorObserver.tillTheEnd) {
                        concatMapDelayErrorObserver.d.dispose();
                    }
                    concatMapDelayErrorObserver.active = false;
                    concatMapDelayErrorObserver.drain();
                    return;
                }
                C1252.m3349(th);
            }

            @Override // 㴹.K.AbstractC2520
            public void onNext(R r) {
                this.f3425.onNext(r);
            }

            @Override // 㴹.K.AbstractC2520
            public void onSubscribe(AbstractC2514 r2) {
                this.f3424.arbiter.replace(r2);
            }
        }

        public ConcatMapDelayErrorObserver(AbstractC2520<? super R> r1, AbstractC2521<? super T, ? extends AbstractC2518<? extends R>> r2, int i, boolean z) {
            this.actual = r1;
            this.mapper = r2;
            this.bufferSize = i;
            this.tillTheEnd = z;
            this.observer = new C0573<>(r1, this);
            this.arbiter = new SequentialDisposable();
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public void dispose() {
            this.cancelled = true;
            this.d.dispose();
            this.arbiter.dispose();
        }

        public void drain() {
            if (getAndIncrement() == 0) {
                AbstractC2520<? super R> r0 = this.actual;
                AbstractC2439<T> r1 = this.queue;
                AtomicThrowable atomicThrowable = this.error;
                while (true) {
                    if (!this.active) {
                        if (this.cancelled) {
                            r1.clear();
                            return;
                        } else if (this.tillTheEnd || ((Throwable) atomicThrowable.get()) == null) {
                            boolean z = this.done;
                            try {
                                T poll = r1.poll();
                                boolean z2 = poll == null;
                                if (z && z2) {
                                    Throwable terminate = atomicThrowable.terminate();
                                    if (terminate != null) {
                                        r0.onError(terminate);
                                        return;
                                    } else {
                                        r0.onComplete();
                                        return;
                                    }
                                } else if (!z2) {
                                    try {
                                        Object apply = this.mapper.apply(poll);
                                        C2456.m6500(apply, "The mapper returned a null ObservableSource");
                                        AbstractC2518 r3 = (AbstractC2518) apply;
                                        if (r3 instanceof Callable) {
                                            try {
                                                Object obj = (Object) ((Callable) r3).call();
                                                if (obj != 0 && !this.cancelled) {
                                                    r0.onNext(obj);
                                                }
                                            } catch (Throwable th) {
                                                C1252.m3329(th);
                                                atomicThrowable.addThrowable(th);
                                            }
                                        } else {
                                            this.active = true;
                                            ((AbstractC2500) r3).m6545((AbstractC2520) this.observer);
                                        }
                                    } catch (Throwable th2) {
                                        C1252.m3329(th2);
                                        this.d.dispose();
                                        r1.clear();
                                        atomicThrowable.addThrowable(th2);
                                        r0.onError(atomicThrowable.terminate());
                                        return;
                                    }
                                }
                            } catch (Throwable th3) {
                                C1252.m3329(th3);
                                this.d.dispose();
                                atomicThrowable.addThrowable(th3);
                                r0.onError(atomicThrowable.terminate());
                                return;
                            }
                        } else {
                            r1.clear();
                            r0.onError(atomicThrowable.terminate());
                            return;
                        }
                    }
                    if (decrementAndGet() == 0) {
                        return;
                    }
                }
            }
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override // 㴹.K.AbstractC2520
        public void onComplete() {
            this.done = true;
            drain();
        }

        @Override // 㴹.K.AbstractC2520
        public void onError(Throwable th) {
            if (this.error.addThrowable(th)) {
                this.done = true;
                drain();
                return;
            }
            C1252.m3349(th);
        }

        @Override // 㴹.K.AbstractC2520
        public void onNext(T t) {
            if (this.sourceMode == 0) {
                this.queue.offer(t);
            }
            drain();
        }

        @Override // 㴹.K.AbstractC2520
        public void onSubscribe(AbstractC2514 r3) {
            if (DisposableHelper.validate(this.d, r3)) {
                this.d = r3;
                if (r3 instanceof AbstractC2432) {
                    AbstractC2432 r32 = (AbstractC2432) r3;
                    int requestFusion = r32.requestFusion(3);
                    if (requestFusion == 1) {
                        this.sourceMode = requestFusion;
                        this.queue = r32;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        drain();
                        return;
                    } else if (requestFusion == 2) {
                        this.sourceMode = requestFusion;
                        this.queue = r32;
                        this.actual.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new C2487(this.bufferSize);
                this.actual.onSubscribe(this);
            }
        }
    }

    public static final class SourceObserver<T, U> extends AtomicInteger implements AbstractC2520<T>, AbstractC2514 {
        public static final long serialVersionUID = 8828587559905699186L;
        public volatile boolean active;
        public final AbstractC2520<? super U> actual;
        public final int bufferSize;
        public volatile boolean disposed;
        public volatile boolean done;
        public int fusionMode;
        public final AbstractC2520<U> inner;
        public final AbstractC2521<? super T, ? extends AbstractC2518<? extends U>> mapper;
        public AbstractC2439<T> queue;
        public AbstractC2514 s;
        public final SequentialDisposable sa = new SequentialDisposable();

        /* renamed from: io.reactivex.internal.operators.observable.ObservableConcatMap$SourceObserver$K  reason: contains not printable characters */
        public static final class C0574<U> implements AbstractC2520<U> {

            /* renamed from: ʬ  reason: contains not printable characters */
            public final SourceObserver<?, ?> f3426;

            /* renamed from: ῲ  reason: contains not printable characters */
            public final AbstractC2520<? super U> f3427;

            public C0574(AbstractC2520<? super U> r1, SourceObserver<?, ?> sourceObserver) {
                this.f3427 = r1;
                this.f3426 = sourceObserver;
            }

            @Override // 㴹.K.AbstractC2520
            public void onComplete() {
                this.f3426.innerComplete();
            }

            @Override // 㴹.K.AbstractC2520
            public void onError(Throwable th) {
                this.f3426.dispose();
                this.f3427.onError(th);
            }

            @Override // 㴹.K.AbstractC2520
            public void onNext(U u) {
                this.f3427.onNext(u);
            }

            @Override // 㴹.K.AbstractC2520
            public void onSubscribe(AbstractC2514 r2) {
                this.f3426.innerSubscribe(r2);
            }
        }

        public SourceObserver(AbstractC2520<? super U> r1, AbstractC2521<? super T, ? extends AbstractC2518<? extends U>> r2, int i) {
            this.actual = r1;
            this.mapper = r2;
            this.bufferSize = i;
            this.inner = new C0574(r1, this);
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public void dispose() {
            this.disposed = true;
            this.sa.dispose();
            this.s.dispose();
            if (getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        public void drain() {
            if (getAndIncrement() == 0) {
                while (!this.disposed) {
                    if (!this.active) {
                        boolean z = this.done;
                        try {
                            T poll = this.queue.poll();
                            boolean z2 = poll == null;
                            if (z && z2) {
                                this.actual.onComplete();
                                return;
                            } else if (!z2) {
                                try {
                                    Object apply = this.mapper.apply(poll);
                                    C2456.m6500(apply, "The mapper returned a null ObservableSource");
                                    AbstractC2518 r0 = (AbstractC2518) apply;
                                    this.active = true;
                                    ((AbstractC2500) r0).m6545((AbstractC2520) this.inner);
                                } catch (Throwable th) {
                                    C1252.m3329(th);
                                    dispose();
                                    this.queue.clear();
                                    this.actual.onError(th);
                                    return;
                                }
                            }
                        } catch (Throwable th2) {
                            C1252.m3329(th2);
                            dispose();
                            this.queue.clear();
                            this.actual.onError(th2);
                            return;
                        }
                    }
                    if (decrementAndGet() == 0) {
                        return;
                    }
                }
                this.queue.clear();
            }
        }

        public void innerComplete() {
            this.active = false;
            drain();
        }

        public void innerSubscribe(AbstractC2514 r2) {
            this.sa.update(r2);
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override // 㴹.K.AbstractC2520
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                drain();
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onError(Throwable th) {
            if (this.done) {
                C1252.m3349(th);
                return;
            }
            this.done = true;
            dispose();
            this.actual.onError(th);
        }

        @Override // 㴹.K.AbstractC2520
        public void onNext(T t) {
            if (!this.done) {
                if (this.fusionMode == 0) {
                    this.queue.offer(t);
                }
                drain();
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onSubscribe(AbstractC2514 r3) {
            if (DisposableHelper.validate(this.s, r3)) {
                this.s = r3;
                if (r3 instanceof AbstractC2432) {
                    AbstractC2432 r32 = (AbstractC2432) r3;
                    int requestFusion = r32.requestFusion(3);
                    if (requestFusion == 1) {
                        this.fusionMode = requestFusion;
                        this.queue = r32;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        drain();
                        return;
                    } else if (requestFusion == 2) {
                        this.fusionMode = requestFusion;
                        this.queue = r32;
                        this.actual.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new C2487(this.bufferSize);
                this.actual.onSubscribe(this);
            }
        }
    }

    public ObservableConcatMap(AbstractC2518<T> r1, AbstractC2521<? super T, ? extends AbstractC2518<? extends U>> r2, int i, ErrorMode errorMode) {
        super(r1);
        this.f3421 = r2;
        this.f3422 = errorMode;
        this.f3423 = Math.max(8, i);
    }

    @Override // 㴹.K.AbstractC2500
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1950(AbstractC2520<? super U> r7) {
        if (!C1252.m3351(this.f8388, r7, this.f3421)) {
            ErrorMode errorMode = this.f3422;
            if (errorMode == ErrorMode.IMMEDIATE) {
                ((AbstractC2500) this.f8388).m6545((AbstractC2520) new SourceObserver(new C2516(r7), this.f3421, this.f3423));
                return;
            }
            ((AbstractC2500) this.f8388).m6545((AbstractC2520) new ConcatMapDelayErrorObserver(r7, this.f3421, this.f3423, errorMode == ErrorMode.END));
        }
    }
}
